/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.util.Arrays;
import java.util.List;
import org.xmind.ui.util.Messages;

public enum ImageFormat {
    BMP("BMP", "image/bmp", Messages.BMPFile, 0, ".bmp"),
    JPEG("JPEG", "image/jpeg", Messages.JPEGFile, 4, ".jpg", ".jpeg"),
    GIF("GIF", "image/gif", Messages.GIFFile, 2, ".gif"),
    PNG("PNG", "image/png", Messages.PNGFile, 5, ".png");

    private String name;
    private String mediaType;
    private String description;
    private int swtFormat;
    private List<String> fileExtensions;

    private ImageFormat(String name, String mediaType, String description, int swtType, String ... fileExtensions) {
        this.name = name;
        this.mediaType = mediaType;
        this.description = description;
        this.swtFormat = swtType;
        this.fileExtensions = Arrays.asList(fileExtensions);
    }

    public String getName() {
        return this.name;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSWTFormat() {
        return this.swtFormat;
    }

    public List<String> getExtensions() {
        return this.fileExtensions;
    }

    public static ImageFormat findByExtension(String ext, ImageFormat defaultFormat) {
        ImageFormat[] imageFormatArray = ImageFormat.values();
        int n = imageFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            if (format.fileExtensions.contains(ext.toLowerCase())) {
                return format;
            }
            ++n2;
        }
        return defaultFormat;
    }

    public static ImageFormat findByMediaType(String mediaType, ImageFormat defaultFormat) {
        ImageFormat[] imageFormatArray = ImageFormat.values();
        int n = imageFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            if (format.mediaType.equals(mediaType)) {
                return format;
            }
            ++n2;
        }
        return defaultFormat;
    }

    public static ImageFormat findBySWTFormat(int swtFormat, ImageFormat defaultFormat) {
        ImageFormat[] imageFormatArray = ImageFormat.values();
        int n = imageFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            if (format.swtFormat == swtFormat) {
                return format;
            }
            ++n2;
        }
        return defaultFormat;
    }
}

