/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.texteditor;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.texteditor.MEmbeddedEditor;

public class MTextEditor
extends MEmbeddedEditor {
    private Text input;
    private Listener eventHandler;
    private String text = "";
    private boolean deleteAllEnalbed = false;
    private boolean updating = false;
    private boolean modifying = false;

    public MTextEditor(Composite parent) {
        super(parent);
        this.getButton().getControl().addListener(1, this.eventHandler);
    }

    @Override
    protected Composite createContainer(Composite parent) {
        this.eventHandler = new EventHandler();
        return super.createContainer(parent);
    }

    @Override
    protected void createEditor(Composite parent) {
        this.input = new Text(parent, 2052);
        this.input.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.input.setBackground(parent.getDisplay().getSystemColor(29));
        this.input.addListener(31, this.eventHandler);
        this.input.addListener(24, this.eventHandler);
        this.input.addListener(16, this.eventHandler);
        this.input.addListener(14, this.eventHandler);
    }

    @Override
    protected void setEditorFocus() {
        this.input.setFocus();
    }

    public Control getInputControl() {
        return this.input;
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        this.textChanged(text, oldText);
    }

    public String getText() {
        return this.text;
    }

    protected void textChanged(String newText, String oldText) {
        if (!this.input.isDisposed() && !this.modifying) {
            this.updating = true;
            this.input.setText(newText);
            this.updating = false;
        }
        if (!this.getButton().getControl().isDisposed()) {
            this.getButton().setText(newText);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.input.setEnabled(enabled);
    }

    public void setDeleteAllEnalbed(boolean deleteAllEnalbed) {
        this.deleteAllEnalbed = deleteAllEnalbed;
    }

    public boolean isDeleteAllEnalbed() {
        return this.deleteAllEnalbed;
    }

    protected void handleKeyDownOnButton(Event event) {
        if (event.stateMask == 0) {
            if (event.character >= '0' && event.character <= '9') {
                this.setText(String.valueOf(event.character));
                this.startEditing();
                this.input.setSelection(this.input.getCharCount());
            } else if ((event.keyCode == 127 || event.keyCode == 8) && this.isDeleteAllEnalbed()) {
                this.setText("");
                this.fireApplyEditorValue();
            }
        }
    }

    private class EventHandler
    implements Listener {
        private EventHandler() {
        }

        public void handleEvent(Event event) {
            if (event.widget == MTextEditor.this.input) {
                if (event.type == 14) {
                    MTextEditor.this.endEditing();
                } else if (event.type == 31) {
                    if (event.detail == 2) {
                        MTextEditor.this.cancelEditing();
                    }
                } else if (event.type == 24) {
                    if (MTextEditor.this.updating) {
                        return;
                    }
                    MTextEditor.this.modifying = true;
                    MTextEditor.this.setText(MTextEditor.this.input.getText());
                    MTextEditor.this.modifying = false;
                } else if (event.type == 16) {
                    MTextEditor.this.endEditingWhenFocusOut();
                }
            } else if (event.widget == MTextEditor.this.getButton().getControl() && ((Control)event.widget).isEnabled() && event.type == 1) {
                MTextEditor.this.handleKeyDownOnButton(event);
            }
        }
    }
}

