/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorUtils {
    private static final Pattern PATTERN_RGBA = Pattern.compile("rgb\\s*\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*(,\\s*(\\d+)\\s*)?\\)");
    private static final int min = 96;
    private static final int max = 172;
    private static final int t = 76;
    private static final RGB[] rainbowColors = new RGB[]{new RGB(172, 96, 96), new RGB(172, 172, 96), new RGB(96, 172, 96), new RGB(96, 172, 172), new RGB(96, 96, 172), new RGB(172, 96, 172)};

    private ColorUtils() {
    }

    public static Color getColor(String key, RGB rgb) {
        if (key == null && (key = ColorUtils.toString(rgb)) == null) {
            return null;
        }
        ColorRegistry reg = JFaceResources.getColorRegistry();
        if (!reg.hasValueFor(key)) {
            if (rgb == null && (rgb = ColorUtils.toRGB(key)) == null) {
                return null;
            }
            reg.put(key, rgb);
        }
        return reg.get(key);
    }

    public static Color getColor(RGB rgb) {
        return ColorUtils.getColor(null, rgb);
    }

    public static Color getColor(String s) {
        return ColorUtils.getColor(s, null);
    }

    public static Color getColor(int r, int g, int b) {
        return ColorUtils.getColor(new RGB(r, g, b));
    }

    public static Color getRelative(RGB source, int dr, int dg, int db) {
        return ColorUtils.getColor(new RGB(source.red + dr, source.green + dg, source.blue + db));
    }

    public static Color getRelative(Color c, int dr, int dg, int db) {
        return ColorUtils.getRelative(c.getRGB(), dr, dg, db);
    }

    public static ColorDescriptor toDescriptor(String s) {
        return ColorDescriptor.createFrom((RGB)ColorUtils.toRGB(s));
    }

    public static RGB toRGB(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("#")) {
            int n;
            try {
                n = Integer.parseInt(s.substring(1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (s.length() == 4) {
                return ColorUtils.splitShortRGB(n);
            }
            if (s.length() == 7) {
                return ColorUtils.splitRGB(n);
            }
            return null;
        }
        Matcher m = PATTERN_RGBA.matcher(s);
        if (m.matches()) {
            int r = Integer.parseInt(m.group(1), 10);
            int g = Integer.parseInt(m.group(2), 10);
            int b = Integer.parseInt(m.group(3), 10);
            return new RGB(r, g, b);
        }
        return null;
    }

    public static String toString(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return String.format("#%06X", ColorUtils.merge(rgb));
    }

    public static String toString(Color color) {
        return color == null ? null : ColorUtils.toString(color.getRGB());
    }

    public static String toString(int r, int g, int b) {
        return String.format("#%06X", ColorUtils.merge(r, g, b));
    }

    public static int merge(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int merge(RGB rgb) {
        return ColorUtils.merge(rgb.red, rgb.green, rgb.blue);
    }

    public static int merge(Color color) {
        return ColorUtils.merge(color.getRGB());
    }

    public static RGB split(int rgb) {
        return ColorUtils.splitRGB(rgb);
    }

    private static RGB splitRGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new RGB(r, g, b);
    }

    private static RGB splitShortRGB(int rgb) {
        int r = (rgb >> 8 & 0xF) * 17;
        int g = (rgb >> 4 & 0xF) * 17;
        int b = (rgb & 0xF) * 17;
        return new RGB(r, g, b);
    }

    public static Color darker(Color c) {
        return ColorUtils.getColor(ColorUtils.darker(c.getRGB()));
    }

    public static RGB darker(RGB rgb) {
        return new RGB(rgb.red * 2 / 3, rgb.green * 2 / 3, rgb.blue * 2 / 3);
    }

    public static Color lighter(Color c) {
        return ColorUtils.getColor(ColorUtils.lighter(c.getRGB()));
    }

    public static RGB lighter(RGB rgb) {
        return new RGB(rgb.red + (255 - rgb.red) / 2, rgb.green + (255 - rgb.green) / 2, rgb.blue + (255 - rgb.blue) / 2);
    }

    public static Color gradientLighter(Color c) {
        return ColorUtils.getColor(ColorUtils.gradientLighter(c.getRGB()));
    }

    public static RGB gradientLighter(RGB rgb) {
        return new RGB(rgb.red + (255 - rgb.red) * 5 / 7, rgb.green + (255 - rgb.green) * 5 / 7, rgb.blue + (255 - rgb.blue) * 5 / 7);
    }

    public static Color gray(Color c) {
        return ColorUtils.getColor(ColorUtils.gray(c.getRGB()));
    }

    public static RGB gray(RGB rgb) {
        int l = ColorUtils.lightness(rgb);
        return new RGB(l, l, l);
    }

    public static RGB getRainbow(int index, int total) {
        return rainbowColors[index % 6];
    }

    public static Color getRainbowColor(int index, int total) {
        return ColorUtils.getColor(ColorUtils.getRainbow(index, total));
    }

    public static Color getRainbowColor2(int index, int total) {
        total = Math.abs(total);
        if (index < 0) {
            index = index % total + total;
        } else if (index >= total) {
            index %= total;
        }
        double step = 456.0 / (double)total;
        int f = (int)(step * (double)index);
        if (f >= 0 && f < 76) {
            return ColorUtils.getColor(172, 96 + f, 96);
        }
        if (f >= 76 && f < 152) {
            return ColorUtils.getColor(248 - f, 172, 96);
        }
        if (f >= 152 && f < 228) {
            return ColorUtils.getColor(96, 172, 96 + f - 152);
        }
        if (f >= 228 && f < 304) {
            return ColorUtils.getColor(96, 400 - f, 172);
        }
        if (f >= 304 && f < 380) {
            return ColorUtils.getColor(96 + f - 304, 96, 172);
        }
        return ColorUtils.getColor(172, 96, 552 - f);
    }

    public static int lightness(Color c) {
        return ColorUtils.lightness(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static int lightness(RGB rgb) {
        return ColorUtils.lightness(rgb.red, rgb.green, rgb.blue);
    }

    public static int lightness(int r, int g, int b) {
        return (int)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
    }
}

