/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.StringToObjectMapImpl;
import org.eclipse.e4.ui.model.application.impl.StringToStringMapImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.E4PartWrapper;
import org.osgi.service.event.Event;
import org.xmind.ui.internal.e4models.IModelPartContext;

public class ModelPart
implements IAdaptable,
IModelPartContext {
    public static final String TAG_VIEW_MENU = "ViewMenu";
    @Inject
    EMenuService menuService;
    @Inject
    private EModelService modelService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private MPart partModel;
    @Inject
    private IWorkbenchWindow workbenchWindow;
    @Inject
    private MApplication application;
    private ISelectionProvider selectionProvider = null;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ModelPart.this.handleSelectionChanged(event);
        }
    };
    protected LocalResourceManager resources;
    private boolean postConfigurationSuccess;
    private Composite control;

    @PostConstruct
    private void postConstruct(Composite parent) {
        this.init();
        Composite composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createContent(composite);
        this.control = composite;
    }

    protected void init() {
        this.partModel.getContext().set(IModelPartContext.class, (Object)this);
    }

    protected void createContent(Composite parent) {
    }

    @PreDestroy
    private void preDestroy() {
        this.dispose();
    }

    protected void dispose() {
    }

    @Focus
    private void delegateSetFocus() {
        IPartService partService;
        this.setFocus();
        if (this.workbenchWindow != null && (partService = this.workbenchWindow.getPartService()) instanceof IPartListener && this.partModel.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
            IWorkbenchPart wp = (IWorkbenchPart)this.partModel.getTransientData().get("e4Wrapper");
            ((IPartListener)partService).partActivated(wp);
        }
    }

    protected void setFocus() {
        this.control.setFocus();
    }

    @Override
    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        if (selectionProvider == oldSelectionProvider) {
            return;
        }
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        }
        this.selectionProvider = selectionProvider;
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.selectionService != null) {
            this.selectionService.setSelection((Object)(selectionProvider == null ? null : selectionProvider.getSelection()));
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        if (this.selectionService != null) {
            this.selectionService.setSelection((Object)event.getSelection());
        }
    }

    @Inject
    @Optional
    private void subscribeTopicTransientDataChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") Event event) {
        Object changedElement = event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPart)) {
            return;
        }
        Object newValue = event.getProperty("NewValue");
        Object oldValue = event.getProperty("OldValue");
        if (((MPart)changedElement).getObject() == this) {
            String newKey = null;
            Object newValueOfKey = null;
            String oldKey = null;
            Object oldValueOfKey = null;
            if (newValue instanceof StringToObjectMapImpl) {
                newKey = ((StringToObjectMapImpl)newValue).getKey();
                newValueOfKey = ((StringToObjectMapImpl)newValue).getValue();
            } else if (newValue instanceof StringToStringMapImpl) {
                newKey = ((StringToStringMapImpl)newValue).getKey();
                newValueOfKey = ((StringToStringMapImpl)newValue).getValue();
            }
            if (oldValue instanceof StringToObjectMapImpl) {
                oldKey = ((StringToObjectMapImpl)oldValue).getKey();
                oldValueOfKey = ((StringToObjectMapImpl)oldValue).getValue();
            } else if (newValue instanceof StringToStringMapImpl) {
                oldKey = ((StringToStringMapImpl)oldValue).getKey();
                oldValueOfKey = ((StringToStringMapImpl)oldValue).getValue();
            }
            if (UIEvents.isADD((Event)event)) {
                this.handleTransientDataAdded(newKey, newValueOfKey, oldKey, oldValueOfKey);
            } else if (UIEvents.isREMOVE((Event)event)) {
                this.handleTransientDataRemoved(newKey, newValueOfKey, oldKey, oldValueOfKey);
            }
        }
    }

    protected void handleTransientDataAdded(String newKey, Object newValue, String oldKey, Object oldValue) {
    }

    protected void handleTransientDataRemoved(String newKey, Object newValue, String oldKey, Object oldValue) {
    }

    @Inject
    @Optional
    public void activePartChanged(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        Object wp;
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MPart)) {
            return;
        }
        MPart part = (MPart)element;
        this.handlePartActivated(part);
        if (part.getObject() == this && !this.postConfigurationSuccess && (wp = this.partModel.getTransientData().get("e4Wrapper")) instanceof E4PartWrapper) {
            this.postConfigurationSuccess = this.postConfiguration((IWorkbenchPart)wp, this.partModel);
        }
    }

    protected void handlePartActivated(MPart part) {
    }

    @Inject
    @Optional
    private void subscribeTopicBringToTop(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (element == this.partModel) {
            this.handleBringToTop();
        }
    }

    protected void handleBringToTop() {
    }

    protected boolean postConfiguration(IWorkbenchPart workbenchPart, MPart part) {
        return true;
    }

    @Override
    public boolean registerViewMenu(String viewMenuId) {
        if (viewMenuId == null || this.partModel == null || this.modelService == null) {
            return false;
        }
        MMenu viewMenu = null;
        for (MMenu menu : this.partModel.getMenus()) {
            boolean isViewMenu = menu.getTags().contains(TAG_VIEW_MENU);
            if (!isViewMenu || !viewMenuId.equals(menu.getElementId())) continue;
            viewMenu = menu;
            break;
        }
        if (viewMenu == null) {
            viewMenu = (MMenu)this.modelService.createModelElement(MMenu.class);
            viewMenu.setElementId(viewMenuId);
            viewMenu.getTags().add(TAG_VIEW_MENU);
            this.partModel.getMenus().add(viewMenu);
        }
        return true;
    }

    @Override
    public boolean registerContextMenu(Object menuParent, String menuId) {
        if (!(menuParent instanceof Control) || this.menuService == null || this.partModel == null) {
            return false;
        }
        Control parentControl = (Control)menuParent;
        MPopupMenu menuModel = null;
        for (MMenu item : this.partModel.getMenus()) {
            if (!menuId.equals(item.getElementId()) || !(item instanceof MPopupMenu)) continue;
            menuModel = (MPopupMenu)item;
            break;
        }
        if (menuModel == null) {
            menuModel = (MPopupMenu)this.modelService.createModelElement(MPopupMenu.class);
            menuModel.setElementId(menuId);
            menuModel.getTags().add("menuContribution:popup");
            this.partModel.getMenus().add(menuModel);
        }
        if (menuModel.getWidget() instanceof Menu) {
            Menu menu = (Menu)menuModel.getWidget();
            parentControl.setMenu(menu);
            return true;
        }
        return this.menuService.registerContextMenu((Object)parentControl, menuId);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (EModelService.class.equals(adapter)) {
            return adapter.cast(this.modelService);
        }
        if (MPart.class.equals(adapter)) {
            return adapter.cast(this.partModel);
        }
        if (EMenuService.class.equals(adapter)) {
            return adapter.cast(this.menuService);
        }
        if (IWorkbenchWindow.class.equals(adapter)) {
            return adapter.cast(this.workbenchWindow);
        }
        if (ESelectionService.class.equals(adapter)) {
            return adapter.cast(this.selectionService);
        }
        if (IModelPartContext.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (ISelectionProvider.class.equals(adapter)) {
            return adapter.cast(this.selectionProvider);
        }
        if (MApplication.class.equals(adapter)) {
            return adapter.cast(this.application);
        }
        return (T)this.partModel.getContext().get(adapter);
    }
}

