/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.xmind.ui.dialogs.Messages;
import org.xmind.ui.dialogs.StyledLink;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.RegionUtils;
import org.xmind.ui.util.UITimer;

public class Notification
extends Dialog {
    private static int STAY_DURATION = 5000;
    private static List<Window> group = new ArrayList<Window>();
    private String infoText;
    private IAction action;
    private Rectangle bounds;
    private boolean isCenter;
    private boolean isLong;
    private boolean isInfoHyperlink;
    private String infoTooltip;
    private UITimer timer;
    private int duration = STAY_DURATION;
    private Label close;
    private ResourceManager resources;
    private boolean noButton;

    public Notification(Shell parent, String infoText, IAction action, Rectangle bounds, boolean isCenter, boolean isLong, boolean isInfoHyperlink, String infoTooltip) {
        this(parent, infoText, action, bounds, isCenter, isLong, isInfoHyperlink, infoTooltip, false);
    }

    public Notification(Shell parent, String infoText, IAction action, Rectangle bounds, boolean isCenter, boolean isLong, boolean isInfoHyperlink, String infoTooltip, boolean noButton) {
        super(parent);
        this.infoText = infoText;
        this.action = action;
        this.isCenter = isCenter;
        this.isLong = isLong;
        this.isInfoHyperlink = isInfoHyperlink;
        this.infoTooltip = infoTooltip;
        this.noButton = noButton;
        if (bounds == null) {
            bounds = parent.getBounds();
        }
        this.bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        this.setShellStyle(12);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
        newShell.setAlpha(149);
        newShell.setBackgroundMode(2);
    }

    protected void initializeBounds() {
        Point size = this.getInitialSize();
        Region region = RegionUtils.getRoundedRectangle(new Rectangle(0, 0, size.x, size.y), 2);
        this.getShell().setRegion(region);
        Point location = this.getInitialLocation();
        this.getShell().setLocation(location);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Notification.this.getShell().getRegion().dispose();
            }
        });
    }

    private Point getInitialLocation() {
        Window topDialog;
        Point size = this.getInitialSize();
        int x = this.isCenter ? this.bounds.x + (this.bounds.width - size.x) / 2 : this.bounds.x + this.bounds.width - size.x;
        int y = this.bounds.y + this.bounds.height - size.y;
        if (group.size() != 0 && !(topDialog = group.get(group.size() - 1)).getShell().isDisposed()) {
            y = topDialog.getShell().getBounds().y - size.y - 1;
        }
        return new Point(x, y);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#000000")));
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.isLong ? 500 : 380;
        gridData.heightHint = 64;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(this.noButton ? 2 : 3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createImageSection(composite);
        this.createInfoSection(composite);
        if (!this.noButton) {
            this.createButtonsSection(composite);
        }
        return composite;
    }

    private void createImageSection(Composite parent) {
        ImageDescriptor icon;
        Image image = null;
        if (this.action != null && (icon = this.action.getImageDescriptor()) != null) {
            image = (Image)this.resources.get((DeviceResourceDescriptor)icon);
        }
        if (image == null) {
            image = (Image)this.resources.get((DeviceResourceDescriptor)ToolkitImages.get("notification-default-small.png"));
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(16384, 4, false, false);
        gridData.widthHint = 76;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label iconLabel = new Label(composite, 0x1000000);
        iconLabel.setBackground(composite.getBackground());
        GridData gridData2 = new GridData(0x1000000, 0x1000000, true, true);
        iconLabel.setLayoutData((Object)gridData2);
        iconLabel.setImage(image);
    }

    private void createInfoSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 20;
        composite.setLayout((Layout)gridLayout);
        if (this.isInfoHyperlink) {
            String content = this.infoText;
            StyledLink link = content.indexOf("<form>") >= 0 ? new StyledLink(composite, 0) : new StyledLink(composite, 64);
            link.setBackground(composite.getBackground());
            link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#ffffff")));
            link.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight(link.getFont().getFontData(), 1))));
            link.setText(content);
            if (this.infoTooltip != null) {
                link.setToolTipText(this.infoTooltip);
            }
            GridData layoutData = new GridData(4, 0x1000000, true, true);
            link.setLayoutData(layoutData);
            if (this.action == null) {
                link.setEnabled(false);
            }
            final IAction theAction = this.action;
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (theAction != null) {
                                theAction.run();
                            }
                        }
                    });
                }
            });
        } else {
            Label infoLabel = null;
            String content = this.infoText;
            infoLabel = content.indexOf("<form>") >= 0 ? new Label(composite, 66) : new Label(composite, 64);
            infoLabel.setBackground(composite.getBackground());
            infoLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#ffffff")));
            infoLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight(infoLabel.getFont().getFontData(), 1))));
            infoLabel.setText(content);
            GridData layoutData = new GridData(4, 0x1000000, true, true);
            infoLabel.setLayoutData((Object)layoutData);
            if (this.infoTooltip != null) {
                infoLabel.setToolTipText(this.infoTooltip);
            }
        }
    }

    private void createButtonsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(131072, 4, false, true);
        gridData.widthHint = 74;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createCloseButton(composite);
        this.createActionButton(composite);
    }

    private void createCloseButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#9b9b9b")));
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 1;
        layout.marginBottom = 1;
        composite.setLayout((Layout)layout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(parent.getBackground());
        GridData layoutData2 = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)layoutData2);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        composite2.setLayout((Layout)layout2);
        this.close = new Label(composite2, 131072);
        this.close.setBackground(this.close.getParent().getBackground());
        this.close.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#ffffff")));
        this.close.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.close.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold(FontUtils.relativeHeight(this.close.getFont().getFontData(), -1), true))));
        this.close.setText(Messages.Notification_closeButton_text);
        composite2.setCursor(parent.getDisplay().getSystemCursor(21));
        this.close.setCursor(parent.getDisplay().getSystemCursor(21));
        final Color original = this.close.getForeground();
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                Notification.this.close.setForeground(original);
            }

            public void mouseEnter(MouseEvent e) {
                Notification.this.close.setForeground((Color)Notification.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#3399ff")));
            }
        };
        composite.addMouseTrackListener(mouseTrackListener);
        this.close.addMouseTrackListener(mouseTrackListener);
        MouseListener mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Notification.this.close();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        composite2.addMouseListener(mouseListener);
        this.close.addMouseListener(mouseListener);
    }

    private void createActionButton(Composite parent) {
        boolean hasAction;
        boolean bl = hasAction = this.action != null;
        if (hasAction) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#9b9b9b")));
            GridData layoutData = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginLeft = 1;
            layout.marginTop = 0;
            composite.setLayout((Layout)layout);
            Composite composite2 = new Composite(composite, 0);
            composite2.setBackground(parent.getBackground());
            GridData layoutData2 = new GridData(4, 4, true, true);
            composite2.setLayoutData((Object)layoutData2);
            GridLayout layout2 = new GridLayout(1, false);
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            composite2.setLayout((Layout)layout2);
            final Label actionButton = new Label(composite2, 131072);
            actionButton.setBackground(parent.getBackground());
            actionButton.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#ffffff")));
            actionButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            actionButton.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold(FontUtils.relativeHeight(actionButton.getFont().getFontData(), -1), true))));
            actionButton.setText(this.action.getText());
            composite2.setCursor(parent.getDisplay().getSystemCursor(21));
            actionButton.setCursor(parent.getDisplay().getSystemCursor(21));
            final Color original = actionButton.getForeground();
            MouseTrackListener mouseTrackListener = new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    actionButton.setForeground(original);
                }

                public void mouseEnter(MouseEvent e) {
                    actionButton.setForeground((Color)Notification.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#3399ff")));
                }
            };
            composite.addMouseTrackListener(mouseTrackListener);
            actionButton.addMouseTrackListener(mouseTrackListener);
            Listener mouseDownListener = new Listener(){

                public void handleEvent(Event event) {
                    Notification.this.close();
                    Notification.this.action.run();
                }
            };
            composite2.addListener(3, mouseDownListener);
            actionButton.addListener(3, mouseDownListener);
        }
    }

    public void setDuration(int stayDuration) {
        this.duration = stayDuration;
    }

    public int open() {
        int code = super.open();
        if (this.timer == null) {
            this.timer = new UITimer(this.duration, 0, 0, (ISafeRunnable)new SafeRunnable(){

                public void run() {
                    Notification.this.close();
                }
            });
        }
        this.timer.run();
        group.add((Window)this);
        return code;
    }

    public boolean close() {
        boolean closed = super.close();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        group.remove((Object)this);
        return closed;
    }

    public void setCloseButtonListener(int eventType, Listener listener) {
        if (this.close == null || this.close.isDisposed()) {
            return;
        }
        this.close.addListener(eventType, listener);
        this.close.getParent().addListener(eventType, listener);
    }
}

