/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.vector.pdf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.exports.vector.pdf.Messages;
import org.xmind.ui.internal.exports.vector.pdf.PDFMapConstants;
import org.xmind.ui.internal.exports.vector.pdf.PDFMapExporter;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.UnitConvertor;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class PDFMapExportWizard
extends AbstractMindMapExportWizard {
    private static final String PAGE_NAME = "pdfImageExportPage";
    private static final String SETTINGS_ID = "org.xmind.ui.export.pdfMap";
    private static final String FILE_EXT = ".pdf";
    private PDFMapExportPage page;

    public PDFMapExportWizard() {
        this.setWindowTitle(Messages.PDFMapExportWizard_WindowTitle);
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(SETTINGS_ID));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToPDFMap", Messages.PDFMapExportJob_Name));
        this.page = new PDFMapExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        return Messages.PDFMapExportWizard_FormatName;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToPDFMapCount");
        try {
            new PDFMapExporter(this.getSourcePage(), this.getSourceMindMap(), this.getTargetPath(), this.getDialogSettings()).export(monitor, display);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        if (!monitor.isCanceled()) {
            this.launchTargetFile(true, monitor, display, parentShell);
        }
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && FILE_EXT.equals(extension);
    }

    public boolean needsPreviousAndNextButtons() {
        if (!super.needsPreviousAndNextButtons()) {
            return false;
        }
        int count = 0;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof VerifyWizardPage20141031) {
                ++count;
            }
            ++n2;
        }
        return this.getPages().length - count > 1;
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    public void dispose() {
        super.dispose();
    }

    protected String getSuggestedFileName() {
        String fileName = super.getSuggestedFileName();
        return String.valueOf(fileName) + FILE_EXT;
    }

    protected boolean doExport() {
        return super.doExport();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PDFMapExportPage
    extends AbstractMindMapExportPage {
        private static final Point PAGE_DPI = new Point(72, 72);
        private Button showPlusCheck;
        private Button showMinusCheck;

        public PDFMapExportPage() {
            super(PDFMapExportWizard.PAGE_NAME, Messages.PDFMapPage_Title);
            this.setDescription(Messages.PDFMapPage_Description);
        }

        protected PDFMapExportWizard getCastedWizard() {
            return (PDFMapExportWizard)super.getCastedWizard();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 40;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control setupGroup = this.createSetupControls(composite);
            setupGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            Control fileGroup = this.createFileControls(composite);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 210;
            fileGroup.setLayoutData((Object)gridData);
        }

        private Control createSetupControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            this.createPageSizeControls(composite);
            this.createOrientationControls(composite);
            this.createShowPlusMinusControls(composite);
            return composite;
        }

        private void createPageSizeControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 7;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(Messages.PDFMapPage_PageSize_Label);
            final Combo combo = new Combo(composite, 12);
            GridData gridData = new GridData(4, 0x1000000, false, false);
            gridData.widthHint = 350;
            combo.setLayoutData((Object)gridData);
            combo.setItems(this.getPageSizeDescriptions());
            combo.select(this.getPageSizeSelection());
            combo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PDFMapConstants.PageSize size = PDFMapConstants.PageSize.values()[combo.getSelectionIndex()];
                    PDFMapExportPage.this.getDialogSettings().put("PageSize", size.toString());
                    PDFMapExportPage.this.updateStatus();
                }
            });
        }

        private void createOrientationControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 7;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(Messages.PDFMapPage_Orientation_Label);
            Composite radioGroup = new Composite(composite, 0);
            GridLayout gridLayout2 = new GridLayout(2, false);
            gridLayout2.marginWidth = 0;
            gridLayout2.marginHeight = 0;
            gridLayout2.verticalSpacing = 0;
            gridLayout2.horizontalSpacing = 15;
            radioGroup.setLayout((Layout)gridLayout2);
            GridData gridData = new GridData(4, 4, false, false);
            gridData.widthHint = 300;
            gridData.heightHint = -1;
            radioGroup.setLayoutData((Object)gridData);
            this.createOrientationRadio(radioGroup, PDFMapConstants.Orientation.Landscape);
            this.createOrientationRadio(radioGroup, PDFMapConstants.Orientation.Portrait);
        }

        private void createOrientationRadio(Composite parent, final PDFMapConstants.Orientation ortn) {
            final Button widget = new Button(parent, 16);
            widget.setText(ortn.getDescription());
            widget.setData((Object)ortn);
            widget.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            widget.setSelection(this.getOrientationSelection(ortn));
            widget.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (widget.getSelection()) {
                        PDFMapExportPage.this.getDialogSettings().put("Orientation", ortn.toString());
                        PDFMapExportPage.this.updateStatus();
                    }
                }
            });
        }

        private void createShowPlusMinusControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 15;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(Messages.ExportWizard_Collapse_Expand_text);
            Composite rightGroup = new Composite(composite, 0);
            GridLayout gridLayout2 = new GridLayout(1, false);
            gridLayout2.marginWidth = 0;
            gridLayout2.marginHeight = 0;
            gridLayout2.verticalSpacing = 15;
            gridLayout2.horizontalSpacing = 0;
            gridLayout2.marginLeft = 15;
            rightGroup.setLayout((Layout)gridLayout2);
            GridData gridData = new GridData(4, 4, false, false);
            gridData.widthHint = 300;
            gridData.heightHint = -1;
            rightGroup.setLayoutData((Object)gridData);
            this.createShowPlusCheck(rightGroup);
            this.createShowMinusCheck(rightGroup);
            this.initPlusMinusCheckState();
        }

        private void createShowPlusCheck(Composite parent) {
            this.showPlusCheck = this.createPlusMinusCheck(parent, Messages.PDFMapExportWizard_PrintExpandIcon_label, MindMapUI.getImages().get("plus.png", true).createImage());
        }

        private void createShowMinusCheck(Composite parent) {
            this.showMinusCheck = this.createPlusMinusCheck(parent, Messages.PDFMapExportWizard_PrintCollapseIcon_label, MindMapUI.getImages().get("minus.png", true).createImage());
        }

        private Button createPlusMinusCheck(Composite parent, String text, Image image) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getBackground());
            composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            Button check = new Button(composite, 32);
            check.setBackground(composite.getBackground());
            check.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            check.setText(text);
            Label imageLabel = new Label(composite, 0);
            imageLabel.setBackground(composite.getBackground());
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            imageLabel.setImage(image);
            this.hookWidget((Widget)check, 13);
            return check;
        }

        private void initPlusMinusCheckState() {
            boolean plusVisible = this.getBoolean(this.getDialogSettings(), "plusVisible", true);
            boolean minusVisible = this.getBoolean(this.getDialogSettings(), "minusVisible", true);
            this.showPlusCheck.setSelection(plusVisible);
            this.showMinusCheck.setSelection(minusVisible);
        }

        private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
            boolean value = defaultValue;
            if (settings.get(key) != null) {
                value = settings.getBoolean(key);
            }
            return value;
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.showPlusCheck) {
                this.setProperty("plusVisible", this.showPlusCheck.getSelection());
            } else if (event.widget == this.showMinusCheck) {
                this.setProperty("minusVisible", this.showMinusCheck.getSelection());
            } else {
                super.handleWidgetEvent(event);
            }
        }

        private void setProperty(String key, boolean value) {
            this.getDialogSettings().put(key, value);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, Messages.PDFMapPage_FilterName);
            filterExtensions.add(0, "*.pdf");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        private int getPageSizeSelection() {
            String sizeStr = this.getDialogSettings().get("PageSize");
            PDFMapConstants.PageSize selection = sizeStr == null ? PDFMapConstants.PageSize.A4 : PDFMapConstants.PageSize.valueOf(sizeStr);
            return PDFMapExportPage.find((Object[])PDFMapConstants.PageSize.values(), (Object)selection);
        }

        private boolean getOrientationSelection(PDFMapConstants.Orientation ortn) {
            PDFMapConstants.Orientation selection;
            String ortnStr = this.getDialogSettings().get("Orientation");
            PDFMapConstants.Orientation orientation = selection = ortnStr == null ? PDFMapConstants.Orientation.Landscape : PDFMapConstants.Orientation.valueOf(ortnStr);
            return ortn == selection;
        }

        private static int find(Object[] array, Object obj) {
            if (obj != null) {
                int i = 0;
                while (i < array.length) {
                    if (array[i].equals(obj)) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        private String[] getPageSizeDescriptions() {
            PDFMapConstants.PageSize[] sizes = PDFMapConstants.PageSize.values();
            String[] descriptions = new String[sizes.length];
            int i = 0;
            while (i < sizes.length) {
                descriptions[i] = this.getPageSizeDescription(sizes[i]);
                ++i;
            }
            return descriptions;
        }

        private String getPageSizeDescription(PDFMapConstants.PageSize pageSize) {
            PrecisionPoint s = UnitConvertor.dots2mm((Point)new Point(pageSize.getWidth(), pageSize.getHeight()), (Point)PAGE_DPI);
            return String.format("%s (%.1f mm x %.1f mm)", pageSize.getName(), Math.ceil(s.x * 10.0) / 10.0, Math.ceil(s.y * 10.0) / 10.0);
        }
    }
}

