/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.gallery;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.internal.DPIUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.internal.gallery.DownloadedGalleryGroup;
import org.xmind.core.internal.gallery.GallerySheet;
import org.xmind.core.internal.gallery.IGalleryItem;

public class DownloadedGalleryItem
implements IGalleryItem {
    private Element implementation;
    private GallerySheet ownedSheet;

    public DownloadedGalleryItem(Element implementation, GallerySheet ownedSheet) {
        this.implementation = implementation;
        this.ownedSheet = ownedSheet;
    }

    public GallerySheet getOwnedSheet() {
        return this.ownedSheet;
    }

    protected Element getImplementation() {
        return this.implementation;
    }

    public URL getURL() {
        File file = new File(this.getPath());
        if (!file.isFile()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getSourceURL() {
        return this.getImplementation().getAttribute("source");
    }

    public String getPath() {
        String path = this.getImplementation().getAttribute("path");
        if (DPIUtil.getDeviceZoom() > 100) {
            return this.get2xPath(path);
        }
        return path;
    }

    private String get2xPath(String path) {
        int dot = path.lastIndexOf(46);
        if (dot > -1) {
            String lead = path.substring(0, dot);
            String tail = path.substring(dot);
            String xpath = String.valueOf(lead) + "@2x" + tail;
            if (new File(xpath).exists()) {
                path = xpath;
            }
        }
        return path;
    }

    public void setPath(String path) {
        this.getImplementation().setAttribute("path", path);
    }

    public DownloadedGalleryGroup getParent() {
        Node p = this.implementation.getParentNode();
        return new DownloadedGalleryGroup((Element)p, this.ownedSheet);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DownloadedGalleryItem)) {
            return false;
        }
        DownloadedGalleryItem that = (DownloadedGalleryItem)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public boolean isSystemItem() {
        return true;
    }
}

