/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.IEditorLayout;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.PresentationEditorLayout;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;

public class StoryMenuItemHandler {
    @Execute
    public void execute(final IWorkbenchPage page, final MDirectMenuItem item) {
        if (!(page.getActiveEditor() instanceof IGraphicalEditor)) {
            return;
        }
        VerifyUI20141031.runAction20141031((String)"StoryPresentation", (String)PresentationMessages.ShowPresentationAction_name, (int)3, (Runnable)new Runnable(){

            public void run() {
                IGraphicalEditor editor = (IGraphicalEditor)page.getActiveEditor();
                IWorkbook workbook = StoryMenuItemHandler.this.getWorkbook((IEditorPart)editor);
                if (workbook == null) {
                    return;
                }
                PresentationStory story = PresentationStoryManager.instance.getStory(workbook, item.getContainerData());
                if (story != null) {
                    IEditorLayoutManager layoutManager = (IEditorLayoutManager)editor.getAdapter(IEditorLayoutManager.class);
                    IEditorLayout currentEditorLayout = layoutManager.getActiveLayout();
                    if (currentEditorLayout instanceof PresentationEditorLayout) {
                        PresentationEditorLayout layout = (PresentationEditorLayout)currentEditorLayout;
                        layout.setCurrentStory(story);
                    } else {
                        layoutManager.restoreDefault();
                        PresentationEditorLayout layout = new PresentationEditorLayout(layoutManager, story, editor);
                        layout.setSelectionProvider(editor.getSite().getSelectionProvider());
                        layoutManager.setActiveLayout((IEditorLayout)layout);
                    }
                }
            }
        }, null);
    }

    private IWorkbook getWorkbook(IEditorPart editor) {
        IViewer viewer = (IViewer)MindMapUIPlugin.getAdapter((Object)editor, IViewer.class);
        if (viewer != null) {
            return (IWorkbook)viewer.getAdapter(IWorkbook.class);
        }
        return null;
    }
}

