/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.part.IPart;
import org.xmind.ui.decorations.IArrowDecoration;
import org.xmind.ui.decorations.IBoundaryDecoration;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.decorations.ISummaryDecoration;
import org.xmind.ui.internal.figures.BoundaryFigure;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.figures.InformationFigure;
import org.xmind.ui.internal.figures.RelationshipFigure;
import org.xmind.ui.internal.figures.SummaryFigure;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.internal.mindmap.IconTipPart;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;

public class SlideFilter {
    private final IGraphicalViewer viewer;

    public SlideFilter(IGraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public void show(PresentationSlide slide) {
        String type = slide.getType();
        AbstractFilter filter = null;
        if ("topic".equals(type)) {
            filter = new TopicFilter(slide);
        } else if ("summary".equals(type)) {
            filter = new SummaryFilter(slide);
        } else if ("boundary".equals(type)) {
            filter = new BoundaryFilter(slide);
        } else if ("relationship".equals(type)) {
            filter = new RelationshipFilter(slide);
        }
        if (filter != null) {
            ((AbstractFilter)filter).show();
        }
    }

    private ITopicPart findTopicPart(ITopic topic) {
        IPart part = this.viewer.findPart((Object)topic);
        if (part instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return null;
    }

    private IBranchPart findBranchPart(ITopic topic) {
        IPart part = this.viewer.findPart((Object)topic);
        if (part != null) {
            return (IBranchPart)part.getAdapter(IBranchPart.class);
        }
        return null;
    }

    private IFigure findBranchFigure(ITopic topic) {
        IBranchPart branch = this.findBranchPart(topic);
        if (branch != null) {
            return branch.getFigure();
        }
        return null;
    }

    private abstract class AbstractFilter {
        public static final int OPAQUE_ALPHA = 255;
        public static final int GRAY_ALPHA = 30;
        protected List<ITopic> selections;
        protected List<ITopic> selectionsParents;

        private AbstractFilter() {
        }

        public abstract void show();

        protected void hideOtherElements(ITopic parent) {
            for (ITopic child : parent.getAllChildren()) {
                IFigure branchFigure;
                if (this.selectionsParents.contains(child)) {
                    this.hideOtherElements(child);
                    continue;
                }
                if (this.selections.contains(child) || (branchFigure = SlideFilter.this.findBranchFigure(child)) == null) continue;
                branchFigure.setVisible(false);
            }
            this.hideSelectionParent(parent);
        }

        private void hideSelectionParent(ITopic selectionParent) {
            ITopicPart topicPart = SlideFilter.this.findTopicPart(selectionParent);
            if (topicPart != null) {
                IBranchPart branchPart = topicPart.getOwnerBranch();
                if (branchPart != null) {
                    IDecoration decoration;
                    BranchFigure branchFigure = (BranchFigure)branchPart.getFigure();
                    branchFigure.setVisible(true);
                    branchFigure.setMainAlpha(255);
                    this.hideSelectionParentBranchElements(branchPart);
                    if (this.hasSpreadsheetStructure(selectionParent.getStructureClass()) && (decoration = branchFigure.getDecoration()) != null) {
                        decoration.setVisible((IFigure)branchFigure, false);
                    }
                }
                topicPart.getFigure().setVisible(false);
            }
        }

        private boolean hasSpreadsheetStructure(String structure) {
            return "org.xmind.ui.spreadsheet.column".equals(structure) || "org.xmind.ui.spreadsheet".equals(structure);
        }

        private void hideSelectionParentBranchElements(IBranchPart branchPart) {
            for (ISummaryPart summaryPart : branchPart.getSummaries()) {
                summaryPart.getFigure().setVisible(false);
            }
            for (IBoundaryPart boundaryPart : branchPart.getBoundaries()) {
                boundaryPart.getFigure().setVisible(false);
            }
            BranchFigure branchFigure = (BranchFigure)branchPart.getFigure();
            branchFigure.setFolded(false);
            this.hidePlusMinusPart(branchPart);
            branchPart.getConnections().setVisible((IFigure)branchFigure, false);
            if (branchPart.getInfoPart() != null) {
                this.setInfoPartVisible(branchPart.getInfoPart(), false);
            }
        }

        private void hidePlusMinusPart(IBranchPart branchPart) {
            IPlusMinusPart pmPart = branchPart.getPlusMinus();
            if (pmPart != null) {
                pmPart.getFigure().setVisible(false);
            }
        }

        protected void revealTopics() {
            for (ITopic selection : this.selections) {
                this.revealTopic(selection);
            }
        }

        private void revealTopic(ITopic topic) {
            this.revealTopicElement(topic);
            for (ITopic subTopic : topic.getAllChildren()) {
                this.revealTopic(subTopic);
            }
        }

        protected abstract void revealTopicElement(ITopic var1);

        protected void revealTopicBranchElements(IBranchPart branchPart, ITopic topic) {
            IDecoration decoration;
            BranchFigure branchFigure = (BranchFigure)branchPart.getFigure();
            branchFigure.setVisible(true);
            branchFigure.setFolded(false);
            this.hidePlusMinusPart(branchPart);
            this.revealBranchConnections(branchPart, branchFigure, topic);
            this.revealCalloutConnections(topic);
            this.revealInfoPart(branchPart.getInfoPart(), topic);
            if (this.hasSpreadsheetStructure(topic.getStructureClass()) && (decoration = branchFigure.getDecoration()) != null) {
                decoration.setVisible((IFigure)branchFigure, true);
            }
        }

        protected void revealBranchConnections(IBranchPart branchPart, BranchFigure branchFigure, ITopic parent) {
            IBranchConnections connections = branchPart.getConnections();
            connections.setVisible((IFigure)branchFigure, true);
            connections.setAlpha((IFigure)branchFigure, 255);
            for (ITopic subTopic : parent.getChildren("attached")) {
                IDecoration decoration = connections.getDecoration(subTopic.getIndex());
                if (decoration == null) continue;
                decoration.setAlpha((IFigure)branchFigure, 255);
            }
        }

        protected void revealCalloutConnections(ITopic topic) {
            ITopicPart topicPart;
            if ("callout".equals(topic.getType()) && (topicPart = SlideFilter.this.findTopicPart(topic.getParent())) != null) {
                topicPart.getFigure().setVisible(true);
            }
        }

        protected void revealInfoPart(IInfoPart infoPart, ITopic topic) {
            if (infoPart != null) {
                this.setInfoPartVisible(infoPart, !infoPart.getChildren().isEmpty());
            }
        }

        protected void cleanIconItpPartAction(ITopicPart topicPart) {
            for (IIconTipPart p : topicPart.getIconTips()) {
                if (!(p instanceof IconTipPart)) continue;
                ((IconTipPart)p).setAction(null);
            }
        }

        public void setRelationshipVisible(IRelationship r, boolean visible) {
            this.setRelationshipVisible(r, visible, 255);
        }

        public void setRelationshipVisible(IRelationship r, boolean visible, int alpha) {
            IPart part = SlideFilter.this.viewer.findPart((Object)r);
            if (part instanceof IRelationshipPart) {
                IArrowDecoration arrow2;
                IRelationshipPart rp = (IRelationshipPart)part;
                RelationshipFigure figure = (RelationshipFigure)rp.getFigure();
                boolean hasTitle = r.hasTitle() && !"".equals(r.getTitleText());
                figure.getTitle().setVisible(visible && hasTitle);
                IRelationshipDecoration decoration = figure.getDecoration();
                decoration.setVisible((IFigure)figure, visible);
                decoration.setAlpha((IFigure)figure, alpha);
                IArrowDecoration arrow1 = decoration.getArrow1();
                if (arrow1 != null) {
                    arrow1.setVisible((IFigure)figure, visible);
                    arrow1.setAlpha((IFigure)figure, alpha);
                }
                if ((arrow2 = decoration.getArrow2()) != null) {
                    arrow2.setVisible((IFigure)figure, visible);
                    arrow2.setAlpha((IFigure)figure, alpha);
                }
            }
        }

        protected void hideAllRelationships(ITopic rootTopic) {
            ISheet sheet = rootTopic.getOwnedSheet();
            if (sheet != null) {
                for (IRelationship r : sheet.getRelationships()) {
                    this.setRelationshipVisible(r, false);
                }
            }
        }

        public void setSummaryVisible(ISummaryPart s, boolean visible) {
            this.setSummaryVisible(s, visible, 255);
        }

        public void setSummaryVisible(ISummaryPart sp, boolean visible, int alpha) {
            SummaryFigure summaryFigure = (SummaryFigure)sp.getFigure();
            summaryFigure.setVisible(visible);
            ISummaryDecoration decoration = summaryFigure.getDecoration();
            decoration.setVisible((IFigure)summaryFigure, visible);
            decoration.setAlpha((IFigure)summaryFigure, alpha);
            for (IBranchPart branchPart : sp.getEnclosingBranches()) {
                branchPart.getFigure().setVisible(visible);
            }
            ITopic summaryTopic = sp.getSummaryTopic();
            ITopicPart topicPart = SlideFilter.this.findTopicPart(summaryTopic);
            if (topicPart != null) {
                TopicFigure topicFigure = (TopicFigure)topicPart.getFigure();
                topicFigure.setVisible(visible);
                topicFigure.setMainAlpha(alpha);
            }
        }

        public void setBoundaryVisible(IBoundaryPart bp, boolean visible) {
            this.setBoundaryVisible(bp, visible, 255);
        }

        public void setBoundaryVisible(IBoundaryPart bp, boolean visible, int alpha) {
            BoundaryFigure bf = (BoundaryFigure)bp.getFigure();
            bf.setVisible(visible);
            IBoundaryDecoration decoration = bf.getDecoration();
            decoration.setVisible((IFigure)bf, visible);
            decoration.setAlpha((IFigure)bf, alpha);
        }

        public void setInfoPartVisible(IInfoPart ip, boolean visible) {
            this.setInfoPartVisible(ip, visible, 255);
        }

        public void setInfoPartVisible(IInfoPart ip, boolean visible, int alpha) {
            InformationFigure figure = (InformationFigure)ip.getFigure();
            figure.setVisible(visible);
            figure.setMainAlpha(alpha);
        }
    }

    private class BoundaryFilter
    extends AbstractFilter {
        private PresentationSlide slide;
        private IBoundary parent;
        private ITopic rootTopic;

        public BoundaryFilter(PresentationSlide slide) {
            this.slide = slide;
            this.init();
        }

        private void init() {
            if (this.slide.getParent() instanceof IBoundary) {
                this.parent = (IBoundary)this.slide.getParent();
                this.rootTopic = this.parent.getParent().getPath().getRootTopic();
            }
            if (this.parent == null || this.rootTopic == null) {
                throw new IllegalArgumentException();
            }
            this.selections = new ArrayList();
            for (ITopic topic : this.parent.getEnclosingTopics()) {
                this.selections.add(topic);
            }
            this.selectionsParents = new ArrayList();
            ITopic summaryParent = this.parent.getParent();
            this.selectionsParents.addAll(summaryParent.getPath().toTopicList());
            if (this.selections.isEmpty()) {
                throw new IllegalArgumentException();
            }
        }

        public void show() {
            this.hideOtherElements(this.rootTopic);
            this.hideAllRelationships(this.rootTopic);
            this.revealTopics();
            this.revealParentBoundary();
        }

        protected void revealTopicElement(ITopic topic) {
            IBranchPart branchPart = SlideFilter.this.findBranchPart(topic);
            if (branchPart == null) {
                return;
            }
            this.revealTopicBranchElements(branchPart, topic);
            for (ISummaryPart sp : branchPart.getSummaries()) {
                this.setSummaryVisible(sp, true);
            }
            for (IBoundaryPart bp : branchPart.getBoundaries()) {
                this.setBoundaryVisible(bp, true);
            }
            ITopicPart topicPart = branchPart.getTopicPart();
            if (topicPart != null) {
                TopicFigure topicFigure = (TopicFigure)topicPart.getFigure();
                topicFigure.setVisible(true);
                topicFigure.setMainAlpha(255);
                this.cleanIconItpPartAction(topicPart);
            }
        }

        private void revealParentBoundary() {
            IPart part = SlideFilter.this.viewer.findPart((Object)this.parent);
            if (part instanceof IBoundaryPart) {
                this.setBoundaryVisible((IBoundaryPart)part, true);
            }
        }
    }

    private class RelationshipFilter
    extends AbstractFilter {
        private PresentationSlide slide;
        private ITopic rootTopic;
        private List<IRelationship> relationshipSelections;
        private List<IBoundary> revealBoundaries;

        public RelationshipFilter(PresentationSlide slide) {
            this.slide = slide;
            this.init();
        }

        private void init() {
            if (this.slide.getParent() instanceof IRelationship) {
                IRelationship r = (IRelationship)this.slide.getParent();
                this.rootTopic = r.getOwnedSheet().getRootTopic();
            }
            if (this.rootTopic == null) {
                throw new IllegalArgumentException();
            }
            this.relationshipSelections = new ArrayList<IRelationship>();
            this.selections = new ArrayList();
            this.selectionsParents = new ArrayList();
            this.revealBoundaries = new ArrayList<IBoundary>();
            for (IAdaptable a : this.slide.getSelections()) {
                if (!(a instanceof IRelationship)) continue;
                IRelationship r = (IRelationship)a;
                this.relationshipSelections.add(r);
                this.fillSelectionsAndParentsList(r.getEnd1());
                this.fillSelectionsAndParentsList(r.getEnd2());
            }
            if (this.selections.isEmpty()) {
                throw new IllegalArgumentException();
            }
        }

        private void fillSelectionsAndParentsList(IRelationshipEnd end) {
            if (end instanceof ITopic) {
                ITopic t = (ITopic)end;
                this.selections.add(t);
                this.selectionsParents.addAll(t.getPath().toTopicList());
                this.selectionsParents.remove(t);
            } else if (end instanceof IBoundary) {
                IBoundary b = (IBoundary)end;
                this.revealBoundaries.add(b);
                this.selections.addAll(b.getEnclosingTopics());
                ITopic boundaryParent = b.getParent();
                this.selectionsParents.addAll(boundaryParent.getPath().toTopicList());
            }
        }

        public void show() {
            this.hideOtherElements(this.rootTopic);
            this.revealRelationships();
            this.revealTopics();
            this.revealBoundaries();
        }

        private void revealRelationships() {
            ISheet sheet = this.rootTopic.getOwnedSheet();
            if (sheet == null) {
                return;
            }
            for (IRelationship r : sheet.getRelationships()) {
                if (this.relationshipSelections.contains(r)) {
                    this.setRelationshipVisible(r, true);
                    continue;
                }
                this.setRelationshipVisible(r, false);
            }
        }

        protected void revealTopicElement(ITopic topic) {
            IBranchPart branchPart = SlideFilter.this.findBranchPart(topic);
            if (branchPart == null) {
                return;
            }
            this.revealTopicBranchElements(branchPart, topic);
            for (ISummaryPart sp : branchPart.getSummaries()) {
                this.setSummaryVisible(sp, true);
            }
            for (IBoundaryPart bp : branchPart.getBoundaries()) {
                this.setBoundaryVisible(bp, true);
            }
            ITopicPart topicPart = branchPart.getTopicPart();
            if (topicPart != null) {
                TopicFigure topicFigure = (TopicFigure)topicPart.getFigure();
                topicFigure.setVisible(true);
                topicFigure.setMainAlpha(255);
                this.cleanIconItpPartAction(topicPart);
            }
        }

        private void revealBoundaries() {
            for (IBoundary b : this.revealBoundaries) {
                IPart part = SlideFilter.this.viewer.findPart((Object)b);
                if (!(part instanceof IBoundaryPart)) continue;
                this.setBoundaryVisible((IBoundaryPart)part, true);
            }
        }
    }

    private class SummaryFilter
    extends AbstractFilter {
        private PresentationSlide slide;
        private ISummary parent;
        private ITopic rootTopic;

        public SummaryFilter(PresentationSlide slide) {
            this.slide = slide;
            this.init();
        }

        private void init() {
            if (this.slide.getParent() instanceof ISummary) {
                this.parent = (ISummary)this.slide.getParent();
                this.rootTopic = this.parent.getTopic().getPath().getRootTopic();
            }
            if (this.parent == null || this.rootTopic == null) {
                throw new IllegalArgumentException();
            }
            this.selections = new ArrayList();
            this.selections.add(this.parent.getTopic());
            for (ITopic topic : this.parent.getEnclosingTopics()) {
                this.selections.add(topic);
            }
            this.selectionsParents = new ArrayList();
            ITopic summaryParent = this.parent.getParent();
            this.selectionsParents.addAll(summaryParent.getPath().toTopicList());
            if (this.selections.isEmpty()) {
                throw new IllegalArgumentException();
            }
        }

        public void show() {
            this.hideOtherElements(this.rootTopic);
            this.hideAllRelationships(this.rootTopic);
            this.revealTopics();
            this.revealParentSummary();
        }

        protected void revealTopicElement(ITopic topic) {
            IBranchPart branchPart = SlideFilter.this.findBranchPart(topic);
            if (branchPart == null) {
                return;
            }
            this.revealTopicBranchElements(branchPart, topic);
            ITopic summaryTopic = this.parent.getTopic();
            boolean visible = topic.getPath().isDescendentOf(summaryTopic) || topic == summaryTopic;
            this.setSummariesVisible(branchPart, visible);
            this.setBoundariesVisible(branchPart, visible);
            ITopicPart topicPart = branchPart.getTopicPart();
            if (topicPart != null) {
                TopicFigure topicFigure = (TopicFigure)topicPart.getFigure();
                topicFigure.setVisible(true);
                topicFigure.setMainAlpha(255);
                this.cleanIconItpPartAction(topicPart);
            }
        }

        private void revealParentSummary() {
            ITopic summaryParent = this.parent.getParent();
            IBranchPart branchPart = SlideFilter.this.findBranchPart(summaryParent);
            if (branchPart != null) {
                for (ISummaryPart sp : branchPart.getSummaries()) {
                    if (sp.getSummary() != this.parent) continue;
                    this.setSummaryVisible(sp, true);
                }
            }
        }

        private void setSummariesVisible(IBranchPart branchPart, boolean visible) {
            for (ISummaryPart sp : branchPart.getSummaries()) {
                this.setSummaryVisible(sp, visible);
            }
        }

        private void setBoundariesVisible(IBranchPart branchPart, boolean visible) {
            for (IBoundaryPart bp : branchPart.getBoundaries()) {
                this.setBoundaryVisible(bp, visible);
            }
        }
    }

    private class TopicFilter
    extends AbstractFilter {
        private final PresentationSlide slide;
        private ITopic rootTopic;
        private ITopic parent;
        private List<ITopic> revealTopics;
        private List<ITopic> grayedTopics;
        private boolean needGrayed = true;

        public TopicFilter(PresentationSlide slide) {
            this.slide = slide;
            this.init();
        }

        private void init() {
            if (this.slide.getParent() instanceof ITopic) {
                this.parent = (ITopic)this.slide.getParent();
                this.rootTopic = this.parent.getPath().getRootTopic();
            }
            if (this.parent == null || this.rootTopic == null) {
                throw new IllegalArgumentException();
            }
            this.selections = new ArrayList();
            this.selectionsParents = new ArrayList();
            for (IAdaptable a : this.slide.getSelections()) {
                if (!(a instanceof ITopic)) continue;
                ITopic selection = (ITopic)a;
                this.selections.add(selection);
                this.selectionsParents.addAll(selection.getPath().toTopicList());
                this.selectionsParents.remove(selection);
            }
            if (this.selections.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (this.selections.size() == 1 && this.selections.contains(this.parent)) {
                this.needGrayed = false;
            }
            this.revealTopics = new ArrayList<ITopic>();
            this.grayedTopics = new ArrayList<ITopic>();
            for (ITopic selection : this.selections) {
                this.sortSubTopics(selection);
                this.revealTopics.add(selection);
            }
        }

        private void sortSubTopics(ITopic topic) {
            this.revealTopics.addAll(topic.getAllChildren());
            if (this.needGrayed) {
                for (ITopic subTopic : topic.getAllChildren()) {
                    boolean isSummaryTopic = "summary".equals(subTopic.getType());
                    if (isSummaryTopic) {
                        this.sortSubTopics(subTopic);
                        continue;
                    }
                    if (this.selections.contains(subTopic)) continue;
                    this.grayedTopics.add(subTopic);
                    this.sortSubTopics(subTopic);
                }
            } else {
                for (ITopic subTopic : topic.getAllChildren()) {
                    this.sortSubTopics(subTopic);
                }
            }
        }

        public void show() {
            if (!this.selections.contains(this.rootTopic)) {
                this.hideOtherElements(this.rootTopic);
            }
            this.revealRelationships();
            this.revealTopics();
        }

        private void revealRelationships() {
            ISheet sheet = this.rootTopic.getOwnedSheet();
            if (sheet == null) {
                return;
            }
            for (IRelationship r : sheet.getRelationships()) {
                IRelationshipEnd e1 = r.getEnd1();
                IRelationshipEnd e2 = r.getEnd2();
                if (!this.canReveal(e1) || !this.canReveal(e2)) {
                    this.setRelationshipVisible(r, false);
                    continue;
                }
                if (!this.needGrayed) {
                    this.setRelationshipVisible(r, true, 255);
                    continue;
                }
                if (this.getAlpha(e1) == 30 || this.getAlpha(e2) == 30) {
                    this.setRelationshipVisible(r, true, 30);
                    continue;
                }
                this.setRelationshipVisible(r, true, 255);
            }
        }

        private boolean canReveal(IRelationshipEnd relationshipEnd) {
            if (relationshipEnd instanceof ITopic) {
                return this.revealTopics.contains(relationshipEnd);
            }
            if (relationshipEnd instanceof IBoundary) {
                IBoundary b = (IBoundary)relationshipEnd;
                for (ITopic t : b.getEnclosingTopics()) {
                    if (this.revealTopics.contains(t)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private int getAlpha(IRelationshipEnd relationshipEnd) {
            if (relationshipEnd instanceof ITopic) {
                return this.grayedTopics.contains(relationshipEnd) ? 30 : 255;
            }
            if (relationshipEnd instanceof IBoundary) {
                IBoundary b = (IBoundary)relationshipEnd;
                for (ITopic t : b.getEnclosingTopics()) {
                    if (!this.grayedTopics.contains(t)) continue;
                    return 30;
                }
            }
            return 255;
        }

        protected void revealTopicElement(ITopic topic) {
            IBranchPart branchPart = SlideFilter.this.findBranchPart(topic);
            if (branchPart == null) {
                return;
            }
            this.revealTopicBranchElements(branchPart, topic);
            this.revealSummaries(branchPart);
            this.revealBoundaries(branchPart);
            ITopicPart topicPart = branchPart.getTopicPart();
            if (topicPart != null) {
                if (!"summary".equals(topic.getType())) {
                    TopicFigure topicFigure = (TopicFigure)topicPart.getFigure();
                    topicFigure.setVisible(true);
                    if (this.needGrayed && this.grayedTopics.contains(topic)) {
                        topicFigure.setMainAlpha(30);
                    } else {
                        topicFigure.setMainAlpha(255);
                    }
                }
                this.cleanIconItpPartAction(topicPart);
            }
        }

        protected void revealBranchConnections(IBranchPart branchPart, BranchFigure branchFigure, ITopic parent) {
            if (!this.needGrayed) {
                super.revealBranchConnections(branchPart, branchFigure, parent);
            } else {
                IBranchConnections connections = branchPart.getConnections();
                connections.setVisible((IFigure)branchFigure, true);
                List children = parent.getChildren("attached");
                ArrayList<IDecoration> needGrayedDecorations = new ArrayList<IDecoration>();
                for (ITopic subTopic : children) {
                    IDecoration decoration;
                    if (!this.grayedTopics.contains(subTopic) || (decoration = connections.getDecoration(subTopic.getIndex())) == null) continue;
                    needGrayedDecorations.add(decoration);
                }
                if (needGrayedDecorations.size() == children.size()) {
                    connections.setAlpha((IFigure)branchFigure, 30);
                } else {
                    connections.setAlpha((IFigure)branchFigure, 255);
                    for (IDecoration d : needGrayedDecorations) {
                        d.setAlpha((IFigure)branchFigure, 30);
                    }
                }
            }
        }

        protected void revealInfoPart(IInfoPart infoPart, ITopic topic) {
            if (infoPart != null) {
                if (infoPart.getChildren().isEmpty()) {
                    this.setInfoPartVisible(infoPart, false);
                    return;
                }
                if (this.needGrayed && this.grayedTopics.contains(topic)) {
                    this.setInfoPartVisible(infoPart, true, 30);
                } else {
                    this.setInfoPartVisible(infoPart, true);
                }
            }
        }

        private void revealSummaries(IBranchPart branchPart) {
            for (ISummaryPart sp : branchPart.getSummaries()) {
                if (!this.needGrayed) {
                    this.setSummaryVisible(sp, true);
                    continue;
                }
                ISummary s = sp.getSummary();
                int alpha = 255;
                for (ITopic t : s.getEnclosingTopics()) {
                    if (!this.grayedTopics.contains(t)) continue;
                    alpha = 30;
                    break;
                }
                this.setSummaryVisible(sp, true, alpha);
            }
        }

        private void revealBoundaries(IBranchPart branchPart) {
            for (IBoundaryPart bp : branchPart.getBoundaries()) {
                if (!this.needGrayed) {
                    this.setBoundaryVisible(bp, true);
                    continue;
                }
                int alpha = 255;
                IBoundary b = bp.getBoundary();
                for (ITopic t : b.getEnclosingTopics()) {
                    if (!this.grayedTopics.contains(t)) continue;
                    alpha = 30;
                    break;
                }
                this.setBoundaryVisible(bp, true, alpha);
            }
        }
    }
}

