/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.internal.presentation.Presentation;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryGalleryViewer;
import org.xmind.ui.internal.presentation.slide.PresentationStoryPage;
import org.xmind.ui.internal.presentation.slide.PresentationStoryWindow;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ControlWrapper {
    private static final String PATH = "icons/";
    private PresentationStoryWindow window;
    private PresentationStory story;
    private ResourceManager resources;
    private Composite controlWrapper;
    private Composite controlPanel;
    private Label currentPageLabel;
    private Label totalPagesLabel;
    private Composite slidesArea;
    private Label backButton;
    private Label forwardButton;
    private PresentationStoryGalleryViewer viewer;
    private int currentSlideIndex;
    private List<Region> regions = new ArrayList<Region>();

    public ControlWrapper(PresentationStoryWindow window, PresentationStory story) {
        this.window = window;
        this.story = story;
    }

    public Control getControl() {
        return this.controlWrapper;
    }

    public void createControl(Composite parent) {
        this.controlWrapper = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.controlWrapper);
        this.controlWrapper.moveAbove(null);
        this.controlWrapper.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#e3e3e3")));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.controlWrapper.setLayout((Layout)layout);
        this.createControlPanel(this.controlWrapper);
        this.createSlidesArea(this.controlWrapper);
        this.initRegions((Control)this.controlWrapper);
        this.updateRegions();
    }

    private void createControlPanel(Composite parent) {
        Composite border;
        this.controlPanel = border = new Composite(parent, 0);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#e3e3e3")));
        GridData gridData = new GridData(4, 128, true, false);
        border.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 0;
        border.setLayout((Layout)layout);
        Composite composite = new Composite(border, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#fbfbfb")));
        GridData gridData2 = new GridData(1808);
        gridData2.exclude = false;
        composite.setLayoutData((Object)gridData2);
        GridLayout layout2 = new GridLayout(5, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 0;
        composite.setLayout((Layout)layout2);
        Point size = new Point(240, 42);
        GridData borderData = (GridData)border.getLayoutData();
        borderData.widthHint = size.x;
        borderData.heightHint = size.y;
        this.createLeftBarArea(composite);
        this.createRightBarArea(composite);
        this.currentSlideIndex = this.story.getSlidesSize() > 0 ? 0 : -1;
        this.updatePageLabel();
        this.initViewerSelection();
        this.updateButtonStatus();
    }

    private void createLeftBarArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.backButton = this.createButton(composite, (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/nav_back.png")), (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/nav_back_hover.png")), PresentationMessages.ControlWrapper_Button_Go_back, new Runnable(){

            public void run() {
                ControlWrapper.this.prevPage();
            }
        });
        this.createPagesArea(composite);
        this.forwardButton = this.createButton(composite, (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/nav_forward.png")), (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/nav_forward_hover.png")), PresentationMessages.ControlWrapper_Button_Go_forwoard, new Runnable(){

            public void run() {
                ControlWrapper.this.nextPage();
            }
        });
    }

    private void createRightBarArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createButton(parent, (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/button_close.png")), (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/button_close_hover.png")), PresentationMessages.ControlWrapper_Button_Exit, new Runnable(){

            public void run() {
                if (ControlWrapper.this.window != null) {
                    ControlWrapper.this.window.close();
                    ControlWrapper.this.window = null;
                }
            }
        });
    }

    private Label createButton(Composite parent, Image image, Image hoverImage, String tooltip, Runnable runnable) {
        Label buttonLabel = new Label(parent, 0);
        buttonLabel.setBackground(parent.getBackground());
        GridData gridData = new GridData(16384, 0x1000000, false, true);
        buttonLabel.setLayoutData((Object)gridData);
        if (image != null) {
            buttonLabel.setImage(image);
        }
        if (tooltip != null) {
            buttonLabel.setToolTipText(tooltip);
        }
        buttonLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        this.installMouseListener(buttonLabel, image, hoverImage, runnable);
        return buttonLabel;
    }

    private void installMouseListener(final Label button, final Image image, final Image hoverImage, final Runnable runnable) {
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                button.setImage(image);
            }

            public void mouseEnter(MouseEvent e) {
                button.setImage(hoverImage);
            }
        };
        button.addMouseTrackListener(mouseTrackListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        button.addMouseListener((MouseListener)mouseListener);
    }

    private void createPagesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        final Color foreground = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#bfbfbf"));
        final Color hoverForeground = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#dbdbdb"));
        this.currentPageLabel = new Label(composite, 0);
        this.currentPageLabel.setBackground(composite.getBackground());
        GridData gridData = new GridData(16384, 0x1000000, false, true);
        this.currentPageLabel.setLayoutData((Object)gridData);
        this.currentPageLabel.setForeground(foreground);
        this.currentPageLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.currentPageLabel.getFont().getFontData(), (int)5))));
        final Label separatorLabel = new Label(composite, 0);
        separatorLabel.setBackground(composite.getBackground());
        GridData gridData2 = new GridData(16384, 0x1000000, false, true);
        separatorLabel.setLayoutData((Object)gridData2);
        separatorLabel.setForeground(foreground);
        separatorLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])separatorLabel.getFont().getFontData(), (int)5))));
        separatorLabel.setText("/");
        this.totalPagesLabel = new Label(composite, 0);
        this.totalPagesLabel.setBackground(composite.getBackground());
        GridData gridData3 = new GridData(16384, 0x1000000, false, true);
        this.totalPagesLabel.setLayoutData((Object)gridData3);
        this.totalPagesLabel.setForeground(foreground);
        this.totalPagesLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.totalPagesLabel.getFont().getFontData(), (int)5))));
        this.totalPagesLabel.setText("" + this.story.getSlidesSize());
        composite.setCursor(parent.getDisplay().getSystemCursor(21));
        this.currentPageLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        separatorLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        this.totalPagesLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                ControlWrapper.this.currentPageLabel.setForeground(foreground);
                separatorLabel.setForeground(foreground);
                ControlWrapper.this.totalPagesLabel.setForeground(foreground);
            }

            public void mouseEnter(MouseEvent e) {
                ControlWrapper.this.currentPageLabel.setForeground(hoverForeground);
                separatorLabel.setForeground(hoverForeground);
                ControlWrapper.this.totalPagesLabel.setForeground(hoverForeground);
            }
        };
        composite.addMouseTrackListener(mouseTrackListener);
        this.currentPageLabel.addMouseTrackListener(mouseTrackListener);
        separatorLabel.addMouseTrackListener(mouseTrackListener);
        this.totalPagesLabel.addMouseTrackListener(mouseTrackListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ControlWrapper.this.slidesArea.isVisible()) {
                    ControlWrapper.this.hideSlides();
                } else {
                    ControlWrapper.this.showSlides();
                }
            }
        };
        composite.addMouseListener((MouseListener)mouseListener);
        this.currentPageLabel.addMouseListener((MouseListener)mouseListener);
        separatorLabel.addMouseListener((MouseListener)mouseListener);
        this.totalPagesLabel.addMouseListener((MouseListener)mouseListener);
    }

    private void showSlides() {
        if (this.slidesArea.isVisible()) {
            return;
        }
        this.slidesArea.setVisible(true);
        ((GridData)this.slidesArea.getLayoutData()).exclude = false;
        this.updateRegions();
        this.updateButtonStatus();
        this.controlWrapper.pack();
        this.controlWrapper.layout();
        this.initViewerSelection();
    }

    private void hideSlides() {
        if (!this.slidesArea.isVisible()) {
            return;
        }
        this.slidesArea.setVisible(false);
        ((GridData)this.slidesArea.getLayoutData()).exclude = true;
        this.updateRegions();
        this.updateButtonStatus();
        this.controlWrapper.pack();
        this.controlWrapper.layout();
    }

    private void updateRegions() {
        boolean slidesVisible = this.slidesArea.isVisible();
        if (slidesVisible) {
            this.controlWrapper.setRegion(this.regions.get(0));
            this.controlPanel.setRegion(this.regions.get(1));
            Image image = (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/story_control_panel_show_background.png"));
            this.controlPanel.setBackgroundImage(image);
        } else {
            this.controlWrapper.setRegion(this.regions.get(2));
            this.controlPanel.setRegion(this.regions.get(3));
            Image image = (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/story_control_panel_hide_background.png"));
            this.controlPanel.setBackgroundImage(image);
        }
    }

    private void initRegions(Control parent) {
        Region region_2;
        Point size = new Point(240, 674);
        Image image = (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/story_control_panel_show_background.png"));
        Region region_1 = this.getImageRegion(image);
        Rectangle imageBounds = image.getBounds();
        Region region0 = new Region();
        region0.add(region_1);
        region0.add(new Rectangle(0, imageBounds.height, size.x, size.y - imageBounds.height));
        this.regions.add(region0);
        Region region1 = region_1;
        this.regions.add(region1);
        Image image2 = (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/story_control_panel_hide_background.png"));
        Region region2 = region_2 = this.getImageRegion(image2);
        this.regions.add(region2);
        Region region3 = region_2;
        this.regions.add(region3);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Region region : ControlWrapper.this.regions) {
                    region.dispose();
                }
                ControlWrapper.this.regions.clear();
                ControlWrapper.this.regions = null;
            }
        });
    }

    private Region getImageRegion(Image image) {
        Rectangle imageBounds = image.getBounds();
        Region region = new Region();
        region.add(new Rectangle(imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height));
        ImageData data = image.getImageData();
        Rectangle pixel = new Rectangle(0, 0, 1, 1);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                if (data.getAlpha(x, y) == 0) {
                    pixel.x = data.x + x;
                    pixel.y = data.y + y;
                    region.subtract(pixel);
                }
                ++x;
            }
            ++y;
        }
        return region;
    }

    private void createSlidesArea(Composite parent) {
        Composite border = new Composite(parent, 0);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#e3e3e3")));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 632;
        gridData.widthHint = 240;
        border.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 0;
        layout.marginBottom = 1;
        border.setLayout((Layout)layout);
        Composite composite = new Composite(border, 0);
        composite.setBackground(this.resources.createColor(ColorUtils.toDescriptor((String)"#F6F5F5")));
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.marginLeft = 1;
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 0;
        composite.setLayout((Layout)new FillLayout());
        this.viewer = new PresentationStoryGalleryViewer(null, true);
        this.viewer.createControl(composite, 0);
        this.viewer.setInput(this.story.getSlides());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object o = selection.getFirstElement();
                if (o instanceof PresentationSlide) {
                    PresentationSlide slide = (PresentationSlide)o;
                    if (ControlWrapper.this.currentSlideIndex != slide.getIndex()) {
                        ControlWrapper.this.currentSlideIndex = slide.getIndex();
                        ControlWrapper.this.switchSlide(ControlWrapper.this.currentSlideIndex);
                    }
                }
            }
        });
        this.slidesArea = border;
        this.slidesArea.setVisible(false);
        ((GridData)this.slidesArea.getLayoutData()).exclude = true;
    }

    private void updatePageLabel() {
        if (this.currentPageLabel != null && !this.currentPageLabel.isDisposed()) {
            if (this.currentSlideIndex > -1) {
                this.currentPageLabel.setText("" + (this.currentSlideIndex + 1));
            } else {
                this.currentPageLabel.setText("0");
            }
            this.currentPageLabel.getParent().layout();
        }
        if (this.controlPanel != null && !this.controlPanel.isDisposed()) {
            this.controlPanel.layout(true, true);
        }
    }

    private void initViewerSelection() {
        if (this.story != null && this.currentSlideIndex < this.story.getSlides().size() && this.viewer != null) {
            PresentationSlide slide = this.story.getSlides().get(this.currentSlideIndex);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)slide));
        }
    }

    private void updateButtonStatus() {
        if (this.backButton != null && !this.backButton.isDisposed()) {
            this.backButton.setEnabled(this.currentSlideIndex > 0);
        }
        if (this.forwardButton != null && !this.forwardButton.isDisposed()) {
            this.forwardButton.setEnabled(this.currentSlideIndex < this.story.getSlidesSize() - 1);
        }
    }

    public void prevPage() {
        if (this.currentSlideIndex > 0) {
            --this.currentSlideIndex;
            this.switchSlide(this.currentSlideIndex);
        }
    }

    public void nextPage() {
        if (this.currentSlideIndex < this.story.getSlidesSize() - 1) {
            ++this.currentSlideIndex;
            this.switchSlide(this.currentSlideIndex);
        }
    }

    private void switchSlide(int slideIndex) {
        this.updateButtonStatus();
        this.updatePageLabel();
        if (slideIndex < -1 || slideIndex > this.story.getSlidesSize() - 1 || this.story.getSlidesSize() == 0) {
            return;
        }
        PresentationSlide slide = this.story.getSlides().get(slideIndex);
        IPresentationPage p = this.window.getCurrentPage();
        if (p instanceof PresentationStoryPage) {
            PresentationStoryPage page = (PresentationStoryPage)p;
            page.showSlide(slide);
        }
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)slide));
    }
}

