/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.internal.e4handlers.StartPresentationHandler;
import org.xmind.ui.internal.presentation.PresentationMessages;

public class PresentationStartup
implements IStartup {
    public void earlyStartup() {
        if (System.getProperty("org.xmind.cathy.app.status") != null) {
            new CheckPresentationJob(PlatformUI.getWorkbench()).schedule();
        }
    }

    private static class CheckPresentationJob
    extends Job {
        private IWorkbench workbench;
        private IEditorPart editor;

        public CheckPresentationJob(IWorkbench workbench) {
            super(PresentationMessages.CheckStartupPresentation_jobName);
            this.setSystem(true);
            this.workbench = workbench;
            this.editor = null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(null, 4);
            try {
                while (!"workbenchReady".equals(System.getProperty("org.xmind.cathy.app.status"))) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            monitor.worked(1);
            boolean shouldStartPresentation = this.checkStartupPresentation();
            monitor.worked(1);
            if (shouldStartPresentation) {
                this.editor = this.getPresentationSourceEditor();
                monitor.worked(1);
                if (this.editor != null) {
                    this.startPresentation();
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private boolean checkStartupPresentation() {
            return "true".equals(System.getProperty("org.xmind.cathy.startup.presentation"));
        }

        private IEditorPart getPresentationSourceEditor() {
            final IEditorPart[] theEditor = new IEditorPart[1];
            Display display = this.workbench.getDisplay();
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow window = CheckPresentationJob.this.workbench.getActiveWorkbenchWindow();
                        if (window == null) {
                            return;
                        }
                        IWorkbenchPage page = window.getActivePage();
                        if (page == null) {
                            return;
                        }
                        IEditorPart editor = page.getActiveEditor();
                        if (editor == null) {
                            return;
                        }
                        theEditor[0] = editor;
                    }
                });
            }
            return theEditor[0];
        }

        private void startPresentation() {
            IWorkbenchPage page = this.editor.getSite().getPage();
            if (page == null) {
                return;
            }
            if (page.findEditor(this.editor.getEditorInput()) != this.editor) {
                return;
            }
            StartPresentationHandler.execute(this.editor.getSite().getShell(), this.editor);
        }
    }
}

