/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.util.Cancelable;
import org.xmind.ui.util.ICancelable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPresentationWindows
extends Window
implements Listener {
    private static final List<IPresentationPage> NO_PAGES = Collections.emptyList();
    private static final int FADE_INTERVALS = 15;
    private static final int FADE_DELAY = 50;
    private boolean wasParentFullScreen;
    private IGraphicalEditor sourceEditor;
    private ICancelable fadeJob = null;
    private boolean closing = false;
    protected List<IPresentationPage> pages;
    private Composite pageContainer;
    private StackLayout pageSwitcher;
    private int currentPageIndex = -1;
    private Properties properties = new Properties();

    public AbstractPresentationWindows(Shell parentShell) {
        super(parentShell);
        this.wasParentFullScreen = parentShell.getFullScreen();
        this.setBlockOnOpen(true);
        this.setShellStyle(8);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        return preferredSize;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle bound = this.getShell().getMonitor().getBounds();
        return new Point(bound.x, bound.y);
    }

    protected Point getInitialSize() {
        Rectangle bound = this.getShell().getMonitor().getBounds();
        return new Point(bound.width, bound.height);
    }

    protected Composite getPageContainer() {
        return this.pageContainer;
    }

    public void setCurrentPage(int pageIndex) {
        int oldIndex = this.currentPageIndex;
        this.currentPageIndex = pageIndex;
        IPresentationPage oldPage = this.getPage(oldIndex);
        IPresentationPage newPage = this.getPage(pageIndex);
        this.pageChanged(oldPage, newPage);
    }

    public IPresentationPage getPage(int pageIndex) {
        if (this.pages != null && pageIndex >= 0 && pageIndex < this.pages.size()) {
            return this.pages.get(pageIndex);
        }
        return null;
    }

    protected void pageChanged(IPresentationPage oldPage, IPresentationPage newPage) {
        Control pageControl;
        if (newPage != null && this.pageSwitcher.topControl != (pageControl = newPage.getControl()) && pageControl != null && !pageControl.isDisposed()) {
            this.pageSwitcher.topControl.setVisible(false);
            this.pageSwitcher.topControl = pageControl;
            pageControl.setVisible(true);
            pageControl.setFocus();
        }
    }

    public IPresentationPage getCurrentPage() {
        return this.pages == null ? null : this.pages.get(this.currentPageIndex);
    }

    protected int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public List<IPresentationPage> getPages() {
        return this.pages == null ? NO_PAGES : this.pages;
    }

    public int getPageCount() {
        return this.pages == null ? 0 : this.pages.size();
    }

    protected void configureShell(final Shell newShell) {
        Shell[] oldShells;
        super.configureShell(newShell);
        final Listener oldShellActivationListener = new Listener(){

            public void handleEvent(Event event) {
                if (newShell.isDisposed() || !newShell.isVisible()) {
                    return;
                }
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (!newShell.isDisposed()) {
                            newShell.forceActive();
                        }
                    }
                });
            }
        };
        final Display display = newShell.getDisplay();
        Shell[] shellArray = oldShells = display.getShells();
        int n = oldShells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell oldShell = shellArray[n2];
            if (oldShell != newShell) {
                oldShell.addListener(26, oldShellActivationListener);
            }
            ++n2;
        }
        newShell.setBackground(display.getSystemColor(2));
        display.addFilter(31, (Listener)this);
        display.addFilter(1, (Listener)this);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(31, (Listener)AbstractPresentationWindows.this);
                display.removeFilter(1, (Listener)AbstractPresentationWindows.this);
            }
        });
        newShell.setAlpha(0);
        newShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (newShell != null && !newShell.isDisposed()) {
                    newShell.setFullScreen(true);
                }
            }
        });
        if (this.fadeJob != null) {
            this.fadeJob.cancel();
            this.fadeJob = null;
        }
        this.fadeJob = new OpenShellJob();
        newShell.getDisplay().timerExec(50, (Runnable)this.fadeJob);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newShell.setFullScreen(false);
                AbstractPresentationWindows.this.handleCloseEvent();
                Shell[] shellArray = oldShells;
                int n = oldShells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell oldShell = shellArray[n2];
                    if (oldShell != null && !oldShell.isDisposed() && oldShell != newShell && oldShell.getDisplay() != null) {
                        oldShell.removeListener(26, oldShellActivationListener);
                    }
                    ++n2;
                }
            }
        });
    }

    protected void handleCloseEvent() {
    }

    public int open() {
        this.closing = false;
        return super.open();
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout(this.getContentLayout());
        this.createPages(composite);
        return composite;
    }

    protected abstract Layout getContentLayout();

    private void createPages(Composite parent) {
        this.pageContainer = new Composite(parent, 0);
        this.pageContainer.setBackground(parent.getBackground());
        this.pageSwitcher = new StackLayout();
        this.pageContainer.setLayout((Layout)this.pageSwitcher);
        this.createPages();
    }

    private void createPages() {
        if (this.sourceEditor == null) {
            return;
        }
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.sourceEditor.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            this.createPage(page);
            ++n2;
        }
        this.setCurrentPage(this.sourceEditor.getActivePage());
    }

    private void createPage(IGraphicalEditorPage sourcePage) {
        IMindMap mindmap = this.findMindMap(sourcePage);
        if (mindmap == null) {
            return;
        }
        IPresentationPage page = this.createPage(mindmap);
        this.addPage(page);
    }

    protected abstract IPresentationPage createPage(IMindMap var1);

    private IMindMap findMindMap(IGraphicalEditorPage sourcePage) {
        Object o;
        Object input = sourcePage.getInput();
        if (input instanceof IMindMap) {
            return (IMindMap)input;
        }
        if (input instanceof IAdaptable && (o = ((IAdaptable)input).getAdapter(IMindMap.class)) instanceof IMindMap) {
            return (IMindMap)o;
        }
        return (IMindMap)sourcePage.getAdapter(IMindMap.class);
    }

    private void addPage(IPresentationPage page) {
        if (this.pages == null) {
            this.pages = new ArrayList<IPresentationPage>();
        }
        this.pages.add(page);
        this.createPageControl(page);
    }

    private void createPageControl(IPresentationPage page) {
        if (page.getControl() == null || page.getControl().isDisposed()) {
            page.createControl(this.pageContainer);
        }
        Assert.isNotNull((Object)page.getControl());
        if (this.pageSwitcher.topControl == null) {
            this.pageSwitcher.topControl = page.getControl();
        } else {
            page.getControl().setVisible(false);
        }
    }

    public boolean close() {
        this.deactivateContext();
        if (this.closing) {
            this.hardClose();
        } else {
            if (this.fadeJob != null) {
                this.fadeJob.cancel();
                this.fadeJob = null;
            }
            this.fadeJob = new CloseShellJob();
            this.getShell().getDisplay().timerExec(50, (Runnable)this.fadeJob);
            if (this.pages != null) {
                for (IPresentationPage page : this.pages) {
                    page.dispose();
                }
            }
            this.closing = true;
        }
        return false;
    }

    private boolean hardClose() {
        boolean closed = super.close();
        if (closed) {
            this.pages = null;
        }
        return closed;
    }

    protected abstract void deactivateContext();

    public boolean canHandleShellCloseEvent() {
        EditDomain ed = this.getCurrentPage().getViewer().getEditDomain();
        if (ed != null && ed.getActiveTool() != ed.getDefaultTool()) {
            return false;
        }
        return super.canHandleShellCloseEvent();
    }

    public void handleEvent(Event event) {
    }

    private final class CloseShellJob
    extends Cancelable {
        int alpha = -1;

        private CloseShellJob() {
        }

        protected void doJob() {
            if (AbstractPresentationWindows.this.getShell() == null || AbstractPresentationWindows.this.getShell().isDisposed()) {
                return;
            }
            Shell parentShell = AbstractPresentationWindows.this.getParentShell();
            if (parentShell != null && !parentShell.isDisposed() && !AbstractPresentationWindows.this.wasParentFullScreen) {
                parentShell.setFullScreen(AbstractPresentationWindows.this.wasParentFullScreen);
            }
            if (this.alpha < 0) {
                this.alpha = AbstractPresentationWindows.this.getShell().getAlpha();
            }
            this.alpha -= 20;
            if (this.alpha <= 0) {
                this.alpha = -1;
                AbstractPresentationWindows.this.hardClose();
                return;
            }
            AbstractPresentationWindows.this.getShell().setAlpha(this.alpha);
            AbstractPresentationWindows.this.getShell().getDisplay().timerExec(15, (Runnable)((Object)this));
        }
    }

    private class OpenShellJob
    extends Cancelable {
        int alpha = -1;

        private OpenShellJob() {
        }

        protected void doJob() {
            if (AbstractPresentationWindows.this.getShell() == null || AbstractPresentationWindows.this.getShell().isDisposed()) {
                return;
            }
            if (this.alpha < 0) {
                this.alpha = AbstractPresentationWindows.this.getShell().getAlpha();
            }
            this.alpha += 20;
            if (this.alpha > 255) {
                this.alpha = -1;
                AbstractPresentationWindows.this.getShell().setAlpha(255);
                if (!AbstractPresentationWindows.this.wasParentFullScreen) {
                    AbstractPresentationWindows.this.getParentShell().setFullScreen(true);
                }
                return;
            }
            AbstractPresentationWindows.this.getShell().setAlpha(this.alpha);
            AbstractPresentationWindows.this.getShell().getDisplay().timerExec(15, (Runnable)((Object)this));
        }
    }
}

