/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import net.xmind.core.IAccount;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;

public class AccountPropertyTester
extends PropertyTester {
    private static final String P_USER_NAME = "userName";
    private static final String P_IS_AUTHENTICATED = "isAuthenticated";
    private static final String P_IS_AUTHENTICATION_EXPIRED = "isAuthenticationExpired";
    private static final String P_HAS_VALID_SUBSCRIPTION = "hasValidSubscription";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Assert.isLegal((boolean)(receiver instanceof IAccount), (String)("Receiver is not an IAccount object: " + receiver));
        IAccount account = (IAccount)receiver;
        if (P_USER_NAME.equals(property)) {
            return AccountPropertyTester.testStringEquals((String)account.getProperty("user"), expectedValue);
        }
        if (P_IS_AUTHENTICATED.equals(property)) {
            return AccountPropertyTester.testBooleanEquals(account.isAuthenticated(), expectedValue);
        }
        if (P_IS_AUTHENTICATION_EXPIRED.equals(property)) {
            return AccountPropertyTester.testBooleanEquals(account.isAuthenticationExpired(), expectedValue);
        }
        if (P_HAS_VALID_SUBSCRIPTION.equals(property)) {
            return AccountPropertyTester.testBooleanEquals(account.hasValidSubscription(), expectedValue);
        }
        Assert.isLegal((boolean)false, (String)("Unrecognized property: " + property));
        return false;
    }

    private static boolean testStringEquals(String actualValue, Object expectedValue) {
        if ("".equals(expectedValue)) {
            expectedValue = null;
        } else if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        return actualValue == expectedValue || actualValue != null && actualValue.equals(expectedValue);
    }

    private static boolean testBooleanEquals(boolean actualValue, Object expectedValue) {
        if (expectedValue == null) {
            return actualValue;
        }
        if (expectedValue instanceof String) {
            return Boolean.parseBoolean((String)expectedValue) == actualValue;
        }
        if (expectedValue instanceof Boolean) {
            return (Boolean)expectedValue == actualValue;
        }
        return false;
    }
}

