/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo.e4.model;

import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.internal.e4models.AbstractProViewModelPart;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.internal.taskinfo.TaskInfoViewer;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.tabfolder.DelegatedSelectionProvider;
import org.xmind.ui.util.MindMapUtils;

public class TaskInfoPart
extends AbstractProViewModelPart
implements IPartListener,
IContributedContentsView,
ISelectionChangedListener,
ISelectionListener {
    private TaskInfoViewer viewer = null;
    private IEditorPart targetEditor;
    private boolean changingViewerInput = false;
    private boolean changingEditorSelection = false;
    IWorkbenchWindow workbenchWindow = null;
    private ITopic topic;

    protected void init() {
        super.init();
        if (this.workbenchWindow == null) {
            this.workbenchWindow = (IWorkbenchWindow)this.getAdapter(IWorkbenchWindow.class);
        }
    }

    protected void doCreateProPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        if (this.viewer == null) {
            this.viewer = new TaskInfoViewer();
            VerifyUI20141031.getUsageDataCollector().increase("ShowTaskInfoPartCount");
        }
        this.viewer.addTaskChangedListener(new Runnable(){

            public void run() {
                if (TaskInfoPart.this.changingViewerInput) {
                    return;
                }
                TaskInfoPart.this.setTaskSelectionToEditor(TaskInfoPart.this.viewer.getTask());
            }
        });
        this.viewer.createControl(composite);
        IEditorPart activeEditor = this.workbenchWindow.getActivePage().getActiveEditor();
        this.setTargetEditor(activeEditor);
        this.setInitialInputFromView();
        this.workbenchWindow.getActivePage().addPartListener((IPartListener)this);
        this.workbenchWindow.getActivePage().addSelectionListener((ISelectionListener)this);
    }

    private void setInitialInputFromView() {
        ISelectionProvider provider;
        Object obj;
        IEditorPart activeEditor = this.workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor != null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MPart part = E4Utils.findPart((IWorkbenchWindow)window, (String)"org.xmind.ui.dialogPart.gantt");
        if (part != null && (obj = part.getObject()) instanceof IAdaptable && (provider = (ISelectionProvider)((IAdaptable)obj).getAdapter(ISelectionProvider.class)) != null) {
            this.refreshViewer(provider.getSelection());
        }
    }

    private void refreshViewer(ISelection selection) {
        ITopic topic;
        if (this.viewer != null && (topic = this.findLastTopic(selection)) != this.topic) {
            this.topic = topic;
            this.viewer.setCommandStack(this.findCommandStack(topic));
            this.setTaskInputToViewer(topic);
        }
    }

    private ICommandStack findCommandStack(ITopic topic) {
        ICommandStack cs = this.findCommandStack((IWorkbenchPart)this.targetEditor);
        if (cs == null && topic != null) {
            cs = MindMapUtils.getCommandStack((IWorkbook)topic.getOwnedWorkbook());
        }
        return cs;
    }

    private void setTaskInputToViewer(ITopic task) {
        this.changingViewerInput = true;
        this.viewer.setTask(task);
        this.changingViewerInput = false;
    }

    private void setTaskSelectionToEditor(ITopic task) {
        ISelectionProvider selectionProvider;
        if (this.targetEditor != null && (selectionProvider = this.targetEditor.getSite().getSelectionProvider()) != null) {
            this.changingEditorSelection = true;
            selectionProvider.setSelection((ISelection)new StructuredSelection((Object)task));
            this.changingEditorSelection = false;
        }
    }

    private ITopic findLastTopic(ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        ITopicComponent topicComponent = null;
        Object[] objs = ((IStructuredSelection)selection).toArray();
        if (objs == null) {
            return null;
        }
        int i = objs.length - 1;
        while (i >= 0) {
            Object o = objs[i];
            if (o instanceof ITopic) {
                return (ITopic)o;
            }
            if (o instanceof ITopicComponent && topicComponent == null) {
                topicComponent = (ITopicComponent)o;
            }
            --i;
        }
        if (topicComponent != null) {
            return topicComponent.getParent();
        }
        return null;
    }

    private ICommandStack findCommandStack(IWorkbenchPart part) {
        return part == null ? null : (ICommandStack)part.getAdapter(ICommandStack.class);
    }

    private void setTargetEditor(IEditorPart editor) {
        DelegatedSelectionProvider selectionProvider;
        DelegatedSelectionProvider selectionProvider2;
        if (editor == this.targetEditor) {
            return;
        }
        if (this.targetEditor != null && (selectionProvider2 = (DelegatedSelectionProvider)this.targetEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider2.removeAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.targetEditor = editor;
        StructuredSelection newSelection = null;
        if (editor != null && (selectionProvider = (DelegatedSelectionProvider)editor.getSite().getSelectionProvider()) != null) {
            selectionProvider.addAsyncSelectionChangedListener((ISelectionChangedListener)this);
            newSelection = selectionProvider.getSelection();
        }
        if (newSelection == null) {
            newSelection = StructuredSelection.EMPTY;
        }
        this.refreshViewer((ISelection)newSelection);
    }

    protected void dispose() {
        this.setTargetEditor(null);
        this.workbenchWindow.getActivePage().removePartListener((IPartListener)this);
        this.workbenchWindow.getActivePage().removeSelectionListener((ISelectionListener)this);
        this.viewer = null;
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor = this.workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor != null) {
            return;
        }
        if (part.getSite().getId().equals("org.xmind.ui.dialogPart.gantt")) {
            this.refreshViewer(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.changingEditorSelection) {
            return;
        }
        this.refreshViewer(event.getSelection());
    }

    public IWorkbenchPart getContributingPart() {
        return this.targetEditor;
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IEditorPart)) {
            return;
        }
        this.setTargetEditor((IEditorPart)part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.targetEditor) {
            this.setTargetEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected String getFeatureKey() {
        return "TaskInfoView";
    }

    protected int getRequiredFeatures() {
        return 3;
    }
}

