/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellingPlugin;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;

public class SpellingOptionsPreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private List<FieldEditor> settingFields = new ArrayList<FieldEditor>();
    protected Composite settingsParent;

    public void init(IWorkbench workbenche) {
        this.setPreferenceStore(SpellingPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("SPELLING_CHECK_ENABLED", Messages.enableSpellCheck, this.getFieldEditorParent()));
        this.addSpellingSettings(this.getFieldEditorParent());
        this.updateOptions(SpellingPlugin.isSpellingCheckEnabled());
    }

    private void addSpellingSettings(Composite parent) {
        this.settingsParent = this.createSettingsParent(parent);
        this.addSettingField("SPELL_IGNOREUPPERCASE", Messages.ignoreAllCapital);
        this.addSettingField("SPELL_IGNOREMIXEDCASE", Messages.ignoreMultiCapital);
        this.addSettingField("SPELL_IGNOREINTERNETADDRESS", Messages.ignoreWebAddress);
        this.addSettingField("SPELL_IGNOREDIGITWORDS", Messages.ignoreNumberousAppendix);
        this.addSettingField("SPELL_IGNORESENTENCECAPTILIZATION", Messages.ignoreFirstLowercaseSentences);
    }

    private void addSettingField(String name, String label) {
        BooleanFieldEditor field = new BooleanFieldEditor(name, label, this.settingsParent);
        this.addField((FieldEditor)field);
        this.settingFields.add((FieldEditor)field);
    }

    private void updateOptions(boolean enabled) {
        this.settingsParent.setEnabled(enabled);
        for (FieldEditor field : this.settingFields) {
            field.setEnabled(enabled, this.settingsParent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor field = (FieldEditor)event.getSource();
        if ("SPELLING_CHECK_ENABLED".equals(field.getPreferenceName())) {
            this.updateOptions(((BooleanFieldEditor)field).getBooleanValue());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.settingsParent != null) {
            this.settingsParent.dispose();
            this.settingsParent = null;
        }
    }

    protected Composite createSettingsParent(Composite parent) {
        GridLayoutFactory.fillDefaults().extendedMargins(25, 0, 0, 0).applyTo(parent);
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite itemContainer = new Composite(parent, 0);
        itemContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayoutFactory.fillDefaults().applyTo(itemContainer);
        return itemContainer;
    }

    public void apply() {
        this.performApply();
    }

    public boolean ok() {
        return this.performOk();
    }

    public void excuteDefault() {
        this.performDefaults();
    }

    public boolean cancel() {
        return this.performCancel();
    }
}

