/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.lighten;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.IControlPoint;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.PlainNotesContentImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.TopicExtensionElementImpl;
import org.xmind.core.internal.dom.TopicExtensionImpl;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Point;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.wizards.MindMapImporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LightenImporter
extends MindMapImporter
implements ErrorHandler {
    private ISheet targetSheet;
    private IStyleSheet targetStyleSheet;
    private IStyle theme;
    private Map<IStyled, IStyle> styleMap;
    private static final String PIXEL_POINT = "pt";

    public LightenImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        block17: {
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromLightenCount");
            ZipInputStream zis = null;
            try {
                try {
                    ZipEntry entry;
                    this.getMonitor().beginTask(null, 100);
                    zis = new ZipInputStream(new FileInputStream(this.getSourcePath()));
                    JSONObject json = null;
                    while ((entry = zis.getNextEntry()) != null) {
                        String read;
                        if (!"content.json".equals(entry.getName())) continue;
                        this.getMonitor().worked(40);
                        BufferedInputStream bis = new BufferedInputStream(zis);
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bis, "utf-8"));
                        StringBuilder sb = new StringBuilder();
                        while ((read = reader.readLine()) != null) {
                            sb.append(read).append('\n');
                        }
                        json = new JSONObject(sb.toString());
                        this.getMonitor().worked(10);
                    }
                    zis.close();
                    zis = null;
                    if (json != null) {
                        this.addTargetSheet(this.parseJsonIntoWorkbook(json));
                    }
                    this.getMonitor().worked(50);
                    this.getMonitor().done();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (zis != null) {
                        try {
                            zis.closeEntry();
                            zis.close();
                        }
                        catch (Exception exception) {
                            zis = null;
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (zis != null) {
                    try {
                        zis.closeEntry();
                        zis.close();
                    }
                    catch (Exception exception) {
                        zis = null;
                    }
                }
                throw throwable;
            }
            if (zis != null) {
                try {
                    zis.closeEntry();
                    zis.close();
                }
                catch (Exception exception) {
                    zis = null;
                }
            }
        }
        this.postBuilded();
    }

    private ISheet parseJsonIntoWorkbook(JSONObject json) {
        WorkbookImpl workbook = (WorkbookImpl)this.getTargetWorkbook();
        this.targetSheet = workbook.createSheet();
        SheetImpl sheet = (SheetImpl)this.targetSheet;
        sheet.setTitleText(this.getSuggestedSheetTitle());
        if (this.targetStyleSheet == null) {
            this.targetStyleSheet = workbook.getStyleSheet();
        }
        if (this.styleMap == null) {
            this.styleMap = new HashMap<IStyled, IStyle>();
        }
        if (json.has("skeletonTheme")) {
            this.parseTheme(json.getJSONObject("skeletonTheme"));
        }
        if (json.has("updateTime")) {
            sheet.getImplementation().setAttribute("timestamp", Long.valueOf(Double.valueOf(json.getDouble("updateTime") * 1000.0).longValue()).toString());
        }
        if (json.has("rootTopic")) {
            JSONObject rootTopicJson = (JSONObject)json.get("rootTopic");
            ITopic rootTopic = this.parseTopic(rootTopicJson, (ISheet)sheet);
            sheet.replaceRootTopic(rootTopic);
            if (json.has("rightNumber")) {
                TopicExtensionImpl topicExtension = (TopicExtensionImpl)rootTopic.createExtension("org.xmind.ui.map.unbalanced");
                TopicExtensionElementImpl element = (TopicExtensionElementImpl)topicExtension.getContent().getCreatedChild("right-number");
                element.setTextContent(Integer.valueOf(json.getInt("rightNumber")).toString());
            }
        }
        if (json.has("relationships")) {
            JSONArray relationshipsJson = json.getJSONArray("relationships");
            int i = 0;
            while (i < relationshipsJson.length()) {
                JSONObject relationshipJson = relationshipsJson.getJSONObject(i);
                IRelationship relationship = workbook.createRelationship();
                relationship.setEnd1Id(relationshipJson.getString("startNodeId"));
                relationship.setEnd2Id(relationshipJson.getString("endNodeId"));
                if (relationshipJson.has("controlPoint1")) {
                    IControlPoint controlPoint1 = relationship.getControlPoint(0);
                    controlPoint1.setPosition(this.deserializePoint(relationshipJson.getString("controlPoint1")));
                }
                if (relationshipJson.has("controlPoint2")) {
                    IControlPoint controlPoint2 = relationship.getControlPoint(1);
                    controlPoint2.setPosition(this.deserializePoint(relationshipJson.getString("controlPoint2")));
                }
                sheet.addRelationship(relationship);
                ++i;
            }
        }
        if (json.has("colorTheme")) {
            String themeName = this.parseTheme(json.getJSONObject("colorTheme"));
            this.importStyleAndTheme(themeName);
        }
        return this.targetSheet;
    }

    private ITopic parseTopic(JSONObject json, ISheet sheet) {
        JSONObject notesJson;
        IWorkbook workbook = sheet.getOwnedWorkbook();
        TopicImpl topic = (TopicImpl)workbook.createTopic();
        if (json.has("title")) {
            topic.setTitleText(json.getString("title"));
        }
        if (json.has("id")) {
            topic.getImplementation().setAttribute("id", json.getString("id"));
        }
        if (json.has("subtopics")) {
            JSONArray subtopicJson = json.getJSONArray("subtopics");
            int i = 0;
            while (i < subtopicJson.length()) {
                ITopic subtopic = this.parseTopic(subtopicJson.getJSONObject(i), sheet);
                topic.add(subtopic);
                ++i;
            }
        }
        if (json.has("note") && (notesJson = json.getJSONObject("note")).has("text")) {
            INotes notes = topic.getNotes();
            PlainNotesContentImpl plainNotes = (PlainNotesContentImpl)workbook.createNotesContent("plain");
            try {
                plainNotes.setTextContent(notesJson.getString("text"));
            }
            catch (Exception exception) {}
            notes.setContent("plain", (INotesContent)plainNotes);
        }
        if (json.has("detach") && json.getBoolean("detach") && json.has("position")) {
            topic.setPosition(this.deserializePoint(json.getString("position")));
        }
        if (json.has("folded")) {
            topic.setFolded(json.getBoolean("folded"));
        }
        if (json.has("style")) {
            this.setTopicStyle((ITopic)topic, json.getJSONObject("style"));
        }
        return topic;
    }

    private Point deserializePoint(String point) {
        int commaPos = point.indexOf(44);
        int x = Double.valueOf(point.substring(1, commaPos)).intValue();
        int y = Double.valueOf(point.substring(commaPos + 1, point.length() - 1)).intValue();
        return new Point(x, y);
    }

    private String parseTheme(JSONObject json) {
        String name = json.getString("name");
        if (json.has("topicStyleForMain")) {
            this.parseThemeStyle("topic", "mainTopic", json.getJSONObject("topicStyleForMain"));
        }
        if (json.has("topicStyleForSubtopic")) {
            this.parseThemeStyle("topic", "subTopic", json.getJSONObject("topicStyleForSubtopic"));
        }
        if (json.has("mapStyle")) {
            this.parseThemeStyle("map", "map", json.getJSONObject("mapStyle"));
        }
        if (json.has("topicStyleForCentral")) {
            this.parseThemeStyle("topic", "centralTopic", json.getJSONObject("topicStyleForCentral"));
        }
        if (json.has("topicStyleForFloating")) {
            this.parseThemeStyle("topic", "floatingTopic", json.getJSONObject("topicStyleForFloating"));
        }
        if (json.has("relationshipStyle")) {
            this.parseThemeStyle("relationship", "relationship", json.getJSONObject("relationshipStyle"));
        }
        return name;
    }

    private void parseThemeStyle(String type, String styleFamily, JSONObject json) {
        if (json.has("lineColor")) {
            this.registerTheme(type, styleFamily, "line-color", this.colorToRgb(json.getString("lineColor")));
        }
        if (json.has("fillColor")) {
            this.registerTheme(type, styleFamily, "svg:fill", this.colorToRgb(json.getString("fillColor")));
        }
        if (json.has("fontFamily")) {
            this.registerTheme(type, styleFamily, "fo:font-family", json.getString("fontFamily"));
        }
        if (json.has("fontColor")) {
            this.registerTheme(type, styleFamily, "fo:color", this.colorToRgb(json.getString("fontColor")));
        }
        if (json.has("cornerRadius")) {
            this.registerTheme(type, styleFamily, "line-corner", String.valueOf(json.getInt("cornerRadius")) + PIXEL_POINT);
        }
        if (json.has("lineWidth")) {
            this.registerTheme(type, styleFamily, "line-width", String.valueOf(json.getInt("lineWidth")) + PIXEL_POINT);
        }
    }

    private void registerStyle(IStyled styleOwner, String key, String value) {
        if (value == null) {
            return;
        }
        IStyle style = this.styleMap.get(styleOwner);
        if (style == null) {
            style = this.targetStyleSheet.createStyle(styleOwner.getStyleType());
            this.targetStyleSheet.addStyle(style, "normal-styles");
            this.styleMap.put(styleOwner, style);
        }
        style.setProperty(key, value);
    }

    private void registerTheme(String type, String styleFamily, String styleKey, String styleValue) {
        IStyle defaultStyle;
        if (styleFamily == null || styleKey == null || styleValue == null) {
            return;
        }
        if (this.theme == null) {
            this.theme = this.targetStyleSheet.createStyle("theme");
            this.targetStyleSheet.addStyle(this.theme, "master-styles");
        }
        if ((defaultStyle = this.theme.getDefaultStyle(styleFamily)) == null) {
            defaultStyle = this.targetStyleSheet.createStyle(type);
            this.targetStyleSheet.addStyle(defaultStyle, "automatic-styles");
            this.theme.setDefaultStyleId(styleFamily, defaultStyle.getId());
        }
        defaultStyle.setProperty(styleKey, styleValue);
    }

    private void importStyleAndTheme(String themeName) {
        IStyleSheet targetStyleSheet = this.getTargetWorkbook().getStyleSheet();
        for (Map.Entry<IStyled, IStyle> entry : this.styleMap.entrySet()) {
            IStyled styled = entry.getKey();
            IStyle style = entry.getValue();
            IStyle imported = targetStyleSheet.importStyle(style);
            if (imported == null) continue;
            styled.setStyleId(imported.getId());
        }
        if (this.theme != null) {
            this.theme.setName(themeName);
            IStyle imported = targetStyleSheet.importStyle(this.theme);
            if (imported != null) {
                this.targetSheet.setThemeId(imported.getId());
            }
        }
    }

    private String colorToRgb(String colorPoint) {
        if ("0.00".equals(colorPoint.substring(colorPoint.lastIndexOf(44) + 1, colorPoint.length() - 1).trim())) {
            return null;
        }
        StringBuilder sb = new StringBuilder().append('#');
        char[] chars = colorPoint.toCharArray();
        StringBuilder splitBuilder = new StringBuilder();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '{' && c != ' ') {
                if (c == ',') {
                    String value = Integer.toHexString(Integer.valueOf(splitBuilder.toString()));
                    if (value.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(value);
                    splitBuilder = new StringBuilder();
                } else {
                    splitBuilder.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    private void setTopicStyle(ITopic topic, JSONObject json) {
        if (json.has("lineColor")) {
            this.registerStyle((IStyled)topic, "line-color", this.colorToRgb(json.getString("lineColor")));
        }
        if (json.has("fontColor")) {
            this.registerStyle((IStyled)topic, "fo:color", this.colorToRgb(json.getString("fontColor")));
        }
        if (json.has("fontWeight")) {
            this.registerStyle((IStyled)topic, "fo:font-weight", json.getString("fontWeight"));
        }
    }

    public void error(SAXParseException arg0) throws SAXException {
        this.log(arg0, null);
    }

    public void fatalError(SAXParseException arg0) throws SAXException {
        this.log(arg0, null);
    }

    public void warning(SAXParseException arg0) throws SAXException {
        this.log(arg0, null);
    }
}

