/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.clientserver;

import zmq.Ctx;
import zmq.Msg;
import zmq.SocketBase;
import zmq.pipe.Pipe;
import zmq.socket.FQ;
import zmq.socket.LB;
import zmq.util.Blob;

public class Client
extends SocketBase {
    private final FQ fq;
    private final LB lb;

    public Client(Ctx parent, int tid, int sid) {
        super(parent, tid, sid, true);
        this.options.type = 13;
        this.options.canSendHelloMsg = true;
        this.options.canReceiveHiccupMsg = true;
        this.fq = new FQ();
        this.lb = new LB();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        this.fq.attach(pipe);
        this.lb.attach(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (msg.hasMore()) {
            this.errno.set(22);
            return false;
        }
        return this.lb.sendpipe(msg, this.errno, null);
    }

    @Override
    protected Msg xrecv() {
        Msg msg = this.fq.recvPipe(this.errno, null);
        while (msg != null && msg.hasMore()) {
            msg = this.fq.recvPipe(this.errno, null);
            while (msg != null && msg.hasMore()) {
                this.fq.recvPipe(this.errno, null);
            }
            if (msg == null) continue;
            this.fq.recvPipe(this.errno, null);
        }
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return this.fq.hasIn();
    }

    @Override
    protected boolean xhasOut() {
        return this.lb.hasOut();
    }

    @Override
    protected Blob getCredential() {
        return this.fq.getCredential();
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.lb.activated(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.fq.terminated(pipe);
        this.lb.terminated(pipe);
    }
}

