/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.logging;

import org.apache.maven.shared.utils.logging.LoggerLevelRenderer;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.Style;
import org.fusesource.jansi.Ansi;

class AnsiMessageBuilder
implements MessageBuilder,
LoggerLevelRenderer {
    private Ansi ansi;

    AnsiMessageBuilder() {
        this(Ansi.ansi());
    }

    AnsiMessageBuilder(StringBuilder builder) {
        this(Ansi.ansi((StringBuilder)builder));
    }

    AnsiMessageBuilder(int size) {
        this(Ansi.ansi((int)size));
    }

    AnsiMessageBuilder(Ansi ansi) {
        this.ansi = ansi;
    }

    @Override
    public String debug(String message) {
        return Style.DEBUG.apply(this.ansi).a(message).reset().toString();
    }

    @Override
    public String info(String message) {
        return Style.INFO.apply(this.ansi).a(message).reset().toString();
    }

    @Override
    public String warning(String message) {
        return Style.WARNING.apply(this.ansi).a(message).reset().toString();
    }

    @Override
    public String error(String message) {
        return Style.ERROR.apply(this.ansi).a(message).reset().toString();
    }

    @Override
    public AnsiMessageBuilder success(Object message) {
        Style.SUCCESS.apply(this.ansi).a(message).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder warning(Object message) {
        Style.WARNING.apply(this.ansi).a(message).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder failure(Object message) {
        Style.FAILURE.apply(this.ansi).a(message).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder strong(Object message) {
        Style.STRONG.apply(this.ansi).a(message).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder mojo(Object message) {
        Style.MOJO.apply(this.ansi).a(message).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder project(Object message) {
        Style.PROJECT.apply(this.ansi).a(message).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder a(char[] value, int offset, int len) {
        this.ansi.a(value, offset, len);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(char[] value) {
        this.ansi.a(value);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(CharSequence value, int start, int end) {
        this.ansi.a(value, start, end);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(CharSequence value) {
        this.ansi.a(value);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(Object value) {
        this.ansi.a(value);
        return this;
    }

    @Override
    public AnsiMessageBuilder newline() {
        this.ansi.newline();
        return this;
    }

    @Override
    public AnsiMessageBuilder format(String pattern, Object ... args) {
        this.ansi.format(pattern, args);
        return this;
    }

    public String toString() {
        return this.ansi.toString();
    }
}

