/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.LongitudeSegment;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0005\u001a\u00020\u0003J\u0013\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0003J\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018J\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "", "startLongitude", "", "minLatitude", "endLongitude", "maxLatitude", "(DDDD)V", "isEmpty", "", "()Z", "myLatitudeRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "myLongitudeSegment", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LongitudeSegment;", "encloses", "rect", "equals", "other", "hashCode", "", "latitudeRangeIsEmpty", "range", "splitByAntiMeridian", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "commons"})
@SourceDebugExtension(value={"SMAP\nGeoRectangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoRectangle.kt\norg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class GeoRectangle {
    @NotNull
    private final LongitudeSegment myLongitudeSegment;
    @NotNull
    private final DoubleSpan myLatitudeRange;

    public GeoRectangle(double startLongitude, double minLatitude, double endLongitude, double maxLatitude) {
        if (!(minLatitude <= maxLatitude)) {
            boolean bl = false;
            String string = "Invalid latitude range: [" + minLatitude + ".." + maxLatitude + ']';
            throw new IllegalArgumentException(string.toString());
        }
        this.myLongitudeSegment = new LongitudeSegment(startLongitude, endLongitude);
        this.myLatitudeRange = new DoubleSpan(minLatitude, maxLatitude);
    }

    public final boolean isEmpty() {
        return this.myLongitudeSegment.isEmpty() && this.latitudeRangeIsEmpty(this.myLatitudeRange);
    }

    private final boolean latitudeRangeIsEmpty(DoubleSpan range) {
        return range.getUpperEnd().doubleValue() == range.getLowerEnd().doubleValue();
    }

    public final double startLongitude() {
        return this.myLongitudeSegment.start();
    }

    public final double endLongitude() {
        return this.myLongitudeSegment.end();
    }

    public final double minLatitude() {
        return this.myLatitudeRange.getLowerEnd();
    }

    public final double maxLatitude() {
        return this.myLatitudeRange.getUpperEnd();
    }

    public final boolean encloses(@NotNull GeoRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return this.myLongitudeSegment.encloses(rect2.myLongitudeSegment) && this.myLatitudeRange.encloses(rect2.myLatitudeRange);
    }

    @NotNull
    public final List<Rect<LonLat>> splitByAntiMeridian() {
        ArrayList rects = new ArrayList();
        List<DoubleSpan> longitudeRanges = this.myLongitudeSegment.splitByAntiMeridian();
        for (DoubleSpan longitudeRange : longitudeRanges) {
            rects.add(Rect.Companion.LTRB(longitudeRange.getLowerEnd(), this.myLatitudeRange.getLowerEnd(), longitudeRange.getUpperEnd(), this.myLatitudeRange.getUpperEnd()));
        }
        return rects;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeoRectangle that = (GeoRectangle)other;
        return Intrinsics.areEqual((Object)this.myLongitudeSegment, (Object)that.myLongitudeSegment) && Intrinsics.areEqual((Object)this.myLatitudeRange, (Object)that.myLatitudeRange);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.myLongitudeSegment, this.myLatitudeRange};
        return ((Object)CollectionsKt.listOf((Object[])objectArray)).hashCode();
    }
}

