/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.variables;

import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.variables.NotebookSessionEnvironmentProvider;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\bH\u0002J&\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u001e\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010 \u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR4\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00130\u00120\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R.\u0010\u0016\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00170\u00120\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/variables/NotebookSessionNoSuspensionEnvironmentProvider;", "Lcom/intellij/kotlin/jupyter/core/debug/variables/NotebookSessionEnvironmentProvider;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "notebookReferenceProvider", "Lkotlin/Function1;", "Lcom/intellij/debugger/engine/jdi/VirtualMachineProxy;", "Lcom/sun/jdi/ObjectReference;", "getNotebookReferenceProvider", "()Lkotlin/jvm/functions/Function1;", "variableStateReferenceProvider", "getVariableStateReferenceProvider", "variableValueFromStateProvider", "Lkotlin/Function2;", "Lcom/sun/jdi/Value;", "", "Lkotlin/Pair;", "Lcom/sun/jdi/Field;", "getVariableValueFromStateProvider", "()Lkotlin/jvm/functions/Function2;", "variableStateFirstEntryAndSizeProvider", "", "getVariableStateFirstEntryAndSizeProvider", "retrieveNotebookReference", "virtualMachine", "retrieveVariablesStateReference", "retrieveValueFromVariableState", "variablesState", "variableName", "retrieveMapEntryReferenceAndVariablesSize", "variablesStateReference", "intellij.kotlin.jupyter.core"})
public final class NotebookSessionNoSuspensionEnvironmentProvider
implements NotebookSessionEnvironmentProvider {
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;
    @NotNull
    private final Function1<VirtualMachineProxy, ObjectReference> variableStateReferenceProvider;

    public NotebookSessionNoSuspensionEnvironmentProvider(@NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.virtualFile = virtualFile;
        this.variableStateReferenceProvider = (Function1)new Function1<VirtualMachineProxy, ObjectReference>((Object)this){

            public final ObjectReference invoke(VirtualMachineProxy p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return NotebookSessionNoSuspensionEnvironmentProvider.access$retrieveVariablesStateReference((NotebookSessionNoSuspensionEnvironmentProvider)this.receiver, p0);
            }
        };
    }

    @Override
    @NotNull
    public Function1<VirtualMachineProxy, ObjectReference> getNotebookReferenceProvider() {
        return (Function1)new Function1<VirtualMachineProxy, ObjectReference>((Object)this){

            public final ObjectReference invoke(VirtualMachineProxy p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return NotebookSessionNoSuspensionEnvironmentProvider.access$retrieveNotebookReference((NotebookSessionNoSuspensionEnvironmentProvider)this.receiver, p0);
            }
        };
    }

    @Override
    @NotNull
    public Function1<VirtualMachineProxy, ObjectReference> getVariableStateReferenceProvider() {
        return this.variableStateReferenceProvider;
    }

    @Override
    @NotNull
    public Function2<Value, String, Pair<ObjectReference, Field>> getVariableValueFromStateProvider() {
        return (Function2)new Function2<Value, String, Pair<? extends ObjectReference, ? extends Field>>((Object)this){

            public final Pair<ObjectReference, Field> invoke(Value p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return NotebookSessionNoSuspensionEnvironmentProvider.access$retrieveValueFromVariableState((NotebookSessionNoSuspensionEnvironmentProvider)this.receiver, p0, p1);
            }
        };
    }

    @Override
    @NotNull
    public Function1<ObjectReference, Pair<ObjectReference, Integer>> getVariableStateFirstEntryAndSizeProvider() {
        return (Function1)new Function1<ObjectReference, Pair<? extends ObjectReference, ? extends Integer>>((Object)this){

            public final Pair<ObjectReference, Integer> invoke(ObjectReference p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return NotebookSessionNoSuspensionEnvironmentProvider.access$retrieveMapEntryReferenceAndVariablesSize((NotebookSessionNoSuspensionEnvironmentProvider)this.receiver, p0);
            }
        };
    }

    private final ObjectReference retrieveNotebookReference(VirtualMachineProxy virtualMachine) {
        if (!(virtualMachine instanceof VirtualMachineProxyImpl)) {
            return null;
        }
        List list = ((VirtualMachineProxyImpl)virtualMachine).getClassesByNameProvider().get("org.jetbrains.kotlinx.jupyter.repl.notebook.impl.NotebookImpl");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        ReferenceType referenceType = (ReferenceType)CollectionsKt.firstOrNull((List)list);
        if (referenceType == null) {
            return null;
        }
        ReferenceType notebookClass = referenceType;
        List<ObjectReference> list2 = notebookClass.instances(1L);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"instances(...)");
        return (ObjectReference)CollectionsKt.firstOrNull(list2);
    }

    private final ObjectReference retrieveVariablesStateReference(VirtualMachineProxy virtualMachine) {
        if (!(virtualMachine instanceof VirtualMachineProxyImpl)) {
            return null;
        }
        ObjectReference objectReference = this.retrieveNotebookReference(virtualMachine);
        if (objectReference == null) {
            return null;
        }
        ObjectReference notebookReference = objectReference;
        Field sharedContextField = notebookReference.referenceType().fieldByName("sharedReplContext");
        Value value = notebookReference.getValue(sharedContextField);
        ObjectReference objectReference2 = value instanceof ObjectReference ? (ObjectReference)value : null;
        if (objectReference2 == null) {
            return null;
        }
        ObjectReference sharedContextReference = objectReference2;
        Field evaluatorField = sharedContextReference.referenceType().fieldByName("evaluator");
        Value value2 = sharedContextReference.getValue(evaluatorField);
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        ObjectReference evaluatorImpl = (ObjectReference)value2;
        Field variablesHolderField = evaluatorImpl.referenceType().fieldByName("variablesHolder");
        Value value3 = evaluatorImpl.getValue(variablesHolderField);
        Intrinsics.checkNotNull((Object)value3, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        return (ObjectReference)value3;
    }

    private final Pair<ObjectReference, Field> retrieveValueFromVariableState(Value variablesState, String variableName) {
        Intrinsics.checkNotNull((Object)variablesState, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        ObjectReference objectReference = (ObjectReference)variablesState;
        if (!Intrinsics.areEqual((Object)objectReference.referenceType().name(), (Object)"org.jetbrains.kotlinx.jupyter.api.VariableStateImpl")) {
            throw new IllegalArgumentException("Value retrieval is possible from instances of VariableStateImpl");
        }
        Field it = objectReference.referenceType().fieldByName("scriptInstance");
        boolean bl = false;
        Value value = objectReference.getValue(it);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        ObjectReference scriptInstance = (ObjectReference)value;
        Field suitableFieldAccessor = scriptInstance.referenceType().fieldByName(variableName);
        return TuplesKt.to((Object)scriptInstance, (Object)suitableFieldAccessor);
    }

    private final Pair<ObjectReference, Integer> retrieveMapEntryReferenceAndVariablesSize(ObjectReference variablesStateReference) {
        ReferenceType declaringClass = variablesStateReference.referenceType();
        if (!Intrinsics.areEqual((Object)declaringClass.name(), (Object)"java.util.LinkedHashMap")) {
            throw new UnsupportedOperationException("VariablesState shall be an instance of LinkedMap");
        }
        Value value = variablesStateReference.getValue(declaringClass.fieldByName("size"));
        IntegerValue integerValue = value instanceof IntegerValue ? (IntegerValue)value : null;
        Integer currentSize = integerValue != null ? Integer.valueOf(integerValue.value()) : null;
        Field headField = declaringClass.fieldByName("head");
        if (currentSize == null) {
            throw new IllegalArgumentException("Could not retrieve size from VariablesState");
        }
        value = variablesStateReference.getValue(headField);
        return TuplesKt.to((Object)(value instanceof ObjectReference ? (ObjectReference)value : null), (Object)currentSize);
    }

    public static final /* synthetic */ ObjectReference access$retrieveNotebookReference(NotebookSessionNoSuspensionEnvironmentProvider $this, VirtualMachineProxy virtualMachine) {
        return $this.retrieveNotebookReference(virtualMachine);
    }

    public static final /* synthetic */ Pair access$retrieveValueFromVariableState(NotebookSessionNoSuspensionEnvironmentProvider $this, Value variablesState, String variableName) {
        return $this.retrieveValueFromVariableState(variablesState, variableName);
    }

    public static final /* synthetic */ Pair access$retrieveMapEntryReferenceAndVariablesSize(NotebookSessionNoSuspensionEnvironmentProvider $this, ObjectReference variablesStateReference) {
        return $this.retrieveMapEntryReferenceAndVariablesSize(variablesStateReference);
    }

    public static final /* synthetic */ ObjectReference access$retrieveVariablesStateReference(NotebookSessionNoSuspensionEnvironmentProvider $this, VirtualMachineProxy virtualMachine) {
        return $this.retrieveVariablesStateReference(virtualMachine);
    }
}

