/* trackTable.h was originally generated by the autoSql program, which also 
 * generated trackTable.c and trackTable.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef TRACKTABLE_H
#define TRACKTABLE_H

struct trackTable
/* This describes an annotation track. */
    {
    struct trackTable *next;  /* Next in singly linked list. */
    char *mapName;	/* Symbolic ID of Track */
    char *tableName;	/* Name of table (without any chrN_ if split) */
    char *shortLabel;	/* Short label displayed on left */
    char *longLabel;	/* Long label displayed in middle */
    unsigned char visibility;	/* 0=hide, 1=dense, 2=full */
    unsigned char colorR;	/* Color red component 0-255 */
    unsigned char colorG;	/* Color green component 0-255 */
    unsigned char colorB;	/* Color blue component 0-255 */
    unsigned char altColorR;	/* Light color red component 0-255 */
    unsigned char altColorG;	/* Light color green component 0-255 */
    unsigned char altColorB;	/* Light color blue component 0-255 */
    unsigned char useScore;	/* 1 if use score, 0 if not */
    unsigned char isSplit;	/* 1 if table is split across chromosomes */
#ifndef	__cplusplus
    unsigned char private;	/* 1 if only want to show it on test site */
#else
    unsigned char priv;		/* don't conflict with C++ keyword */
#endif
    };

void trackTableStaticLoad(char **row, struct trackTable *ret);
/* Load a row from trackTable table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct trackTable *trackTableLoad(char **row);
/* Load a trackTable from row fetched with select * from trackTable
 * from database.  Dispose of this with trackTableFree(). */

struct trackTable *trackTableLoadAll(char *fileName);
/* Load all trackTable from a tab-separated file.
 * Dispose of this with trackTableFreeList(). */

struct trackTable *trackTableCommaIn(char **pS, struct trackTable *ret);
/* Create a trackTable out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new trackTable */

void trackTableFree(struct trackTable **pEl);
/* Free a single dynamically allocated trackTable such as created
 * with trackTableLoad(). */

void trackTableFreeList(struct trackTable **pList);
/* Free a list of dynamically allocated trackTable's */

void trackTableOutput(struct trackTable *el, FILE *f, char sep, char lastSep);
/* Print out trackTable.  Separate fields with sep. Follow last field with lastSep. */

#define trackTableTabOut(el,f) trackTableOutput(el,f,'\t','\n');
/* Print out trackTable as a line in a tab-separated file. */

#define trackTableCommaOut(el,f) trackTableOutput(el,f,',',',');
/* Print out trackTable as a comma separated list including final comma. */

/* ---------------- End of AutoSQL generated code. ------------------ */

struct trackTable *hGetTracks();
/* Get track table for current database. */

#endif /* TRACKTABLE_H */

