/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.BrowserPanicResponseStream;
import com.google.jstestdriver.CommandTask;
import com.google.jstestdriver.CommandTaskFactory;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileUploader;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.model.JstdTestCase;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JsTestDriverClientImpl
implements JsTestDriverClient {
    private final Gson gson = new Gson();
    private final CommandTaskFactory commandTaskFactory;
    private final String baseUrl;
    private final Server server;
    private final Boolean debug;
    private final FileUploader uploader;

    @Inject
    public JsTestDriverClientImpl(CommandTaskFactory commandTaskFactory, @Named(value="server") String baseUrl, Server server, @Named(value="debug") Boolean debug, FileUploader uploader) {
        this.commandTaskFactory = commandTaskFactory;
        this.baseUrl = baseUrl;
        this.server = server;
        this.debug = debug;
        this.uploader = uploader;
    }

    @Override
    public Collection<BrowserInfo> listBrowsers() {
        return (Collection)this.gson.fromJson(this.server.fetch(this.baseUrl + "/cmd?listBrowsers"), new TypeToken<Collection<BrowserInfo>>(){}.getType());
    }

    @Override
    public String getNextBrowserId() {
        return this.server.fetch(this.baseUrl + "/cmd?nextBrowserId");
    }

    private void sendCommand(String browserId, ResponseStream stream, String cmd, boolean uploadFiles, JstdTestCase testCase) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("data", cmd);
        params.put("id", browserId);
        CommandTask task = this.commandTaskFactory.getCommandTask(stream, this.baseUrl, this.server, params, uploadFiles);
        task.run(testCase);
    }

    @Override
    public void eval(String browserId, ResponseStream responseStream, String cmd, JstdTestCase testCase) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(cmd);
        JsonCommand jsonCmd = new JsonCommand(JsonCommand.CommandType.EXECUTE, parameters);
        this.sendCommand(browserId, responseStream, this.gson.toJson(jsonCmd), false, testCase);
    }

    @Override
    public void runAllTests(String browserId, ResponseStream responseStream, boolean captureConsole, JstdTestCase testCase) {
        this.runTests(browserId, responseStream, Lists.newArrayList("all"), captureConsole, testCase);
    }

    @Override
    public void reset(String browserId, ResponseStream responseStream, JstdTestCase testCase) {
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RESET, Collections.<String>emptyList());
        this.sendCommand(browserId, responseStream, this.gson.toJson(cmd), false, testCase);
    }

    @Override
    public void runTests(String browserId, ResponseStream responseStream, List<String> tests, boolean captureConsole, JstdTestCase testCase) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(this.gson.toJson(tests));
        parameters.add(String.valueOf(captureConsole));
        parameters.add(this.debug != false ? "1" : "");
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RUNTESTS, parameters);
        this.sendCommand(browserId, responseStream, this.gson.toJson(cmd), true, testCase);
    }

    @Override
    public void dryRun(String browserId, ResponseStream responseStream, JstdTestCase testCase) {
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.DRYRUN, Collections.<String>emptyList());
        this.sendCommand(browserId, responseStream, this.gson.toJson(cmd), true, testCase);
    }

    @Override
    public void dryRunFor(String browserId, ResponseStream responseStream, List<String> expressions, JstdTestCase testCase) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(this.gson.toJson(expressions));
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.DRYRUNFOR, parameters);
        this.sendCommand(browserId, responseStream, this.gson.toJson(cmd), true, testCase);
    }

    @Override
    public void uploadFiles(String browserId, JstdTestCase testCase) {
        LinkedHashSet<FileInfo> fileSet = Sets.newLinkedHashSet(testCase.getDependencies());
        fileSet.addAll(testCase.getTests());
        this.uploader.uploadFileSet(browserId, fileSet, new BrowserPanicResponseStream());
    }
}

