/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

export const AddressMetaDataExtension = {
  "data/AF": {
    alpha_3_code: "AFG",
  },
  "data/AX": {
    alpha_3_code: "ALA",
  },
  "data/AL": {
    alpha_3_code: "ALB",
  },
  "data/DZ": {
    alpha_3_code: "DZA",
  },
  "data/AS": {
    alpha_3_code: "ASM",
  },
  "data/AD": {
    alpha_3_code: "AND",
  },
  "data/AO": {
    alpha_3_code: "AGO",
  },
  "data/AI": {
    alpha_3_code: "AIA",
  },
  "data/AQ": {
    alpha_3_code: "ATA",
  },
  "data/AG": {
    alpha_3_code: "ATG",
  },
  "data/AR": {
    alpha_3_code: "ARG",
  },
  "data/AM": {
    alpha_3_code: "ARM",
  },
  "data/AW": {
    alpha_3_code: "ABW",
  },
  "data/AU": {
    alpha_3_code: "AUS",
  },
  "data/AT": {
    alpha_3_code: "AUT",
  },
  "data/AZ": {
    alpha_3_code: "AZE",
  },
  "data/BS": {
    alpha_3_code: "BHS",
  },
  "data/BH": {
    alpha_3_code: "BHR",
  },
  "data/BD": {
    alpha_3_code: "BGD",
  },
  "data/BB": {
    alpha_3_code: "BRB",
  },
  "data/BY": {
    alpha_3_code: "BLR",
  },
  "data/BE": {
    alpha_3_code: "BEL",
  },
  "data/BZ": {
    alpha_3_code: "BLZ",
  },
  "data/BJ": {
    alpha_3_code: "BEN",
  },
  "data/BM": {
    alpha_3_code: "BMU",
  },
  "data/BT": {
    alpha_3_code: "BTN",
  },
  "data/BO": {
    alpha_3_code: "BOL",
  },
  "data/BQ": {
    alpha_3_code: "BES",
  },
  "data/BA": {
    alpha_3_code: "BIH",
  },
  "data/BW": {
    alpha_3_code: "BWA",
  },
  "data/BV": {
    alpha_3_code: "BVT",
  },
  "data/BR": {
    alpha_3_code: "BRA",
  },
  "data/IO": {
    alpha_3_code: "IOT",
  },
  "data/BN": {
    alpha_3_code: "BRN",
  },
  "data/BG": {
    alpha_3_code: "BGR",
  },
  "data/BF": {
    alpha_3_code: "BFA",
  },
  "data/BI": {
    alpha_3_code: "BDI",
  },
  "data/CV": {
    alpha_3_code: "CPV",
  },
  "data/KH": {
    alpha_3_code: "KHM",
  },
  "data/CM": {
    alpha_3_code: "CMR",
  },
  "data/CA": {
    alpha_3_code: "CAN",
  },
  "data/KY": {
    alpha_3_code: "CYM",
  },
  "data/CF": {
    alpha_3_code: "CAF",
  },
  "data/TD": {
    alpha_3_code: "TCD",
  },
  "data/CL": {
    alpha_3_code: "CHL",
  },
  "data/CN": {
    alpha_3_code: "CHN",
  },
  "data/CX": {
    alpha_3_code: "CXR",
  },
  "data/CC": {
    alpha_3_code: "CCK",
  },
  "data/CO": {
    alpha_3_code: "COL",
  },
  "data/KM": {
    alpha_3_code: "COM",
  },
  "data/CG": {
    alpha_3_code: "COG",
  },
  "data/CD": {
    alpha_3_code: "COD",
  },
  "data/CK": {
    alpha_3_code: "COK",
  },
  "data/CR": {
    alpha_3_code: "CRI",
  },
  "data/CI": {
    alpha_3_code: "CIV",
  },
  "data/HR": {
    alpha_3_code: "HRV",
  },
  "data/CU": {
    alpha_3_code: "CUB",
  },
  "data/CW": {
    alpha_3_code: "CUW",
  },
  "data/CY": {
    alpha_3_code: "CYP",
  },
  "data/CZ": {
    alpha_3_code: "CZE",
  },
  "data/DK": {
    alpha_3_code: "DNK",
  },
  "data/DJ": {
    alpha_3_code: "DJI",
  },
  "data/DM": {
    alpha_3_code: "DMA",
  },
  "data/DO": {
    alpha_3_code: "DOM",
  },
  "data/EC": {
    alpha_3_code: "ECU",
  },
  "data/EG": {
    alpha_3_code: "EGY",
  },
  "data/SV": {
    alpha_3_code: "SLV",
  },
  "data/GQ": {
    alpha_3_code: "GNQ",
  },
  "data/ER": {
    alpha_3_code: "ERI",
  },
  "data/EE": {
    alpha_3_code: "EST",
  },
  "data/SZ": {
    alpha_3_code: "SWZ",
  },
  "data/ET": {
    alpha_3_code: "ETH",
  },
  "data/FK": {
    alpha_3_code: "FLK",
  },
  "data/FO": {
    alpha_3_code: "FRO",
  },
  "data/FJ": {
    alpha_3_code: "FJI",
  },
  "data/FI": {
    alpha_3_code: "FIN",
  },
  "data/FR": {
    alpha_3_code: "FRA",
  },
  "data/GF": {
    alpha_3_code: "GUF",
  },
  "data/PF": {
    alpha_3_code: "PYF",
  },
  "data/TF": {
    alpha_3_code: "ATF",
  },
  "data/GA": {
    alpha_3_code: "GAB",
  },
  "data/GM": {
    alpha_3_code: "GMB",
  },
  "data/GE": {
    alpha_3_code: "GEO",
  },
  "data/DE": {
    alpha_3_code: "DEU",
    address_reversed: true,
  },
  "data/GH": {
    alpha_3_code: "GHA",
  },
  "data/GI": {
    alpha_3_code: "GIB",
  },
  "data/GR": {
    alpha_3_code: "GRC",
  },
  "data/GL": {
    alpha_3_code: "GRL",
  },
  "data/GD": {
    alpha_3_code: "GRD",
  },
  "data/GP": {
    alpha_3_code: "GLP",
  },
  "data/GU": {
    alpha_3_code: "GUM",
  },
  "data/GT": {
    alpha_3_code: "GTM",
  },
  "data/GG": {
    alpha_3_code: "GGY",
  },
  "data/GN": {
    alpha_3_code: "GIN",
  },
  "data/GW": {
    alpha_3_code: "GNB",
  },
  "data/GY": {
    alpha_3_code: "GUY",
  },
  "data/HT": {
    alpha_3_code: "HTI",
  },
  "data/HM": {
    alpha_3_code: "HMD",
  },
  "data/VA": {
    alpha_3_code: "VAT",
  },
  "data/HN": {
    alpha_3_code: "HND",
  },
  "data/HK": {
    alpha_3_code: "HKG",
  },
  "data/HU": {
    alpha_3_code: "HUN",
  },
  "data/IS": {
    alpha_3_code: "ISL",
  },
  "data/IN": {
    alpha_3_code: "IND",
  },
  "data/ID": {
    alpha_3_code: "IDN",
  },
  "data/IR": {
    alpha_3_code: "IRN",
  },
  "data/IQ": {
    alpha_3_code: "IRQ",
  },
  "data/IE": {
    alpha_3_code: "IRL",
  },
  "data/IM": {
    alpha_3_code: "IMN",
  },
  "data/IL": {
    alpha_3_code: "ISR",
  },
  "data/IT": {
    alpha_3_code: "ITA",
  },
  "data/JM": {
    alpha_3_code: "JAM",
  },
  "data/JP": {
    alpha_3_code: "JPN",
    fmt: "〒%Z%n%S%C%n%A%n%O%n%N",
    require: "ACSZ",
  },
  "data/JE": {
    alpha_3_code: "JEY",
  },
  "data/JO": {
    alpha_3_code: "JOR",
  },
  "data/KZ": {
    alpha_3_code: "KAZ",
  },
  "data/KE": {
    alpha_3_code: "KEN",
  },
  "data/KI": {
    alpha_3_code: "KIR",
  },
  "data/KP": {
    alpha_3_code: "PRK",
  },
  "data/KR": {
    alpha_3_code: "KOR",
  },
  "data/KW": {
    alpha_3_code: "KWT",
  },
  "data/KG": {
    alpha_3_code: "KGZ",
  },
  "data/LA": {
    alpha_3_code: "LAO",
  },
  "data/LV": {
    alpha_3_code: "LVA",
  },
  "data/LB": {
    alpha_3_code: "LBN",
  },
  "data/LS": {
    alpha_3_code: "LSO",
  },
  "data/LR": {
    alpha_3_code: "LBR",
  },
  "data/LY": {
    alpha_3_code: "LBY",
  },
  "data/LI": {
    alpha_3_code: "LIE",
  },
  "data/LT": {
    alpha_3_code: "LTU",
  },
  "data/LU": {
    alpha_3_code: "LUX",
  },
  "data/MO": {
    alpha_3_code: "MAC",
  },
  "data/MG": {
    alpha_3_code: "MDG",
  },
  "data/MW": {
    alpha_3_code: "MWI",
  },
  "data/MY": {
    alpha_3_code: "MYS",
  },
  "data/MV": {
    alpha_3_code: "MDV",
  },
  "data/ML": {
    alpha_3_code: "MLI",
  },
  "data/MT": {
    alpha_3_code: "MLT",
  },
  "data/MH": {
    alpha_3_code: "MHL",
  },
  "data/MQ": {
    alpha_3_code: "MTQ",
  },
  "data/MR": {
    alpha_3_code: "MRT",
  },
  "data/MU": {
    alpha_3_code: "MUS",
  },
  "data/YT": {
    alpha_3_code: "MYT",
  },
  "data/MX": {
    alpha_3_code: "MEX",
  },
  "data/FM": {
    alpha_3_code: "FSM",
  },
  "data/MD": {
    alpha_3_code: "MDA",
  },
  "data/MC": {
    alpha_3_code: "MCO",
  },
  "data/MN": {
    alpha_3_code: "MNG",
  },
  "data/ME": {
    alpha_3_code: "MNE",
  },
  "data/MS": {
    alpha_3_code: "MSR",
  },
  "data/MA": {
    alpha_3_code: "MAR",
  },
  "data/MZ": {
    alpha_3_code: "MOZ",
  },
  "data/MM": {
    alpha_3_code: "MMR",
  },
  "data/NA": {
    alpha_3_code: "NAM",
  },
  "data/NR": {
    alpha_3_code: "NRU",
  },
  "data/NP": {
    alpha_3_code: "NPL",
  },
  "data/NL": {
    alpha_3_code: "NLD",
  },
  "data/NC": {
    alpha_3_code: "NCL",
  },
  "data/NZ": {
    alpha_3_code: "NZL",
  },
  "data/NI": {
    alpha_3_code: "NIC",
  },
  "data/NE": {
    alpha_3_code: "NER",
  },
  "data/NG": {
    alpha_3_code: "NGA",
  },
  "data/NU": {
    alpha_3_code: "NIU",
  },
  "data/NF": {
    alpha_3_code: "NFK",
  },
  "data/MK": {
    alpha_3_code: "MKD",
  },
  "data/MP": {
    alpha_3_code: "MNP",
  },
  "data/NO": {
    alpha_3_code: "NOR",
  },
  "data/OM": {
    alpha_3_code: "OMN",
  },
  "data/PK": {
    alpha_3_code: "PAK",
  },
  "data/PW": {
    alpha_3_code: "PLW",
  },
  "data/PS": {
    alpha_3_code: "PSE",
  },
  "data/PA": {
    alpha_3_code: "PAN",
  },
  "data/PG": {
    alpha_3_code: "PNG",
  },
  "data/PY": {
    alpha_3_code: "PRY",
  },
  "data/PE": {
    alpha_3_code: "PER",
  },
  "data/PH": {
    alpha_3_code: "PHL",
  },
  "data/PN": {
    alpha_3_code: "PCN",
  },
  "data/PL": {
    alpha_3_code: "POL",
  },
  "data/PT": {
    alpha_3_code: "PRT",
  },
  "data/PR": {
    alpha_3_code: "PRI",
  },
  "data/QA": {
    alpha_3_code: "QAT",
  },
  "data/RE": {
    alpha_3_code: "REU",
  },
  "data/RO": {
    alpha_3_code: "ROU",
  },
  "data/RU": {
    alpha_3_code: "RUS",
  },
  "data/RW": {
    alpha_3_code: "RWA",
  },
  "data/BL": {
    alpha_3_code: "BLM",
  },
  "data/SH": {
    alpha_3_code: "SHN",
  },
  "data/KN": {
    alpha_3_code: "KNA",
  },
  "data/LC": {
    alpha_3_code: "LCA",
  },
  "data/MF": {
    alpha_3_code: "MAF",
  },
  "data/PM": {
    alpha_3_code: "SPM",
  },
  "data/VC": {
    alpha_3_code: "VCT",
  },
  "data/WS": {
    alpha_3_code: "WSM",
  },
  "data/SM": {
    alpha_3_code: "SMR",
  },
  "data/ST": {
    alpha_3_code: "STP",
  },
  "data/SA": {
    alpha_3_code: "SAU",
  },
  "data/SN": {
    alpha_3_code: "SEN",
  },
  "data/RS": {
    alpha_3_code: "SRB",
  },
  "data/SC": {
    alpha_3_code: "SYC",
  },
  "data/SL": {
    alpha_3_code: "SLE",
  },
  "data/SG": {
    alpha_3_code: "SGP",
  },
  "data/SX": {
    alpha_3_code: "SXM",
  },
  "data/SK": {
    alpha_3_code: "SVK",
  },
  "data/SI": {
    alpha_3_code: "SVN",
  },
  "data/SB": {
    alpha_3_code: "SLB",
  },
  "data/SO": {
    alpha_3_code: "SOM",
  },
  "data/ZA": {
    alpha_3_code: "ZAF",
  },
  "data/GS": {
    alpha_3_code: "SGS",
  },
  "data/SS": {
    alpha_3_code: "SSD",
  },
  "data/ES": {
    alpha_3_code: "ESP",
  },
  "data/LK": {
    alpha_3_code: "LKA",
  },
  "data/SD": {
    alpha_3_code: "SDN",
  },
  "data/SR": {
    alpha_3_code: "SUR",
  },
  "data/SJ": {
    alpha_3_code: "SJM",
  },
  "data/SE": {
    alpha_3_code: "SWE",
  },
  "data/CH": {
    alpha_3_code: "CHE",
  },
  "data/SY": {
    alpha_3_code: "SYR",
  },
  "data/TW": {
    alpha_3_code: "TWN",
  },
  "data/TJ": {
    alpha_3_code: "TJK",
  },
  "data/TZ": {
    alpha_3_code: "TZA",
  },
  "data/TH": {
    alpha_3_code: "THA",
  },
  "data/TL": {
    alpha_3_code: "TLS",
  },
  "data/TG": {
    alpha_3_code: "TGO",
  },
  "data/TK": {
    alpha_3_code: "TKL",
  },
  "data/TO": {
    alpha_3_code: "TON",
  },
  "data/TT": {
    alpha_3_code: "TTO",
  },
  "data/TN": {
    alpha_3_code: "TUN",
  },
  "data/TR": {
    alpha_3_code: "TUR",
  },
  "data/TM": {
    alpha_3_code: "TKM",
  },
  "data/TC": {
    alpha_3_code: "TCA",
  },
  "data/TV": {
    alpha_3_code: "TUV",
  },
  "data/UG": {
    alpha_3_code: "UGA",
  },
  "data/UA": {
    alpha_3_code: "UKR",
  },
  "data/AE": {
    alpha_3_code: "ARE",
  },
  "data/GB": {
    alpha_3_code: "GBR",
  },
  "data/US": {
    alternative_names: [
      "US",
      "United States of America",
      "United States",
      "America",
      "U.S.",
      "USA",
      "U.S.A.",
      "U.S.A",
    ],
    alpha_3_code: "USA",
  },
  "data/UM": {
    alpha_3_code: "UMI",
  },
  "data/UY": {
    alpha_3_code: "URY",
  },
  "data/UZ": {
    alpha_3_code: "UZB",
  },
  "data/VU": {
    alpha_3_code: "VUT",
  },
  "data/VE": {
    alpha_3_code: "VEN",
  },
  "data/VN": {
    alpha_3_code: "VNM",
  },
  "data/VG": {
    alpha_3_code: "VGB",
  },
  "data/VI": {
    alpha_3_code: "VIR",
  },
  "data/WF": {
    alpha_3_code: "WLF",
  },
  "data/EH": {
    alpha_3_code: "ESH",
  },
  "data/YE": {
    alpha_3_code: "YEM",
  },
  "data/ZM": {
    alpha_3_code: "ZMB",
  },
  "data/ZW": {
    alpha_3_code: "ZWE",
  },
};

export default AddressMetaDataExtension;
