// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/identity/accesscontextmanager/v1/service_perimeter.proto

package accesscontextmanager

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies the type of the Perimeter. There are two types: regular and
// bridge. Regular Service Perimeter contains resources, access levels, and
// restricted services. Every resource can be in at most ONE
// regular Service Perimeter.
//
// In addition to being in a regular service perimeter, a resource can also
// be in zero or more perimeter bridges.  A perimeter bridge only contains
// resources.  Cross project operations are permitted if all effected
// resources share some perimeter (whether bridge or regular). Perimeter
// Bridge does not contain access levels or services: those are governed
// entirely by the regular perimeter that resource is in.
//
// Perimeter Bridges are typically useful when building more complex toplogies
// with many independent perimeters that need to share some data with a common
// perimeter, but should not be able to share data among themselves.
type ServicePerimeter_PerimeterType int32

const (
	// Regular Perimeter.
	ServicePerimeter_PERIMETER_TYPE_REGULAR ServicePerimeter_PerimeterType = 0
	// Perimeter Bridge.
	ServicePerimeter_PERIMETER_TYPE_BRIDGE ServicePerimeter_PerimeterType = 1
)

var ServicePerimeter_PerimeterType_name = map[int32]string{
	0: "PERIMETER_TYPE_REGULAR",
	1: "PERIMETER_TYPE_BRIDGE",
}

var ServicePerimeter_PerimeterType_value = map[string]int32{
	"PERIMETER_TYPE_REGULAR": 0,
	"PERIMETER_TYPE_BRIDGE":  1,
}

func (x ServicePerimeter_PerimeterType) String() string {
	return proto.EnumName(ServicePerimeter_PerimeterType_name, int32(x))
}

func (ServicePerimeter_PerimeterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1ecc0f866f4798a3, []int{0, 0}
}

// `ServicePerimeter` describes a set of Google Cloud resources which can freely
// import and export data amongst themselves, but not export outside of the
// `ServicePerimeter`. If a request with a source within this `ServicePerimeter`
// has a target outside of the `ServicePerimeter`, the request will be blocked.
// Otherwise the request is allowed. There are two types of Service Perimeter -
// Regular and Bridge. Regular Service Perimeters cannot overlap, a single
// Google Cloud project can only belong to a single regular Service Perimeter.
// Service Perimeter Bridges can contain only Google Cloud projects as members,
// a single Google Cloud project may belong to multiple Service Perimeter
// Bridges.
type ServicePerimeter struct {
	// Required. Resource name for the ServicePerimeter.  The `short_name`
	// component must begin with a letter and only include alphanumeric and '_'.
	// Format: `accessPolicies/{policy_id}/servicePerimeters/{short_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable title. Must be unique within the Policy.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Description of the `ServicePerimeter` and its use. Does not affect
	// behavior.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time the `ServicePerimeter` was created in UTC.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the `ServicePerimeter` was updated in UTC.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Perimeter type indicator. A single project is
	// allowed to be a member of single regular perimeter, but multiple service
	// perimeter bridges. A project cannot be a included in a perimeter bridge
	// without being included in regular perimeter. For perimeter bridges,
	// the restricted service list as well as access level lists must be
	// empty.
	PerimeterType ServicePerimeter_PerimeterType `protobuf:"varint,6,opt,name=perimeter_type,json=perimeterType,proto3,enum=google.identity.accesscontextmanager.v1.ServicePerimeter_PerimeterType" json:"perimeter_type,omitempty"`
	// Current ServicePerimeter configuration. Specifies sets of resources,
	// restricted services and access levels that determine perimeter
	// content and boundaries.
	Status *ServicePerimeterConfig `protobuf:"bytes,7,opt,name=status,proto3" json:"status,omitempty"`
	// Proposed (or dry run) ServicePerimeter configuration. This configuration
	// allows to specify and test ServicePerimeter configuration without enforcing
	// actual access restrictions. Only allowed to be set when the
	// "use_explicit_dry_run_spec" flag is set.
	Spec *ServicePerimeterConfig `protobuf:"bytes,8,opt,name=spec,proto3" json:"spec,omitempty"`
	// Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly
	// exists  for all Service Perimeters, and that spec is identical to the
	// status for those Service Perimeters. When this flag is set, it inhibits the
	// generation of the implicit spec, thereby allowing the user to explicitly
	// provide a configuration ("spec") to use in a dry-run version of the Service
	// Perimeter. This allows the user to test changes to the enforced config
	// ("status") without actually enforcing them. This testing is done through
	// analyzing the differences between currently enforced and suggested
	// restrictions. use_explicit_dry_run_spec must bet set to True if any of the
	// fields in the spec are set to non-default values.
	UseExplicitDryRunSpec bool     `protobuf:"varint,9,opt,name=use_explicit_dry_run_spec,json=useExplicitDryRunSpec,proto3" json:"use_explicit_dry_run_spec,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *ServicePerimeter) Reset()         { *m = ServicePerimeter{} }
func (m *ServicePerimeter) String() string { return proto.CompactTextString(m) }
func (*ServicePerimeter) ProtoMessage()    {}
func (*ServicePerimeter) Descriptor() ([]byte, []int) {
	return fileDescriptor_1ecc0f866f4798a3, []int{0}
}

func (m *ServicePerimeter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServicePerimeter.Unmarshal(m, b)
}
func (m *ServicePerimeter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServicePerimeter.Marshal(b, m, deterministic)
}
func (m *ServicePerimeter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicePerimeter.Merge(m, src)
}
func (m *ServicePerimeter) XXX_Size() int {
	return xxx_messageInfo_ServicePerimeter.Size(m)
}
func (m *ServicePerimeter) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicePerimeter.DiscardUnknown(m)
}

var xxx_messageInfo_ServicePerimeter proto.InternalMessageInfo

func (m *ServicePerimeter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServicePerimeter) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *ServicePerimeter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ServicePerimeter) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *ServicePerimeter) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *ServicePerimeter) GetPerimeterType() ServicePerimeter_PerimeterType {
	if m != nil {
		return m.PerimeterType
	}
	return ServicePerimeter_PERIMETER_TYPE_REGULAR
}

func (m *ServicePerimeter) GetStatus() *ServicePerimeterConfig {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ServicePerimeter) GetSpec() *ServicePerimeterConfig {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *ServicePerimeter) GetUseExplicitDryRunSpec() bool {
	if m != nil {
		return m.UseExplicitDryRunSpec
	}
	return false
}

// `ServicePerimeterConfig` specifies a set of Google Cloud resources that
// describe specific Service Perimeter configuration.
type ServicePerimeterConfig struct {
	// A list of Google Cloud resources that are inside of the service perimeter.
	// Currently only projects are allowed. Format: `projects/{project_number}`
	Resources []string `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// A list of `AccessLevel` resource names that allow resources within the
	// `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed
	// must be in the same policy as this `ServicePerimeter`. Referencing a
	// nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are
	// listed, resources within the perimeter can only be accessed via Google
	// Cloud calls with request origins within the perimeter. Example:
	// `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`.
	// For Service Perimeter Bridge, must be empty.
	AccessLevels []string `protobuf:"bytes,2,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
	// Google Cloud services that are subject to the Service Perimeter
	// restrictions. For example, if `storage.googleapis.com` is specified, access
	// to the storage buckets inside the perimeter must meet the perimeter's
	// access restrictions.
	RestrictedServices []string `protobuf:"bytes,4,rep,name=restricted_services,json=restrictedServices,proto3" json:"restricted_services,omitempty"`
	// Configuration for APIs allowed within Perimeter.
	VpcAccessibleServices *ServicePerimeterConfig_VpcAccessibleServices `protobuf:"bytes,10,opt,name=vpc_accessible_services,json=vpcAccessibleServices,proto3" json:"vpc_accessible_services,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                                      `json:"-"`
	XXX_unrecognized      []byte                                        `json:"-"`
	XXX_sizecache         int32                                         `json:"-"`
}

func (m *ServicePerimeterConfig) Reset()         { *m = ServicePerimeterConfig{} }
func (m *ServicePerimeterConfig) String() string { return proto.CompactTextString(m) }
func (*ServicePerimeterConfig) ProtoMessage()    {}
func (*ServicePerimeterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1ecc0f866f4798a3, []int{1}
}

func (m *ServicePerimeterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServicePerimeterConfig.Unmarshal(m, b)
}
func (m *ServicePerimeterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServicePerimeterConfig.Marshal(b, m, deterministic)
}
func (m *ServicePerimeterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicePerimeterConfig.Merge(m, src)
}
func (m *ServicePerimeterConfig) XXX_Size() int {
	return xxx_messageInfo_ServicePerimeterConfig.Size(m)
}
func (m *ServicePerimeterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicePerimeterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServicePerimeterConfig proto.InternalMessageInfo

func (m *ServicePerimeterConfig) GetResources() []string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ServicePerimeterConfig) GetAccessLevels() []string {
	if m != nil {
		return m.AccessLevels
	}
	return nil
}

func (m *ServicePerimeterConfig) GetRestrictedServices() []string {
	if m != nil {
		return m.RestrictedServices
	}
	return nil
}

func (m *ServicePerimeterConfig) GetVpcAccessibleServices() *ServicePerimeterConfig_VpcAccessibleServices {
	if m != nil {
		return m.VpcAccessibleServices
	}
	return nil
}

// Specifies how APIs are allowed to communicate within the Service
// Perimeter.
type ServicePerimeterConfig_VpcAccessibleServices struct {
	// Whether to restrict API calls within the Service Perimeter to the list of
	// APIs specified in 'allowed_services'.
	EnableRestriction bool `protobuf:"varint,1,opt,name=enable_restriction,json=enableRestriction,proto3" json:"enable_restriction,omitempty"`
	// The list of APIs usable within the Service Perimeter. Must be empty
	// unless 'enable_restriction' is True.
	AllowedServices      []string `protobuf:"bytes,2,rep,name=allowed_services,json=allowedServices,proto3" json:"allowed_services,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServicePerimeterConfig_VpcAccessibleServices) Reset() {
	*m = ServicePerimeterConfig_VpcAccessibleServices{}
}
func (m *ServicePerimeterConfig_VpcAccessibleServices) String() string {
	return proto.CompactTextString(m)
}
func (*ServicePerimeterConfig_VpcAccessibleServices) ProtoMessage() {}
func (*ServicePerimeterConfig_VpcAccessibleServices) Descriptor() ([]byte, []int) {
	return fileDescriptor_1ecc0f866f4798a3, []int{1, 0}
}

func (m *ServicePerimeterConfig_VpcAccessibleServices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServicePerimeterConfig_VpcAccessibleServices.Unmarshal(m, b)
}
func (m *ServicePerimeterConfig_VpcAccessibleServices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServicePerimeterConfig_VpcAccessibleServices.Marshal(b, m, deterministic)
}
func (m *ServicePerimeterConfig_VpcAccessibleServices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicePerimeterConfig_VpcAccessibleServices.Merge(m, src)
}
func (m *ServicePerimeterConfig_VpcAccessibleServices) XXX_Size() int {
	return xxx_messageInfo_ServicePerimeterConfig_VpcAccessibleServices.Size(m)
}
func (m *ServicePerimeterConfig_VpcAccessibleServices) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicePerimeterConfig_VpcAccessibleServices.DiscardUnknown(m)
}

var xxx_messageInfo_ServicePerimeterConfig_VpcAccessibleServices proto.InternalMessageInfo

func (m *ServicePerimeterConfig_VpcAccessibleServices) GetEnableRestriction() bool {
	if m != nil {
		return m.EnableRestriction
	}
	return false
}

func (m *ServicePerimeterConfig_VpcAccessibleServices) GetAllowedServices() []string {
	if m != nil {
		return m.AllowedServices
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.identity.accesscontextmanager.v1.ServicePerimeter_PerimeterType", ServicePerimeter_PerimeterType_name, ServicePerimeter_PerimeterType_value)
	proto.RegisterType((*ServicePerimeter)(nil), "google.identity.accesscontextmanager.v1.ServicePerimeter")
	proto.RegisterType((*ServicePerimeterConfig)(nil), "google.identity.accesscontextmanager.v1.ServicePerimeterConfig")
	proto.RegisterType((*ServicePerimeterConfig_VpcAccessibleServices)(nil), "google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices")
}

func init() {
	proto.RegisterFile("google/identity/accesscontextmanager/v1/service_perimeter.proto", fileDescriptor_1ecc0f866f4798a3)
}

var fileDescriptor_1ecc0f866f4798a3 = []byte{
	// 659 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0xdd, 0x4e, 0x13, 0x41,
	0x14, 0x76, 0x4b, 0x41, 0x3a, 0x08, 0xd6, 0xd1, 0xe2, 0xd2, 0x90, 0xd8, 0xe0, 0x05, 0x55, 0xe3,
	0x6e, 0x8a, 0x37, 0xa6, 0x5c, 0x10, 0x7e, 0x6a, 0x43, 0x02, 0x49, 0xb3, 0x94, 0x1a, 0x95, 0x64,
	0x33, 0x4c, 0x0f, 0x9b, 0x49, 0xb6, 0xb3, 0xe3, 0xcc, 0x6c, 0xa5, 0x0f, 0x61, 0x7c, 0x07, 0x2f,
	0xf5, 0x4d, 0x7c, 0x14, 0x9f, 0xc0, 0x4b, 0xd3, 0x99, 0xdd, 0x16, 0x49, 0x13, 0x88, 0x7a, 0xb7,
	0xf3, 0x9d, 0xef, 0x7c, 0xe7, 0x3b, 0x5f, 0x73, 0x8a, 0x76, 0xa2, 0x24, 0x89, 0x62, 0xf0, 0x59,
	0x1f, 0xb8, 0x66, 0x7a, 0xe4, 0x13, 0x4a, 0x41, 0x29, 0x9a, 0x70, 0x0d, 0x97, 0x7a, 0x40, 0x38,
	0x89, 0x40, 0xfa, 0xc3, 0x86, 0xaf, 0x40, 0x0e, 0x19, 0x85, 0x50, 0x80, 0x64, 0x03, 0xd0, 0x20,
	0x3d, 0x21, 0x13, 0x9d, 0xe0, 0x4d, 0x2b, 0xe0, 0xe5, 0x02, 0xde, 0x2c, 0x01, 0x6f, 0xd8, 0xa8,
	0x3e, 0xc9, 0x26, 0x99, 0xb6, 0xf3, 0xf4, 0xc2, 0xd7, 0x6c, 0x00, 0x4a, 0x93, 0x81, 0xb0, 0x4a,
	0xd5, 0xf5, 0x8c, 0x40, 0x04, 0xf3, 0x09, 0xe7, 0x89, 0x26, 0x9a, 0x25, 0x5c, 0xd9, 0xea, 0xc6,
	0xaf, 0x22, 0x2a, 0x9f, 0x58, 0x0f, 0x9d, 0xdc, 0x02, 0xc6, 0xa8, 0xc8, 0xc9, 0x00, 0x5c, 0xa7,
	0xe6, 0xd4, 0x4b, 0x81, 0xf9, 0xc6, 0x8f, 0xd0, 0xbc, 0x66, 0x3a, 0x06, 0xb7, 0x60, 0x40, 0xfb,
	0xc0, 0x35, 0xb4, 0xd4, 0x07, 0x45, 0x25, 0x13, 0x63, 0x51, 0x77, 0xce, 0xd4, 0xae, 0x42, 0x78,
	0x1b, 0x2d, 0x51, 0x09, 0x44, 0x43, 0x38, 0x36, 0xe6, 0x16, 0x6b, 0x4e, 0x7d, 0x69, 0xab, 0xea,
	0x65, 0xeb, 0xe5, 0xae, 0xbd, 0x6e, 0xee, 0x3a, 0x40, 0x96, 0x3e, 0x06, 0xc6, 0xcd, 0xa9, 0xe8,
	0x4f, 0x9a, 0xe7, 0x6f, 0x6e, 0xb6, 0x74, 0xd3, 0xcc, 0xd1, 0xca, 0x24, 0xd5, 0x50, 0x8f, 0x04,
	0xb8, 0x0b, 0x35, 0xa7, 0xbe, 0xb2, 0xd5, 0xf6, 0x6e, 0x99, 0xad, 0x77, 0x3d, 0x18, 0x6f, 0xf2,
	0xd5, 0x1d, 0x09, 0x08, 0x96, 0xc5, 0xd5, 0x27, 0x7e, 0x8b, 0x16, 0x94, 0x26, 0x3a, 0x55, 0xee,
	0x5d, 0xe3, 0x73, 0xe7, 0xaf, 0xe7, 0xec, 0x27, 0xfc, 0x82, 0x45, 0x41, 0x26, 0x87, 0x4f, 0x50,
	0x51, 0x09, 0xa0, 0xee, 0xe2, 0xff, 0x91, 0x35, 0x62, 0xf8, 0x35, 0x5a, 0x4b, 0x15, 0x84, 0x70,
	0x29, 0x62, 0x46, 0x99, 0x0e, 0xfb, 0x72, 0x14, 0xca, 0x94, 0x87, 0x66, 0x52, 0xa9, 0xe6, 0xd4,
	0x17, 0x83, 0x4a, 0xaa, 0xa0, 0x95, 0xd5, 0x0f, 0xe4, 0x28, 0x48, 0xf9, 0x89, 0x00, 0xba, 0xf1,
	0x06, 0x2d, 0xff, 0x91, 0x03, 0xae, 0xa2, 0xd5, 0x4e, 0x2b, 0x38, 0x3c, 0x6e, 0x75, 0x5b, 0x41,
	0xd8, 0x7d, 0xd7, 0x69, 0x85, 0x41, 0xab, 0x7d, 0x7a, 0xb4, 0x1b, 0x94, 0xef, 0xe0, 0x35, 0x54,
	0xb9, 0x56, 0xdb, 0x0b, 0x0e, 0x0f, 0xda, 0xad, 0xb2, 0xb3, 0xf1, 0x65, 0x0e, 0xad, 0xce, 0xb6,
	0x88, 0xd7, 0x51, 0x49, 0x82, 0x4a, 0x52, 0x49, 0x41, 0xb9, 0x4e, 0x6d, 0xae, 0x5e, 0x0a, 0xa6,
	0x00, 0x7e, 0x8a, 0x96, 0xed, 0xca, 0x61, 0x0c, 0x43, 0x88, 0x95, 0x5b, 0x30, 0x8c, 0x7b, 0x16,
	0x3c, 0x32, 0x18, 0xf6, 0xd1, 0x43, 0x09, 0x4a, 0x4b, 0x46, 0x35, 0xf4, 0xc3, 0xec, 0xcc, 0x94,
	0x5b, 0x34, 0x54, 0x3c, 0x2d, 0x65, 0x0e, 0x14, 0xfe, 0xec, 0xa0, 0xc7, 0x43, 0x41, 0x43, 0xab,
	0xc2, 0xce, 0x63, 0x98, 0x76, 0x21, 0x93, 0xfc, 0xe9, 0x3f, 0x26, 0xef, 0xf5, 0x04, 0xdd, 0x9d,
	0xa8, 0xe7, 0x83, 0x83, 0xca, 0x70, 0x16, 0x5c, 0xfd, 0x88, 0x2a, 0x33, 0xf9, 0xf8, 0x25, 0xc2,
	0xc0, 0xc9, 0xd8, 0x5f, 0xbe, 0xc5, 0xf8, 0xf4, 0x1c, 0xf3, 0x93, 0x3d, 0xb0, 0x95, 0x60, 0x5a,
	0xc0, 0xcf, 0x50, 0x99, 0xc4, 0x71, 0xf2, 0xe9, 0x6a, 0x0a, 0x36, 0xb0, 0xfb, 0x19, 0x9e, 0x2b,
	0xef, 0x7d, 0x2f, 0xa0, 0x17, 0x34, 0x19, 0xdc, 0x76, 0xcd, 0xbd, 0xca, 0xf5, 0x3d, 0x3b, 0xe3,
	0x8b, 0xec, 0x38, 0xef, 0x3f, 0x64, 0x0a, 0x51, 0x12, 0x13, 0x1e, 0x79, 0x89, 0x8c, 0xfc, 0x08,
	0xb8, 0xb9, 0x57, 0xdf, 0x96, 0x88, 0x60, 0xea, 0xc6, 0x7f, 0xc7, 0xed, 0x59, 0xf8, 0xd7, 0x42,
	0xb1, 0xbd, 0xbb, 0x7f, 0xfc, 0xad, 0xb0, 0xd9, 0xb6, 0x43, 0x0e, 0x73, 0x9b, 0x36, 0xab, 0x7d,
	0xcb, 0x3e, 0xce, 0x6c, 0xf6, 0x1a, 0x3f, 0x72, 0xe6, 0x59, 0xce, 0x3c, 0x9b, 0xc5, 0x3c, 0xeb,
	0x35, 0x7e, 0x16, 0x9e, 0x5b, 0x66, 0xb3, 0x99, 0x53, 0x9b, 0xcd, 0x59, 0xdc, 0x66, 0xb3, 0xd7,
	0x38, 0x5f, 0x30, 0xfb, 0xbc, 0xfa, 0x1d, 0x00, 0x00, 0xff, 0xff, 0x49, 0x78, 0x85, 0x63, 0xec,
	0x05, 0x00, 0x00,
}
