// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/webrisk/v1/webrisk.proto

package webrisk

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of threat. This maps dirrectly to the threat list a threat may
// belong to.
type ThreatType int32

const (
	// Unknown.
	ThreatType_THREAT_TYPE_UNSPECIFIED ThreatType = 0
	// Malware targeting any platform.
	ThreatType_MALWARE ThreatType = 1
	// Social engineering targeting any platform.
	ThreatType_SOCIAL_ENGINEERING ThreatType = 2
	// Unwanted software targeting any platform.
	ThreatType_UNWANTED_SOFTWARE ThreatType = 3
)

var ThreatType_name = map[int32]string{
	0: "THREAT_TYPE_UNSPECIFIED",
	1: "MALWARE",
	2: "SOCIAL_ENGINEERING",
	3: "UNWANTED_SOFTWARE",
}

var ThreatType_value = map[string]int32{
	"THREAT_TYPE_UNSPECIFIED": 0,
	"MALWARE":                 1,
	"SOCIAL_ENGINEERING":      2,
	"UNWANTED_SOFTWARE":       3,
}

func (x ThreatType) String() string {
	return proto.EnumName(ThreatType_name, int32(x))
}

func (ThreatType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{0}
}

// The ways in which threat entry sets can be compressed.
type CompressionType int32

const (
	// Unknown.
	CompressionType_COMPRESSION_TYPE_UNSPECIFIED CompressionType = 0
	// Raw, uncompressed data.
	CompressionType_RAW CompressionType = 1
	// Rice-Golomb encoded data.
	CompressionType_RICE CompressionType = 2
)

var CompressionType_name = map[int32]string{
	0: "COMPRESSION_TYPE_UNSPECIFIED",
	1: "RAW",
	2: "RICE",
}

var CompressionType_value = map[string]int32{
	"COMPRESSION_TYPE_UNSPECIFIED": 0,
	"RAW":                          1,
	"RICE":                         2,
}

func (x CompressionType) String() string {
	return proto.EnumName(CompressionType_name, int32(x))
}

func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{1}
}

// The type of response sent to the client.
type ComputeThreatListDiffResponse_ResponseType int32

const (
	// Unknown.
	ComputeThreatListDiffResponse_RESPONSE_TYPE_UNSPECIFIED ComputeThreatListDiffResponse_ResponseType = 0
	// Partial updates are applied to the client's existing local database.
	ComputeThreatListDiffResponse_DIFF ComputeThreatListDiffResponse_ResponseType = 1
	// Full updates resets the client's entire local database. This means
	// that either the client had no state, was seriously out-of-date,
	// or the client is believed to be corrupt.
	ComputeThreatListDiffResponse_RESET ComputeThreatListDiffResponse_ResponseType = 2
)

var ComputeThreatListDiffResponse_ResponseType_name = map[int32]string{
	0: "RESPONSE_TYPE_UNSPECIFIED",
	1: "DIFF",
	2: "RESET",
}

var ComputeThreatListDiffResponse_ResponseType_value = map[string]int32{
	"RESPONSE_TYPE_UNSPECIFIED": 0,
	"DIFF":                      1,
	"RESET":                     2,
}

func (x ComputeThreatListDiffResponse_ResponseType) String() string {
	return proto.EnumName(ComputeThreatListDiffResponse_ResponseType_name, int32(x))
}

func (ComputeThreatListDiffResponse_ResponseType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{1, 0}
}

// Describes an API diff request.
type ComputeThreatListDiffRequest struct {
	// Required. The threat list to update. Only a single ThreatType should be specified.
	ThreatType ThreatType `protobuf:"varint,1,opt,name=threat_type,json=threatType,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_type,omitempty"`
	// The current version token of the client for the requested list (the
	// client version that was received from the last successful diff).
	// If the client does not have a version token (this is the first time calling
	// ComputeThreatListDiff), this may be left empty and a full database
	// snapshot will be returned.
	VersionToken []byte `protobuf:"bytes,2,opt,name=version_token,json=versionToken,proto3" json:"version_token,omitempty"`
	// Required. The constraints associated with this request.
	Constraints          *ComputeThreatListDiffRequest_Constraints `protobuf:"bytes,3,opt,name=constraints,proto3" json:"constraints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *ComputeThreatListDiffRequest) Reset()         { *m = ComputeThreatListDiffRequest{} }
func (m *ComputeThreatListDiffRequest) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffRequest) ProtoMessage()    {}
func (*ComputeThreatListDiffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{0}
}

func (m *ComputeThreatListDiffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffRequest.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffRequest.Marshal(b, m, deterministic)
}
func (m *ComputeThreatListDiffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffRequest.Merge(m, src)
}
func (m *ComputeThreatListDiffRequest) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffRequest.Size(m)
}
func (m *ComputeThreatListDiffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffRequest proto.InternalMessageInfo

func (m *ComputeThreatListDiffRequest) GetThreatType() ThreatType {
	if m != nil {
		return m.ThreatType
	}
	return ThreatType_THREAT_TYPE_UNSPECIFIED
}

func (m *ComputeThreatListDiffRequest) GetVersionToken() []byte {
	if m != nil {
		return m.VersionToken
	}
	return nil
}

func (m *ComputeThreatListDiffRequest) GetConstraints() *ComputeThreatListDiffRequest_Constraints {
	if m != nil {
		return m.Constraints
	}
	return nil
}

// The constraints for this diff.
type ComputeThreatListDiffRequest_Constraints struct {
	// The maximum size in number of entries. The diff will not contain more
	// entries than this value.  This should be a power of 2 between 2**10 and
	// 2**20.  If zero, no diff size limit is set.
	MaxDiffEntries int32 `protobuf:"varint,1,opt,name=max_diff_entries,json=maxDiffEntries,proto3" json:"max_diff_entries,omitempty"`
	// Sets the maximum number of entries that the client is willing to have
	// in the local database. This should be a power of 2 between 2**10 and
	// 2**20. If zero, no database size limit is set.
	MaxDatabaseEntries int32 `protobuf:"varint,2,opt,name=max_database_entries,json=maxDatabaseEntries,proto3" json:"max_database_entries,omitempty"`
	// The compression types supported by the client.
	SupportedCompressions []CompressionType `protobuf:"varint,3,rep,packed,name=supported_compressions,json=supportedCompressions,proto3,enum=google.cloud.webrisk.v1.CompressionType" json:"supported_compressions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}          `json:"-"`
	XXX_unrecognized      []byte            `json:"-"`
	XXX_sizecache         int32             `json:"-"`
}

func (m *ComputeThreatListDiffRequest_Constraints) Reset() {
	*m = ComputeThreatListDiffRequest_Constraints{}
}
func (m *ComputeThreatListDiffRequest_Constraints) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffRequest_Constraints) ProtoMessage()    {}
func (*ComputeThreatListDiffRequest_Constraints) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{0, 0}
}

func (m *ComputeThreatListDiffRequest_Constraints) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Marshal(b, m, deterministic)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Merge(m, src)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Size(m)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffRequest_Constraints proto.InternalMessageInfo

func (m *ComputeThreatListDiffRequest_Constraints) GetMaxDiffEntries() int32 {
	if m != nil {
		return m.MaxDiffEntries
	}
	return 0
}

func (m *ComputeThreatListDiffRequest_Constraints) GetMaxDatabaseEntries() int32 {
	if m != nil {
		return m.MaxDatabaseEntries
	}
	return 0
}

func (m *ComputeThreatListDiffRequest_Constraints) GetSupportedCompressions() []CompressionType {
	if m != nil {
		return m.SupportedCompressions
	}
	return nil
}

type ComputeThreatListDiffResponse struct {
	// The type of response. This may indicate that an action must be taken by the
	// client when the response is received.
	ResponseType ComputeThreatListDiffResponse_ResponseType `protobuf:"varint,4,opt,name=response_type,json=responseType,proto3,enum=google.cloud.webrisk.v1.ComputeThreatListDiffResponse_ResponseType" json:"response_type,omitempty"`
	// A set of entries to add to a local threat type's list.
	Additions *ThreatEntryAdditions `protobuf:"bytes,5,opt,name=additions,proto3" json:"additions,omitempty"`
	// A set of entries to remove from a local threat type's list.
	// This field may be empty.
	Removals *ThreatEntryRemovals `protobuf:"bytes,6,opt,name=removals,proto3" json:"removals,omitempty"`
	// The new opaque client version token. This should be retained by the client
	// and passed into the next call of ComputeThreatListDiff as 'version_token'.
	// A separate version token should be stored and used for each threatList.
	NewVersionToken []byte `protobuf:"bytes,7,opt,name=new_version_token,json=newVersionToken,proto3" json:"new_version_token,omitempty"`
	// The expected SHA256 hash of the client state; that is, of the sorted list
	// of all hashes present in the database after applying the provided diff.
	// If the client state doesn't match the expected state, the client must
	// discard this diff and retry later.
	Checksum *ComputeThreatListDiffResponse_Checksum `protobuf:"bytes,8,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// The soonest the client should wait before issuing any diff
	// request. Querying sooner is unlikely to produce a meaningful diff.
	// Waiting longer is acceptable considering the use case.
	// If this field is not set clients may update as soon as they want.
	RecommendedNextDiff  *timestamp.Timestamp `protobuf:"bytes,2,opt,name=recommended_next_diff,json=recommendedNextDiff,proto3" json:"recommended_next_diff,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ComputeThreatListDiffResponse) Reset()         { *m = ComputeThreatListDiffResponse{} }
func (m *ComputeThreatListDiffResponse) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffResponse) ProtoMessage()    {}
func (*ComputeThreatListDiffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{1}
}

func (m *ComputeThreatListDiffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffResponse.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffResponse.Marshal(b, m, deterministic)
}
func (m *ComputeThreatListDiffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffResponse.Merge(m, src)
}
func (m *ComputeThreatListDiffResponse) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffResponse.Size(m)
}
func (m *ComputeThreatListDiffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffResponse proto.InternalMessageInfo

func (m *ComputeThreatListDiffResponse) GetResponseType() ComputeThreatListDiffResponse_ResponseType {
	if m != nil {
		return m.ResponseType
	}
	return ComputeThreatListDiffResponse_RESPONSE_TYPE_UNSPECIFIED
}

func (m *ComputeThreatListDiffResponse) GetAdditions() *ThreatEntryAdditions {
	if m != nil {
		return m.Additions
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetRemovals() *ThreatEntryRemovals {
	if m != nil {
		return m.Removals
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetNewVersionToken() []byte {
	if m != nil {
		return m.NewVersionToken
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetChecksum() *ComputeThreatListDiffResponse_Checksum {
	if m != nil {
		return m.Checksum
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetRecommendedNextDiff() *timestamp.Timestamp {
	if m != nil {
		return m.RecommendedNextDiff
	}
	return nil
}

// The expected state of a client's local database.
type ComputeThreatListDiffResponse_Checksum struct {
	// The SHA256 hash of the client state; that is, of the sorted list of all
	// hashes present in the database.
	Sha256               []byte   `protobuf:"bytes,1,opt,name=sha256,proto3" json:"sha256,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComputeThreatListDiffResponse_Checksum) Reset() {
	*m = ComputeThreatListDiffResponse_Checksum{}
}
func (m *ComputeThreatListDiffResponse_Checksum) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffResponse_Checksum) ProtoMessage()    {}
func (*ComputeThreatListDiffResponse_Checksum) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{1, 0}
}

func (m *ComputeThreatListDiffResponse_Checksum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Marshal(b, m, deterministic)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Merge(m, src)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Size(m)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffResponse_Checksum proto.InternalMessageInfo

func (m *ComputeThreatListDiffResponse_Checksum) GetSha256() []byte {
	if m != nil {
		return m.Sha256
	}
	return nil
}

// Request to check URI entries against threatLists.
type SearchUrisRequest struct {
	// Required. The URI to be checked for matches.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Required. The ThreatLists to search in. Multiple ThreatLists may be specified.
	ThreatTypes          []ThreatType `protobuf:"varint,2,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SearchUrisRequest) Reset()         { *m = SearchUrisRequest{} }
func (m *SearchUrisRequest) String() string { return proto.CompactTextString(m) }
func (*SearchUrisRequest) ProtoMessage()    {}
func (*SearchUrisRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{2}
}

func (m *SearchUrisRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchUrisRequest.Unmarshal(m, b)
}
func (m *SearchUrisRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchUrisRequest.Marshal(b, m, deterministic)
}
func (m *SearchUrisRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchUrisRequest.Merge(m, src)
}
func (m *SearchUrisRequest) XXX_Size() int {
	return xxx_messageInfo_SearchUrisRequest.Size(m)
}
func (m *SearchUrisRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchUrisRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchUrisRequest proto.InternalMessageInfo

func (m *SearchUrisRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *SearchUrisRequest) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

type SearchUrisResponse struct {
	// The threat list matches. This may be empty if the URI is on no list.
	Threat               *SearchUrisResponse_ThreatUri `protobuf:"bytes,1,opt,name=threat,proto3" json:"threat,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *SearchUrisResponse) Reset()         { *m = SearchUrisResponse{} }
func (m *SearchUrisResponse) String() string { return proto.CompactTextString(m) }
func (*SearchUrisResponse) ProtoMessage()    {}
func (*SearchUrisResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{3}
}

func (m *SearchUrisResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchUrisResponse.Unmarshal(m, b)
}
func (m *SearchUrisResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchUrisResponse.Marshal(b, m, deterministic)
}
func (m *SearchUrisResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchUrisResponse.Merge(m, src)
}
func (m *SearchUrisResponse) XXX_Size() int {
	return xxx_messageInfo_SearchUrisResponse.Size(m)
}
func (m *SearchUrisResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchUrisResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchUrisResponse proto.InternalMessageInfo

func (m *SearchUrisResponse) GetThreat() *SearchUrisResponse_ThreatUri {
	if m != nil {
		return m.Threat
	}
	return nil
}

// Contains threat information on a matching uri.
type SearchUrisResponse_ThreatUri struct {
	// The ThreatList this threat belongs to.
	ThreatTypes []ThreatType `protobuf:"varint,1,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
	// The cache lifetime for the returned match. Clients must not cache this
	// response past this timestamp to avoid false positives.
	ExpireTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchUrisResponse_ThreatUri) Reset()         { *m = SearchUrisResponse_ThreatUri{} }
func (m *SearchUrisResponse_ThreatUri) String() string { return proto.CompactTextString(m) }
func (*SearchUrisResponse_ThreatUri) ProtoMessage()    {}
func (*SearchUrisResponse_ThreatUri) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{3, 0}
}

func (m *SearchUrisResponse_ThreatUri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchUrisResponse_ThreatUri.Unmarshal(m, b)
}
func (m *SearchUrisResponse_ThreatUri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchUrisResponse_ThreatUri.Marshal(b, m, deterministic)
}
func (m *SearchUrisResponse_ThreatUri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchUrisResponse_ThreatUri.Merge(m, src)
}
func (m *SearchUrisResponse_ThreatUri) XXX_Size() int {
	return xxx_messageInfo_SearchUrisResponse_ThreatUri.Size(m)
}
func (m *SearchUrisResponse_ThreatUri) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchUrisResponse_ThreatUri.DiscardUnknown(m)
}

var xxx_messageInfo_SearchUrisResponse_ThreatUri proto.InternalMessageInfo

func (m *SearchUrisResponse_ThreatUri) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

func (m *SearchUrisResponse_ThreatUri) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// Request to return full hashes matched by the provided hash prefixes.
type SearchHashesRequest struct {
	// A hash prefix, consisting of the most significant 4-32 bytes of a SHA256
	// hash. For JSON requests, this field is base64-encoded.
	HashPrefix []byte `protobuf:"bytes,1,opt,name=hash_prefix,json=hashPrefix,proto3" json:"hash_prefix,omitempty"`
	// Required. The ThreatLists to search in. Multiple ThreatLists may be specified.
	ThreatTypes          []ThreatType `protobuf:"varint,2,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SearchHashesRequest) Reset()         { *m = SearchHashesRequest{} }
func (m *SearchHashesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchHashesRequest) ProtoMessage()    {}
func (*SearchHashesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{4}
}

func (m *SearchHashesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchHashesRequest.Unmarshal(m, b)
}
func (m *SearchHashesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchHashesRequest.Marshal(b, m, deterministic)
}
func (m *SearchHashesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchHashesRequest.Merge(m, src)
}
func (m *SearchHashesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchHashesRequest.Size(m)
}
func (m *SearchHashesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchHashesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchHashesRequest proto.InternalMessageInfo

func (m *SearchHashesRequest) GetHashPrefix() []byte {
	if m != nil {
		return m.HashPrefix
	}
	return nil
}

func (m *SearchHashesRequest) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

type SearchHashesResponse struct {
	// The full hashes that matched the requested prefixes.
	// The hash will be populated in the key.
	Threats []*SearchHashesResponse_ThreatHash `protobuf:"bytes,1,rep,name=threats,proto3" json:"threats,omitempty"`
	// For requested entities that did not match the threat list, how long to
	// cache the response until.
	NegativeExpireTime   *timestamp.Timestamp `protobuf:"bytes,2,opt,name=negative_expire_time,json=negativeExpireTime,proto3" json:"negative_expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchHashesResponse) Reset()         { *m = SearchHashesResponse{} }
func (m *SearchHashesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchHashesResponse) ProtoMessage()    {}
func (*SearchHashesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{5}
}

func (m *SearchHashesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchHashesResponse.Unmarshal(m, b)
}
func (m *SearchHashesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchHashesResponse.Marshal(b, m, deterministic)
}
func (m *SearchHashesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchHashesResponse.Merge(m, src)
}
func (m *SearchHashesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchHashesResponse.Size(m)
}
func (m *SearchHashesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchHashesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchHashesResponse proto.InternalMessageInfo

func (m *SearchHashesResponse) GetThreats() []*SearchHashesResponse_ThreatHash {
	if m != nil {
		return m.Threats
	}
	return nil
}

func (m *SearchHashesResponse) GetNegativeExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.NegativeExpireTime
	}
	return nil
}

// Contains threat information on a matching hash.
type SearchHashesResponse_ThreatHash struct {
	// The ThreatList this threat belongs to.
	// This must contain at least one entry.
	ThreatTypes []ThreatType `protobuf:"varint,1,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
	// A 32 byte SHA256 hash. This field is in binary format. For JSON
	// requests, hashes are base64-encoded.
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	// The cache lifetime for the returned match. Clients must not cache this
	// response past this timestamp to avoid false positives.
	ExpireTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchHashesResponse_ThreatHash) Reset()         { *m = SearchHashesResponse_ThreatHash{} }
func (m *SearchHashesResponse_ThreatHash) String() string { return proto.CompactTextString(m) }
func (*SearchHashesResponse_ThreatHash) ProtoMessage()    {}
func (*SearchHashesResponse_ThreatHash) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{5, 0}
}

func (m *SearchHashesResponse_ThreatHash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchHashesResponse_ThreatHash.Unmarshal(m, b)
}
func (m *SearchHashesResponse_ThreatHash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchHashesResponse_ThreatHash.Marshal(b, m, deterministic)
}
func (m *SearchHashesResponse_ThreatHash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchHashesResponse_ThreatHash.Merge(m, src)
}
func (m *SearchHashesResponse_ThreatHash) XXX_Size() int {
	return xxx_messageInfo_SearchHashesResponse_ThreatHash.Size(m)
}
func (m *SearchHashesResponse_ThreatHash) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchHashesResponse_ThreatHash.DiscardUnknown(m)
}

var xxx_messageInfo_SearchHashesResponse_ThreatHash proto.InternalMessageInfo

func (m *SearchHashesResponse_ThreatHash) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

func (m *SearchHashesResponse_ThreatHash) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *SearchHashesResponse_ThreatHash) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// Contains the set of entries to add to a local database.
// May contain a combination of compressed and raw data in a single response.
type ThreatEntryAdditions struct {
	// The raw SHA256-formatted entries.
	// Repeated to allow returning sets of hashes with different prefix sizes.
	RawHashes []*RawHashes `protobuf:"bytes,1,rep,name=raw_hashes,json=rawHashes,proto3" json:"raw_hashes,omitempty"`
	// The encoded 4-byte prefixes of SHA256-formatted entries, using a
	// Golomb-Rice encoding. The hashes are converted to uint32, sorted in
	// ascending order, then delta encoded and stored as encoded_data.
	RiceHashes           *RiceDeltaEncoding `protobuf:"bytes,2,opt,name=rice_hashes,json=riceHashes,proto3" json:"rice_hashes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ThreatEntryAdditions) Reset()         { *m = ThreatEntryAdditions{} }
func (m *ThreatEntryAdditions) String() string { return proto.CompactTextString(m) }
func (*ThreatEntryAdditions) ProtoMessage()    {}
func (*ThreatEntryAdditions) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{6}
}

func (m *ThreatEntryAdditions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThreatEntryAdditions.Unmarshal(m, b)
}
func (m *ThreatEntryAdditions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThreatEntryAdditions.Marshal(b, m, deterministic)
}
func (m *ThreatEntryAdditions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThreatEntryAdditions.Merge(m, src)
}
func (m *ThreatEntryAdditions) XXX_Size() int {
	return xxx_messageInfo_ThreatEntryAdditions.Size(m)
}
func (m *ThreatEntryAdditions) XXX_DiscardUnknown() {
	xxx_messageInfo_ThreatEntryAdditions.DiscardUnknown(m)
}

var xxx_messageInfo_ThreatEntryAdditions proto.InternalMessageInfo

func (m *ThreatEntryAdditions) GetRawHashes() []*RawHashes {
	if m != nil {
		return m.RawHashes
	}
	return nil
}

func (m *ThreatEntryAdditions) GetRiceHashes() *RiceDeltaEncoding {
	if m != nil {
		return m.RiceHashes
	}
	return nil
}

// Contains the set of entries to remove from a local database.
type ThreatEntryRemovals struct {
	// The raw removal indices for a local list.
	RawIndices *RawIndices `protobuf:"bytes,1,opt,name=raw_indices,json=rawIndices,proto3" json:"raw_indices,omitempty"`
	// The encoded local, lexicographically-sorted list indices, using a
	// Golomb-Rice encoding. Used for sending compressed removal indices. The
	// removal indices (uint32) are sorted in ascending order, then delta encoded
	// and stored as encoded_data.
	RiceIndices          *RiceDeltaEncoding `protobuf:"bytes,2,opt,name=rice_indices,json=riceIndices,proto3" json:"rice_indices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ThreatEntryRemovals) Reset()         { *m = ThreatEntryRemovals{} }
func (m *ThreatEntryRemovals) String() string { return proto.CompactTextString(m) }
func (*ThreatEntryRemovals) ProtoMessage()    {}
func (*ThreatEntryRemovals) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{7}
}

func (m *ThreatEntryRemovals) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThreatEntryRemovals.Unmarshal(m, b)
}
func (m *ThreatEntryRemovals) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThreatEntryRemovals.Marshal(b, m, deterministic)
}
func (m *ThreatEntryRemovals) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThreatEntryRemovals.Merge(m, src)
}
func (m *ThreatEntryRemovals) XXX_Size() int {
	return xxx_messageInfo_ThreatEntryRemovals.Size(m)
}
func (m *ThreatEntryRemovals) XXX_DiscardUnknown() {
	xxx_messageInfo_ThreatEntryRemovals.DiscardUnknown(m)
}

var xxx_messageInfo_ThreatEntryRemovals proto.InternalMessageInfo

func (m *ThreatEntryRemovals) GetRawIndices() *RawIndices {
	if m != nil {
		return m.RawIndices
	}
	return nil
}

func (m *ThreatEntryRemovals) GetRiceIndices() *RiceDeltaEncoding {
	if m != nil {
		return m.RiceIndices
	}
	return nil
}

// A set of raw indices to remove from a local list.
type RawIndices struct {
	// The indices to remove from a lexicographically-sorted local list.
	Indices              []int32  `protobuf:"varint,1,rep,packed,name=indices,proto3" json:"indices,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawIndices) Reset()         { *m = RawIndices{} }
func (m *RawIndices) String() string { return proto.CompactTextString(m) }
func (*RawIndices) ProtoMessage()    {}
func (*RawIndices) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{8}
}

func (m *RawIndices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawIndices.Unmarshal(m, b)
}
func (m *RawIndices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawIndices.Marshal(b, m, deterministic)
}
func (m *RawIndices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawIndices.Merge(m, src)
}
func (m *RawIndices) XXX_Size() int {
	return xxx_messageInfo_RawIndices.Size(m)
}
func (m *RawIndices) XXX_DiscardUnknown() {
	xxx_messageInfo_RawIndices.DiscardUnknown(m)
}

var xxx_messageInfo_RawIndices proto.InternalMessageInfo

func (m *RawIndices) GetIndices() []int32 {
	if m != nil {
		return m.Indices
	}
	return nil
}

// The uncompressed threat entries in hash format.
// Hashes can be anywhere from 4 to 32 bytes in size. A large majority are 4
// bytes, but some hashes are lengthened if they collide with the hash of a
// popular URI.
//
// Used for sending ThreatEntryAdditons to clients that do not support
// compression, or when sending non-4-byte hashes to clients that do support
// compression.
type RawHashes struct {
	// The number of bytes for each prefix encoded below.  This field can be
	// anywhere from 4 (shortest prefix) to 32 (full SHA256 hash).
	// In practice this is almost always 4, except in exceptional circumstances.
	PrefixSize int32 `protobuf:"varint,1,opt,name=prefix_size,json=prefixSize,proto3" json:"prefix_size,omitempty"`
	// The hashes, in binary format, concatenated into one long string. Hashes are
	// sorted in lexicographic order. For JSON API users, hashes are
	// base64-encoded.
	RawHashes            []byte   `protobuf:"bytes,2,opt,name=raw_hashes,json=rawHashes,proto3" json:"raw_hashes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawHashes) Reset()         { *m = RawHashes{} }
func (m *RawHashes) String() string { return proto.CompactTextString(m) }
func (*RawHashes) ProtoMessage()    {}
func (*RawHashes) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{9}
}

func (m *RawHashes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawHashes.Unmarshal(m, b)
}
func (m *RawHashes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawHashes.Marshal(b, m, deterministic)
}
func (m *RawHashes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawHashes.Merge(m, src)
}
func (m *RawHashes) XXX_Size() int {
	return xxx_messageInfo_RawHashes.Size(m)
}
func (m *RawHashes) XXX_DiscardUnknown() {
	xxx_messageInfo_RawHashes.DiscardUnknown(m)
}

var xxx_messageInfo_RawHashes proto.InternalMessageInfo

func (m *RawHashes) GetPrefixSize() int32 {
	if m != nil {
		return m.PrefixSize
	}
	return 0
}

func (m *RawHashes) GetRawHashes() []byte {
	if m != nil {
		return m.RawHashes
	}
	return nil
}

// The Rice-Golomb encoded data. Used for sending compressed 4-byte hashes or
// compressed removal indices.
type RiceDeltaEncoding struct {
	// The offset of the first entry in the encoded data, or, if only a single
	// integer was encoded, that single integer's value. If the field is empty or
	// missing, assume zero.
	FirstValue int64 `protobuf:"varint,1,opt,name=first_value,json=firstValue,proto3" json:"first_value,omitempty"`
	// The Golomb-Rice parameter, which is a number between 2 and 28. This field
	// is missing (that is, zero) if `num_entries` is zero.
	RiceParameter int32 `protobuf:"varint,2,opt,name=rice_parameter,json=riceParameter,proto3" json:"rice_parameter,omitempty"`
	// The number of entries that are delta encoded in the encoded data. If only a
	// single integer was encoded, this will be zero and the single value will be
	// stored in `first_value`.
	EntryCount int32 `protobuf:"varint,3,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// The encoded deltas that are encoded using the Golomb-Rice coder.
	EncodedData          []byte   `protobuf:"bytes,4,opt,name=encoded_data,json=encodedData,proto3" json:"encoded_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RiceDeltaEncoding) Reset()         { *m = RiceDeltaEncoding{} }
func (m *RiceDeltaEncoding) String() string { return proto.CompactTextString(m) }
func (*RiceDeltaEncoding) ProtoMessage()    {}
func (*RiceDeltaEncoding) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{10}
}

func (m *RiceDeltaEncoding) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RiceDeltaEncoding.Unmarshal(m, b)
}
func (m *RiceDeltaEncoding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RiceDeltaEncoding.Marshal(b, m, deterministic)
}
func (m *RiceDeltaEncoding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RiceDeltaEncoding.Merge(m, src)
}
func (m *RiceDeltaEncoding) XXX_Size() int {
	return xxx_messageInfo_RiceDeltaEncoding.Size(m)
}
func (m *RiceDeltaEncoding) XXX_DiscardUnknown() {
	xxx_messageInfo_RiceDeltaEncoding.DiscardUnknown(m)
}

var xxx_messageInfo_RiceDeltaEncoding proto.InternalMessageInfo

func (m *RiceDeltaEncoding) GetFirstValue() int64 {
	if m != nil {
		return m.FirstValue
	}
	return 0
}

func (m *RiceDeltaEncoding) GetRiceParameter() int32 {
	if m != nil {
		return m.RiceParameter
	}
	return 0
}

func (m *RiceDeltaEncoding) GetEntryCount() int32 {
	if m != nil {
		return m.EntryCount
	}
	return 0
}

func (m *RiceDeltaEncoding) GetEncodedData() []byte {
	if m != nil {
		return m.EncodedData
	}
	return nil
}

// Wraps a URI that might be displaying phishing content.
type Submission struct {
	// Required. The URI that is being reported for phishing content to be analyzed.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Submission) Reset()         { *m = Submission{} }
func (m *Submission) String() string { return proto.CompactTextString(m) }
func (*Submission) ProtoMessage()    {}
func (*Submission) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{11}
}

func (m *Submission) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Submission.Unmarshal(m, b)
}
func (m *Submission) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Submission.Marshal(b, m, deterministic)
}
func (m *Submission) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Submission.Merge(m, src)
}
func (m *Submission) XXX_Size() int {
	return xxx_messageInfo_Submission.Size(m)
}
func (m *Submission) XXX_DiscardUnknown() {
	xxx_messageInfo_Submission.DiscardUnknown(m)
}

var xxx_messageInfo_Submission proto.InternalMessageInfo

func (m *Submission) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Request to send a potentially phishy URI to WebRisk.
type CreateSubmissionRequest struct {
	// Required. The name of the project that is making the submission. This string is in
	// the format "projects/{project_number}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The submission that contains the content of the phishing report.
	Submission           *Submission `protobuf:"bytes,2,opt,name=submission,proto3" json:"submission,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateSubmissionRequest) Reset()         { *m = CreateSubmissionRequest{} }
func (m *CreateSubmissionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSubmissionRequest) ProtoMessage()    {}
func (*CreateSubmissionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_381d885d2cc1205c, []int{12}
}

func (m *CreateSubmissionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSubmissionRequest.Unmarshal(m, b)
}
func (m *CreateSubmissionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSubmissionRequest.Marshal(b, m, deterministic)
}
func (m *CreateSubmissionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSubmissionRequest.Merge(m, src)
}
func (m *CreateSubmissionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSubmissionRequest.Size(m)
}
func (m *CreateSubmissionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSubmissionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSubmissionRequest proto.InternalMessageInfo

func (m *CreateSubmissionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSubmissionRequest) GetSubmission() *Submission {
	if m != nil {
		return m.Submission
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.webrisk.v1.ThreatType", ThreatType_name, ThreatType_value)
	proto.RegisterEnum("google.cloud.webrisk.v1.CompressionType", CompressionType_name, CompressionType_value)
	proto.RegisterEnum("google.cloud.webrisk.v1.ComputeThreatListDiffResponse_ResponseType", ComputeThreatListDiffResponse_ResponseType_name, ComputeThreatListDiffResponse_ResponseType_value)
	proto.RegisterType((*ComputeThreatListDiffRequest)(nil), "google.cloud.webrisk.v1.ComputeThreatListDiffRequest")
	proto.RegisterType((*ComputeThreatListDiffRequest_Constraints)(nil), "google.cloud.webrisk.v1.ComputeThreatListDiffRequest.Constraints")
	proto.RegisterType((*ComputeThreatListDiffResponse)(nil), "google.cloud.webrisk.v1.ComputeThreatListDiffResponse")
	proto.RegisterType((*ComputeThreatListDiffResponse_Checksum)(nil), "google.cloud.webrisk.v1.ComputeThreatListDiffResponse.Checksum")
	proto.RegisterType((*SearchUrisRequest)(nil), "google.cloud.webrisk.v1.SearchUrisRequest")
	proto.RegisterType((*SearchUrisResponse)(nil), "google.cloud.webrisk.v1.SearchUrisResponse")
	proto.RegisterType((*SearchUrisResponse_ThreatUri)(nil), "google.cloud.webrisk.v1.SearchUrisResponse.ThreatUri")
	proto.RegisterType((*SearchHashesRequest)(nil), "google.cloud.webrisk.v1.SearchHashesRequest")
	proto.RegisterType((*SearchHashesResponse)(nil), "google.cloud.webrisk.v1.SearchHashesResponse")
	proto.RegisterType((*SearchHashesResponse_ThreatHash)(nil), "google.cloud.webrisk.v1.SearchHashesResponse.ThreatHash")
	proto.RegisterType((*ThreatEntryAdditions)(nil), "google.cloud.webrisk.v1.ThreatEntryAdditions")
	proto.RegisterType((*ThreatEntryRemovals)(nil), "google.cloud.webrisk.v1.ThreatEntryRemovals")
	proto.RegisterType((*RawIndices)(nil), "google.cloud.webrisk.v1.RawIndices")
	proto.RegisterType((*RawHashes)(nil), "google.cloud.webrisk.v1.RawHashes")
	proto.RegisterType((*RiceDeltaEncoding)(nil), "google.cloud.webrisk.v1.RiceDeltaEncoding")
	proto.RegisterType((*Submission)(nil), "google.cloud.webrisk.v1.Submission")
	proto.RegisterType((*CreateSubmissionRequest)(nil), "google.cloud.webrisk.v1.CreateSubmissionRequest")
}

func init() {
	proto.RegisterFile("google/cloud/webrisk/v1/webrisk.proto", fileDescriptor_381d885d2cc1205c)
}

var fileDescriptor_381d885d2cc1205c = []byte{
	// 1598 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcd, 0x73, 0x1b, 0x49,
	0x15, 0x67, 0x24, 0x7f, 0x3e, 0x29, 0x8e, 0xdc, 0x89, 0x63, 0xaf, 0x36, 0xa9, 0x0d, 0x93, 0x0a,
	0xe5, 0xf2, 0x3a, 0xd2, 0xda, 0x4b, 0xb6, 0x28, 0x6d, 0x01, 0x35, 0x91, 0xc7, 0x89, 0x70, 0x22,
	0xab, 0x5a, 0x8a, 0x5d, 0x40, 0xaa, 0xa6, 0xda, 0xa3, 0x96, 0xd4, 0x44, 0x9a, 0x19, 0xba, 0x5b,
	0x96, 0xb3, 0x14, 0x17, 0xf8, 0x07, 0xa0, 0xf8, 0x03, 0x28, 0xa0, 0xe0, 0xb0, 0x27, 0x4e, 0x5c,
	0x39, 0x71, 0xc9, 0x91, 0xbd, 0xe5, 0x14, 0xaa, 0x38, 0xf1, 0x07, 0x70, 0xe0, 0x44, 0x75, 0x4f,
	0x8f, 0x34, 0xfe, 0x50, 0xd6, 0x4e, 0xed, 0xad, 0xe7, 0x7d, 0xfe, 0xfa, 0xbd, 0x7e, 0x1f, 0x03,
	0xf7, 0xbb, 0x61, 0xd8, 0xed, 0xd3, 0xb2, 0xdf, 0x0f, 0x87, 0xed, 0xf2, 0x88, 0x1e, 0x71, 0x26,
	0x5e, 0x96, 0x8f, 0xb7, 0x92, 0x63, 0x29, 0xe2, 0xa1, 0x0c, 0xd1, 0x6a, 0x2c, 0x56, 0xd2, 0x62,
	0xa5, 0x84, 0x77, 0xbc, 0x55, 0xbc, 0x6d, 0xf4, 0x49, 0xc4, 0xca, 0x24, 0x08, 0x42, 0x49, 0x24,
	0x0b, 0x03, 0x11, 0xab, 0x15, 0x57, 0x53, 0x5c, 0xbf, 0xcf, 0x68, 0x20, 0x0d, 0xe3, 0xa3, 0x14,
	0xa3, 0xc3, 0x68, 0xbf, 0xed, 0x1d, 0xd1, 0x1e, 0x39, 0x66, 0x21, 0x37, 0x02, 0x1f, 0xa4, 0x04,
	0x38, 0x15, 0xe1, 0x90, 0xfb, 0xf4, 0x8c, 0xae, 0xfe, 0x3a, 0x1a, 0x76, 0xca, 0x92, 0x0d, 0xa8,
	0x90, 0x64, 0x10, 0xc5, 0x02, 0xf6, 0x3f, 0xb2, 0x70, 0xbb, 0x1a, 0x0e, 0xa2, 0xa1, 0xa4, 0xad,
	0x1e, 0xa7, 0x44, 0x3e, 0x65, 0x42, 0xee, 0xb0, 0x4e, 0x07, 0xd3, 0x9f, 0x0f, 0xa9, 0x90, 0xa8,
	0x06, 0x39, 0xa9, 0x19, 0x9e, 0x7c, 0x15, 0xd1, 0x35, 0xeb, 0xae, 0xb5, 0xbe, 0xb4, 0x7d, 0xaf,
	0x34, 0xe5, 0x8e, 0xa5, 0xd8, 0x48, 0xeb, 0x55, 0x44, 0x1f, 0x65, 0xdf, 0x3a, 0x19, 0x0c, 0x72,
	0x4c, 0x40, 0xf7, 0xe0, 0xda, 0x31, 0xe5, 0x82, 0x85, 0x81, 0x27, 0xc3, 0x97, 0x34, 0x58, 0xcb,
	0xdc, 0xb5, 0xd6, 0xf3, 0x38, 0x6f, 0x88, 0x2d, 0x45, 0x43, 0x3d, 0xc8, 0xf9, 0x61, 0x20, 0x24,
	0x27, 0x2c, 0x90, 0x62, 0x2d, 0x7b, 0xd7, 0x5a, 0xcf, 0x6d, 0x3b, 0x53, 0xfd, 0xbd, 0x0b, 0x7b,
	0xa9, 0x3a, 0x31, 0x14, 0xa3, 0x49, 0x9b, 0x2e, 0xbe, 0xb6, 0x20, 0x97, 0x92, 0x40, 0xeb, 0x50,
	0x18, 0x90, 0x13, 0xaf, 0xcd, 0x3a, 0x1d, 0x8f, 0x06, 0x92, 0x33, 0x2a, 0xf4, 0x75, 0x67, 0xf1,
	0xd2, 0x80, 0x9c, 0x28, 0xbb, 0x6e, 0x4c, 0x45, 0x9f, 0xc0, 0x4d, 0x2d, 0x49, 0x24, 0x39, 0x22,
	0x82, 0x8e, 0xa5, 0x33, 0x5a, 0x1a, 0x29, 0x69, 0xc3, 0x4a, 0x34, 0x3c, 0xb8, 0x25, 0x86, 0x51,
	0x14, 0x72, 0x49, 0xdb, 0x9e, 0x1f, 0x0e, 0x22, 0x4e, 0x85, 0xba, 0xb3, 0xba, 0x60, 0x76, 0x7d,
	0x69, 0x7b, 0xfd, 0x9d, 0x17, 0x34, 0xc2, 0x2a, 0x88, 0x78, 0x65, 0x6c, 0x27, 0xc5, 0x11, 0xf6,
	0xbf, 0x66, 0xe0, 0xce, 0x94, 0x58, 0x88, 0x28, 0x0c, 0x04, 0x45, 0x3d, 0xb8, 0xc6, 0xcd, 0x39,
	0x4e, 0xe5, 0x8c, 0x4e, 0x65, 0xf5, 0xaa, 0xa1, 0x8d, 0x4d, 0x94, 0x92, 0x83, 0x06, 0x95, 0xe7,
	0xa9, 0x2f, 0xb4, 0x07, 0x8b, 0xa4, 0xdd, 0x66, 0xfa, 0x71, 0xaf, 0xcd, 0xea, 0x04, 0x3e, 0xf8,
	0x9a, 0x07, 0xa3, 0xe2, 0xf4, 0xca, 0x49, 0x94, 0xf0, 0x44, 0x1f, 0x3d, 0x81, 0x05, 0x4e, 0x07,
	0xe1, 0x31, 0xe9, 0x8b, 0xb5, 0x39, 0x6d, 0x6b, 0xf3, 0x32, 0xb6, 0xb0, 0xd1, 0xc1, 0x63, 0x6d,
	0xb4, 0x01, 0xcb, 0x01, 0x1d, 0x79, 0xa7, 0x9f, 0xe0, 0xbc, 0x7e, 0x82, 0xd7, 0x03, 0x3a, 0x3a,
	0x48, 0xbf, 0xc2, 0x9f, 0xc2, 0x82, 0xdf, 0xa3, 0xfe, 0x4b, 0x31, 0x1c, 0xac, 0x2d, 0x68, 0xaf,
	0x3f, 0x7c, 0xcf, 0x38, 0x55, 0x8d, 0x19, 0x3c, 0x36, 0x88, 0xea, 0xb0, 0xc2, 0xa9, 0x1f, 0x0e,
	0x06, 0x34, 0x68, 0xd3, 0xb6, 0x17, 0xd0, 0x13, 0xa9, 0x5f, 0x9d, 0x7e, 0x3f, 0xb9, 0xed, 0x62,
	0xe2, 0x29, 0x29, 0xda, 0x52, 0x2b, 0x29, 0x5a, 0x7c, 0x23, 0xa5, 0x58, 0xa7, 0x27, 0xda, 0x55,
	0xd1, 0x86, 0x85, 0xc4, 0x0b, 0xba, 0x05, 0x73, 0xa2, 0x47, 0xb6, 0x1f, 0x7e, 0xa6, 0x9f, 0x6e,
	0x1e, 0x9b, 0x2f, 0xfb, 0x11, 0xe4, 0xd3, 0x19, 0x43, 0x77, 0xe0, 0x03, 0xec, 0x36, 0x1b, 0xfb,
	0xf5, 0xa6, 0xeb, 0xb5, 0x7e, 0xdc, 0x70, 0xbd, 0xe7, 0xf5, 0x66, 0xc3, 0xad, 0xd6, 0x76, 0x6b,
	0xee, 0x4e, 0xe1, 0x5b, 0x68, 0x01, 0x66, 0x76, 0x6a, 0xbb, 0xbb, 0x05, 0x0b, 0x2d, 0xc2, 0x2c,
	0x76, 0x9b, 0x6e, 0xab, 0x90, 0xb1, 0x47, 0xb0, 0xdc, 0xa4, 0x84, 0xfb, 0xbd, 0xe7, 0x9c, 0x89,
	0xa4, 0x3f, 0xac, 0x40, 0x76, 0xc8, 0x99, 0xf6, 0xb6, 0x18, 0x17, 0x99, 0xfa, 0x46, 0x7b, 0x90,
	0x4f, 0xb5, 0x0d, 0x55, 0x1a, 0xd9, 0x2b, 0xf5, 0x8d, 0xdc, 0xa4, 0x6f, 0x08, 0xfb, 0xbf, 0x16,
	0xa0, 0xb4, 0x67, 0xf3, 0xa2, 0x9f, 0xc1, 0x5c, 0x2c, 0xa5, 0xbd, 0xe7, 0xb6, 0x1f, 0x4e, 0xb5,
	0x7e, 0x5e, 0xd9, 0x38, 0x7c, 0xce, 0x19, 0x36, 0x46, 0x8a, 0xbf, 0xb1, 0x60, 0x71, 0x4c, 0x45,
	0xbb, 0x67, 0x2e, 0x60, 0x5d, 0xfa, 0x02, 0xa7, 0xb0, 0xa3, 0xcf, 0x21, 0x47, 0x4f, 0x22, 0xc6,
	0xa9, 0xa7, 0x5a, 0xef, 0x25, 0x52, 0x0c, 0xb1, 0xb8, 0x22, 0xd8, 0xbf, 0xb6, 0xe0, 0x46, 0x8c,
	0xfd, 0x09, 0x11, 0x3d, 0x3a, 0x0e, 0xfa, 0x47, 0x90, 0xeb, 0x11, 0xd1, 0xf3, 0x22, 0x4e, 0x3b,
	0xec, 0xc4, 0xa4, 0x1a, 0x14, 0xa9, 0xa1, 0x29, 0xdf, 0x6c, 0xf8, 0xdf, 0x66, 0xe0, 0xe6, 0x69,
	0x14, 0x26, 0x01, 0x18, 0xe6, 0x63, 0xb9, 0x38, 0x3c, 0xb9, 0xed, 0xef, 0x7d, 0x4d, 0x06, 0x4e,
	0xeb, 0x1b, 0xaf, 0x8a, 0x88, 0x13, 0x43, 0xe8, 0x29, 0xdc, 0x0c, 0x68, 0x97, 0x48, 0x76, 0x4c,
	0xbd, 0xab, 0x05, 0x0e, 0x25, 0x7a, 0xee, 0x38, 0x80, 0xc5, 0x3f, 0x5b, 0x00, 0x13, 0x2f, 0xdf,
	0x58, 0x52, 0x11, 0xcc, 0xa8, 0x60, 0x9b, 0x01, 0xa6, 0xcf, 0x67, 0x13, 0x9d, 0xbd, 0x52, 0xa2,
	0xff, 0x62, 0xc1, 0xcd, 0x8b, 0x3a, 0x21, 0x72, 0x00, 0x38, 0x19, 0x79, 0x3d, 0x1d, 0x38, 0x13,
	0x65, 0x7b, 0x2a, 0x5e, 0x4c, 0x46, 0x26, 0xc4, 0x8b, 0x3c, 0x39, 0xa2, 0x3d, 0xc8, 0x71, 0xe6,
	0xd3, 0xc4, 0x46, 0x1c, 0xc8, 0x8d, 0xe9, 0x36, 0x98, 0x4f, 0x77, 0x68, 0x5f, 0x12, 0x37, 0xf0,
	0xc3, 0x36, 0x0b, 0xba, 0x18, 0x94, 0x7a, 0x6c, 0xcc, 0xfe, 0xd2, 0x82, 0x1b, 0x17, 0xb4, 0x59,
	0xb4, 0x03, 0x39, 0x85, 0x93, 0x05, 0x6d, 0xe6, 0x9b, 0xb9, 0x99, 0x7b, 0x47, 0x60, 0x31, 0x19,
	0xd5, 0x62, 0x51, 0xac, 0xee, 0x67, 0xce, 0xe8, 0x19, 0xe4, 0x35, 0xd4, 0xc4, 0xcc, 0xd5, 0xb1,
	0xea, 0xab, 0x1a, 0x73, 0xf6, 0x77, 0x00, 0x26, 0x8e, 0xd0, 0x1a, 0xcc, 0x4f, 0xe0, 0x65, 0xd7,
	0x67, 0x71, 0xf2, 0x69, 0xef, 0xc1, 0xe2, 0x38, 0x72, 0xaa, 0xb6, 0xe2, 0xb2, 0xf2, 0x04, 0xfb,
	0x82, 0x9a, 0x0d, 0x00, 0x62, 0x52, 0x93, 0x7d, 0xa1, 0x5a, 0x67, 0x3a, 0x25, 0xf1, 0x13, 0x98,
	0x84, 0xdb, 0xfe, 0xbd, 0x05, 0xcb, 0xe7, 0x70, 0x29, 0xab, 0x1d, 0xc6, 0x85, 0xf4, 0x8e, 0x49,
	0x7f, 0x18, 0x5b, 0xcd, 0x62, 0xd0, 0xa4, 0x03, 0x45, 0x41, 0xf7, 0x61, 0x49, 0x5f, 0x3d, 0x22,
	0x9c, 0x0c, 0xa8, 0xa4, 0xdc, 0x6c, 0x13, 0xd7, 0x14, 0xb5, 0x91, 0x10, 0x95, 0x1d, 0xb5, 0x6d,
	0xbc, 0xf2, 0xfc, 0x70, 0x18, 0x48, 0xfd, 0xca, 0x66, 0x31, 0x68, 0x52, 0x55, 0x51, 0xd0, 0xb7,
	0x21, 0x4f, 0x95, 0x53, 0xda, 0xd6, 0xfb, 0x89, 0x9e, 0xf2, 0x79, 0x9c, 0x33, 0x34, 0xb5, 0x97,
	0xd8, 0xf7, 0x00, 0x9a, 0xc3, 0xa3, 0x01, 0xd3, 0xab, 0xc3, 0x94, 0x06, 0x6e, 0xff, 0xd5, 0x82,
	0xd5, 0xaa, 0xca, 0x33, 0x9d, 0xc8, 0x26, 0xed, 0x67, 0x0f, 0xe6, 0x22, 0xc2, 0x69, 0x20, 0x8d,
	0xd6, 0xa7, 0x6f, 0x9d, 0xcc, 0xff, 0x9c, 0x07, 0xf0, 0xb1, 0x4e, 0x50, 0xb2, 0x82, 0x0e, 0x48,
	0x40, 0xba, 0x94, 0x9b, 0xe4, 0x91, 0x88, 0x89, 0x92, 0x1f, 0x0e, 0xca, 0x0d, 0x1e, 0xfe, 0x8c,
	0xfa, 0x12, 0x1b, 0x13, 0xe8, 0x09, 0x80, 0x18, 0x7b, 0x30, 0x19, 0x9f, 0xfe, 0x70, 0x26, 0x60,
	0xcc, 0x7e, 0x39, 0xd1, 0xdd, 0xa0, 0x49, 0xad, 0xeb, 0x09, 0xf7, 0x21, 0xac, 0xb6, 0x9e, 0x60,
	0xd7, 0x69, 0x5d, 0x34, 0xdf, 0x72, 0x30, 0xff, 0xcc, 0x79, 0x7a, 0xe8, 0x60, 0xb7, 0x60, 0xa1,
	0x5b, 0x80, 0x9a, 0xfb, 0xd5, 0x9a, 0xf3, 0xd4, 0x73, 0xeb, 0x8f, 0x6b, 0x75, 0xd7, 0xc5, 0xb5,
	0xfa, 0xe3, 0x42, 0x06, 0xad, 0xc0, 0xf2, 0xf3, 0xfa, 0xa1, 0x53, 0x6f, 0xb9, 0x3b, 0x5e, 0x73,
	0x7f, 0xb7, 0xa5, 0xc5, 0xb3, 0x1b, 0xbb, 0x70, 0xfd, 0xcc, 0x52, 0x86, 0xee, 0xc2, 0xed, 0xea,
	0xfe, 0xb3, 0x06, 0x76, 0x9b, 0xcd, 0xda, 0x7e, 0xfd, 0x22, 0x87, 0xf3, 0x90, 0xc5, 0xce, 0x61,
	0xc1, 0x52, 0x93, 0x15, 0xd7, 0xaa, 0x6e, 0x21, 0xb3, 0xfd, 0xa7, 0x39, 0x58, 0x3a, 0xa4, 0x47,
	0x98, 0x89, 0x97, 0x4d, 0xca, 0x8f, 0x99, 0x4f, 0xd1, 0x57, 0x16, 0xac, 0x5c, 0xb8, 0x4e, 0xa0,
	0x87, 0xef, 0xb5, 0x01, 0x17, 0x3f, 0x7b, 0xbf, 0xad, 0xc5, 0xde, 0x7b, 0xe3, 0xdc, 0x4f, 0x75,
	0xca, 0xcd, 0x53, 0x4b, 0xd3, 0x66, 0x6a, 0x8b, 0xfe, 0xd5, 0x57, 0xff, 0xfe, 0x5d, 0xe6, 0x0e,
	0xfa, 0x50, 0xfd, 0x06, 0xc9, 0xb1, 0x2d, 0x51, 0xf1, 0x63, 0xf3, 0x1a, 0xfb, 0x6f, 0x2d, 0x80,
	0xc9, 0x04, 0x46, 0x1b, 0x97, 0x1a, 0xd3, 0x31, 0xfe, 0x8f, 0xaf, 0x30, 0xd2, 0xed, 0x8d, 0x37,
	0x4e, 0x61, 0xc8, 0xd9, 0x66, 0xba, 0xc5, 0x6b, 0x7c, 0xcb, 0xe8, 0xba, 0xc2, 0x37, 0xe4, 0x4c,
	0x54, 0x84, 0xd6, 0x43, 0x7f, 0xb0, 0x20, 0x9f, 0x9e, 0x49, 0x68, 0xf3, 0x92, 0xa3, 0x2b, 0xc6,
	0xf5, 0xe0, 0x4a, 0x83, 0xce, 0xfe, 0xee, 0x1b, 0x67, 0x2d, 0x35, 0xb0, 0xcf, 0x23, 0xbc, 0x81,
	0x96, 0x15, 0xc2, 0xb8, 0xa7, 0x24, 0x18, 0xff, 0x66, 0x41, 0xe1, 0x6c, 0x09, 0xa2, 0x4f, 0xa6,
	0x67, 0xf4, 0xe2, 0x6a, 0x2d, 0x5e, 0xa6, 0x98, 0x54, 0xc2, 0x97, 0xe3, 0x82, 0xdc, 0x9c, 0x54,
	0x94, 0x86, 0xb6, 0x65, 0xdf, 0x53, 0xd0, 0x7e, 0x11, 0x73, 0xbf, 0x1f, 0xc5, 0xe5, 0x2b, 0xca,
	0x1b, 0xbf, 0x2c, 0x4f, 0x24, 0x45, 0x25, 0x55, 0x88, 0xc5, 0x1f, 0xbd, 0x76, 0x6e, 0x25, 0x6e,
	0x4e, 0x57, 0xff, 0x3f, 0x9d, 0x52, 0x4f, 0xca, 0x48, 0x54, 0xca, 0xe5, 0xd1, 0x68, 0x74, 0xb6,
	0x35, 0x90, 0xa1, 0xec, 0xc5, 0x7f, 0xd7, 0x0f, 0xa2, 0x3e, 0x91, 0x9d, 0x90, 0x0f, 0x1e, 0xfd,
	0xdd, 0x82, 0x15, 0x3f, 0x1c, 0x24, 0x77, 0x98, 0xa0, 0x7f, 0x94, 0x37, 0xc5, 0xd3, 0x50, 0xa3,
	0xb5, 0x61, 0xfd, 0xe4, 0x07, 0x46, 0xa4, 0x1b, 0xf6, 0x49, 0xd0, 0x2d, 0x85, 0xbc, 0x5b, 0xee,
	0xd2, 0x40, 0x0f, 0xde, 0xf2, 0xc4, 0xd1, 0xb9, 0xbf, 0xf7, 0xcf, 0xcd, 0xf1, 0x8f, 0x99, 0x99,
	0xc7, 0xd5, 0x43, 0xfc, 0x65, 0x66, 0xf5, 0x71, 0x6c, 0xa7, 0xaa, 0xc3, 0x65, 0x9c, 0x94, 0x0e,
	0xb6, 0x5e, 0x27, 0x9c, 0x17, 0x9a, 0xf3, 0xc2, 0x70, 0x5e, 0x1c, 0x6c, 0xfd, 0x27, 0x53, 0x8c,
	0x39, 0x95, 0x8a, 0x66, 0x55, 0x2a, 0x86, 0x57, 0xa9, 0x1c, 0x6c, 0x1d, 0xcd, 0x69, 0x08, 0x9f,
	0xfe, 0x3f, 0x00, 0x00, 0xff, 0xff, 0x75, 0x70, 0x99, 0x33, 0x3f, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WebRiskServiceClient is the client API for WebRiskService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WebRiskServiceClient interface {
	// Gets the most recent threat list diffs. These diffs should be applied to
	// a local database of hashes to keep it up-to-date. If the local database is
	// empty or excessively out-of-date, a complete snapshot of the database will
	// be returned. This Method only updates a single ThreatList at a time. To
	// update multiple ThreatList databases, this method needs to be called once
	// for each list.
	ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	// Multiple threatLists may be searched in a single query.
	// The response will list all requested threatLists the URI was found to
	// match. If the URI is not found on any of the requested ThreatList an
	// empty response will be returned.
	SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error)
	// Creates a Submission of a URI suspected of containing phishing content to
	// be reviewed. If the result verifies the existence of malicious phishing
	// content, the site will be added to the [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// projects with CREATE_SUBMISSION_USERS visibility can use this method.
	CreateSubmission(ctx context.Context, in *CreateSubmissionRequest, opts ...grpc.CallOption) (*Submission, error)
}

type webRiskServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewWebRiskServiceClient(cc grpc.ClientConnInterface) WebRiskServiceClient {
	return &webRiskServiceClient{cc}
}

func (c *webRiskServiceClient) ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error) {
	out := new(ComputeThreatListDiffResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error) {
	out := new(SearchUrisResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/SearchUris", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error) {
	out := new(SearchHashesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/SearchHashes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) CreateSubmission(ctx context.Context, in *CreateSubmissionRequest, opts ...grpc.CallOption) (*Submission, error) {
	out := new(Submission)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/CreateSubmission", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebRiskServiceServer is the server API for WebRiskService service.
type WebRiskServiceServer interface {
	// Gets the most recent threat list diffs. These diffs should be applied to
	// a local database of hashes to keep it up-to-date. If the local database is
	// empty or excessively out-of-date, a complete snapshot of the database will
	// be returned. This Method only updates a single ThreatList at a time. To
	// update multiple ThreatList databases, this method needs to be called once
	// for each list.
	ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	// Multiple threatLists may be searched in a single query.
	// The response will list all requested threatLists the URI was found to
	// match. If the URI is not found on any of the requested ThreatList an
	// empty response will be returned.
	SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error)
	// Creates a Submission of a URI suspected of containing phishing content to
	// be reviewed. If the result verifies the existence of malicious phishing
	// content, the site will be added to the [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// projects with CREATE_SUBMISSION_USERS visibility can use this method.
	CreateSubmission(context.Context, *CreateSubmissionRequest) (*Submission, error)
}

// UnimplementedWebRiskServiceServer can be embedded to have forward compatible implementations.
type UnimplementedWebRiskServiceServer struct {
}

func (*UnimplementedWebRiskServiceServer) ComputeThreatListDiff(ctx context.Context, req *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeThreatListDiff not implemented")
}
func (*UnimplementedWebRiskServiceServer) SearchUris(ctx context.Context, req *SearchUrisRequest) (*SearchUrisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchUris not implemented")
}
func (*UnimplementedWebRiskServiceServer) SearchHashes(ctx context.Context, req *SearchHashesRequest) (*SearchHashesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchHashes not implemented")
}
func (*UnimplementedWebRiskServiceServer) CreateSubmission(ctx context.Context, req *CreateSubmissionRequest) (*Submission, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubmission not implemented")
}

func RegisterWebRiskServiceServer(s *grpc.Server, srv WebRiskServiceServer) {
	s.RegisterService(&_WebRiskService_serviceDesc, srv)
}

func _WebRiskService_ComputeThreatListDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeThreatListDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).ComputeThreatListDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).ComputeThreatListDiff(ctx, req.(*ComputeThreatListDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SearchUris_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchUrisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SearchUris(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/SearchUris",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SearchUris(ctx, req.(*SearchUrisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SearchHashes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchHashesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SearchHashes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/SearchHashes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SearchHashes(ctx, req.(*SearchHashesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_CreateSubmission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubmissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).CreateSubmission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/CreateSubmission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).CreateSubmission(ctx, req.(*CreateSubmissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WebRiskService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.webrisk.v1.WebRiskService",
	HandlerType: (*WebRiskServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeThreatListDiff",
			Handler:    _WebRiskService_ComputeThreatListDiff_Handler,
		},
		{
			MethodName: "SearchUris",
			Handler:    _WebRiskService_SearchUris_Handler,
		},
		{
			MethodName: "SearchHashes",
			Handler:    _WebRiskService_SearchHashes_Handler,
		},
		{
			MethodName: "CreateSubmission",
			Handler:    _WebRiskService_CreateSubmission_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/webrisk/v1/webrisk.proto",
}
