// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAbortDocumentVersionUpload = "AbortDocumentVersionUpload"

// AbortDocumentVersionUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortDocumentVersionUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortDocumentVersionUpload for more information on using the AbortDocumentVersionUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AbortDocumentVersionUploadRequest method.
//    req, resp := client.AbortDocumentVersionUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AbortDocumentVersionUpload
func (c *WorkDocs) AbortDocumentVersionUploadRequest(input *AbortDocumentVersionUploadInput) (req *request.Request, output *AbortDocumentVersionUploadOutput) {
	op := &request.Operation{
		Name:       opAbortDocumentVersionUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}",
	}

	if input == nil {
		input = &AbortDocumentVersionUploadInput{}
	}

	output = &AbortDocumentVersionUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AbortDocumentVersionUpload API operation for Amazon WorkDocs.
//
// Aborts the upload of the specified document version that was previously initiated
// by InitiateDocumentVersionUpload. The client should make this call only when
// it no longer intends to upload the document version, or fails to do so.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation AbortDocumentVersionUpload for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AbortDocumentVersionUpload
func (c *WorkDocs) AbortDocumentVersionUpload(input *AbortDocumentVersionUploadInput) (*AbortDocumentVersionUploadOutput, error) {
	req, out := c.AbortDocumentVersionUploadRequest(input)
	return out, req.Send()
}

// AbortDocumentVersionUploadWithContext is the same as AbortDocumentVersionUpload with the addition of
// the ability to pass a context and additional request options.
//
// See AbortDocumentVersionUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) AbortDocumentVersionUploadWithContext(ctx aws.Context, input *AbortDocumentVersionUploadInput, opts ...request.Option) (*AbortDocumentVersionUploadOutput, error) {
	req, out := c.AbortDocumentVersionUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opActivateUser = "ActivateUser"

// ActivateUserRequest generates a "aws/request.Request" representing the
// client's request for the ActivateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateUser for more information on using the ActivateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ActivateUserRequest method.
//    req, resp := client.ActivateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser
func (c *WorkDocs) ActivateUserRequest(input *ActivateUserInput) (req *request.Request, output *ActivateUserOutput) {
	op := &request.Operation{
		Name:       opActivateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/users/{UserId}/activation",
	}

	if input == nil {
		input = &ActivateUserInput{}
	}

	output = &ActivateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateUser API operation for Amazon WorkDocs.
//
// Activates the specified user. Only active users can access Amazon WorkDocs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation ActivateUser for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser
func (c *WorkDocs) ActivateUser(input *ActivateUserInput) (*ActivateUserOutput, error) {
	req, out := c.ActivateUserRequest(input)
	return out, req.Send()
}

// ActivateUserWithContext is the same as ActivateUser with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) ActivateUserWithContext(ctx aws.Context, input *ActivateUserInput, opts ...request.Option) (*ActivateUserOutput, error) {
	req, out := c.ActivateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddResourcePermissions = "AddResourcePermissions"

// AddResourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the AddResourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddResourcePermissions for more information on using the AddResourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddResourcePermissionsRequest method.
//    req, resp := client.AddResourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions
func (c *WorkDocs) AddResourcePermissionsRequest(input *AddResourcePermissionsInput) (req *request.Request, output *AddResourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opAddResourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/resources/{ResourceId}/permissions",
	}

	if input == nil {
		input = &AddResourcePermissionsInput{}
	}

	output = &AddResourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddResourcePermissions API operation for Amazon WorkDocs.
//
// Creates a set of permissions for the specified folder or document. The resource
// permissions are overwritten if the principals already have different permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation AddResourcePermissions for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/AddResourcePermissions
func (c *WorkDocs) AddResourcePermissions(input *AddResourcePermissionsInput) (*AddResourcePermissionsOutput, error) {
	req, out := c.AddResourcePermissionsRequest(input)
	return out, req.Send()
}

// AddResourcePermissionsWithContext is the same as AddResourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See AddResourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) AddResourcePermissionsWithContext(ctx aws.Context, input *AddResourcePermissionsInput, opts ...request.Option) (*AddResourcePermissionsOutput, error) {
	req, out := c.AddResourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComment = "CreateComment"

// CreateCommentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComment for more information on using the CreateComment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCommentRequest method.
//    req, resp := client.CreateCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateComment
func (c *WorkDocs) CreateCommentRequest(input *CreateCommentInput) (req *request.Request, output *CreateCommentOutput) {
	op := &request.Operation{
		Name:       opCreateComment,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment",
	}

	if input == nil {
		input = &CreateCommentInput{}
	}

	output = &CreateCommentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComment API operation for Amazon WorkDocs.
//
// Adds a new comment to the specified document version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation CreateComment for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * DocumentLockedForCommentsException
//   This exception is thrown when the document is locked for comments and user
//   tries to create or delete a comment on that document.
//
//   * InvalidCommentOperationException
//   The requested operation is not allowed on the specified comment object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateComment
func (c *WorkDocs) CreateComment(input *CreateCommentInput) (*CreateCommentOutput, error) {
	req, out := c.CreateCommentRequest(input)
	return out, req.Send()
}

// CreateCommentWithContext is the same as CreateComment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) CreateCommentWithContext(ctx aws.Context, input *CreateCommentInput, opts ...request.Option) (*CreateCommentOutput, error) {
	req, out := c.CreateCommentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomMetadata = "CreateCustomMetadata"

// CreateCustomMetadataRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomMetadata for more information on using the CreateCustomMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomMetadataRequest method.
//    req, resp := client.CreateCustomMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata
func (c *WorkDocs) CreateCustomMetadataRequest(input *CreateCustomMetadataInput) (req *request.Request, output *CreateCustomMetadataOutput) {
	op := &request.Operation{
		Name:       opCreateCustomMetadata,
		HTTPMethod: "PUT",
		HTTPPath:   "/api/v1/resources/{ResourceId}/customMetadata",
	}

	if input == nil {
		input = &CreateCustomMetadataInput{}
	}

	output = &CreateCustomMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateCustomMetadata API operation for Amazon WorkDocs.
//
// Adds one or more custom properties to the specified resource (a folder, document,
// or version).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation CreateCustomMetadata for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * CustomMetadataLimitExceededException
//   The limit has been reached on the number of custom properties for the specified
//   resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata
func (c *WorkDocs) CreateCustomMetadata(input *CreateCustomMetadataInput) (*CreateCustomMetadataOutput, error) {
	req, out := c.CreateCustomMetadataRequest(input)
	return out, req.Send()
}

// CreateCustomMetadataWithContext is the same as CreateCustomMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) CreateCustomMetadataWithContext(ctx aws.Context, input *CreateCustomMetadataInput, opts ...request.Option) (*CreateCustomMetadataOutput, error) {
	req, out := c.CreateCustomMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolder = "CreateFolder"

// CreateFolderRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolder for more information on using the CreateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFolderRequest method.
//    req, resp := client.CreateFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateFolder
func (c *WorkDocs) CreateFolderRequest(input *CreateFolderInput) (req *request.Request, output *CreateFolderOutput) {
	op := &request.Operation{
		Name:       opCreateFolder,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/folders",
	}

	if input == nil {
		input = &CreateFolderInput{}
	}

	output = &CreateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolder API operation for Amazon WorkDocs.
//
// Creates a folder with the specified name and parent folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation CreateFolder for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * EntityAlreadyExistsException
//   The resource already exists.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConflictingOperationException
//   Another operation is in progress on the resource that conflicts with the
//   current operation.
//
//   * LimitExceededException
//   The maximum of 100,000 folders under the parent folder has been exceeded.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateFolder
func (c *WorkDocs) CreateFolder(input *CreateFolderInput) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	return out, req.Send()
}

// CreateFolderWithContext is the same as CreateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) CreateFolderWithContext(ctx aws.Context, input *CreateFolderInput, opts ...request.Option) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLabels = "CreateLabels"

// CreateLabelsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLabels for more information on using the CreateLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLabelsRequest method.
//    req, resp := client.CreateLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateLabels
func (c *WorkDocs) CreateLabelsRequest(input *CreateLabelsInput) (req *request.Request, output *CreateLabelsOutput) {
	op := &request.Operation{
		Name:       opCreateLabels,
		HTTPMethod: "PUT",
		HTTPPath:   "/api/v1/resources/{ResourceId}/labels",
	}

	if input == nil {
		input = &CreateLabelsInput{}
	}

	output = &CreateLabelsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateLabels API operation for Amazon WorkDocs.
//
// Adds the specified list of labels to the given resource (a document or folder)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation CreateLabels for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * TooManyLabelsException
//   The limit has been reached on the number of labels for the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateLabels
func (c *WorkDocs) CreateLabels(input *CreateLabelsInput) (*CreateLabelsOutput, error) {
	req, out := c.CreateLabelsRequest(input)
	return out, req.Send()
}

// CreateLabelsWithContext is the same as CreateLabels with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) CreateLabelsWithContext(ctx aws.Context, input *CreateLabelsInput, opts ...request.Option) (*CreateLabelsOutput, error) {
	req, out := c.CreateLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotificationSubscription = "CreateNotificationSubscription"

// CreateNotificationSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotificationSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotificationSubscription for more information on using the CreateNotificationSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotificationSubscriptionRequest method.
//    req, resp := client.CreateNotificationSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateNotificationSubscription
func (c *WorkDocs) CreateNotificationSubscriptionRequest(input *CreateNotificationSubscriptionInput) (req *request.Request, output *CreateNotificationSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateNotificationSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/organizations/{OrganizationId}/subscriptions",
	}

	if input == nil {
		input = &CreateNotificationSubscriptionInput{}
	}

	output = &CreateNotificationSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotificationSubscription API operation for Amazon WorkDocs.
//
// Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives
// a confirmation message, and must confirm the subscription.
//
// For more information, see Subscribe to Notifications (https://docs.aws.amazon.com/workdocs/latest/developerguide/subscribe-notifications.html)
// in the Amazon WorkDocs Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation CreateNotificationSubscription for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * TooManySubscriptionsException
//   You've reached the limit on the number of subscriptions for the WorkDocs
//   instance.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateNotificationSubscription
func (c *WorkDocs) CreateNotificationSubscription(input *CreateNotificationSubscriptionInput) (*CreateNotificationSubscriptionOutput, error) {
	req, out := c.CreateNotificationSubscriptionRequest(input)
	return out, req.Send()
}

// CreateNotificationSubscriptionWithContext is the same as CreateNotificationSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotificationSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) CreateNotificationSubscriptionWithContext(ctx aws.Context, input *CreateNotificationSubscriptionInput, opts ...request.Option) (*CreateNotificationSubscriptionOutput, error) {
	req, out := c.CreateNotificationSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateUser
func (c *WorkDocs) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/users",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon WorkDocs.
//
// Creates a user in a Simple AD or Microsoft AD directory. The status of a
// newly created user is "ACTIVE". New users can access Amazon WorkDocs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * EntityAlreadyExistsException
//   The resource already exists.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateUser
func (c *WorkDocs) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateUser = "DeactivateUser"

// DeactivateUserRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateUser for more information on using the DeactivateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeactivateUserRequest method.
//    req, resp := client.DeactivateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser
func (c *WorkDocs) DeactivateUserRequest(input *DeactivateUserInput) (req *request.Request, output *DeactivateUserOutput) {
	op := &request.Operation{
		Name:       opDeactivateUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/users/{UserId}/activation",
	}

	if input == nil {
		input = &DeactivateUserInput{}
	}

	output = &DeactivateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateUser API operation for Amazon WorkDocs.
//
// Deactivates the specified user, which revokes the user's access to Amazon
// WorkDocs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeactivateUser for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeactivateUser
func (c *WorkDocs) DeactivateUser(input *DeactivateUserInput) (*DeactivateUserOutput, error) {
	req, out := c.DeactivateUserRequest(input)
	return out, req.Send()
}

// DeactivateUserWithContext is the same as DeactivateUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeactivateUserWithContext(ctx aws.Context, input *DeactivateUserInput, opts ...request.Option) (*DeactivateUserOutput, error) {
	req, out := c.DeactivateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComment = "DeleteComment"

// DeleteCommentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComment for more information on using the DeleteComment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCommentRequest method.
//    req, resp := client.DeleteCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteComment
func (c *WorkDocs) DeleteCommentRequest(input *DeleteCommentInput) (req *request.Request, output *DeleteCommentOutput) {
	op := &request.Operation{
		Name:       opDeleteComment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment/{CommentId}",
	}

	if input == nil {
		input = &DeleteCommentInput{}
	}

	output = &DeleteCommentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteComment API operation for Amazon WorkDocs.
//
// Deletes the specified comment from the document version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteComment for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * DocumentLockedForCommentsException
//   This exception is thrown when the document is locked for comments and user
//   tries to create or delete a comment on that document.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteComment
func (c *WorkDocs) DeleteComment(input *DeleteCommentInput) (*DeleteCommentOutput, error) {
	req, out := c.DeleteCommentRequest(input)
	return out, req.Send()
}

// DeleteCommentWithContext is the same as DeleteComment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteCommentWithContext(ctx aws.Context, input *DeleteCommentInput, opts ...request.Option) (*DeleteCommentOutput, error) {
	req, out := c.DeleteCommentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomMetadata = "DeleteCustomMetadata"

// DeleteCustomMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomMetadata for more information on using the DeleteCustomMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCustomMetadataRequest method.
//    req, resp := client.DeleteCustomMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteCustomMetadata
func (c *WorkDocs) DeleteCustomMetadataRequest(input *DeleteCustomMetadataInput) (req *request.Request, output *DeleteCustomMetadataOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomMetadata,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/resources/{ResourceId}/customMetadata",
	}

	if input == nil {
		input = &DeleteCustomMetadataInput{}
	}

	output = &DeleteCustomMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomMetadata API operation for Amazon WorkDocs.
//
// Deletes custom metadata from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteCustomMetadata for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteCustomMetadata
func (c *WorkDocs) DeleteCustomMetadata(input *DeleteCustomMetadataInput) (*DeleteCustomMetadataOutput, error) {
	req, out := c.DeleteCustomMetadataRequest(input)
	return out, req.Send()
}

// DeleteCustomMetadataWithContext is the same as DeleteCustomMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteCustomMetadataWithContext(ctx aws.Context, input *DeleteCustomMetadataInput, opts ...request.Option) (*DeleteCustomMetadataOutput, error) {
	req, out := c.DeleteCustomMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocument = "DeleteDocument"

// DeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocument for more information on using the DeleteDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDocumentRequest method.
//    req, resp := client.DeleteDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocument
func (c *WorkDocs) DeleteDocumentRequest(input *DeleteDocumentInput) (req *request.Request, output *DeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opDeleteDocument,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/documents/{DocumentId}",
	}

	if input == nil {
		input = &DeleteDocumentInput{}
	}

	output = &DeleteDocumentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocument API operation for Amazon WorkDocs.
//
// Permanently deletes the specified document and its associated metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteDocument for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConflictingOperationException
//   Another operation is in progress on the resource that conflicts with the
//   current operation.
//
//   * ConcurrentModificationException
//   The resource hierarchy is changing.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteDocument
func (c *WorkDocs) DeleteDocument(input *DeleteDocumentInput) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	return out, req.Send()
}

// DeleteDocumentWithContext is the same as DeleteDocument with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteDocumentWithContext(ctx aws.Context, input *DeleteDocumentInput, opts ...request.Option) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolder = "DeleteFolder"

// DeleteFolderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolder for more information on using the DeleteFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFolderRequest method.
//    req, resp := client.DeleteFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder
func (c *WorkDocs) DeleteFolderRequest(input *DeleteFolderInput) (req *request.Request, output *DeleteFolderOutput) {
	op := &request.Operation{
		Name:       opDeleteFolder,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/folders/{FolderId}",
	}

	if input == nil {
		input = &DeleteFolderInput{}
	}

	output = &DeleteFolderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFolder API operation for Amazon WorkDocs.
//
// Permanently deletes the specified folder and its contents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteFolder for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConflictingOperationException
//   Another operation is in progress on the resource that conflicts with the
//   current operation.
//
//   * ConcurrentModificationException
//   The resource hierarchy is changing.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolder
func (c *WorkDocs) DeleteFolder(input *DeleteFolderInput) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	return out, req.Send()
}

// DeleteFolderWithContext is the same as DeleteFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteFolderWithContext(ctx aws.Context, input *DeleteFolderInput, opts ...request.Option) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolderContents = "DeleteFolderContents"

// DeleteFolderContentsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolderContents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolderContents for more information on using the DeleteFolderContents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFolderContentsRequest method.
//    req, resp := client.DeleteFolderContentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolderContents
func (c *WorkDocs) DeleteFolderContentsRequest(input *DeleteFolderContentsInput) (req *request.Request, output *DeleteFolderContentsOutput) {
	op := &request.Operation{
		Name:       opDeleteFolderContents,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/folders/{FolderId}/contents",
	}

	if input == nil {
		input = &DeleteFolderContentsInput{}
	}

	output = &DeleteFolderContentsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFolderContents API operation for Amazon WorkDocs.
//
// Deletes the contents of the specified folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteFolderContents for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConflictingOperationException
//   Another operation is in progress on the resource that conflicts with the
//   current operation.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteFolderContents
func (c *WorkDocs) DeleteFolderContents(input *DeleteFolderContentsInput) (*DeleteFolderContentsOutput, error) {
	req, out := c.DeleteFolderContentsRequest(input)
	return out, req.Send()
}

// DeleteFolderContentsWithContext is the same as DeleteFolderContents with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolderContents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteFolderContentsWithContext(ctx aws.Context, input *DeleteFolderContentsInput, opts ...request.Option) (*DeleteFolderContentsOutput, error) {
	req, out := c.DeleteFolderContentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLabels = "DeleteLabels"

// DeleteLabelsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLabels for more information on using the DeleteLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLabelsRequest method.
//    req, resp := client.DeleteLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteLabels
func (c *WorkDocs) DeleteLabelsRequest(input *DeleteLabelsInput) (req *request.Request, output *DeleteLabelsOutput) {
	op := &request.Operation{
		Name:       opDeleteLabels,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/resources/{ResourceId}/labels",
	}

	if input == nil {
		input = &DeleteLabelsInput{}
	}

	output = &DeleteLabelsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLabels API operation for Amazon WorkDocs.
//
// Deletes the specified list of labels from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteLabels for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteLabels
func (c *WorkDocs) DeleteLabels(input *DeleteLabelsInput) (*DeleteLabelsOutput, error) {
	req, out := c.DeleteLabelsRequest(input)
	return out, req.Send()
}

// DeleteLabelsWithContext is the same as DeleteLabels with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteLabelsWithContext(ctx aws.Context, input *DeleteLabelsInput, opts ...request.Option) (*DeleteLabelsOutput, error) {
	req, out := c.DeleteLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotificationSubscription = "DeleteNotificationSubscription"

// DeleteNotificationSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotificationSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotificationSubscription for more information on using the DeleteNotificationSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotificationSubscriptionRequest method.
//    req, resp := client.DeleteNotificationSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteNotificationSubscription
func (c *WorkDocs) DeleteNotificationSubscriptionRequest(input *DeleteNotificationSubscriptionInput) (req *request.Request, output *DeleteNotificationSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/organizations/{OrganizationId}/subscriptions/{SubscriptionId}",
	}

	if input == nil {
		input = &DeleteNotificationSubscriptionInput{}
	}

	output = &DeleteNotificationSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotificationSubscription API operation for Amazon WorkDocs.
//
// Deletes the specified subscription from the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteNotificationSubscription for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteNotificationSubscription
func (c *WorkDocs) DeleteNotificationSubscription(input *DeleteNotificationSubscriptionInput) (*DeleteNotificationSubscriptionOutput, error) {
	req, out := c.DeleteNotificationSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteNotificationSubscriptionWithContext is the same as DeleteNotificationSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotificationSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteNotificationSubscriptionWithContext(ctx aws.Context, input *DeleteNotificationSubscriptionInput, opts ...request.Option) (*DeleteNotificationSubscriptionOutput, error) {
	req, out := c.DeleteNotificationSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteUser
func (c *WorkDocs) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/users/{UserId}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon WorkDocs.
//
// Deletes the specified user from a Simple AD or Microsoft AD directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DeleteUser
func (c *WorkDocs) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActivities = "DescribeActivities"

// DescribeActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActivities for more information on using the DescribeActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActivitiesRequest method.
//    req, resp := client.DescribeActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities
func (c *WorkDocs) DescribeActivitiesRequest(input *DescribeActivitiesInput) (req *request.Request, output *DescribeActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeActivities,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/activities",
	}

	if input == nil {
		input = &DescribeActivitiesInput{}
	}

	output = &DescribeActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActivities API operation for Amazon WorkDocs.
//
// Describes the user activities in a specified time period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeActivities for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeActivities
func (c *WorkDocs) DescribeActivities(input *DescribeActivitiesInput) (*DescribeActivitiesOutput, error) {
	req, out := c.DescribeActivitiesRequest(input)
	return out, req.Send()
}

// DescribeActivitiesWithContext is the same as DescribeActivities with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeActivitiesWithContext(ctx aws.Context, input *DescribeActivitiesInput, opts ...request.Option) (*DescribeActivitiesOutput, error) {
	req, out := c.DescribeActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComments = "DescribeComments"

// DescribeCommentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComments for more information on using the DescribeComments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCommentsRequest method.
//    req, resp := client.DescribeCommentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments
func (c *WorkDocs) DescribeCommentsRequest(input *DescribeCommentsInput) (req *request.Request, output *DescribeCommentsOutput) {
	op := &request.Operation{
		Name:       opDescribeComments,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}/comments",
	}

	if input == nil {
		input = &DescribeCommentsInput{}
	}

	output = &DescribeCommentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComments API operation for Amazon WorkDocs.
//
// List all the comments for the specified document version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeComments for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeComments
func (c *WorkDocs) DescribeComments(input *DescribeCommentsInput) (*DescribeCommentsOutput, error) {
	req, out := c.DescribeCommentsRequest(input)
	return out, req.Send()
}

// DescribeCommentsWithContext is the same as DescribeComments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeCommentsWithContext(ctx aws.Context, input *DescribeCommentsInput, opts ...request.Option) (*DescribeCommentsOutput, error) {
	req, out := c.DescribeCommentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentVersions = "DescribeDocumentVersions"

// DescribeDocumentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentVersions for more information on using the DescribeDocumentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDocumentVersionsRequest method.
//    req, resp := client.DescribeDocumentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions
func (c *WorkDocs) DescribeDocumentVersionsRequest(input *DescribeDocumentVersionsInput) (req *request.Request, output *DescribeDocumentVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDocumentVersionsInput{}
	}

	output = &DescribeDocumentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentVersions API operation for Amazon WorkDocs.
//
// Retrieves the document versions for the specified document.
//
// By default, only active versions are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeDocumentVersions for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeDocumentVersions
func (c *WorkDocs) DescribeDocumentVersions(input *DescribeDocumentVersionsInput) (*DescribeDocumentVersionsOutput, error) {
	req, out := c.DescribeDocumentVersionsRequest(input)
	return out, req.Send()
}

// DescribeDocumentVersionsWithContext is the same as DescribeDocumentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeDocumentVersionsWithContext(ctx aws.Context, input *DescribeDocumentVersionsInput, opts ...request.Option) (*DescribeDocumentVersionsOutput, error) {
	req, out := c.DescribeDocumentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDocumentVersionsPages iterates over the pages of a DescribeDocumentVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDocumentVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDocumentVersions operation.
//    pageNum := 0
//    err := client.DescribeDocumentVersionsPages(params,
//        func(page *workdocs.DescribeDocumentVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkDocs) DescribeDocumentVersionsPages(input *DescribeDocumentVersionsInput, fn func(*DescribeDocumentVersionsOutput, bool) bool) error {
	return c.DescribeDocumentVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDocumentVersionsPagesWithContext same as DescribeDocumentVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeDocumentVersionsPagesWithContext(ctx aws.Context, input *DescribeDocumentVersionsInput, fn func(*DescribeDocumentVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDocumentVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDocumentVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDocumentVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFolderContents = "DescribeFolderContents"

// DescribeFolderContentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderContents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderContents for more information on using the DescribeFolderContents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFolderContentsRequest method.
//    req, resp := client.DescribeFolderContentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents
func (c *WorkDocs) DescribeFolderContentsRequest(input *DescribeFolderContentsInput) (req *request.Request, output *DescribeFolderContentsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderContents,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/folders/{FolderId}/contents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFolderContentsInput{}
	}

	output = &DescribeFolderContentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderContents API operation for Amazon WorkDocs.
//
// Describes the contents of the specified folder, including its documents and
// subfolders.
//
// By default, Amazon WorkDocs returns the first 100 active document and folder
// metadata items. If there are more results, the response includes a marker
// that you can use to request the next set of results. You can also request
// initialized documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeFolderContents for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeFolderContents
func (c *WorkDocs) DescribeFolderContents(input *DescribeFolderContentsInput) (*DescribeFolderContentsOutput, error) {
	req, out := c.DescribeFolderContentsRequest(input)
	return out, req.Send()
}

// DescribeFolderContentsWithContext is the same as DescribeFolderContents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderContents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeFolderContentsWithContext(ctx aws.Context, input *DescribeFolderContentsInput, opts ...request.Option) (*DescribeFolderContentsOutput, error) {
	req, out := c.DescribeFolderContentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFolderContentsPages iterates over the pages of a DescribeFolderContents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFolderContents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFolderContents operation.
//    pageNum := 0
//    err := client.DescribeFolderContentsPages(params,
//        func(page *workdocs.DescribeFolderContentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkDocs) DescribeFolderContentsPages(input *DescribeFolderContentsInput, fn func(*DescribeFolderContentsOutput, bool) bool) error {
	return c.DescribeFolderContentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFolderContentsPagesWithContext same as DescribeFolderContentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeFolderContentsPagesWithContext(ctx aws.Context, input *DescribeFolderContentsInput, fn func(*DescribeFolderContentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFolderContentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFolderContentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFolderContentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGroups = "DescribeGroups"

// DescribeGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroups for more information on using the DescribeGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupsRequest method.
//    req, resp := client.DescribeGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups
func (c *WorkDocs) DescribeGroupsRequest(input *DescribeGroupsInput) (req *request.Request, output *DescribeGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/groups",
	}

	if input == nil {
		input = &DescribeGroupsInput{}
	}

	output = &DescribeGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroups API operation for Amazon WorkDocs.
//
// Describes the groups specified by the query. Groups are defined by the underlying
// Active Directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeGroups for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeGroups
func (c *WorkDocs) DescribeGroups(input *DescribeGroupsInput) (*DescribeGroupsOutput, error) {
	req, out := c.DescribeGroupsRequest(input)
	return out, req.Send()
}

// DescribeGroupsWithContext is the same as DescribeGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeGroupsWithContext(ctx aws.Context, input *DescribeGroupsInput, opts ...request.Option) (*DescribeGroupsOutput, error) {
	req, out := c.DescribeGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotificationSubscriptions = "DescribeNotificationSubscriptions"

// DescribeNotificationSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotificationSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotificationSubscriptions for more information on using the DescribeNotificationSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotificationSubscriptionsRequest method.
//    req, resp := client.DescribeNotificationSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions
func (c *WorkDocs) DescribeNotificationSubscriptionsRequest(input *DescribeNotificationSubscriptionsInput) (req *request.Request, output *DescribeNotificationSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeNotificationSubscriptions,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/organizations/{OrganizationId}/subscriptions",
	}

	if input == nil {
		input = &DescribeNotificationSubscriptionsInput{}
	}

	output = &DescribeNotificationSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotificationSubscriptions API operation for Amazon WorkDocs.
//
// Lists the specified notification subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeNotificationSubscriptions for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeNotificationSubscriptions
func (c *WorkDocs) DescribeNotificationSubscriptions(input *DescribeNotificationSubscriptionsInput) (*DescribeNotificationSubscriptionsOutput, error) {
	req, out := c.DescribeNotificationSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeNotificationSubscriptionsWithContext is the same as DescribeNotificationSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotificationSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeNotificationSubscriptionsWithContext(ctx aws.Context, input *DescribeNotificationSubscriptionsInput, opts ...request.Option) (*DescribeNotificationSubscriptionsOutput, error) {
	req, out := c.DescribeNotificationSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourcePermissions = "DescribeResourcePermissions"

// DescribeResourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourcePermissions for more information on using the DescribeResourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourcePermissionsRequest method.
//    req, resp := client.DescribeResourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions
func (c *WorkDocs) DescribeResourcePermissionsRequest(input *DescribeResourcePermissionsInput) (req *request.Request, output *DescribeResourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeResourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/resources/{ResourceId}/permissions",
	}

	if input == nil {
		input = &DescribeResourcePermissionsInput{}
	}

	output = &DescribeResourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourcePermissions API operation for Amazon WorkDocs.
//
// Describes the permissions of a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeResourcePermissions for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeResourcePermissions
func (c *WorkDocs) DescribeResourcePermissions(input *DescribeResourcePermissionsInput) (*DescribeResourcePermissionsOutput, error) {
	req, out := c.DescribeResourcePermissionsRequest(input)
	return out, req.Send()
}

// DescribeResourcePermissionsWithContext is the same as DescribeResourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeResourcePermissionsWithContext(ctx aws.Context, input *DescribeResourcePermissionsInput, opts ...request.Option) (*DescribeResourcePermissionsOutput, error) {
	req, out := c.DescribeResourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRootFolders = "DescribeRootFolders"

// DescribeRootFoldersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRootFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRootFolders for more information on using the DescribeRootFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRootFoldersRequest method.
//    req, resp := client.DescribeRootFoldersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders
func (c *WorkDocs) DescribeRootFoldersRequest(input *DescribeRootFoldersInput) (req *request.Request, output *DescribeRootFoldersOutput) {
	op := &request.Operation{
		Name:       opDescribeRootFolders,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/me/root",
	}

	if input == nil {
		input = &DescribeRootFoldersInput{}
	}

	output = &DescribeRootFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRootFolders API operation for Amazon WorkDocs.
//
// Describes the current user's special folders; the RootFolder and the RecycleBin.
// RootFolder is the root of user's files and folders and RecycleBin is the
// root of recycled items. This is not a valid action for SigV4 (administrative
// API) clients.
//
// This action requires an authentication token. To get an authentication token,
// register an application with Amazon WorkDocs. For more information, see Authentication
// and Access Control for User Applications (https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html)
// in the Amazon WorkDocs Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeRootFolders for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeRootFolders
func (c *WorkDocs) DescribeRootFolders(input *DescribeRootFoldersInput) (*DescribeRootFoldersOutput, error) {
	req, out := c.DescribeRootFoldersRequest(input)
	return out, req.Send()
}

// DescribeRootFoldersWithContext is the same as DescribeRootFolders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRootFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeRootFoldersWithContext(ctx aws.Context, input *DescribeRootFoldersInput, opts ...request.Option) (*DescribeRootFoldersOutput, error) {
	req, out := c.DescribeRootFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUsers = "DescribeUsers"

// DescribeUsersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUsers for more information on using the DescribeUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUsersRequest method.
//    req, resp := client.DescribeUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers
func (c *WorkDocs) DescribeUsersRequest(input *DescribeUsersInput) (req *request.Request, output *DescribeUsersOutput) {
	op := &request.Operation{
		Name:       opDescribeUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeUsersInput{}
	}

	output = &DescribeUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUsers API operation for Amazon WorkDocs.
//
// Describes the specified users. You can describe all users or filter the results
// (for example, by status or organization).
//
// By default, Amazon WorkDocs returns the first 24 active or pending users.
// If there are more results, the response includes a marker that you can use
// to request the next set of results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation DescribeUsers for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * RequestedEntityTooLargeException
//   The response is too large to return. The request must include a filter to
//   reduce the size of the response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/DescribeUsers
func (c *WorkDocs) DescribeUsers(input *DescribeUsersInput) (*DescribeUsersOutput, error) {
	req, out := c.DescribeUsersRequest(input)
	return out, req.Send()
}

// DescribeUsersWithContext is the same as DescribeUsers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeUsersWithContext(ctx aws.Context, input *DescribeUsersInput, opts ...request.Option) (*DescribeUsersOutput, error) {
	req, out := c.DescribeUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeUsersPages iterates over the pages of a DescribeUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeUsers operation.
//    pageNum := 0
//    err := client.DescribeUsersPages(params,
//        func(page *workdocs.DescribeUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkDocs) DescribeUsersPages(input *DescribeUsersInput, fn func(*DescribeUsersOutput, bool) bool) error {
	return c.DescribeUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeUsersPagesWithContext same as DescribeUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) DescribeUsersPagesWithContext(ctx aws.Context, input *DescribeUsersInput, fn func(*DescribeUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCurrentUser = "GetCurrentUser"

// GetCurrentUserRequest generates a "aws/request.Request" representing the
// client's request for the GetCurrentUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCurrentUser for more information on using the GetCurrentUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCurrentUserRequest method.
//    req, resp := client.GetCurrentUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser
func (c *WorkDocs) GetCurrentUserRequest(input *GetCurrentUserInput) (req *request.Request, output *GetCurrentUserOutput) {
	op := &request.Operation{
		Name:       opGetCurrentUser,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/me",
	}

	if input == nil {
		input = &GetCurrentUserInput{}
	}

	output = &GetCurrentUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCurrentUser API operation for Amazon WorkDocs.
//
// Retrieves details of the current user for whom the authentication token was
// generated. This is not a valid action for SigV4 (administrative API) clients.
//
// This action requires an authentication token. To get an authentication token,
// register an application with Amazon WorkDocs. For more information, see Authentication
// and Access Control for User Applications (https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html)
// in the Amazon WorkDocs Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetCurrentUser for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetCurrentUser
func (c *WorkDocs) GetCurrentUser(input *GetCurrentUserInput) (*GetCurrentUserOutput, error) {
	req, out := c.GetCurrentUserRequest(input)
	return out, req.Send()
}

// GetCurrentUserWithContext is the same as GetCurrentUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetCurrentUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetCurrentUserWithContext(ctx aws.Context, input *GetCurrentUserInput, opts ...request.Option) (*GetCurrentUserOutput, error) {
	req, out := c.GetCurrentUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocument = "GetDocument"

// GetDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocument for more information on using the GetDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentRequest method.
//    req, resp := client.GetDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocument
func (c *WorkDocs) GetDocumentRequest(input *GetDocumentInput) (req *request.Request, output *GetDocumentOutput) {
	op := &request.Operation{
		Name:       opGetDocument,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/documents/{DocumentId}",
	}

	if input == nil {
		input = &GetDocumentInput{}
	}

	output = &GetDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocument API operation for Amazon WorkDocs.
//
// Retrieves details of a document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetDocument for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * InvalidPasswordException
//   The password is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocument
func (c *WorkDocs) GetDocument(input *GetDocumentInput) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	return out, req.Send()
}

// GetDocumentWithContext is the same as GetDocument with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetDocumentWithContext(ctx aws.Context, input *GetDocumentInput, opts ...request.Option) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentPath = "GetDocumentPath"

// GetDocumentPathRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentPath for more information on using the GetDocumentPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentPathRequest method.
//    req, resp := client.GetDocumentPathRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentPath
func (c *WorkDocs) GetDocumentPathRequest(input *GetDocumentPathInput) (req *request.Request, output *GetDocumentPathOutput) {
	op := &request.Operation{
		Name:       opGetDocumentPath,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/documents/{DocumentId}/path",
	}

	if input == nil {
		input = &GetDocumentPathInput{}
	}

	output = &GetDocumentPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentPath API operation for Amazon WorkDocs.
//
// Retrieves the path information (the hierarchy from the root folder) for the
// requested document.
//
// By default, Amazon WorkDocs returns a maximum of 100 levels upwards from
// the requested document and only includes the IDs of the parent folders in
// the path. You can limit the maximum number of levels. You can also request
// the names of the parent folders.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetDocumentPath for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentPath
func (c *WorkDocs) GetDocumentPath(input *GetDocumentPathInput) (*GetDocumentPathOutput, error) {
	req, out := c.GetDocumentPathRequest(input)
	return out, req.Send()
}

// GetDocumentPathWithContext is the same as GetDocumentPath with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetDocumentPathWithContext(ctx aws.Context, input *GetDocumentPathInput, opts ...request.Option) (*GetDocumentPathOutput, error) {
	req, out := c.GetDocumentPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentVersion = "GetDocumentVersion"

// GetDocumentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentVersion for more information on using the GetDocumentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentVersionRequest method.
//    req, resp := client.GetDocumentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentVersion
func (c *WorkDocs) GetDocumentVersionRequest(input *GetDocumentVersionInput) (req *request.Request, output *GetDocumentVersionOutput) {
	op := &request.Operation{
		Name:       opGetDocumentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}",
	}

	if input == nil {
		input = &GetDocumentVersionInput{}
	}

	output = &GetDocumentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentVersion API operation for Amazon WorkDocs.
//
// Retrieves version metadata for the specified document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetDocumentVersion for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * InvalidPasswordException
//   The password is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetDocumentVersion
func (c *WorkDocs) GetDocumentVersion(input *GetDocumentVersionInput) (*GetDocumentVersionOutput, error) {
	req, out := c.GetDocumentVersionRequest(input)
	return out, req.Send()
}

// GetDocumentVersionWithContext is the same as GetDocumentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetDocumentVersionWithContext(ctx aws.Context, input *GetDocumentVersionInput, opts ...request.Option) (*GetDocumentVersionOutput, error) {
	req, out := c.GetDocumentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFolder = "GetFolder"

// GetFolderRequest generates a "aws/request.Request" representing the
// client's request for the GetFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFolder for more information on using the GetFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFolderRequest method.
//    req, resp := client.GetFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolder
func (c *WorkDocs) GetFolderRequest(input *GetFolderInput) (req *request.Request, output *GetFolderOutput) {
	op := &request.Operation{
		Name:       opGetFolder,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/folders/{FolderId}",
	}

	if input == nil {
		input = &GetFolderInput{}
	}

	output = &GetFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFolder API operation for Amazon WorkDocs.
//
// Retrieves the metadata of the specified folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetFolder for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolder
func (c *WorkDocs) GetFolder(input *GetFolderInput) (*GetFolderOutput, error) {
	req, out := c.GetFolderRequest(input)
	return out, req.Send()
}

// GetFolderWithContext is the same as GetFolder with the addition of
// the ability to pass a context and additional request options.
//
// See GetFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetFolderWithContext(ctx aws.Context, input *GetFolderInput, opts ...request.Option) (*GetFolderOutput, error) {
	req, out := c.GetFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFolderPath = "GetFolderPath"

// GetFolderPathRequest generates a "aws/request.Request" representing the
// client's request for the GetFolderPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFolderPath for more information on using the GetFolderPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFolderPathRequest method.
//    req, resp := client.GetFolderPathRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolderPath
func (c *WorkDocs) GetFolderPathRequest(input *GetFolderPathInput) (req *request.Request, output *GetFolderPathOutput) {
	op := &request.Operation{
		Name:       opGetFolderPath,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/folders/{FolderId}/path",
	}

	if input == nil {
		input = &GetFolderPathInput{}
	}

	output = &GetFolderPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFolderPath API operation for Amazon WorkDocs.
//
// Retrieves the path information (the hierarchy from the root folder) for the
// specified folder.
//
// By default, Amazon WorkDocs returns a maximum of 100 levels upwards from
// the requested folder and only includes the IDs of the parent folders in the
// path. You can limit the maximum number of levels. You can also request the
// parent folder names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetFolderPath for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetFolderPath
func (c *WorkDocs) GetFolderPath(input *GetFolderPathInput) (*GetFolderPathOutput, error) {
	req, out := c.GetFolderPathRequest(input)
	return out, req.Send()
}

// GetFolderPathWithContext is the same as GetFolderPath with the addition of
// the ability to pass a context and additional request options.
//
// See GetFolderPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetFolderPathWithContext(ctx aws.Context, input *GetFolderPathInput, opts ...request.Option) (*GetFolderPathOutput, error) {
	req, out := c.GetFolderPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResources = "GetResources"

// GetResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResources for more information on using the GetResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcesRequest method.
//    req, resp := client.GetResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources
func (c *WorkDocs) GetResourcesRequest(input *GetResourcesInput) (req *request.Request, output *GetResourcesOutput) {
	op := &request.Operation{
		Name:       opGetResources,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/resources",
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	output = &GetResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResources API operation for Amazon WorkDocs.
//
// Retrieves a collection of resources, including folders and documents. The
// only CollectionType supported is SHARED_WITH_ME.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation GetResources for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources
func (c *WorkDocs) GetResources(input *GetResourcesInput) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	return out, req.Send()
}

// GetResourcesWithContext is the same as GetResources with the addition of
// the ability to pass a context and additional request options.
//
// See GetResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) GetResourcesWithContext(ctx aws.Context, input *GetResourcesInput, opts ...request.Option) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateDocumentVersionUpload = "InitiateDocumentVersionUpload"

// InitiateDocumentVersionUploadRequest generates a "aws/request.Request" representing the
// client's request for the InitiateDocumentVersionUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateDocumentVersionUpload for more information on using the InitiateDocumentVersionUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateDocumentVersionUploadRequest method.
//    req, resp := client.InitiateDocumentVersionUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload
func (c *WorkDocs) InitiateDocumentVersionUploadRequest(input *InitiateDocumentVersionUploadInput) (req *request.Request, output *InitiateDocumentVersionUploadOutput) {
	op := &request.Operation{
		Name:       opInitiateDocumentVersionUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/documents",
	}

	if input == nil {
		input = &InitiateDocumentVersionUploadInput{}
	}

	output = &InitiateDocumentVersionUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateDocumentVersionUpload API operation for Amazon WorkDocs.
//
// Creates a new document object and version object.
//
// The client specifies the parent folder ID and name of the document to upload.
// The ID is optionally specified when creating a new version of an existing
// document. This is the first step to upload a document. Next, upload the document
// to the URL returned from the call, and then call UpdateDocumentVersion.
//
// To cancel the document upload, call AbortDocumentVersionUpload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation InitiateDocumentVersionUpload for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * EntityAlreadyExistsException
//   The resource already exists.
//
//   * StorageLimitExceededException
//   The storage limit has been exceeded.
//
//   * StorageLimitWillExceedException
//   The storage limit will be exceeded.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * DraftUploadOutOfSyncException
//   This exception is thrown when a valid checkout ID is not presented on document
//   version upload calls for a document that has been checked out from Web client.
//
//   * ResourceAlreadyCheckedOutException
//   The resource is already checked out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload
func (c *WorkDocs) InitiateDocumentVersionUpload(input *InitiateDocumentVersionUploadInput) (*InitiateDocumentVersionUploadOutput, error) {
	req, out := c.InitiateDocumentVersionUploadRequest(input)
	return out, req.Send()
}

// InitiateDocumentVersionUploadWithContext is the same as InitiateDocumentVersionUpload with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateDocumentVersionUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) InitiateDocumentVersionUploadWithContext(ctx aws.Context, input *InitiateDocumentVersionUploadInput, opts ...request.Option) (*InitiateDocumentVersionUploadOutput, error) {
	req, out := c.InitiateDocumentVersionUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAllResourcePermissions = "RemoveAllResourcePermissions"

// RemoveAllResourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAllResourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAllResourcePermissions for more information on using the RemoveAllResourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAllResourcePermissionsRequest method.
//    req, resp := client.RemoveAllResourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveAllResourcePermissions
func (c *WorkDocs) RemoveAllResourcePermissionsRequest(input *RemoveAllResourcePermissionsInput) (req *request.Request, output *RemoveAllResourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opRemoveAllResourcePermissions,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/resources/{ResourceId}/permissions",
	}

	if input == nil {
		input = &RemoveAllResourcePermissionsInput{}
	}

	output = &RemoveAllResourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveAllResourcePermissions API operation for Amazon WorkDocs.
//
// Removes all the permissions from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation RemoveAllResourcePermissions for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveAllResourcePermissions
func (c *WorkDocs) RemoveAllResourcePermissions(input *RemoveAllResourcePermissionsInput) (*RemoveAllResourcePermissionsOutput, error) {
	req, out := c.RemoveAllResourcePermissionsRequest(input)
	return out, req.Send()
}

// RemoveAllResourcePermissionsWithContext is the same as RemoveAllResourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAllResourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) RemoveAllResourcePermissionsWithContext(ctx aws.Context, input *RemoveAllResourcePermissionsInput, opts ...request.Option) (*RemoveAllResourcePermissionsOutput, error) {
	req, out := c.RemoveAllResourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveResourcePermission = "RemoveResourcePermission"

// RemoveResourcePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveResourcePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveResourcePermission for more information on using the RemoveResourcePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveResourcePermissionRequest method.
//    req, resp := client.RemoveResourcePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveResourcePermission
func (c *WorkDocs) RemoveResourcePermissionRequest(input *RemoveResourcePermissionInput) (req *request.Request, output *RemoveResourcePermissionOutput) {
	op := &request.Operation{
		Name:       opRemoveResourcePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/api/v1/resources/{ResourceId}/permissions/{PrincipalId}",
	}

	if input == nil {
		input = &RemoveResourcePermissionInput{}
	}

	output = &RemoveResourcePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveResourcePermission API operation for Amazon WorkDocs.
//
// Removes the permission for the specified principal from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation RemoveResourcePermission for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/RemoveResourcePermission
func (c *WorkDocs) RemoveResourcePermission(input *RemoveResourcePermissionInput) (*RemoveResourcePermissionOutput, error) {
	req, out := c.RemoveResourcePermissionRequest(input)
	return out, req.Send()
}

// RemoveResourcePermissionWithContext is the same as RemoveResourcePermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveResourcePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) RemoveResourcePermissionWithContext(ctx aws.Context, input *RemoveResourcePermissionInput, opts ...request.Option) (*RemoveResourcePermissionOutput, error) {
	req, out := c.RemoveResourcePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocument = "UpdateDocument"

// UpdateDocumentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocument for more information on using the UpdateDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDocumentRequest method.
//    req, resp := client.UpdateDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument
func (c *WorkDocs) UpdateDocumentRequest(input *UpdateDocumentInput) (req *request.Request, output *UpdateDocumentOutput) {
	op := &request.Operation{
		Name:       opUpdateDocument,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/documents/{DocumentId}",
	}

	if input == nil {
		input = &UpdateDocumentInput{}
	}

	output = &UpdateDocumentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDocument API operation for Amazon WorkDocs.
//
// Updates the specified attributes of a document. The user must have access
// to both the document and its parent folder, if applicable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation UpdateDocument for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * EntityAlreadyExistsException
//   The resource already exists.
//
//   * LimitExceededException
//   The maximum of 100,000 folders under the parent folder has been exceeded.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConflictingOperationException
//   Another operation is in progress on the resource that conflicts with the
//   current operation.
//
//   * ConcurrentModificationException
//   The resource hierarchy is changing.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument
func (c *WorkDocs) UpdateDocument(input *UpdateDocumentInput) (*UpdateDocumentOutput, error) {
	req, out := c.UpdateDocumentRequest(input)
	return out, req.Send()
}

// UpdateDocumentWithContext is the same as UpdateDocument with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) UpdateDocumentWithContext(ctx aws.Context, input *UpdateDocumentInput, opts ...request.Option) (*UpdateDocumentOutput, error) {
	req, out := c.UpdateDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocumentVersion = "UpdateDocumentVersion"

// UpdateDocumentVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocumentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocumentVersion for more information on using the UpdateDocumentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDocumentVersionRequest method.
//    req, resp := client.UpdateDocumentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion
func (c *WorkDocs) UpdateDocumentVersionRequest(input *UpdateDocumentVersionInput) (req *request.Request, output *UpdateDocumentVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDocumentVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}",
	}

	if input == nil {
		input = &UpdateDocumentVersionInput{}
	}

	output = &UpdateDocumentVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDocumentVersion API operation for Amazon WorkDocs.
//
// Changes the status of the document version to ACTIVE.
//
// Amazon WorkDocs also sets its document container to ACTIVE. This is the last
// step in a document upload, after the client uploads the document to an S3-presigned
// URL returned by InitiateDocumentVersionUpload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation UpdateDocumentVersion for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConcurrentModificationException
//   The resource hierarchy is changing.
//
//   * InvalidOperationException
//   The operation is invalid.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion
func (c *WorkDocs) UpdateDocumentVersion(input *UpdateDocumentVersionInput) (*UpdateDocumentVersionOutput, error) {
	req, out := c.UpdateDocumentVersionRequest(input)
	return out, req.Send()
}

// UpdateDocumentVersionWithContext is the same as UpdateDocumentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocumentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) UpdateDocumentVersionWithContext(ctx aws.Context, input *UpdateDocumentVersionInput, opts ...request.Option) (*UpdateDocumentVersionOutput, error) {
	req, out := c.UpdateDocumentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolder = "UpdateFolder"

// UpdateFolderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolder for more information on using the UpdateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFolderRequest method.
//    req, resp := client.UpdateFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder
func (c *WorkDocs) UpdateFolderRequest(input *UpdateFolderInput) (req *request.Request, output *UpdateFolderOutput) {
	op := &request.Operation{
		Name:       opUpdateFolder,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/folders/{FolderId}",
	}

	if input == nil {
		input = &UpdateFolderInput{}
	}

	output = &UpdateFolderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFolder API operation for Amazon WorkDocs.
//
// Updates the specified attributes of the specified folder. The user must have
// access to both the folder and its parent folder, if applicable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation UpdateFolder for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * EntityAlreadyExistsException
//   The resource already exists.
//
//   * ProhibitedStateException
//   The specified document version is not in the INITIALIZED state.
//
//   * ConflictingOperationException
//   Another operation is in progress on the resource that conflicts with the
//   current operation.
//
//   * ConcurrentModificationException
//   The resource hierarchy is changing.
//
//   * LimitExceededException
//   The maximum of 100,000 folders under the parent folder has been exceeded.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder
func (c *WorkDocs) UpdateFolder(input *UpdateFolderInput) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	return out, req.Send()
}

// UpdateFolderWithContext is the same as UpdateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) UpdateFolderWithContext(ctx aws.Context, input *UpdateFolderInput, opts ...request.Option) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateUser
func (c *WorkDocs) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/users/{UserId}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon WorkDocs.
//
// Updates the specified attributes of the specified user, and grants or revokes
// administrative privileges to the Amazon WorkDocs site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkDocs's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//   * EntityNotExistsException
//   The resource does not exist.
//
//   * UnauthorizedOperationException
//   The operation is not permitted.
//
//   * UnauthorizedResourceAccessException
//   The caller does not have access to perform the action on the resource.
//
//   * IllegalUserStateException
//   The user is undergoing transfer of ownership.
//
//   * FailedDependencyException
//   The AWS Directory Service cannot reach an on-premises instance. Or a dependency
//   under the control of the organization is failing, such as a connected Active
//   Directory.
//
//   * ServiceUnavailableException
//   One or more of the dependencies is unavailable.
//
//   * DeactivatingLastSystemUserException
//   The last user in the organization is being deactivated.
//
//   * InvalidArgumentException
//   The pagination marker or limit fields are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateUser
func (c *WorkDocs) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkDocs) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AbortDocumentVersionUploadInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The ID of the version.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortDocumentVersionUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortDocumentVersionUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortDocumentVersionUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortDocumentVersionUploadInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *AbortDocumentVersionUploadInput) SetAuthenticationToken(v string) *AbortDocumentVersionUploadInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *AbortDocumentVersionUploadInput) SetDocumentId(v string) *AbortDocumentVersionUploadInput {
	s.DocumentId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *AbortDocumentVersionUploadInput) SetVersionId(v string) *AbortDocumentVersionUploadInput {
	s.VersionId = &v
	return s
}

type AbortDocumentVersionUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortDocumentVersionUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortDocumentVersionUploadOutput) GoString() string {
	return s.String()
}

type ActivateUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *ActivateUserInput) SetAuthenticationToken(v string) *ActivateUserInput {
	s.AuthenticationToken = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ActivateUserInput) SetUserId(v string) *ActivateUserInput {
	s.UserId = &v
	return s
}

type ActivateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user information.
	User *User `type:"structure"`
}

// String returns the string representation
func (s ActivateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *ActivateUserOutput) SetUser(v *User) *ActivateUserOutput {
	s.User = v
	return s
}

// Describes the activity information.
type Activity struct {
	_ struct{} `type:"structure"`

	// Metadata of the commenting activity. This is an optional field and is filled
	// for commenting activities.
	CommentMetadata *CommentMetadata `type:"structure"`

	// The user who performed the action.
	Initiator *UserMetadata `type:"structure"`

	// Indicates whether an activity is indirect or direct. An indirect activity
	// results from a direct activity performed on a parent resource. For example,
	// sharing a parent folder (the direct activity) shares all of the subfolders
	// and documents within the parent folder (the indirect activity).
	IsIndirectActivity *bool `type:"boolean"`

	// The ID of the organization.
	OrganizationId *string `min:"1" type:"string"`

	// The original parent of the resource. This is an optional field and is filled
	// for move activities.
	OriginalParent *ResourceMetadata `type:"structure"`

	// The list of users or groups impacted by this action. This is an optional
	// field and is filled for the following sharing activities: DOCUMENT_SHARED,
	// DOCUMENT_SHARED, DOCUMENT_UNSHARED, FOLDER_SHARED, FOLDER_UNSHARED.
	Participants *Participants `type:"structure"`

	// The metadata of the resource involved in the user action.
	ResourceMetadata *ResourceMetadata `type:"structure"`

	// The timestamp when the action was performed.
	TimeStamp *time.Time `type:"timestamp"`

	// The activity type.
	Type *string `type:"string" enum:"ActivityType"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Activity) GoString() string {
	return s.String()
}

// SetCommentMetadata sets the CommentMetadata field's value.
func (s *Activity) SetCommentMetadata(v *CommentMetadata) *Activity {
	s.CommentMetadata = v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *Activity) SetInitiator(v *UserMetadata) *Activity {
	s.Initiator = v
	return s
}

// SetIsIndirectActivity sets the IsIndirectActivity field's value.
func (s *Activity) SetIsIndirectActivity(v bool) *Activity {
	s.IsIndirectActivity = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *Activity) SetOrganizationId(v string) *Activity {
	s.OrganizationId = &v
	return s
}

// SetOriginalParent sets the OriginalParent field's value.
func (s *Activity) SetOriginalParent(v *ResourceMetadata) *Activity {
	s.OriginalParent = v
	return s
}

// SetParticipants sets the Participants field's value.
func (s *Activity) SetParticipants(v *Participants) *Activity {
	s.Participants = v
	return s
}

// SetResourceMetadata sets the ResourceMetadata field's value.
func (s *Activity) SetResourceMetadata(v *ResourceMetadata) *Activity {
	s.ResourceMetadata = v
	return s
}

// SetTimeStamp sets the TimeStamp field's value.
func (s *Activity) SetTimeStamp(v time.Time) *Activity {
	s.TimeStamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *Activity) SetType(v string) *Activity {
	s.Type = &v
	return s
}

type AddResourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The notification options.
	NotificationOptions *NotificationOptions `type:"structure"`

	// The users, groups, or organization being granted permission.
	//
	// Principals is a required field
	Principals []*SharePrincipal `type:"list" required:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddResourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddResourcePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddResourcePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddResourcePermissionsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Principals == nil {
		invalidParams.Add(request.NewErrParamRequired("Principals"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Principals != nil {
		for i, v := range s.Principals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Principals", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *AddResourcePermissionsInput) SetAuthenticationToken(v string) *AddResourcePermissionsInput {
	s.AuthenticationToken = &v
	return s
}

// SetNotificationOptions sets the NotificationOptions field's value.
func (s *AddResourcePermissionsInput) SetNotificationOptions(v *NotificationOptions) *AddResourcePermissionsInput {
	s.NotificationOptions = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *AddResourcePermissionsInput) SetPrincipals(v []*SharePrincipal) *AddResourcePermissionsInput {
	s.Principals = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AddResourcePermissionsInput) SetResourceId(v string) *AddResourcePermissionsInput {
	s.ResourceId = &v
	return s
}

type AddResourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The share results.
	ShareResults []*ShareResult `type:"list"`
}

// String returns the string representation
func (s AddResourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddResourcePermissionsOutput) GoString() string {
	return s.String()
}

// SetShareResults sets the ShareResults field's value.
func (s *AddResourcePermissionsOutput) SetShareResults(v []*ShareResult) *AddResourcePermissionsOutput {
	s.ShareResults = v
	return s
}

// Describes a comment.
type Comment struct {
	_ struct{} `type:"structure"`

	// The ID of the comment.
	//
	// CommentId is a required field
	CommentId *string `min:"1" type:"string" required:"true"`

	// The details of the user who made the comment.
	Contributor *User `type:"structure"`

	// The time that the comment was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the parent comment.
	ParentId *string `min:"1" type:"string"`

	// If the comment is a reply to another user's comment, this field contains
	// the user ID of the user being replied to.
	RecipientId *string `min:"1" type:"string"`

	// The status of the comment.
	Status *string `type:"string" enum:"CommentStatusType"`

	// The text of the comment.
	Text *string `min:"1" type:"string" sensitive:"true"`

	// The ID of the root comment in the thread.
	ThreadId *string `min:"1" type:"string"`

	// The visibility of the comment. Options are either PRIVATE, where the comment
	// is visible only to the comment author and document owner and co-owners, or
	// PUBLIC, where the comment is visible to document owners, co-owners, and contributors.
	Visibility *string `type:"string" enum:"CommentVisibilityType"`
}

// String returns the string representation
func (s Comment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Comment) GoString() string {
	return s.String()
}

// SetCommentId sets the CommentId field's value.
func (s *Comment) SetCommentId(v string) *Comment {
	s.CommentId = &v
	return s
}

// SetContributor sets the Contributor field's value.
func (s *Comment) SetContributor(v *User) *Comment {
	s.Contributor = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Comment) SetCreatedTimestamp(v time.Time) *Comment {
	s.CreatedTimestamp = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *Comment) SetParentId(v string) *Comment {
	s.ParentId = &v
	return s
}

// SetRecipientId sets the RecipientId field's value.
func (s *Comment) SetRecipientId(v string) *Comment {
	s.RecipientId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Comment) SetStatus(v string) *Comment {
	s.Status = &v
	return s
}

// SetText sets the Text field's value.
func (s *Comment) SetText(v string) *Comment {
	s.Text = &v
	return s
}

// SetThreadId sets the ThreadId field's value.
func (s *Comment) SetThreadId(v string) *Comment {
	s.ThreadId = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *Comment) SetVisibility(v string) *Comment {
	s.Visibility = &v
	return s
}

// Describes the metadata of a comment.
type CommentMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the comment.
	CommentId *string `min:"1" type:"string"`

	// The status of the comment.
	CommentStatus *string `type:"string" enum:"CommentStatusType"`

	// The user who made the comment.
	Contributor *User `type:"structure"`

	// The timestamp that the comment was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the user being replied to.
	RecipientId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CommentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommentMetadata) GoString() string {
	return s.String()
}

// SetCommentId sets the CommentId field's value.
func (s *CommentMetadata) SetCommentId(v string) *CommentMetadata {
	s.CommentId = &v
	return s
}

// SetCommentStatus sets the CommentStatus field's value.
func (s *CommentMetadata) SetCommentStatus(v string) *CommentMetadata {
	s.CommentStatus = &v
	return s
}

// SetContributor sets the Contributor field's value.
func (s *CommentMetadata) SetContributor(v *User) *CommentMetadata {
	s.Contributor = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CommentMetadata) SetCreatedTimestamp(v time.Time) *CommentMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetRecipientId sets the RecipientId field's value.
func (s *CommentMetadata) SetRecipientId(v string) *CommentMetadata {
	s.RecipientId = &v
	return s
}

// The resource hierarchy is changing.
type ConcurrentModificationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConcurrentModificationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConcurrentModificationException) RequestID() string {
	return s.respMetadata.RequestID
}

// Another operation is in progress on the resource that conflicts with the
// current operation.
type ConflictingOperationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictingOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictingOperationException) GoString() string {
	return s.String()
}

func newErrorConflictingOperationException(v protocol.ResponseMetadata) error {
	return &ConflictingOperationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConflictingOperationException) Code() string {
	return "ConflictingOperationException"
}

// Message returns the exception's message.
func (s ConflictingOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConflictingOperationException) OrigErr() error {
	return nil
}

func (s ConflictingOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConflictingOperationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConflictingOperationException) RequestID() string {
	return s.respMetadata.RequestID
}

type CreateCommentInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// Set this parameter to TRUE to send an email out to the document collaborators
	// after the comment is created.
	NotifyCollaborators *bool `type:"boolean"`

	// The ID of the parent comment.
	ParentId *string `min:"1" type:"string"`

	// The text of the comment.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the root comment in the thread.
	ThreadId *string `min:"1" type:"string"`

	// The ID of the document version.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`

	// The visibility of the comment. Options are either PRIVATE, where the comment
	// is visible only to the comment author and document owner and co-owners, or
	// PUBLIC, where the comment is visible to document owners, co-owners, and contributors.
	Visibility *string `type:"string" enum:"CommentVisibilityType"`
}

// String returns the string representation
func (s CreateCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCommentInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.ParentId != nil && len(*s.ParentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentId", 1))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.ThreadId != nil && len(*s.ThreadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThreadId", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *CreateCommentInput) SetAuthenticationToken(v string) *CreateCommentInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *CreateCommentInput) SetDocumentId(v string) *CreateCommentInput {
	s.DocumentId = &v
	return s
}

// SetNotifyCollaborators sets the NotifyCollaborators field's value.
func (s *CreateCommentInput) SetNotifyCollaborators(v bool) *CreateCommentInput {
	s.NotifyCollaborators = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *CreateCommentInput) SetParentId(v string) *CreateCommentInput {
	s.ParentId = &v
	return s
}

// SetText sets the Text field's value.
func (s *CreateCommentInput) SetText(v string) *CreateCommentInput {
	s.Text = &v
	return s
}

// SetThreadId sets the ThreadId field's value.
func (s *CreateCommentInput) SetThreadId(v string) *CreateCommentInput {
	s.ThreadId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateCommentInput) SetVersionId(v string) *CreateCommentInput {
	s.VersionId = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *CreateCommentInput) SetVisibility(v string) *CreateCommentInput {
	s.Visibility = &v
	return s
}

type CreateCommentOutput struct {
	_ struct{} `type:"structure"`

	// The comment that has been created.
	Comment *Comment `type:"structure"`
}

// String returns the string representation
func (s CreateCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCommentOutput) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *CreateCommentOutput) SetComment(v *Comment) *CreateCommentOutput {
	s.Comment = v
	return s
}

type CreateCustomMetadataInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// Custom metadata in the form of name-value pairs.
	//
	// CustomMetadata is a required field
	CustomMetadata map[string]*string `min:"1" type:"map" required:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`

	// The ID of the version, if the custom metadata is being added to a document
	// version.
	VersionId *string `location:"querystring" locationName:"versionid" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCustomMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomMetadataInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.CustomMetadata == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomMetadata"))
	}
	if s.CustomMetadata != nil && len(s.CustomMetadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomMetadata", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *CreateCustomMetadataInput) SetAuthenticationToken(v string) *CreateCustomMetadataInput {
	s.AuthenticationToken = &v
	return s
}

// SetCustomMetadata sets the CustomMetadata field's value.
func (s *CreateCustomMetadataInput) SetCustomMetadata(v map[string]*string) *CreateCustomMetadataInput {
	s.CustomMetadata = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateCustomMetadataInput) SetResourceId(v string) *CreateCustomMetadataInput {
	s.ResourceId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateCustomMetadataInput) SetVersionId(v string) *CreateCustomMetadataInput {
	s.VersionId = &v
	return s
}

type CreateCustomMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateCustomMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomMetadataOutput) GoString() string {
	return s.String()
}

type CreateFolderInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The name of the new folder.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	//
	// ParentFolderId is a required field
	ParentFolderId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFolderInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParentFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentFolderId"))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *CreateFolderInput) SetAuthenticationToken(v string) *CreateFolderInput {
	s.AuthenticationToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFolderInput) SetName(v string) *CreateFolderInput {
	s.Name = &v
	return s
}

// SetParentFolderId sets the ParentFolderId field's value.
func (s *CreateFolderInput) SetParentFolderId(v string) *CreateFolderInput {
	s.ParentFolderId = &v
	return s
}

type CreateFolderOutput struct {
	_ struct{} `type:"structure"`

	// The metadata of the folder.
	Metadata *FolderMetadata `type:"structure"`
}

// String returns the string representation
func (s CreateFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFolderOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *CreateFolderOutput) SetMetadata(v *FolderMetadata) *CreateFolderOutput {
	s.Metadata = v
	return s
}

type CreateLabelsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// List of labels to add to the resource.
	//
	// Labels is a required field
	Labels []*string `type:"list" required:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLabelsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Labels == nil {
		invalidParams.Add(request.NewErrParamRequired("Labels"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *CreateLabelsInput) SetAuthenticationToken(v string) *CreateLabelsInput {
	s.AuthenticationToken = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *CreateLabelsInput) SetLabels(v []*string) *CreateLabelsInput {
	s.Labels = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateLabelsInput) SetResourceId(v string) *CreateLabelsInput {
	s.ResourceId = &v
	return s
}

type CreateLabelsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLabelsOutput) GoString() string {
	return s.String()
}

type CreateNotificationSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The endpoint to receive the notifications. If the protocol is HTTPS, the
	// endpoint is a URL that begins with https.
	//
	// Endpoint is a required field
	Endpoint *string `min:"1" type:"string" required:"true"`

	// The ID of the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `location:"uri" locationName:"OrganizationId" min:"1" type:"string" required:"true"`

	// The protocol to use. The supported value is https, which delivers JSON-encoded
	// messages using HTTPS POST.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"SubscriptionProtocolType"`

	// The notification type.
	//
	// SubscriptionType is a required field
	SubscriptionType *string `type:"string" required:"true" enum:"SubscriptionType"`
}

// String returns the string representation
func (s CreateNotificationSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotificationSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotificationSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotificationSubscriptionInput"}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.Endpoint != nil && len(*s.Endpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Endpoint", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.SubscriptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateNotificationSubscriptionInput) SetEndpoint(v string) *CreateNotificationSubscriptionInput {
	s.Endpoint = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateNotificationSubscriptionInput) SetOrganizationId(v string) *CreateNotificationSubscriptionInput {
	s.OrganizationId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateNotificationSubscriptionInput) SetProtocol(v string) *CreateNotificationSubscriptionInput {
	s.Protocol = &v
	return s
}

// SetSubscriptionType sets the SubscriptionType field's value.
func (s *CreateNotificationSubscriptionInput) SetSubscriptionType(v string) *CreateNotificationSubscriptionInput {
	s.SubscriptionType = &v
	return s
}

type CreateNotificationSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The subscription.
	Subscription *Subscription `type:"structure"`
}

// String returns the string representation
func (s CreateNotificationSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotificationSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscription sets the Subscription field's value.
func (s *CreateNotificationSubscriptionOutput) SetSubscription(v *Subscription) *CreateNotificationSubscriptionOutput {
	s.Subscription = v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The email address of the user.
	EmailAddress *string `min:"1" type:"string"`

	// The given name of the user.
	//
	// GivenName is a required field
	GivenName *string `min:"1" type:"string" required:"true"`

	// The ID of the organization.
	OrganizationId *string `min:"1" type:"string"`

	// The password of the user.
	//
	// Password is a required field
	Password *string `min:"4" type:"string" required:"true" sensitive:"true"`

	// The amount of storage for the user.
	StorageRule *StorageRuleType `type:"structure"`

	// The surname of the user.
	//
	// Surname is a required field
	Surname *string `min:"1" type:"string" required:"true"`

	// The time zone ID of the user.
	TimeZoneId *string `min:"1" type:"string"`

	// The login name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}
	if s.GivenName == nil {
		invalidParams.Add(request.NewErrParamRequired("GivenName"))
	}
	if s.GivenName != nil && len(*s.GivenName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GivenName", 1))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 4))
	}
	if s.Surname == nil {
		invalidParams.Add(request.NewErrParamRequired("Surname"))
	}
	if s.Surname != nil && len(*s.Surname) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Surname", 1))
	}
	if s.TimeZoneId != nil && len(*s.TimeZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZoneId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *CreateUserInput) SetAuthenticationToken(v string) *CreateUserInput {
	s.AuthenticationToken = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateUserInput) SetEmailAddress(v string) *CreateUserInput {
	s.EmailAddress = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *CreateUserInput) SetGivenName(v string) *CreateUserInput {
	s.GivenName = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateUserInput) SetOrganizationId(v string) *CreateUserInput {
	s.OrganizationId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserInput) SetPassword(v string) *CreateUserInput {
	s.Password = &v
	return s
}

// SetStorageRule sets the StorageRule field's value.
func (s *CreateUserInput) SetStorageRule(v *StorageRuleType) *CreateUserInput {
	s.StorageRule = v
	return s
}

// SetSurname sets the Surname field's value.
func (s *CreateUserInput) SetSurname(v string) *CreateUserInput {
	s.Surname = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *CreateUserInput) SetTimeZoneId(v string) *CreateUserInput {
	s.TimeZoneId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateUserInput) SetUsername(v string) *CreateUserInput {
	s.Username = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user information.
	User *User `type:"structure"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *CreateUserOutput) SetUser(v *User) *CreateUserOutput {
	s.User = v
	return s
}

// The limit has been reached on the number of custom properties for the specified
// resource.
type CustomMetadataLimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s CustomMetadataLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomMetadataLimitExceededException) GoString() string {
	return s.String()
}

func newErrorCustomMetadataLimitExceededException(v protocol.ResponseMetadata) error {
	return &CustomMetadataLimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s CustomMetadataLimitExceededException) Code() string {
	return "CustomMetadataLimitExceededException"
}

// Message returns the exception's message.
func (s CustomMetadataLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s CustomMetadataLimitExceededException) OrigErr() error {
	return nil
}

func (s CustomMetadataLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s CustomMetadataLimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s CustomMetadataLimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type DeactivateUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeactivateUserInput) SetAuthenticationToken(v string) *DeactivateUserInput {
	s.AuthenticationToken = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeactivateUserInput) SetUserId(v string) *DeactivateUserInput {
	s.UserId = &v
	return s
}

type DeactivateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeactivateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateUserOutput) GoString() string {
	return s.String()
}

// The last user in the organization is being deactivated.
type DeactivatingLastSystemUserException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DeactivatingLastSystemUserException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivatingLastSystemUserException) GoString() string {
	return s.String()
}

func newErrorDeactivatingLastSystemUserException(v protocol.ResponseMetadata) error {
	return &DeactivatingLastSystemUserException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s DeactivatingLastSystemUserException) Code() string {
	return "DeactivatingLastSystemUserException"
}

// Message returns the exception's message.
func (s DeactivatingLastSystemUserException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s DeactivatingLastSystemUserException) OrigErr() error {
	return nil
}

func (s DeactivatingLastSystemUserException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s DeactivatingLastSystemUserException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s DeactivatingLastSystemUserException) RequestID() string {
	return s.respMetadata.RequestID
}

type DeleteCommentInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the comment.
	//
	// CommentId is a required field
	CommentId *string `location:"uri" locationName:"CommentId" min:"1" type:"string" required:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The ID of the document version.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCommentInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.CommentId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommentId"))
	}
	if s.CommentId != nil && len(*s.CommentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CommentId", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteCommentInput) SetAuthenticationToken(v string) *DeleteCommentInput {
	s.AuthenticationToken = &v
	return s
}

// SetCommentId sets the CommentId field's value.
func (s *DeleteCommentInput) SetCommentId(v string) *DeleteCommentInput {
	s.CommentId = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *DeleteCommentInput) SetDocumentId(v string) *DeleteCommentInput {
	s.DocumentId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteCommentInput) SetVersionId(v string) *DeleteCommentInput {
	s.VersionId = &v
	return s
}

type DeleteCommentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCommentOutput) GoString() string {
	return s.String()
}

type DeleteCustomMetadataInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// Flag to indicate removal of all custom metadata properties from the specified
	// resource.
	DeleteAll *bool `location:"querystring" locationName:"deleteAll" type:"boolean"`

	// List of properties to remove.
	Keys []*string `location:"querystring" locationName:"keys" type:"list"`

	// The ID of the resource, either a document or folder.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`

	// The ID of the version, if the custom metadata is being deleted from a document
	// version.
	VersionId *string `location:"querystring" locationName:"versionId" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteCustomMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomMetadataInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteCustomMetadataInput) SetAuthenticationToken(v string) *DeleteCustomMetadataInput {
	s.AuthenticationToken = &v
	return s
}

// SetDeleteAll sets the DeleteAll field's value.
func (s *DeleteCustomMetadataInput) SetDeleteAll(v bool) *DeleteCustomMetadataInput {
	s.DeleteAll = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *DeleteCustomMetadataInput) SetKeys(v []*string) *DeleteCustomMetadataInput {
	s.Keys = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteCustomMetadataInput) SetResourceId(v string) *DeleteCustomMetadataInput {
	s.ResourceId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteCustomMetadataInput) SetVersionId(v string) *DeleteCustomMetadataInput {
	s.VersionId = &v
	return s
}

type DeleteCustomMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomMetadataOutput) GoString() string {
	return s.String()
}

type DeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteDocumentInput) SetAuthenticationToken(v string) *DeleteDocumentInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *DeleteDocumentInput) SetDocumentId(v string) *DeleteDocumentInput {
	s.DocumentId = &v
	return s
}

type DeleteDocumentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentOutput) GoString() string {
	return s.String()
}

type DeleteFolderContentsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFolderContentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFolderContentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFolderContentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFolderContentsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteFolderContentsInput) SetAuthenticationToken(v string) *DeleteFolderContentsInput {
	s.AuthenticationToken = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DeleteFolderContentsInput) SetFolderId(v string) *DeleteFolderContentsInput {
	s.FolderId = &v
	return s
}

type DeleteFolderContentsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFolderContentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFolderContentsOutput) GoString() string {
	return s.String()
}

type DeleteFolderInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFolderInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteFolderInput) SetAuthenticationToken(v string) *DeleteFolderInput {
	s.AuthenticationToken = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DeleteFolderInput) SetFolderId(v string) *DeleteFolderInput {
	s.FolderId = &v
	return s
}

type DeleteFolderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFolderOutput) GoString() string {
	return s.String()
}

type DeleteLabelsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// Flag to request removal of all labels from the specified resource.
	DeleteAll *bool `location:"querystring" locationName:"deleteAll" type:"boolean"`

	// List of labels to delete from the resource.
	Labels []*string `location:"querystring" locationName:"labels" type:"list"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLabelsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteLabelsInput) SetAuthenticationToken(v string) *DeleteLabelsInput {
	s.AuthenticationToken = &v
	return s
}

// SetDeleteAll sets the DeleteAll field's value.
func (s *DeleteLabelsInput) SetDeleteAll(v bool) *DeleteLabelsInput {
	s.DeleteAll = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *DeleteLabelsInput) SetLabels(v []*string) *DeleteLabelsInput {
	s.Labels = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteLabelsInput) SetResourceId(v string) *DeleteLabelsInput {
	s.ResourceId = &v
	return s
}

type DeleteLabelsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLabelsOutput) GoString() string {
	return s.String()
}

type DeleteNotificationSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `location:"uri" locationName:"OrganizationId" min:"1" type:"string" required:"true"`

	// The ID of the subscription.
	//
	// SubscriptionId is a required field
	SubscriptionId *string `location:"uri" locationName:"SubscriptionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotificationSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotificationSubscriptionInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}
	if s.SubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionId"))
	}
	if s.SubscriptionId != nil && len(*s.SubscriptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteNotificationSubscriptionInput) SetOrganizationId(v string) *DeleteNotificationSubscriptionInput {
	s.OrganizationId = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *DeleteNotificationSubscriptionInput) SetSubscriptionId(v string) *DeleteNotificationSubscriptionInput {
	s.SubscriptionId = &v
	return s
}

type DeleteNotificationSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Do not set this field when using administrative
	// API actions, as in accessing the API using AWS credentials.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DeleteUserInput) SetAuthenticationToken(v string) *DeleteUserInput {
	s.AuthenticationToken = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeActivitiesInput struct {
	_ struct{} `type:"structure"`

	// Specifies which activity types to include in the response. If this field
	// is left empty, all activity types are returned.
	ActivityTypes *string `location:"querystring" locationName:"activityTypes" min:"1" type:"string"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The timestamp that determines the end time of the activities. The response
	// includes the activities performed before the specified timestamp.
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp"`

	// Includes indirect activities. An indirect activity results from a direct
	// activity performed on a parent resource. For example, sharing a parent folder
	// (the direct activity) shares all of the subfolders and documents within the
	// parent folder (the indirect activity).
	IncludeIndirectActivities *bool `location:"querystring" locationName:"includeIndirectActivities" type:"boolean"`

	// The maximum number of items to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the organization. This is a mandatory parameter when using administrative
	// API (SigV4) requests.
	OrganizationId *string `location:"querystring" locationName:"organizationId" min:"1" type:"string"`

	// The document or folder ID for which to describe activity types.
	ResourceId *string `location:"querystring" locationName:"resourceId" min:"1" type:"string"`

	// The timestamp that determines the starting time of the activities. The response
	// includes the activities performed after the specified timestamp.
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp"`

	// The ID of the user who performed the action. The response includes activities
	// pertaining to this user. This is an optional parameter and is only applicable
	// for administrative API (SigV4) requests.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActivitiesInput"}
	if s.ActivityTypes != nil && len(*s.ActivityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityTypes", 1))
	}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityTypes sets the ActivityTypes field's value.
func (s *DescribeActivitiesInput) SetActivityTypes(v string) *DescribeActivitiesInput {
	s.ActivityTypes = &v
	return s
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeActivitiesInput) SetAuthenticationToken(v string) *DescribeActivitiesInput {
	s.AuthenticationToken = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeActivitiesInput) SetEndTime(v time.Time) *DescribeActivitiesInput {
	s.EndTime = &v
	return s
}

// SetIncludeIndirectActivities sets the IncludeIndirectActivities field's value.
func (s *DescribeActivitiesInput) SetIncludeIndirectActivities(v bool) *DescribeActivitiesInput {
	s.IncludeIndirectActivities = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeActivitiesInput) SetLimit(v int64) *DescribeActivitiesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeActivitiesInput) SetMarker(v string) *DescribeActivitiesInput {
	s.Marker = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeActivitiesInput) SetOrganizationId(v string) *DescribeActivitiesInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeActivitiesInput) SetResourceId(v string) *DescribeActivitiesInput {
	s.ResourceId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeActivitiesInput) SetStartTime(v time.Time) *DescribeActivitiesInput {
	s.StartTime = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeActivitiesInput) SetUserId(v string) *DescribeActivitiesInput {
	s.UserId = &v
	return s
}

type DescribeActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results.
	Marker *string `min:"1" type:"string"`

	// The list of activities for the specified user and time period.
	UserActivities []*Activity `type:"list"`
}

// String returns the string representation
func (s DescribeActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivitiesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeActivitiesOutput) SetMarker(v string) *DescribeActivitiesOutput {
	s.Marker = &v
	return s
}

// SetUserActivities sets the UserActivities field's value.
func (s *DescribeActivitiesOutput) SetUserActivities(v []*Activity) *DescribeActivitiesOutput {
	s.UserActivities = v
	return s
}

type DescribeCommentsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The maximum number of items to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. This marker was received from a previous
	// call.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the document version.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCommentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCommentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCommentsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeCommentsInput) SetAuthenticationToken(v string) *DescribeCommentsInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *DescribeCommentsInput) SetDocumentId(v string) *DescribeCommentsInput {
	s.DocumentId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeCommentsInput) SetLimit(v int64) *DescribeCommentsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCommentsInput) SetMarker(v string) *DescribeCommentsInput {
	s.Marker = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DescribeCommentsInput) SetVersionId(v string) *DescribeCommentsInput {
	s.VersionId = &v
	return s
}

type DescribeCommentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of comments for the specified document version.
	Comments []*Comment `type:"list"`

	// The marker for the next set of results. This marker was received from a previous
	// call.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeCommentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommentsOutput) GoString() string {
	return s.String()
}

// SetComments sets the Comments field's value.
func (s *DescribeCommentsOutput) SetComments(v []*Comment) *DescribeCommentsOutput {
	s.Comments = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCommentsOutput) SetMarker(v string) *DescribeCommentsOutput {
	s.Marker = &v
	return s
}

type DescribeDocumentVersionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// Specify "SOURCE" to include initialized versions and a URL for the source
	// document.
	Fields *string `location:"querystring" locationName:"fields" min:"1" type:"string"`

	// A comma-separated list of values. Specify "INITIALIZED" to include incomplete
	// versions.
	Include *string `location:"querystring" locationName:"include" min:"1" type:"string"`

	// The maximum number of versions to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDocumentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentVersionsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Fields != nil && len(*s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.Include != nil && len(*s.Include) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Include", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeDocumentVersionsInput) SetAuthenticationToken(v string) *DescribeDocumentVersionsInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *DescribeDocumentVersionsInput) SetDocumentId(v string) *DescribeDocumentVersionsInput {
	s.DocumentId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *DescribeDocumentVersionsInput) SetFields(v string) *DescribeDocumentVersionsInput {
	s.Fields = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeDocumentVersionsInput) SetInclude(v string) *DescribeDocumentVersionsInput {
	s.Include = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeDocumentVersionsInput) SetLimit(v int64) *DescribeDocumentVersionsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDocumentVersionsInput) SetMarker(v string) *DescribeDocumentVersionsInput {
	s.Marker = &v
	return s
}

type DescribeDocumentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The document versions.
	DocumentVersions []*DocumentVersionMetadata `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDocumentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentVersionsOutput) GoString() string {
	return s.String()
}

// SetDocumentVersions sets the DocumentVersions field's value.
func (s *DescribeDocumentVersionsOutput) SetDocumentVersions(v []*DocumentVersionMetadata) *DescribeDocumentVersionsOutput {
	s.DocumentVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDocumentVersionsOutput) SetMarker(v string) *DescribeDocumentVersionsOutput {
	s.Marker = &v
	return s
}

type DescribeFolderContentsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The contents to include. Specify "INITIALIZED" to include initialized documents.
	Include *string `location:"querystring" locationName:"include" min:"1" type:"string"`

	// The maximum number of items to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. This marker was received from a previous
	// call.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The order for the contents of the folder.
	Order *string `location:"querystring" locationName:"order" type:"string" enum:"OrderType"`

	// The sorting criteria.
	Sort *string `location:"querystring" locationName:"sort" type:"string" enum:"ResourceSortType"`

	// The type of items.
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"FolderContentType"`
}

// String returns the string representation
func (s DescribeFolderContentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFolderContentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFolderContentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFolderContentsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.Include != nil && len(*s.Include) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Include", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeFolderContentsInput) SetAuthenticationToken(v string) *DescribeFolderContentsInput {
	s.AuthenticationToken = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DescribeFolderContentsInput) SetFolderId(v string) *DescribeFolderContentsInput {
	s.FolderId = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeFolderContentsInput) SetInclude(v string) *DescribeFolderContentsInput {
	s.Include = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFolderContentsInput) SetLimit(v int64) *DescribeFolderContentsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeFolderContentsInput) SetMarker(v string) *DescribeFolderContentsInput {
	s.Marker = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *DescribeFolderContentsInput) SetOrder(v string) *DescribeFolderContentsInput {
	s.Order = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *DescribeFolderContentsInput) SetSort(v string) *DescribeFolderContentsInput {
	s.Sort = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeFolderContentsInput) SetType(v string) *DescribeFolderContentsInput {
	s.Type = &v
	return s
}

type DescribeFolderContentsOutput struct {
	_ struct{} `type:"structure"`

	// The documents in the specified folder.
	Documents []*DocumentMetadata `type:"list"`

	// The subfolders in the specified folder.
	Folders []*FolderMetadata `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFolderContentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFolderContentsOutput) GoString() string {
	return s.String()
}

// SetDocuments sets the Documents field's value.
func (s *DescribeFolderContentsOutput) SetDocuments(v []*DocumentMetadata) *DescribeFolderContentsOutput {
	s.Documents = v
	return s
}

// SetFolders sets the Folders field's value.
func (s *DescribeFolderContentsOutput) SetFolders(v []*FolderMetadata) *DescribeFolderContentsOutput {
	s.Folders = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeFolderContentsOutput) SetMarker(v string) *DescribeFolderContentsOutput {
	s.Marker = &v
	return s
}

type DescribeGroupsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The maximum number of items to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the organization.
	OrganizationId *string `location:"querystring" locationName:"organizationId" min:"1" type:"string"`

	// A query to describe groups by group name.
	//
	// SearchQuery is a required field
	SearchQuery *string `location:"querystring" locationName:"searchQuery" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DescribeGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}
	if s.SearchQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchQuery"))
	}
	if s.SearchQuery != nil && len(*s.SearchQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SearchQuery", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeGroupsInput) SetAuthenticationToken(v string) *DescribeGroupsInput {
	s.AuthenticationToken = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGroupsInput) SetLimit(v int64) *DescribeGroupsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeGroupsInput) SetMarker(v string) *DescribeGroupsInput {
	s.Marker = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeGroupsInput) SetOrganizationId(v string) *DescribeGroupsInput {
	s.OrganizationId = &v
	return s
}

// SetSearchQuery sets the SearchQuery field's value.
func (s *DescribeGroupsInput) SetSearchQuery(v string) *DescribeGroupsInput {
	s.SearchQuery = &v
	return s
}

type DescribeGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of groups.
	Groups []*GroupMetadata `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *DescribeGroupsOutput) SetGroups(v []*GroupMetadata) *DescribeGroupsOutput {
	s.Groups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeGroupsOutput) SetMarker(v string) *DescribeGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeNotificationSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the organization.
	//
	// OrganizationId is a required field
	OrganizationId *string `location:"uri" locationName:"OrganizationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotificationSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotificationSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotificationSubscriptionsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeNotificationSubscriptionsInput) SetLimit(v int64) *DescribeNotificationSubscriptionsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeNotificationSubscriptionsInput) SetMarker(v string) *DescribeNotificationSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeNotificationSubscriptionsInput) SetOrganizationId(v string) *DescribeNotificationSubscriptionsInput {
	s.OrganizationId = &v
	return s
}

type DescribeNotificationSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`

	// The subscriptions.
	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s DescribeNotificationSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeNotificationSubscriptionsOutput) SetMarker(v string) *DescribeNotificationSubscriptionsOutput {
	s.Marker = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *DescribeNotificationSubscriptionsOutput) SetSubscriptions(v []*Subscription) *DescribeNotificationSubscriptionsOutput {
	s.Subscriptions = v
	return s
}

type DescribeResourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The maximum number of items to return with this call.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The ID of the principal to filter permissions by.
	PrincipalId *string `location:"querystring" locationName:"principalId" min:"1" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourcePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourcePermissionsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeResourcePermissionsInput) SetAuthenticationToken(v string) *DescribeResourcePermissionsInput {
	s.AuthenticationToken = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeResourcePermissionsInput) SetLimit(v int64) *DescribeResourcePermissionsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeResourcePermissionsInput) SetMarker(v string) *DescribeResourcePermissionsInput {
	s.Marker = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DescribeResourcePermissionsInput) SetPrincipalId(v string) *DescribeResourcePermissionsInput {
	s.PrincipalId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeResourcePermissionsInput) SetResourceId(v string) *DescribeResourcePermissionsInput {
	s.ResourceId = &v
	return s
}

type DescribeResourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`

	// The principals.
	Principals []*Principal `type:"list"`
}

// String returns the string representation
func (s DescribeResourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourcePermissionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeResourcePermissionsOutput) SetMarker(v string) *DescribeResourcePermissionsOutput {
	s.Marker = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *DescribeResourcePermissionsOutput) SetPrincipals(v []*Principal) *DescribeResourcePermissionsOutput {
	s.Principals = v
	return s
}

type DescribeRootFoldersInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token.
	//
	// AuthenticationToken is a required field
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" required:"true" sensitive:"true"`

	// The maximum number of items to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeRootFoldersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRootFoldersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRootFoldersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRootFoldersInput"}
	if s.AuthenticationToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationToken"))
	}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeRootFoldersInput) SetAuthenticationToken(v string) *DescribeRootFoldersInput {
	s.AuthenticationToken = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeRootFoldersInput) SetLimit(v int64) *DescribeRootFoldersInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeRootFoldersInput) SetMarker(v string) *DescribeRootFoldersInput {
	s.Marker = &v
	return s
}

type DescribeRootFoldersOutput struct {
	_ struct{} `type:"structure"`

	// The user's special folders.
	Folders []*FolderMetadata `type:"list"`

	// The marker for the next set of results.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeRootFoldersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRootFoldersOutput) GoString() string {
	return s.String()
}

// SetFolders sets the Folders field's value.
func (s *DescribeRootFoldersOutput) SetFolders(v []*FolderMetadata) *DescribeRootFoldersOutput {
	s.Folders = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeRootFoldersOutput) SetMarker(v string) *DescribeRootFoldersOutput {
	s.Marker = &v
	return s
}

type DescribeUsersInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// A comma-separated list of values. Specify "STORAGE_METADATA" to include the
	// user storage quota and utilization information.
	Fields *string `location:"querystring" locationName:"fields" min:"1" type:"string"`

	// The state of the users. Specify "ALL" to include inactive users.
	Include *string `location:"querystring" locationName:"include" type:"string" enum:"UserFilterType"`

	// The maximum number of items to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The order for the results.
	Order *string `location:"querystring" locationName:"order" type:"string" enum:"OrderType"`

	// The ID of the organization.
	OrganizationId *string `location:"querystring" locationName:"organizationId" min:"1" type:"string"`

	// A query to filter users by user name.
	Query *string `location:"querystring" locationName:"query" min:"1" type:"string" sensitive:"true"`

	// The sorting criteria.
	Sort *string `location:"querystring" locationName:"sort" type:"string" enum:"UserSortType"`

	// The IDs of the users.
	UserIds *string `location:"querystring" locationName:"userIds" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUsersInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Fields != nil && len(*s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.OrganizationId != nil && len(*s.OrganizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationId", 1))
	}
	if s.Query != nil && len(*s.Query) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Query", 1))
	}
	if s.UserIds != nil && len(*s.UserIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *DescribeUsersInput) SetAuthenticationToken(v string) *DescribeUsersInput {
	s.AuthenticationToken = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *DescribeUsersInput) SetFields(v string) *DescribeUsersInput {
	s.Fields = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *DescribeUsersInput) SetInclude(v string) *DescribeUsersInput {
	s.Include = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeUsersInput) SetLimit(v int64) *DescribeUsersInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeUsersInput) SetMarker(v string) *DescribeUsersInput {
	s.Marker = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *DescribeUsersInput) SetOrder(v string) *DescribeUsersInput {
	s.Order = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeUsersInput) SetOrganizationId(v string) *DescribeUsersInput {
	s.OrganizationId = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *DescribeUsersInput) SetQuery(v string) *DescribeUsersInput {
	s.Query = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *DescribeUsersInput) SetSort(v string) *DescribeUsersInput {
	s.Sort = &v
	return s
}

// SetUserIds sets the UserIds field's value.
func (s *DescribeUsersInput) SetUserIds(v string) *DescribeUsersInput {
	s.UserIds = &v
	return s
}

type DescribeUsersOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`

	// The total number of users included in the results.
	//
	// Deprecated: TotalNumberOfUsers has been deprecated
	TotalNumberOfUsers *int64 `deprecated:"true" type:"long"`

	// The users.
	Users []*User `type:"list"`
}

// String returns the string representation
func (s DescribeUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUsersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeUsersOutput) SetMarker(v string) *DescribeUsersOutput {
	s.Marker = &v
	return s
}

// SetTotalNumberOfUsers sets the TotalNumberOfUsers field's value.
func (s *DescribeUsersOutput) SetTotalNumberOfUsers(v int64) *DescribeUsersOutput {
	s.TotalNumberOfUsers = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *DescribeUsersOutput) SetUsers(v []*User) *DescribeUsersOutput {
	s.Users = v
	return s
}

// This exception is thrown when the document is locked for comments and user
// tries to create or delete a comment on that document.
type DocumentLockedForCommentsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DocumentLockedForCommentsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentLockedForCommentsException) GoString() string {
	return s.String()
}

func newErrorDocumentLockedForCommentsException(v protocol.ResponseMetadata) error {
	return &DocumentLockedForCommentsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s DocumentLockedForCommentsException) Code() string {
	return "DocumentLockedForCommentsException"
}

// Message returns the exception's message.
func (s DocumentLockedForCommentsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s DocumentLockedForCommentsException) OrigErr() error {
	return nil
}

func (s DocumentLockedForCommentsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s DocumentLockedForCommentsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s DocumentLockedForCommentsException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes the document.
type DocumentMetadata struct {
	_ struct{} `type:"structure"`

	// The time when the document was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the creator.
	CreatorId *string `min:"1" type:"string"`

	// The ID of the document.
	Id *string `min:"1" type:"string"`

	// List of labels on the document.
	Labels []*string `type:"list"`

	// The latest version of the document.
	LatestVersionMetadata *DocumentVersionMetadata `type:"structure"`

	// The time when the document was updated.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state.
	ResourceState *string `type:"string" enum:"ResourceStateType"`
}

// String returns the string representation
func (s DocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentMetadata) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DocumentMetadata) SetCreatedTimestamp(v time.Time) *DocumentMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *DocumentMetadata) SetCreatorId(v string) *DocumentMetadata {
	s.CreatorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DocumentMetadata) SetId(v string) *DocumentMetadata {
	s.Id = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *DocumentMetadata) SetLabels(v []*string) *DocumentMetadata {
	s.Labels = v
	return s
}

// SetLatestVersionMetadata sets the LatestVersionMetadata field's value.
func (s *DocumentMetadata) SetLatestVersionMetadata(v *DocumentVersionMetadata) *DocumentMetadata {
	s.LatestVersionMetadata = v
	return s
}

// SetModifiedTimestamp sets the ModifiedTimestamp field's value.
func (s *DocumentMetadata) SetModifiedTimestamp(v time.Time) *DocumentMetadata {
	s.ModifiedTimestamp = &v
	return s
}

// SetParentFolderId sets the ParentFolderId field's value.
func (s *DocumentMetadata) SetParentFolderId(v string) *DocumentMetadata {
	s.ParentFolderId = &v
	return s
}

// SetResourceState sets the ResourceState field's value.
func (s *DocumentMetadata) SetResourceState(v string) *DocumentMetadata {
	s.ResourceState = &v
	return s
}

// Describes a version of a document.
type DocumentVersionMetadata struct {
	_ struct{} `type:"structure"`

	// The timestamp when the content of the document was originally created.
	ContentCreatedTimestamp *time.Time `type:"timestamp"`

	// The timestamp when the content of the document was modified.
	ContentModifiedTimestamp *time.Time `type:"timestamp"`

	// The content type of the document.
	ContentType *string `min:"1" type:"string"`

	// The timestamp when the document was first uploaded.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the creator.
	CreatorId *string `min:"1" type:"string"`

	// The ID of the version.
	Id *string `min:"1" type:"string"`

	// The timestamp when the document was last uploaded.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The name of the version.
	Name *string `min:"1" type:"string"`

	// The signature of the document.
	Signature *string `type:"string"`

	// The size of the document, in bytes.
	Size *int64 `type:"long"`

	// The source of the document.
	Source map[string]*string `type:"map"`

	// The status of the document.
	Status *string `type:"string" enum:"DocumentStatusType"`

	// The thumbnail of the document.
	Thumbnail map[string]*string `type:"map"`
}

// String returns the string representation
func (s DocumentVersionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentVersionMetadata) GoString() string {
	return s.String()
}

// SetContentCreatedTimestamp sets the ContentCreatedTimestamp field's value.
func (s *DocumentVersionMetadata) SetContentCreatedTimestamp(v time.Time) *DocumentVersionMetadata {
	s.ContentCreatedTimestamp = &v
	return s
}

// SetContentModifiedTimestamp sets the ContentModifiedTimestamp field's value.
func (s *DocumentVersionMetadata) SetContentModifiedTimestamp(v time.Time) *DocumentVersionMetadata {
	s.ContentModifiedTimestamp = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *DocumentVersionMetadata) SetContentType(v string) *DocumentVersionMetadata {
	s.ContentType = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DocumentVersionMetadata) SetCreatedTimestamp(v time.Time) *DocumentVersionMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *DocumentVersionMetadata) SetCreatorId(v string) *DocumentVersionMetadata {
	s.CreatorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DocumentVersionMetadata) SetId(v string) *DocumentVersionMetadata {
	s.Id = &v
	return s
}

// SetModifiedTimestamp sets the ModifiedTimestamp field's value.
func (s *DocumentVersionMetadata) SetModifiedTimestamp(v time.Time) *DocumentVersionMetadata {
	s.ModifiedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentVersionMetadata) SetName(v string) *DocumentVersionMetadata {
	s.Name = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *DocumentVersionMetadata) SetSignature(v string) *DocumentVersionMetadata {
	s.Signature = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DocumentVersionMetadata) SetSize(v int64) *DocumentVersionMetadata {
	s.Size = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DocumentVersionMetadata) SetSource(v map[string]*string) *DocumentVersionMetadata {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentVersionMetadata) SetStatus(v string) *DocumentVersionMetadata {
	s.Status = &v
	return s
}

// SetThumbnail sets the Thumbnail field's value.
func (s *DocumentVersionMetadata) SetThumbnail(v map[string]*string) *DocumentVersionMetadata {
	s.Thumbnail = v
	return s
}

// This exception is thrown when a valid checkout ID is not presented on document
// version upload calls for a document that has been checked out from Web client.
type DraftUploadOutOfSyncException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DraftUploadOutOfSyncException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DraftUploadOutOfSyncException) GoString() string {
	return s.String()
}

func newErrorDraftUploadOutOfSyncException(v protocol.ResponseMetadata) error {
	return &DraftUploadOutOfSyncException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s DraftUploadOutOfSyncException) Code() string {
	return "DraftUploadOutOfSyncException"
}

// Message returns the exception's message.
func (s DraftUploadOutOfSyncException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s DraftUploadOutOfSyncException) OrigErr() error {
	return nil
}

func (s DraftUploadOutOfSyncException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s DraftUploadOutOfSyncException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s DraftUploadOutOfSyncException) RequestID() string {
	return s.respMetadata.RequestID
}

// The resource already exists.
type EntityAlreadyExistsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EntityAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorEntityAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &EntityAlreadyExistsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s EntityAlreadyExistsException) Code() string {
	return "EntityAlreadyExistsException"
}

// Message returns the exception's message.
func (s EntityAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s EntityAlreadyExistsException) OrigErr() error {
	return nil
}

func (s EntityAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s EntityAlreadyExistsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s EntityAlreadyExistsException) RequestID() string {
	return s.respMetadata.RequestID
}

// The resource does not exist.
type EntityNotExistsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	EntityIds []*string `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EntityNotExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityNotExistsException) GoString() string {
	return s.String()
}

func newErrorEntityNotExistsException(v protocol.ResponseMetadata) error {
	return &EntityNotExistsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s EntityNotExistsException) Code() string {
	return "EntityNotExistsException"
}

// Message returns the exception's message.
func (s EntityNotExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s EntityNotExistsException) OrigErr() error {
	return nil
}

func (s EntityNotExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s EntityNotExistsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s EntityNotExistsException) RequestID() string {
	return s.respMetadata.RequestID
}

// The AWS Directory Service cannot reach an on-premises instance. Or a dependency
// under the control of the organization is failing, such as a connected Active
// Directory.
type FailedDependencyException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s FailedDependencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedDependencyException) GoString() string {
	return s.String()
}

func newErrorFailedDependencyException(v protocol.ResponseMetadata) error {
	return &FailedDependencyException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s FailedDependencyException) Code() string {
	return "FailedDependencyException"
}

// Message returns the exception's message.
func (s FailedDependencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s FailedDependencyException) OrigErr() error {
	return nil
}

func (s FailedDependencyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s FailedDependencyException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s FailedDependencyException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes a folder.
type FolderMetadata struct {
	_ struct{} `type:"structure"`

	// The time when the folder was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The ID of the creator.
	CreatorId *string `min:"1" type:"string"`

	// The ID of the folder.
	Id *string `min:"1" type:"string"`

	// List of labels on the folder.
	Labels []*string `type:"list"`

	// The size of the latest version of the folder metadata.
	LatestVersionSize *int64 `type:"long"`

	// The time when the folder was updated.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The name of the folder.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state of the folder.
	ResourceState *string `type:"string" enum:"ResourceStateType"`

	// The unique identifier created from the subfolders and documents of the folder.
	Signature *string `type:"string"`

	// The size of the folder metadata.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s FolderMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FolderMetadata) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *FolderMetadata) SetCreatedTimestamp(v time.Time) *FolderMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *FolderMetadata) SetCreatorId(v string) *FolderMetadata {
	s.CreatorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *FolderMetadata) SetId(v string) *FolderMetadata {
	s.Id = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *FolderMetadata) SetLabels(v []*string) *FolderMetadata {
	s.Labels = v
	return s
}

// SetLatestVersionSize sets the LatestVersionSize field's value.
func (s *FolderMetadata) SetLatestVersionSize(v int64) *FolderMetadata {
	s.LatestVersionSize = &v
	return s
}

// SetModifiedTimestamp sets the ModifiedTimestamp field's value.
func (s *FolderMetadata) SetModifiedTimestamp(v time.Time) *FolderMetadata {
	s.ModifiedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *FolderMetadata) SetName(v string) *FolderMetadata {
	s.Name = &v
	return s
}

// SetParentFolderId sets the ParentFolderId field's value.
func (s *FolderMetadata) SetParentFolderId(v string) *FolderMetadata {
	s.ParentFolderId = &v
	return s
}

// SetResourceState sets the ResourceState field's value.
func (s *FolderMetadata) SetResourceState(v string) *FolderMetadata {
	s.ResourceState = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *FolderMetadata) SetSignature(v string) *FolderMetadata {
	s.Signature = &v
	return s
}

// SetSize sets the Size field's value.
func (s *FolderMetadata) SetSize(v int64) *FolderMetadata {
	s.Size = &v
	return s
}

type GetCurrentUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token.
	//
	// AuthenticationToken is a required field
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s GetCurrentUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCurrentUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCurrentUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCurrentUserInput"}
	if s.AuthenticationToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationToken"))
	}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetCurrentUserInput) SetAuthenticationToken(v string) *GetCurrentUserInput {
	s.AuthenticationToken = &v
	return s
}

type GetCurrentUserOutput struct {
	_ struct{} `type:"structure"`

	// Metadata of the user.
	User *User `type:"structure"`
}

// String returns the string representation
func (s GetCurrentUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCurrentUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *GetCurrentUserOutput) SetUser(v *User) *GetCurrentUserOutput {
	s.User = v
	return s
}

type GetDocumentInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// Set this to TRUE to include custom metadata in the response.
	IncludeCustomMetadata *bool `location:"querystring" locationName:"includeCustomMetadata" type:"boolean"`
}

// String returns the string representation
func (s GetDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetDocumentInput) SetAuthenticationToken(v string) *GetDocumentInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *GetDocumentInput) SetDocumentId(v string) *GetDocumentInput {
	s.DocumentId = &v
	return s
}

// SetIncludeCustomMetadata sets the IncludeCustomMetadata field's value.
func (s *GetDocumentInput) SetIncludeCustomMetadata(v bool) *GetDocumentInput {
	s.IncludeCustomMetadata = &v
	return s
}

type GetDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The custom metadata on the document.
	CustomMetadata map[string]*string `min:"1" type:"map"`

	// The metadata details of the document.
	Metadata *DocumentMetadata `type:"structure"`
}

// String returns the string representation
func (s GetDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentOutput) GoString() string {
	return s.String()
}

// SetCustomMetadata sets the CustomMetadata field's value.
func (s *GetDocumentOutput) SetCustomMetadata(v map[string]*string) *GetDocumentOutput {
	s.CustomMetadata = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetDocumentOutput) SetMetadata(v *DocumentMetadata) *GetDocumentOutput {
	s.Metadata = v
	return s
}

type GetDocumentPathInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// A comma-separated list of values. Specify NAME to include the names of the
	// parent folders.
	Fields *string `location:"querystring" locationName:"fields" min:"1" type:"string"`

	// The maximum number of levels in the hierarchy to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// This value is not supported.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`
}

// String returns the string representation
func (s GetDocumentPathInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentPathInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentPathInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentPathInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Fields != nil && len(*s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetDocumentPathInput) SetAuthenticationToken(v string) *GetDocumentPathInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *GetDocumentPathInput) SetDocumentId(v string) *GetDocumentPathInput {
	s.DocumentId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetDocumentPathInput) SetFields(v string) *GetDocumentPathInput {
	s.Fields = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetDocumentPathInput) SetLimit(v int64) *GetDocumentPathInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetDocumentPathInput) SetMarker(v string) *GetDocumentPathInput {
	s.Marker = &v
	return s
}

type GetDocumentPathOutput struct {
	_ struct{} `type:"structure"`

	// The path information.
	Path *ResourcePath `type:"structure"`
}

// String returns the string representation
func (s GetDocumentPathOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentPathOutput) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *GetDocumentPathOutput) SetPath(v *ResourcePath) *GetDocumentPathOutput {
	s.Path = v
	return s
}

type GetDocumentVersionInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// A comma-separated list of values. Specify "SOURCE" to include a URL for the
	// source document.
	Fields *string `location:"querystring" locationName:"fields" min:"1" type:"string"`

	// Set this to TRUE to include custom metadata in the response.
	IncludeCustomMetadata *bool `location:"querystring" locationName:"includeCustomMetadata" type:"boolean"`

	// The version ID of the document.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDocumentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentVersionInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Fields != nil && len(*s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetDocumentVersionInput) SetAuthenticationToken(v string) *GetDocumentVersionInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *GetDocumentVersionInput) SetDocumentId(v string) *GetDocumentVersionInput {
	s.DocumentId = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetDocumentVersionInput) SetFields(v string) *GetDocumentVersionInput {
	s.Fields = &v
	return s
}

// SetIncludeCustomMetadata sets the IncludeCustomMetadata field's value.
func (s *GetDocumentVersionInput) SetIncludeCustomMetadata(v bool) *GetDocumentVersionInput {
	s.IncludeCustomMetadata = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetDocumentVersionInput) SetVersionId(v string) *GetDocumentVersionInput {
	s.VersionId = &v
	return s
}

type GetDocumentVersionOutput struct {
	_ struct{} `type:"structure"`

	// The custom metadata on the document version.
	CustomMetadata map[string]*string `min:"1" type:"map"`

	// The version metadata.
	Metadata *DocumentVersionMetadata `type:"structure"`
}

// String returns the string representation
func (s GetDocumentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentVersionOutput) GoString() string {
	return s.String()
}

// SetCustomMetadata sets the CustomMetadata field's value.
func (s *GetDocumentVersionOutput) SetCustomMetadata(v map[string]*string) *GetDocumentVersionOutput {
	s.CustomMetadata = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetDocumentVersionOutput) SetMetadata(v *DocumentVersionMetadata) *GetDocumentVersionOutput {
	s.Metadata = v
	return s
}

type GetFolderInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// Set to TRUE to include custom metadata in the response.
	IncludeCustomMetadata *bool `location:"querystring" locationName:"includeCustomMetadata" type:"boolean"`
}

// String returns the string representation
func (s GetFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFolderInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetFolderInput) SetAuthenticationToken(v string) *GetFolderInput {
	s.AuthenticationToken = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *GetFolderInput) SetFolderId(v string) *GetFolderInput {
	s.FolderId = &v
	return s
}

// SetIncludeCustomMetadata sets the IncludeCustomMetadata field's value.
func (s *GetFolderInput) SetIncludeCustomMetadata(v bool) *GetFolderInput {
	s.IncludeCustomMetadata = &v
	return s
}

type GetFolderOutput struct {
	_ struct{} `type:"structure"`

	// The custom metadata on the folder.
	CustomMetadata map[string]*string `min:"1" type:"map"`

	// The metadata of the folder.
	Metadata *FolderMetadata `type:"structure"`
}

// String returns the string representation
func (s GetFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFolderOutput) GoString() string {
	return s.String()
}

// SetCustomMetadata sets the CustomMetadata field's value.
func (s *GetFolderOutput) SetCustomMetadata(v map[string]*string) *GetFolderOutput {
	s.CustomMetadata = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetFolderOutput) SetMetadata(v *FolderMetadata) *GetFolderOutput {
	s.Metadata = v
	return s
}

type GetFolderPathInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// A comma-separated list of values. Specify "NAME" to include the names of
	// the parent folders.
	Fields *string `location:"querystring" locationName:"fields" min:"1" type:"string"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The maximum number of levels in the hierarchy to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// This value is not supported.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFolderPathInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFolderPathInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFolderPathInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFolderPathInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Fields != nil && len(*s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetFolderPathInput) SetAuthenticationToken(v string) *GetFolderPathInput {
	s.AuthenticationToken = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetFolderPathInput) SetFields(v string) *GetFolderPathInput {
	s.Fields = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *GetFolderPathInput) SetFolderId(v string) *GetFolderPathInput {
	s.FolderId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetFolderPathInput) SetLimit(v int64) *GetFolderPathInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetFolderPathInput) SetMarker(v string) *GetFolderPathInput {
	s.Marker = &v
	return s
}

type GetFolderPathOutput struct {
	_ struct{} `type:"structure"`

	// The path information.
	Path *ResourcePath `type:"structure"`
}

// String returns the string representation
func (s GetFolderPathOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFolderPathOutput) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *GetFolderPathOutput) SetPath(v *ResourcePath) *GetFolderPathOutput {
	s.Path = v
	return s
}

type GetResourcesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The collection type.
	CollectionType *string `location:"querystring" locationName:"collectionType" type:"string" enum:"ResourceCollectionType"`

	// The maximum number of resources to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. This marker was received from a previous
	// call.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The user ID for the resource collection. This is a required field for accessing
	// the API operation using IAM credentials.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcesInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *GetResourcesInput) SetAuthenticationToken(v string) *GetResourcesInput {
	s.AuthenticationToken = &v
	return s
}

// SetCollectionType sets the CollectionType field's value.
func (s *GetResourcesInput) SetCollectionType(v string) *GetResourcesInput {
	s.CollectionType = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetResourcesInput) SetLimit(v int64) *GetResourcesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetResourcesInput) SetMarker(v string) *GetResourcesInput {
	s.Marker = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetResourcesInput) SetUserId(v string) *GetResourcesInput {
	s.UserId = &v
	return s
}

type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The documents in the specified collection.
	Documents []*DocumentMetadata `type:"list"`

	// The folders in the specified folder.
	Folders []*FolderMetadata `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesOutput) GoString() string {
	return s.String()
}

// SetDocuments sets the Documents field's value.
func (s *GetResourcesOutput) SetDocuments(v []*DocumentMetadata) *GetResourcesOutput {
	s.Documents = v
	return s
}

// SetFolders sets the Folders field's value.
func (s *GetResourcesOutput) SetFolders(v []*FolderMetadata) *GetResourcesOutput {
	s.Folders = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetResourcesOutput) SetMarker(v string) *GetResourcesOutput {
	s.Marker = &v
	return s
}

// Describes the metadata of a user group.
type GroupMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the user group.
	Id *string `min:"1" type:"string"`

	// The name of the group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupMetadata) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *GroupMetadata) SetId(v string) *GroupMetadata {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GroupMetadata) SetName(v string) *GroupMetadata {
	s.Name = &v
	return s
}

// The user is undergoing transfer of ownership.
type IllegalUserStateException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s IllegalUserStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IllegalUserStateException) GoString() string {
	return s.String()
}

func newErrorIllegalUserStateException(v protocol.ResponseMetadata) error {
	return &IllegalUserStateException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s IllegalUserStateException) Code() string {
	return "IllegalUserStateException"
}

// Message returns the exception's message.
func (s IllegalUserStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s IllegalUserStateException) OrigErr() error {
	return nil
}

func (s IllegalUserStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s IllegalUserStateException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s IllegalUserStateException) RequestID() string {
	return s.respMetadata.RequestID
}

type InitiateDocumentVersionUploadInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The timestamp when the content of the document was originally created.
	ContentCreatedTimestamp *time.Time `type:"timestamp"`

	// The timestamp when the content of the document was modified.
	ContentModifiedTimestamp *time.Time `type:"timestamp"`

	// The content type of the document.
	ContentType *string `min:"1" type:"string"`

	// The size of the document, in bytes.
	DocumentSizeInBytes *int64 `type:"long"`

	// The ID of the document.
	Id *string `min:"1" type:"string"`

	// The name of the document.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	//
	// ParentFolderId is a required field
	ParentFolderId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateDocumentVersionUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateDocumentVersionUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateDocumentVersionUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateDocumentVersionUploadInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParentFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentFolderId"))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *InitiateDocumentVersionUploadInput) SetAuthenticationToken(v string) *InitiateDocumentVersionUploadInput {
	s.AuthenticationToken = &v
	return s
}

// SetContentCreatedTimestamp sets the ContentCreatedTimestamp field's value.
func (s *InitiateDocumentVersionUploadInput) SetContentCreatedTimestamp(v time.Time) *InitiateDocumentVersionUploadInput {
	s.ContentCreatedTimestamp = &v
	return s
}

// SetContentModifiedTimestamp sets the ContentModifiedTimestamp field's value.
func (s *InitiateDocumentVersionUploadInput) SetContentModifiedTimestamp(v time.Time) *InitiateDocumentVersionUploadInput {
	s.ContentModifiedTimestamp = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *InitiateDocumentVersionUploadInput) SetContentType(v string) *InitiateDocumentVersionUploadInput {
	s.ContentType = &v
	return s
}

// SetDocumentSizeInBytes sets the DocumentSizeInBytes field's value.
func (s *InitiateDocumentVersionUploadInput) SetDocumentSizeInBytes(v int64) *InitiateDocumentVersionUploadInput {
	s.DocumentSizeInBytes = &v
	return s
}

// SetId sets the Id field's value.
func (s *InitiateDocumentVersionUploadInput) SetId(v string) *InitiateDocumentVersionUploadInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *InitiateDocumentVersionUploadInput) SetName(v string) *InitiateDocumentVersionUploadInput {
	s.Name = &v
	return s
}

// SetParentFolderId sets the ParentFolderId field's value.
func (s *InitiateDocumentVersionUploadInput) SetParentFolderId(v string) *InitiateDocumentVersionUploadInput {
	s.ParentFolderId = &v
	return s
}

type InitiateDocumentVersionUploadOutput struct {
	_ struct{} `type:"structure"`

	// The document metadata.
	Metadata *DocumentMetadata `type:"structure"`

	// The upload metadata.
	UploadMetadata *UploadMetadata `type:"structure"`
}

// String returns the string representation
func (s InitiateDocumentVersionUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateDocumentVersionUploadOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *InitiateDocumentVersionUploadOutput) SetMetadata(v *DocumentMetadata) *InitiateDocumentVersionUploadOutput {
	s.Metadata = v
	return s
}

// SetUploadMetadata sets the UploadMetadata field's value.
func (s *InitiateDocumentVersionUploadOutput) SetUploadMetadata(v *UploadMetadata) *InitiateDocumentVersionUploadOutput {
	s.UploadMetadata = v
	return s
}

// The pagination marker or limit fields are not valid.
type InvalidArgumentException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidArgumentException) OrigErr() error {
	return nil
}

func (s InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidArgumentException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidArgumentException) RequestID() string {
	return s.respMetadata.RequestID
}

// The requested operation is not allowed on the specified comment object.
type InvalidCommentOperationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidCommentOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidCommentOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidCommentOperationException(v protocol.ResponseMetadata) error {
	return &InvalidCommentOperationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidCommentOperationException) Code() string {
	return "InvalidCommentOperationException"
}

// Message returns the exception's message.
func (s InvalidCommentOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidCommentOperationException) OrigErr() error {
	return nil
}

func (s InvalidCommentOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidCommentOperationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidCommentOperationException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation is invalid.
type InvalidOperationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidOperationException(v protocol.ResponseMetadata) error {
	return &InvalidOperationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidOperationException) Code() string {
	return "InvalidOperationException"
}

// Message returns the exception's message.
func (s InvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidOperationException) OrigErr() error {
	return nil
}

func (s InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidOperationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidOperationException) RequestID() string {
	return s.respMetadata.RequestID
}

// The password is invalid.
type InvalidPasswordException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidPasswordException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPasswordException) GoString() string {
	return s.String()
}

func newErrorInvalidPasswordException(v protocol.ResponseMetadata) error {
	return &InvalidPasswordException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidPasswordException) Code() string {
	return "InvalidPasswordException"
}

// Message returns the exception's message.
func (s InvalidPasswordException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidPasswordException) OrigErr() error {
	return nil
}

func (s InvalidPasswordException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidPasswordException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidPasswordException) RequestID() string {
	return s.respMetadata.RequestID
}

// The maximum of 100,000 folders under the parent folder has been exceeded.
type LimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitExceededException) OrigErr() error {
	return nil
}

func (s LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

// Set of options which defines notification preferences of given action.
type NotificationOptions struct {
	_ struct{} `type:"structure"`

	// Text value to be included in the email body.
	EmailMessage *string `type:"string" sensitive:"true"`

	// Boolean value to indicate an email notification should be sent to the receipients.
	SendEmail *bool `type:"boolean"`
}

// String returns the string representation
func (s NotificationOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationOptions) GoString() string {
	return s.String()
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *NotificationOptions) SetEmailMessage(v string) *NotificationOptions {
	s.EmailMessage = &v
	return s
}

// SetSendEmail sets the SendEmail field's value.
func (s *NotificationOptions) SetSendEmail(v bool) *NotificationOptions {
	s.SendEmail = &v
	return s
}

// Describes the users or user groups.
type Participants struct {
	_ struct{} `type:"structure"`

	// The list of user groups.
	Groups []*GroupMetadata `type:"list"`

	// The list of users.
	Users []*UserMetadata `type:"list"`
}

// String returns the string representation
func (s Participants) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Participants) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *Participants) SetGroups(v []*GroupMetadata) *Participants {
	s.Groups = v
	return s
}

// SetUsers sets the Users field's value.
func (s *Participants) SetUsers(v []*UserMetadata) *Participants {
	s.Users = v
	return s
}

// Describes the permissions.
type PermissionInfo struct {
	_ struct{} `type:"structure"`

	// The role of the user.
	Role *string `type:"string" enum:"RoleType"`

	// The type of permissions.
	Type *string `type:"string" enum:"RolePermissionType"`
}

// String returns the string representation
func (s PermissionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionInfo) GoString() string {
	return s.String()
}

// SetRole sets the Role field's value.
func (s *PermissionInfo) SetRole(v string) *PermissionInfo {
	s.Role = &v
	return s
}

// SetType sets the Type field's value.
func (s *PermissionInfo) SetType(v string) *PermissionInfo {
	s.Type = &v
	return s
}

// Describes a resource.
type Principal struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	Id *string `min:"1" type:"string"`

	// The permission information for the resource.
	Roles []*PermissionInfo `type:"list"`

	// The type of resource.
	Type *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Principal) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Principal) SetId(v string) *Principal {
	s.Id = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *Principal) SetRoles(v []*PermissionInfo) *Principal {
	s.Roles = v
	return s
}

// SetType sets the Type field's value.
func (s *Principal) SetType(v string) *Principal {
	s.Type = &v
	return s
}

// The specified document version is not in the INITIALIZED state.
type ProhibitedStateException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ProhibitedStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProhibitedStateException) GoString() string {
	return s.String()
}

func newErrorProhibitedStateException(v protocol.ResponseMetadata) error {
	return &ProhibitedStateException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ProhibitedStateException) Code() string {
	return "ProhibitedStateException"
}

// Message returns the exception's message.
func (s ProhibitedStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ProhibitedStateException) OrigErr() error {
	return nil
}

func (s ProhibitedStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ProhibitedStateException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ProhibitedStateException) RequestID() string {
	return s.respMetadata.RequestID
}

type RemoveAllResourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveAllResourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAllResourcePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAllResourcePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAllResourcePermissionsInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *RemoveAllResourcePermissionsInput) SetAuthenticationToken(v string) *RemoveAllResourcePermissionsInput {
	s.AuthenticationToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *RemoveAllResourcePermissionsInput) SetResourceId(v string) *RemoveAllResourcePermissionsInput {
	s.ResourceId = &v
	return s
}

type RemoveAllResourcePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveAllResourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAllResourcePermissionsOutput) GoString() string {
	return s.String()
}

type RemoveResourcePermissionInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The principal ID of the resource.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"PrincipalId" min:"1" type:"string" required:"true"`

	// The principal type of the resource.
	PrincipalType *string `location:"querystring" locationName:"type" type:"string" enum:"PrincipalType"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveResourcePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveResourcePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveResourcePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveResourcePermissionInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *RemoveResourcePermissionInput) SetAuthenticationToken(v string) *RemoveResourcePermissionInput {
	s.AuthenticationToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *RemoveResourcePermissionInput) SetPrincipalId(v string) *RemoveResourcePermissionInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *RemoveResourcePermissionInput) SetPrincipalType(v string) *RemoveResourcePermissionInput {
	s.PrincipalType = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *RemoveResourcePermissionInput) SetResourceId(v string) *RemoveResourcePermissionInput {
	s.ResourceId = &v
	return s
}

type RemoveResourcePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveResourcePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveResourcePermissionOutput) GoString() string {
	return s.String()
}

// The response is too large to return. The request must include a filter to
// reduce the size of the response.
type RequestedEntityTooLargeException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RequestedEntityTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestedEntityTooLargeException) GoString() string {
	return s.String()
}

func newErrorRequestedEntityTooLargeException(v protocol.ResponseMetadata) error {
	return &RequestedEntityTooLargeException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s RequestedEntityTooLargeException) Code() string {
	return "RequestedEntityTooLargeException"
}

// Message returns the exception's message.
func (s RequestedEntityTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s RequestedEntityTooLargeException) OrigErr() error {
	return nil
}

func (s RequestedEntityTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s RequestedEntityTooLargeException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s RequestedEntityTooLargeException) RequestID() string {
	return s.respMetadata.RequestID
}

// The resource is already checked out.
type ResourceAlreadyCheckedOutException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyCheckedOutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyCheckedOutException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyCheckedOutException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyCheckedOutException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceAlreadyCheckedOutException) Code() string {
	return "ResourceAlreadyCheckedOutException"
}

// Message returns the exception's message.
func (s ResourceAlreadyCheckedOutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceAlreadyCheckedOutException) OrigErr() error {
	return nil
}

func (s ResourceAlreadyCheckedOutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceAlreadyCheckedOutException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceAlreadyCheckedOutException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes the metadata of a resource.
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the resource.
	Id *string `min:"1" type:"string"`

	// The name of the resource.
	Name *string `min:"1" type:"string"`

	// The original name of the resource before a rename operation.
	OriginalName *string `min:"1" type:"string"`

	// The owner of the resource.
	Owner *UserMetadata `type:"structure"`

	// The parent ID of the resource before a rename operation.
	ParentId *string `min:"1" type:"string"`

	// The type of resource.
	Type *string `type:"string" enum:"ResourceType"`

	// The version ID of the resource. This is an optional field and is filled for
	// action on document version.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceMetadata) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ResourceMetadata) SetId(v string) *ResourceMetadata {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceMetadata) SetName(v string) *ResourceMetadata {
	s.Name = &v
	return s
}

// SetOriginalName sets the OriginalName field's value.
func (s *ResourceMetadata) SetOriginalName(v string) *ResourceMetadata {
	s.OriginalName = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ResourceMetadata) SetOwner(v *UserMetadata) *ResourceMetadata {
	s.Owner = v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ResourceMetadata) SetParentId(v string) *ResourceMetadata {
	s.ParentId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceMetadata) SetType(v string) *ResourceMetadata {
	s.Type = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ResourceMetadata) SetVersionId(v string) *ResourceMetadata {
	s.VersionId = &v
	return s
}

// Describes the path information of a resource.
type ResourcePath struct {
	_ struct{} `type:"structure"`

	// The components of the resource path.
	Components []*ResourcePathComponent `type:"list"`
}

// String returns the string representation
func (s ResourcePath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePath) GoString() string {
	return s.String()
}

// SetComponents sets the Components field's value.
func (s *ResourcePath) SetComponents(v []*ResourcePathComponent) *ResourcePath {
	s.Components = v
	return s
}

// Describes the resource path.
type ResourcePathComponent struct {
	_ struct{} `type:"structure"`

	// The ID of the resource path.
	Id *string `min:"1" type:"string"`

	// The name of the resource path.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourcePathComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePathComponent) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ResourcePathComponent) SetId(v string) *ResourcePathComponent {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourcePathComponent) SetName(v string) *ResourcePathComponent {
	s.Name = &v
	return s
}

// One or more of the dependencies is unavailable.
type ServiceUnavailableException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ServiceUnavailableException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ServiceUnavailableException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes the recipient type and ID, if available.
type SharePrincipal struct {
	_ struct{} `type:"structure"`

	// The ID of the recipient.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The role of the recipient.
	//
	// Role is a required field
	Role *string `type:"string" required:"true" enum:"RoleType"`

	// The type of the recipient.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation
func (s SharePrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SharePrincipal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePrincipal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SharePrincipal"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *SharePrincipal) SetId(v string) *SharePrincipal {
	s.Id = &v
	return s
}

// SetRole sets the Role field's value.
func (s *SharePrincipal) SetRole(v string) *SharePrincipal {
	s.Role = &v
	return s
}

// SetType sets the Type field's value.
func (s *SharePrincipal) SetType(v string) *SharePrincipal {
	s.Type = &v
	return s
}

// Describes the share results of a resource.
type ShareResult struct {
	_ struct{} `type:"structure"`

	// The ID of the invited user.
	InviteePrincipalId *string `min:"1" type:"string"`

	// The ID of the principal.
	PrincipalId *string `min:"1" type:"string"`

	// The role.
	Role *string `type:"string" enum:"RoleType"`

	// The ID of the resource that was shared.
	ShareId *string `min:"1" type:"string"`

	// The status.
	Status *string `type:"string" enum:"ShareStatusType"`

	// The status message.
	StatusMessage *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ShareResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShareResult) GoString() string {
	return s.String()
}

// SetInviteePrincipalId sets the InviteePrincipalId field's value.
func (s *ShareResult) SetInviteePrincipalId(v string) *ShareResult {
	s.InviteePrincipalId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ShareResult) SetPrincipalId(v string) *ShareResult {
	s.PrincipalId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *ShareResult) SetRole(v string) *ShareResult {
	s.Role = &v
	return s
}

// SetShareId sets the ShareId field's value.
func (s *ShareResult) SetShareId(v string) *ShareResult {
	s.ShareId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ShareResult) SetStatus(v string) *ShareResult {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ShareResult) SetStatusMessage(v string) *ShareResult {
	s.StatusMessage = &v
	return s
}

// The storage limit has been exceeded.
type StorageLimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s StorageLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLimitExceededException) GoString() string {
	return s.String()
}

func newErrorStorageLimitExceededException(v protocol.ResponseMetadata) error {
	return &StorageLimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s StorageLimitExceededException) Code() string {
	return "StorageLimitExceededException"
}

// Message returns the exception's message.
func (s StorageLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s StorageLimitExceededException) OrigErr() error {
	return nil
}

func (s StorageLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s StorageLimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s StorageLimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

// The storage limit will be exceeded.
type StorageLimitWillExceedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s StorageLimitWillExceedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLimitWillExceedException) GoString() string {
	return s.String()
}

func newErrorStorageLimitWillExceedException(v protocol.ResponseMetadata) error {
	return &StorageLimitWillExceedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s StorageLimitWillExceedException) Code() string {
	return "StorageLimitWillExceedException"
}

// Message returns the exception's message.
func (s StorageLimitWillExceedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s StorageLimitWillExceedException) OrigErr() error {
	return nil
}

func (s StorageLimitWillExceedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s StorageLimitWillExceedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s StorageLimitWillExceedException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes the storage for a user.
type StorageRuleType struct {
	_ struct{} `type:"structure"`

	// The amount of storage allocated, in bytes.
	StorageAllocatedInBytes *int64 `type:"long"`

	// The type of storage.
	StorageType *string `type:"string" enum:"StorageType"`
}

// String returns the string representation
func (s StorageRuleType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageRuleType) GoString() string {
	return s.String()
}

// SetStorageAllocatedInBytes sets the StorageAllocatedInBytes field's value.
func (s *StorageRuleType) SetStorageAllocatedInBytes(v int64) *StorageRuleType {
	s.StorageAllocatedInBytes = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *StorageRuleType) SetStorageType(v string) *StorageRuleType {
	s.StorageType = &v
	return s
}

// Describes a subscription.
type Subscription struct {
	_ struct{} `type:"structure"`

	// The endpoint of the subscription.
	EndPoint *string `min:"1" type:"string"`

	// The protocol of the subscription.
	Protocol *string `type:"string" enum:"SubscriptionProtocolType"`

	// The ID of the subscription.
	SubscriptionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// SetEndPoint sets the EndPoint field's value.
func (s *Subscription) SetEndPoint(v string) *Subscription {
	s.EndPoint = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Subscription) SetProtocol(v string) *Subscription {
	s.Protocol = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *Subscription) SetSubscriptionId(v string) *Subscription {
	s.SubscriptionId = &v
	return s
}

// The limit has been reached on the number of labels for the specified resource.
type TooManyLabelsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TooManyLabelsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyLabelsException) GoString() string {
	return s.String()
}

func newErrorTooManyLabelsException(v protocol.ResponseMetadata) error {
	return &TooManyLabelsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TooManyLabelsException) Code() string {
	return "TooManyLabelsException"
}

// Message returns the exception's message.
func (s TooManyLabelsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TooManyLabelsException) OrigErr() error {
	return nil
}

func (s TooManyLabelsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TooManyLabelsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TooManyLabelsException) RequestID() string {
	return s.respMetadata.RequestID
}

// You've reached the limit on the number of subscriptions for the WorkDocs
// instance.
type TooManySubscriptionsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TooManySubscriptionsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManySubscriptionsException) GoString() string {
	return s.String()
}

func newErrorTooManySubscriptionsException(v protocol.ResponseMetadata) error {
	return &TooManySubscriptionsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TooManySubscriptionsException) Code() string {
	return "TooManySubscriptionsException"
}

// Message returns the exception's message.
func (s TooManySubscriptionsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TooManySubscriptionsException) OrigErr() error {
	return nil
}

func (s TooManySubscriptionsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TooManySubscriptionsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TooManySubscriptionsException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation is not permitted.
type UnauthorizedOperationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedOperationException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedOperationException(v protocol.ResponseMetadata) error {
	return &UnauthorizedOperationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s UnauthorizedOperationException) Code() string {
	return "UnauthorizedOperationException"
}

// Message returns the exception's message.
func (s UnauthorizedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s UnauthorizedOperationException) OrigErr() error {
	return nil
}

func (s UnauthorizedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s UnauthorizedOperationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s UnauthorizedOperationException) RequestID() string {
	return s.respMetadata.RequestID
}

// The caller does not have access to perform the action on the resource.
type UnauthorizedResourceAccessException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedResourceAccessException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedResourceAccessException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedResourceAccessException(v protocol.ResponseMetadata) error {
	return &UnauthorizedResourceAccessException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s UnauthorizedResourceAccessException) Code() string {
	return "UnauthorizedResourceAccessException"
}

// Message returns the exception's message.
func (s UnauthorizedResourceAccessException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s UnauthorizedResourceAccessException) OrigErr() error {
	return nil
}

func (s UnauthorizedResourceAccessException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s UnauthorizedResourceAccessException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s UnauthorizedResourceAccessException) RequestID() string {
	return s.respMetadata.RequestID
}

type UpdateDocumentInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The name of the document.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state of the document. Only ACTIVE and RECYCLED are supported.
	ResourceState *string `type:"string" enum:"ResourceStateType"`
}

// String returns the string representation
func (s UpdateDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDocumentInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *UpdateDocumentInput) SetAuthenticationToken(v string) *UpdateDocumentInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *UpdateDocumentInput) SetDocumentId(v string) *UpdateDocumentInput {
	s.DocumentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDocumentInput) SetName(v string) *UpdateDocumentInput {
	s.Name = &v
	return s
}

// SetParentFolderId sets the ParentFolderId field's value.
func (s *UpdateDocumentInput) SetParentFolderId(v string) *UpdateDocumentInput {
	s.ParentFolderId = &v
	return s
}

// SetResourceState sets the ResourceState field's value.
func (s *UpdateDocumentInput) SetResourceState(v string) *UpdateDocumentInput {
	s.ResourceState = &v
	return s
}

type UpdateDocumentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDocumentOutput) GoString() string {
	return s.String()
}

type UpdateDocumentVersionInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The version ID of the document.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`

	// The status of the version.
	VersionStatus *string `type:"string" enum:"DocumentVersionStatus"`
}

// String returns the string representation
func (s UpdateDocumentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDocumentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDocumentVersionInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *UpdateDocumentVersionInput) SetAuthenticationToken(v string) *UpdateDocumentVersionInput {
	s.AuthenticationToken = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *UpdateDocumentVersionInput) SetDocumentId(v string) *UpdateDocumentVersionInput {
	s.DocumentId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *UpdateDocumentVersionInput) SetVersionId(v string) *UpdateDocumentVersionInput {
	s.VersionId = &v
	return s
}

// SetVersionStatus sets the VersionStatus field's value.
func (s *UpdateDocumentVersionInput) SetVersionStatus(v string) *UpdateDocumentVersionInput {
	s.VersionStatus = &v
	return s
}

type UpdateDocumentVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDocumentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDocumentVersionOutput) GoString() string {
	return s.String()
}

type UpdateFolderInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The name of the folder.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state of the folder. Only ACTIVE and RECYCLED are accepted values
	// from the API.
	ResourceState *string `type:"string" enum:"ResourceStateType"`
}

// String returns the string representation
func (s UpdateFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFolderInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *UpdateFolderInput) SetAuthenticationToken(v string) *UpdateFolderInput {
	s.AuthenticationToken = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *UpdateFolderInput) SetFolderId(v string) *UpdateFolderInput {
	s.FolderId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFolderInput) SetName(v string) *UpdateFolderInput {
	s.Name = &v
	return s
}

// SetParentFolderId sets the ParentFolderId field's value.
func (s *UpdateFolderInput) SetParentFolderId(v string) *UpdateFolderInput {
	s.ParentFolderId = &v
	return s
}

// SetResourceState sets the ResourceState field's value.
func (s *UpdateFolderInput) SetResourceState(v string) *UpdateFolderInput {
	s.ResourceState = &v
	return s
}

type UpdateFolderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFolderOutput) GoString() string {
	return s.String()
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The given name of the user.
	GivenName *string `min:"1" type:"string"`

	// Boolean value to determine whether the user is granted Poweruser privileges.
	GrantPoweruserPrivileges *string `type:"string" enum:"BooleanEnumType"`

	// The locale of the user.
	Locale *string `type:"string" enum:"LocaleType"`

	// The amount of storage for the user.
	StorageRule *StorageRuleType `type:"structure"`

	// The surname of the user.
	Surname *string `min:"1" type:"string"`

	// The time zone ID of the user.
	TimeZoneId *string `min:"1" type:"string"`

	// The type of the user.
	Type *string `type:"string" enum:"UserType"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.GivenName != nil && len(*s.GivenName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GivenName", 1))
	}
	if s.Surname != nil && len(*s.Surname) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Surname", 1))
	}
	if s.TimeZoneId != nil && len(*s.TimeZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZoneId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationToken sets the AuthenticationToken field's value.
func (s *UpdateUserInput) SetAuthenticationToken(v string) *UpdateUserInput {
	s.AuthenticationToken = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *UpdateUserInput) SetGivenName(v string) *UpdateUserInput {
	s.GivenName = &v
	return s
}

// SetGrantPoweruserPrivileges sets the GrantPoweruserPrivileges field's value.
func (s *UpdateUserInput) SetGrantPoweruserPrivileges(v string) *UpdateUserInput {
	s.GrantPoweruserPrivileges = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *UpdateUserInput) SetLocale(v string) *UpdateUserInput {
	s.Locale = &v
	return s
}

// SetStorageRule sets the StorageRule field's value.
func (s *UpdateUserInput) SetStorageRule(v *StorageRuleType) *UpdateUserInput {
	s.StorageRule = v
	return s
}

// SetSurname sets the Surname field's value.
func (s *UpdateUserInput) SetSurname(v string) *UpdateUserInput {
	s.Surname = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *UpdateUserInput) SetTimeZoneId(v string) *UpdateUserInput {
	s.TimeZoneId = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateUserInput) SetType(v string) *UpdateUserInput {
	s.Type = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserInput) SetUserId(v string) *UpdateUserInput {
	s.UserId = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user information.
	User *User `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *UpdateUserOutput) SetUser(v *User) *UpdateUserOutput {
	s.User = v
	return s
}

// Describes the upload.
type UploadMetadata struct {
	_ struct{} `type:"structure"`

	// The signed headers.
	SignedHeaders map[string]*string `type:"map"`

	// The URL of the upload.
	UploadUrl *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s UploadMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadMetadata) GoString() string {
	return s.String()
}

// SetSignedHeaders sets the SignedHeaders field's value.
func (s *UploadMetadata) SetSignedHeaders(v map[string]*string) *UploadMetadata {
	s.SignedHeaders = v
	return s
}

// SetUploadUrl sets the UploadUrl field's value.
func (s *UploadMetadata) SetUploadUrl(v string) *UploadMetadata {
	s.UploadUrl = &v
	return s
}

// Describes a user.
type User struct {
	_ struct{} `type:"structure"`

	// The time when the user was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The email address of the user.
	EmailAddress *string `min:"1" type:"string"`

	// The given name of the user.
	GivenName *string `min:"1" type:"string"`

	// The ID of the user.
	Id *string `min:"1" type:"string"`

	// The locale of the user.
	Locale *string `type:"string" enum:"LocaleType"`

	// The time when the user was modified.
	ModifiedTimestamp *time.Time `type:"timestamp"`

	// The ID of the organization.
	OrganizationId *string `min:"1" type:"string"`

	// The ID of the recycle bin folder.
	RecycleBinFolderId *string `min:"1" type:"string"`

	// The ID of the root folder.
	RootFolderId *string `min:"1" type:"string"`

	// The status of the user.
	Status *string `type:"string" enum:"UserStatusType"`

	// The storage for the user.
	Storage *UserStorageMetadata `type:"structure"`

	// The surname of the user.
	Surname *string `min:"1" type:"string"`

	// The time zone ID of the user.
	TimeZoneId *string `min:"1" type:"string"`

	// The type of user.
	Type *string `type:"string" enum:"UserType"`

	// The login name of the user.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *User) SetCreatedTimestamp(v time.Time) *User {
	s.CreatedTimestamp = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *User) SetEmailAddress(v string) *User {
	s.EmailAddress = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *User) SetGivenName(v string) *User {
	s.GivenName = &v
	return s
}

// SetId sets the Id field's value.
func (s *User) SetId(v string) *User {
	s.Id = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *User) SetLocale(v string) *User {
	s.Locale = &v
	return s
}

// SetModifiedTimestamp sets the ModifiedTimestamp field's value.
func (s *User) SetModifiedTimestamp(v time.Time) *User {
	s.ModifiedTimestamp = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *User) SetOrganizationId(v string) *User {
	s.OrganizationId = &v
	return s
}

// SetRecycleBinFolderId sets the RecycleBinFolderId field's value.
func (s *User) SetRecycleBinFolderId(v string) *User {
	s.RecycleBinFolderId = &v
	return s
}

// SetRootFolderId sets the RootFolderId field's value.
func (s *User) SetRootFolderId(v string) *User {
	s.RootFolderId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *User) SetStatus(v string) *User {
	s.Status = &v
	return s
}

// SetStorage sets the Storage field's value.
func (s *User) SetStorage(v *UserStorageMetadata) *User {
	s.Storage = v
	return s
}

// SetSurname sets the Surname field's value.
func (s *User) SetSurname(v string) *User {
	s.Surname = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *User) SetTimeZoneId(v string) *User {
	s.TimeZoneId = &v
	return s
}

// SetType sets the Type field's value.
func (s *User) SetType(v string) *User {
	s.Type = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *User) SetUsername(v string) *User {
	s.Username = &v
	return s
}

// Describes the metadata of the user.
type UserMetadata struct {
	_ struct{} `type:"structure"`

	// The email address of the user.
	EmailAddress *string `min:"1" type:"string"`

	// The given name of the user before a rename operation.
	GivenName *string `min:"1" type:"string"`

	// The ID of the user.
	Id *string `min:"1" type:"string"`

	// The surname of the user.
	Surname *string `min:"1" type:"string"`

	// The name of the user.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserMetadata) GoString() string {
	return s.String()
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UserMetadata) SetEmailAddress(v string) *UserMetadata {
	s.EmailAddress = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *UserMetadata) SetGivenName(v string) *UserMetadata {
	s.GivenName = &v
	return s
}

// SetId sets the Id field's value.
func (s *UserMetadata) SetId(v string) *UserMetadata {
	s.Id = &v
	return s
}

// SetSurname sets the Surname field's value.
func (s *UserMetadata) SetSurname(v string) *UserMetadata {
	s.Surname = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UserMetadata) SetUsername(v string) *UserMetadata {
	s.Username = &v
	return s
}

// Describes the storage for a user.
type UserStorageMetadata struct {
	_ struct{} `type:"structure"`

	// The storage for a user.
	StorageRule *StorageRuleType `type:"structure"`

	// The amount of storage used, in bytes.
	StorageUtilizedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s UserStorageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserStorageMetadata) GoString() string {
	return s.String()
}

// SetStorageRule sets the StorageRule field's value.
func (s *UserStorageMetadata) SetStorageRule(v *StorageRuleType) *UserStorageMetadata {
	s.StorageRule = v
	return s
}

// SetStorageUtilizedInBytes sets the StorageUtilizedInBytes field's value.
func (s *UserStorageMetadata) SetStorageUtilizedInBytes(v int64) *UserStorageMetadata {
	s.StorageUtilizedInBytes = &v
	return s
}

const (
	// ActivityTypeDocumentCheckedIn is a ActivityType enum value
	ActivityTypeDocumentCheckedIn = "DOCUMENT_CHECKED_IN"

	// ActivityTypeDocumentCheckedOut is a ActivityType enum value
	ActivityTypeDocumentCheckedOut = "DOCUMENT_CHECKED_OUT"

	// ActivityTypeDocumentRenamed is a ActivityType enum value
	ActivityTypeDocumentRenamed = "DOCUMENT_RENAMED"

	// ActivityTypeDocumentVersionUploaded is a ActivityType enum value
	ActivityTypeDocumentVersionUploaded = "DOCUMENT_VERSION_UPLOADED"

	// ActivityTypeDocumentVersionDeleted is a ActivityType enum value
	ActivityTypeDocumentVersionDeleted = "DOCUMENT_VERSION_DELETED"

	// ActivityTypeDocumentVersionViewed is a ActivityType enum value
	ActivityTypeDocumentVersionViewed = "DOCUMENT_VERSION_VIEWED"

	// ActivityTypeDocumentVersionDownloaded is a ActivityType enum value
	ActivityTypeDocumentVersionDownloaded = "DOCUMENT_VERSION_DOWNLOADED"

	// ActivityTypeDocumentRecycled is a ActivityType enum value
	ActivityTypeDocumentRecycled = "DOCUMENT_RECYCLED"

	// ActivityTypeDocumentRestored is a ActivityType enum value
	ActivityTypeDocumentRestored = "DOCUMENT_RESTORED"

	// ActivityTypeDocumentReverted is a ActivityType enum value
	ActivityTypeDocumentReverted = "DOCUMENT_REVERTED"

	// ActivityTypeDocumentShared is a ActivityType enum value
	ActivityTypeDocumentShared = "DOCUMENT_SHARED"

	// ActivityTypeDocumentUnshared is a ActivityType enum value
	ActivityTypeDocumentUnshared = "DOCUMENT_UNSHARED"

	// ActivityTypeDocumentSharePermissionChanged is a ActivityType enum value
	ActivityTypeDocumentSharePermissionChanged = "DOCUMENT_SHARE_PERMISSION_CHANGED"

	// ActivityTypeDocumentShareableLinkCreated is a ActivityType enum value
	ActivityTypeDocumentShareableLinkCreated = "DOCUMENT_SHAREABLE_LINK_CREATED"

	// ActivityTypeDocumentShareableLinkRemoved is a ActivityType enum value
	ActivityTypeDocumentShareableLinkRemoved = "DOCUMENT_SHAREABLE_LINK_REMOVED"

	// ActivityTypeDocumentShareableLinkPermissionChanged is a ActivityType enum value
	ActivityTypeDocumentShareableLinkPermissionChanged = "DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED"

	// ActivityTypeDocumentMoved is a ActivityType enum value
	ActivityTypeDocumentMoved = "DOCUMENT_MOVED"

	// ActivityTypeDocumentCommentAdded is a ActivityType enum value
	ActivityTypeDocumentCommentAdded = "DOCUMENT_COMMENT_ADDED"

	// ActivityTypeDocumentCommentDeleted is a ActivityType enum value
	ActivityTypeDocumentCommentDeleted = "DOCUMENT_COMMENT_DELETED"

	// ActivityTypeDocumentAnnotationAdded is a ActivityType enum value
	ActivityTypeDocumentAnnotationAdded = "DOCUMENT_ANNOTATION_ADDED"

	// ActivityTypeDocumentAnnotationDeleted is a ActivityType enum value
	ActivityTypeDocumentAnnotationDeleted = "DOCUMENT_ANNOTATION_DELETED"

	// ActivityTypeFolderCreated is a ActivityType enum value
	ActivityTypeFolderCreated = "FOLDER_CREATED"

	// ActivityTypeFolderDeleted is a ActivityType enum value
	ActivityTypeFolderDeleted = "FOLDER_DELETED"

	// ActivityTypeFolderRenamed is a ActivityType enum value
	ActivityTypeFolderRenamed = "FOLDER_RENAMED"

	// ActivityTypeFolderRecycled is a ActivityType enum value
	ActivityTypeFolderRecycled = "FOLDER_RECYCLED"

	// ActivityTypeFolderRestored is a ActivityType enum value
	ActivityTypeFolderRestored = "FOLDER_RESTORED"

	// ActivityTypeFolderShared is a ActivityType enum value
	ActivityTypeFolderShared = "FOLDER_SHARED"

	// ActivityTypeFolderUnshared is a ActivityType enum value
	ActivityTypeFolderUnshared = "FOLDER_UNSHARED"

	// ActivityTypeFolderSharePermissionChanged is a ActivityType enum value
	ActivityTypeFolderSharePermissionChanged = "FOLDER_SHARE_PERMISSION_CHANGED"

	// ActivityTypeFolderShareableLinkCreated is a ActivityType enum value
	ActivityTypeFolderShareableLinkCreated = "FOLDER_SHAREABLE_LINK_CREATED"

	// ActivityTypeFolderShareableLinkRemoved is a ActivityType enum value
	ActivityTypeFolderShareableLinkRemoved = "FOLDER_SHAREABLE_LINK_REMOVED"

	// ActivityTypeFolderShareableLinkPermissionChanged is a ActivityType enum value
	ActivityTypeFolderShareableLinkPermissionChanged = "FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED"

	// ActivityTypeFolderMoved is a ActivityType enum value
	ActivityTypeFolderMoved = "FOLDER_MOVED"
)

const (
	// BooleanEnumTypeTrue is a BooleanEnumType enum value
	BooleanEnumTypeTrue = "TRUE"

	// BooleanEnumTypeFalse is a BooleanEnumType enum value
	BooleanEnumTypeFalse = "FALSE"
)

const (
	// CommentStatusTypeDraft is a CommentStatusType enum value
	CommentStatusTypeDraft = "DRAFT"

	// CommentStatusTypePublished is a CommentStatusType enum value
	CommentStatusTypePublished = "PUBLISHED"

	// CommentStatusTypeDeleted is a CommentStatusType enum value
	CommentStatusTypeDeleted = "DELETED"
)

const (
	// CommentVisibilityTypePublic is a CommentVisibilityType enum value
	CommentVisibilityTypePublic = "PUBLIC"

	// CommentVisibilityTypePrivate is a CommentVisibilityType enum value
	CommentVisibilityTypePrivate = "PRIVATE"
)

const (
	// DocumentSourceTypeOriginal is a DocumentSourceType enum value
	DocumentSourceTypeOriginal = "ORIGINAL"

	// DocumentSourceTypeWithComments is a DocumentSourceType enum value
	DocumentSourceTypeWithComments = "WITH_COMMENTS"
)

const (
	// DocumentStatusTypeInitialized is a DocumentStatusType enum value
	DocumentStatusTypeInitialized = "INITIALIZED"

	// DocumentStatusTypeActive is a DocumentStatusType enum value
	DocumentStatusTypeActive = "ACTIVE"
)

const (
	// DocumentThumbnailTypeSmall is a DocumentThumbnailType enum value
	DocumentThumbnailTypeSmall = "SMALL"

	// DocumentThumbnailTypeSmallHq is a DocumentThumbnailType enum value
	DocumentThumbnailTypeSmallHq = "SMALL_HQ"

	// DocumentThumbnailTypeLarge is a DocumentThumbnailType enum value
	DocumentThumbnailTypeLarge = "LARGE"
)

const (
	// DocumentVersionStatusActive is a DocumentVersionStatus enum value
	DocumentVersionStatusActive = "ACTIVE"
)

const (
	// FolderContentTypeAll is a FolderContentType enum value
	FolderContentTypeAll = "ALL"

	// FolderContentTypeDocument is a FolderContentType enum value
	FolderContentTypeDocument = "DOCUMENT"

	// FolderContentTypeFolder is a FolderContentType enum value
	FolderContentTypeFolder = "FOLDER"
)

const (
	// LocaleTypeEn is a LocaleType enum value
	LocaleTypeEn = "en"

	// LocaleTypeFr is a LocaleType enum value
	LocaleTypeFr = "fr"

	// LocaleTypeKo is a LocaleType enum value
	LocaleTypeKo = "ko"

	// LocaleTypeDe is a LocaleType enum value
	LocaleTypeDe = "de"

	// LocaleTypeEs is a LocaleType enum value
	LocaleTypeEs = "es"

	// LocaleTypeJa is a LocaleType enum value
	LocaleTypeJa = "ja"

	// LocaleTypeRu is a LocaleType enum value
	LocaleTypeRu = "ru"

	// LocaleTypeZhCn is a LocaleType enum value
	LocaleTypeZhCn = "zh_CN"

	// LocaleTypeZhTw is a LocaleType enum value
	LocaleTypeZhTw = "zh_TW"

	// LocaleTypePtBr is a LocaleType enum value
	LocaleTypePtBr = "pt_BR"

	// LocaleTypeDefault is a LocaleType enum value
	LocaleTypeDefault = "default"
)

const (
	// OrderTypeAscending is a OrderType enum value
	OrderTypeAscending = "ASCENDING"

	// OrderTypeDescending is a OrderType enum value
	OrderTypeDescending = "DESCENDING"
)

const (
	// PrincipalTypeUser is a PrincipalType enum value
	PrincipalTypeUser = "USER"

	// PrincipalTypeGroup is a PrincipalType enum value
	PrincipalTypeGroup = "GROUP"

	// PrincipalTypeInvite is a PrincipalType enum value
	PrincipalTypeInvite = "INVITE"

	// PrincipalTypeAnonymous is a PrincipalType enum value
	PrincipalTypeAnonymous = "ANONYMOUS"

	// PrincipalTypeOrganization is a PrincipalType enum value
	PrincipalTypeOrganization = "ORGANIZATION"
)

const (
	// ResourceCollectionTypeSharedWithMe is a ResourceCollectionType enum value
	ResourceCollectionTypeSharedWithMe = "SHARED_WITH_ME"
)

const (
	// ResourceSortTypeDate is a ResourceSortType enum value
	ResourceSortTypeDate = "DATE"

	// ResourceSortTypeName is a ResourceSortType enum value
	ResourceSortTypeName = "NAME"
)

const (
	// ResourceStateTypeActive is a ResourceStateType enum value
	ResourceStateTypeActive = "ACTIVE"

	// ResourceStateTypeRestoring is a ResourceStateType enum value
	ResourceStateTypeRestoring = "RESTORING"

	// ResourceStateTypeRecycling is a ResourceStateType enum value
	ResourceStateTypeRecycling = "RECYCLING"

	// ResourceStateTypeRecycled is a ResourceStateType enum value
	ResourceStateTypeRecycled = "RECYCLED"
)

const (
	// ResourceTypeFolder is a ResourceType enum value
	ResourceTypeFolder = "FOLDER"

	// ResourceTypeDocument is a ResourceType enum value
	ResourceTypeDocument = "DOCUMENT"
)

const (
	// RolePermissionTypeDirect is a RolePermissionType enum value
	RolePermissionTypeDirect = "DIRECT"

	// RolePermissionTypeInherited is a RolePermissionType enum value
	RolePermissionTypeInherited = "INHERITED"
)

const (
	// RoleTypeViewer is a RoleType enum value
	RoleTypeViewer = "VIEWER"

	// RoleTypeContributor is a RoleType enum value
	RoleTypeContributor = "CONTRIBUTOR"

	// RoleTypeOwner is a RoleType enum value
	RoleTypeOwner = "OWNER"

	// RoleTypeCoowner is a RoleType enum value
	RoleTypeCoowner = "COOWNER"
)

const (
	// ShareStatusTypeSuccess is a ShareStatusType enum value
	ShareStatusTypeSuccess = "SUCCESS"

	// ShareStatusTypeFailure is a ShareStatusType enum value
	ShareStatusTypeFailure = "FAILURE"
)

const (
	// StorageTypeUnlimited is a StorageType enum value
	StorageTypeUnlimited = "UNLIMITED"

	// StorageTypeQuota is a StorageType enum value
	StorageTypeQuota = "QUOTA"
)

const (
	// SubscriptionProtocolTypeHttps is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeHttps = "HTTPS"
)

const (
	// SubscriptionTypeAll is a SubscriptionType enum value
	SubscriptionTypeAll = "ALL"
)

const (
	// UserFilterTypeAll is a UserFilterType enum value
	UserFilterTypeAll = "ALL"

	// UserFilterTypeActivePending is a UserFilterType enum value
	UserFilterTypeActivePending = "ACTIVE_PENDING"
)

const (
	// UserSortTypeUserName is a UserSortType enum value
	UserSortTypeUserName = "USER_NAME"

	// UserSortTypeFullName is a UserSortType enum value
	UserSortTypeFullName = "FULL_NAME"

	// UserSortTypeStorageLimit is a UserSortType enum value
	UserSortTypeStorageLimit = "STORAGE_LIMIT"

	// UserSortTypeUserStatus is a UserSortType enum value
	UserSortTypeUserStatus = "USER_STATUS"

	// UserSortTypeStorageUsed is a UserSortType enum value
	UserSortTypeStorageUsed = "STORAGE_USED"
)

const (
	// UserStatusTypeActive is a UserStatusType enum value
	UserStatusTypeActive = "ACTIVE"

	// UserStatusTypeInactive is a UserStatusType enum value
	UserStatusTypeInactive = "INACTIVE"

	// UserStatusTypePending is a UserStatusType enum value
	UserStatusTypePending = "PENDING"
)

const (
	// UserTypeUser is a UserType enum value
	UserTypeUser = "USER"

	// UserTypeAdmin is a UserType enum value
	UserTypeAdmin = "ADMIN"

	// UserTypePoweruser is a UserType enum value
	UserTypePoweruser = "POWERUSER"

	// UserTypeMinimaluser is a UserType enum value
	UserTypeMinimaluser = "MINIMALUSER"

	// UserTypeWorkspacesuser is a UserType enum value
	UserTypeWorkspacesuser = "WORKSPACESUSER"
)
