// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opConfigureAgent = "ConfigureAgent"

// ConfigureAgentRequest generates a "aws/request.Request" representing the
// client's request for the ConfigureAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfigureAgent for more information on using the ConfigureAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfigureAgentRequest method.
//    req, resp := client.ConfigureAgentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent
func (c *CodeGuruProfiler) ConfigureAgentRequest(input *ConfigureAgentInput) (req *request.Request, output *ConfigureAgentOutput) {
	op := &request.Operation{
		Name:       opConfigureAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/configureAgent",
	}

	if input == nil {
		input = &ConfigureAgentInput{}
	}

	output = &ConfigureAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfigureAgent API operation for Amazon CodeGuru Profiler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation ConfigureAgent for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent
func (c *CodeGuruProfiler) ConfigureAgent(input *ConfigureAgentInput) (*ConfigureAgentOutput, error) {
	req, out := c.ConfigureAgentRequest(input)
	return out, req.Send()
}

// ConfigureAgentWithContext is the same as ConfigureAgent with the addition of
// the ability to pass a context and additional request options.
//
// See ConfigureAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) ConfigureAgentWithContext(ctx aws.Context, input *ConfigureAgentInput, opts ...request.Option) (*ConfigureAgentOutput, error) {
	req, out := c.ConfigureAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfilingGroup = "CreateProfilingGroup"

// CreateProfilingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfilingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfilingGroup for more information on using the CreateProfilingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProfilingGroupRequest method.
//    req, resp := client.CreateProfilingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup
func (c *CodeGuruProfiler) CreateProfilingGroupRequest(input *CreateProfilingGroupInput) (req *request.Request, output *CreateProfilingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateProfilingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups",
	}

	if input == nil {
		input = &CreateProfilingGroupInput{}
	}

	output = &CreateProfilingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfilingGroup API operation for Amazon CodeGuru Profiler.
//
// Creates a profiling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation CreateProfilingGroup for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   You have exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html)
//   to request a service quota increase.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup
func (c *CodeGuruProfiler) CreateProfilingGroup(input *CreateProfilingGroupInput) (*CreateProfilingGroupOutput, error) {
	req, out := c.CreateProfilingGroupRequest(input)
	return out, req.Send()
}

// CreateProfilingGroupWithContext is the same as CreateProfilingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfilingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) CreateProfilingGroupWithContext(ctx aws.Context, input *CreateProfilingGroupInput, opts ...request.Option) (*CreateProfilingGroupOutput, error) {
	req, out := c.CreateProfilingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfilingGroup = "DeleteProfilingGroup"

// DeleteProfilingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfilingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfilingGroup for more information on using the DeleteProfilingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfilingGroupRequest method.
//    req, resp := client.DeleteProfilingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup
func (c *CodeGuruProfiler) DeleteProfilingGroupRequest(input *DeleteProfilingGroupInput) (req *request.Request, output *DeleteProfilingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteProfilingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profilingGroups/{profilingGroupName}",
	}

	if input == nil {
		input = &DeleteProfilingGroupInput{}
	}

	output = &DeleteProfilingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProfilingGroup API operation for Amazon CodeGuru Profiler.
//
// Deletes a profiling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation DeleteProfilingGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup
func (c *CodeGuruProfiler) DeleteProfilingGroup(input *DeleteProfilingGroupInput) (*DeleteProfilingGroupOutput, error) {
	req, out := c.DeleteProfilingGroupRequest(input)
	return out, req.Send()
}

// DeleteProfilingGroupWithContext is the same as DeleteProfilingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfilingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) DeleteProfilingGroupWithContext(ctx aws.Context, input *DeleteProfilingGroupInput, opts ...request.Option) (*DeleteProfilingGroupOutput, error) {
	req, out := c.DeleteProfilingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProfilingGroup = "DescribeProfilingGroup"

// DescribeProfilingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProfilingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProfilingGroup for more information on using the DescribeProfilingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProfilingGroupRequest method.
//    req, resp := client.DescribeProfilingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup
func (c *CodeGuruProfiler) DescribeProfilingGroupRequest(input *DescribeProfilingGroupInput) (req *request.Request, output *DescribeProfilingGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeProfilingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/profilingGroups/{profilingGroupName}",
	}

	if input == nil {
		input = &DescribeProfilingGroupInput{}
	}

	output = &DescribeProfilingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProfilingGroup API operation for Amazon CodeGuru Profiler.
//
// Describes a profiling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation DescribeProfilingGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup
func (c *CodeGuruProfiler) DescribeProfilingGroup(input *DescribeProfilingGroupInput) (*DescribeProfilingGroupOutput, error) {
	req, out := c.DescribeProfilingGroupRequest(input)
	return out, req.Send()
}

// DescribeProfilingGroupWithContext is the same as DescribeProfilingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProfilingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) DescribeProfilingGroupWithContext(ctx aws.Context, input *DescribeProfilingGroupInput, opts ...request.Option) (*DescribeProfilingGroupOutput, error) {
	req, out := c.DescribeProfilingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProfileRequest method.
//    req, resp := client.GetProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile
func (c *CodeGuruProfiler) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/profile",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for Amazon CodeGuru Profiler.
//
// Gets the aggregated profile of a profiling group for the specified time range.
// If the requested time range does not align with the available aggregated
// profiles, it is expanded to attain alignment. If aggregated profiles are
// available only for part of the period requested, the profile is returned
// from the earliest available to the latest within the requested time range.
//
// For example, if the requested time range is from 00:00 to 00:20 and the available
// profiles are from 00:15 to 00:25, the returned profile will be from 00:15
// to 00:20.
//
// You must specify exactly two of the following parameters: startTime, period,
// and endTime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation GetProfile for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile
func (c *CodeGuruProfiler) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileTimes = "ListProfileTimes"

// ListProfileTimesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileTimes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileTimes for more information on using the ListProfileTimes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProfileTimesRequest method.
//    req, resp := client.ListProfileTimesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes
func (c *CodeGuruProfiler) ListProfileTimesRequest(input *ListProfileTimesInput) (req *request.Request, output *ListProfileTimesOutput) {
	op := &request.Operation{
		Name:       opListProfileTimes,
		HTTPMethod: "GET",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/profileTimes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfileTimesInput{}
	}

	output = &ListProfileTimesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileTimes API operation for Amazon CodeGuru Profiler.
//
// List the start times of the available aggregated profiles of a profiling
// group for an aggregation period within the specified time range.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation ListProfileTimes for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes
func (c *CodeGuruProfiler) ListProfileTimes(input *ListProfileTimesInput) (*ListProfileTimesOutput, error) {
	req, out := c.ListProfileTimesRequest(input)
	return out, req.Send()
}

// ListProfileTimesWithContext is the same as ListProfileTimes with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileTimes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) ListProfileTimesWithContext(ctx aws.Context, input *ListProfileTimesInput, opts ...request.Option) (*ListProfileTimesOutput, error) {
	req, out := c.ListProfileTimesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfileTimesPages iterates over the pages of a ListProfileTimes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfileTimes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProfileTimes operation.
//    pageNum := 0
//    err := client.ListProfileTimesPages(params,
//        func(page *codeguruprofiler.ListProfileTimesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruProfiler) ListProfileTimesPages(input *ListProfileTimesInput, fn func(*ListProfileTimesOutput, bool) bool) error {
	return c.ListProfileTimesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfileTimesPagesWithContext same as ListProfileTimesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) ListProfileTimesPagesWithContext(ctx aws.Context, input *ListProfileTimesInput, fn func(*ListProfileTimesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfileTimesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfileTimesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfileTimesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfilingGroups = "ListProfilingGroups"

// ListProfilingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfilingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfilingGroups for more information on using the ListProfilingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProfilingGroupsRequest method.
//    req, resp := client.ListProfilingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups
func (c *CodeGuruProfiler) ListProfilingGroupsRequest(input *ListProfilingGroupsInput) (req *request.Request, output *ListProfilingGroupsOutput) {
	op := &request.Operation{
		Name:       opListProfilingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/profilingGroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfilingGroupsInput{}
	}

	output = &ListProfilingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfilingGroups API operation for Amazon CodeGuru Profiler.
//
// Lists profiling groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation ListProfilingGroups for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups
func (c *CodeGuruProfiler) ListProfilingGroups(input *ListProfilingGroupsInput) (*ListProfilingGroupsOutput, error) {
	req, out := c.ListProfilingGroupsRequest(input)
	return out, req.Send()
}

// ListProfilingGroupsWithContext is the same as ListProfilingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfilingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) ListProfilingGroupsWithContext(ctx aws.Context, input *ListProfilingGroupsInput, opts ...request.Option) (*ListProfilingGroupsOutput, error) {
	req, out := c.ListProfilingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfilingGroupsPages iterates over the pages of a ListProfilingGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfilingGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProfilingGroups operation.
//    pageNum := 0
//    err := client.ListProfilingGroupsPages(params,
//        func(page *codeguruprofiler.ListProfilingGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruProfiler) ListProfilingGroupsPages(input *ListProfilingGroupsInput, fn func(*ListProfilingGroupsOutput, bool) bool) error {
	return c.ListProfilingGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfilingGroupsPagesWithContext same as ListProfilingGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) ListProfilingGroupsPagesWithContext(ctx aws.Context, input *ListProfilingGroupsInput, fn func(*ListProfilingGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfilingGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfilingGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfilingGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPostAgentProfile = "PostAgentProfile"

// PostAgentProfileRequest generates a "aws/request.Request" representing the
// client's request for the PostAgentProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostAgentProfile for more information on using the PostAgentProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PostAgentProfileRequest method.
//    req, resp := client.PostAgentProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile
func (c *CodeGuruProfiler) PostAgentProfileRequest(input *PostAgentProfileInput) (req *request.Request, output *PostAgentProfileOutput) {
	op := &request.Operation{
		Name:       opPostAgentProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/agentProfile",
	}

	if input == nil {
		input = &PostAgentProfileInput{}
	}

	output = &PostAgentProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PostAgentProfile API operation for Amazon CodeGuru Profiler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation PostAgentProfile for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile
func (c *CodeGuruProfiler) PostAgentProfile(input *PostAgentProfileInput) (*PostAgentProfileOutput, error) {
	req, out := c.PostAgentProfileRequest(input)
	return out, req.Send()
}

// PostAgentProfileWithContext is the same as PostAgentProfile with the addition of
// the ability to pass a context and additional request options.
//
// See PostAgentProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) PostAgentProfileWithContext(ctx aws.Context, input *PostAgentProfileInput, opts ...request.Option) (*PostAgentProfileOutput, error) {
	req, out := c.PostAgentProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfilingGroup = "UpdateProfilingGroup"

// UpdateProfilingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfilingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfilingGroup for more information on using the UpdateProfilingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProfilingGroupRequest method.
//    req, resp := client.UpdateProfilingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup
func (c *CodeGuruProfiler) UpdateProfilingGroupRequest(input *UpdateProfilingGroupInput) (req *request.Request, output *UpdateProfilingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateProfilingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/profilingGroups/{profilingGroupName}",
	}

	if input == nil {
		input = &UpdateProfilingGroupInput{}
	}

	output = &UpdateProfilingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfilingGroup API operation for Amazon CodeGuru Profiler.
//
// Updates a profiling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Profiler's
// API operation UpdateProfilingGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup
func (c *CodeGuruProfiler) UpdateProfilingGroup(input *UpdateProfilingGroupInput) (*UpdateProfilingGroupOutput, error) {
	req, out := c.UpdateProfilingGroupRequest(input)
	return out, req.Send()
}

// UpdateProfilingGroupWithContext is the same as UpdateProfilingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfilingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruProfiler) UpdateProfilingGroupWithContext(ctx aws.Context, input *UpdateProfilingGroupInput, opts ...request.Option) (*UpdateProfilingGroupOutput, error) {
	req, out := c.UpdateProfilingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AgentConfiguration struct {
	_ struct{} `type:"structure"`

	// PeriodInSeconds is a required field
	PeriodInSeconds *int64 `locationName:"periodInSeconds" type:"integer" required:"true"`

	// ShouldProfile is a required field
	ShouldProfile *bool `locationName:"shouldProfile" type:"boolean" required:"true"`
}

// String returns the string representation
func (s AgentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentConfiguration) GoString() string {
	return s.String()
}

// SetPeriodInSeconds sets the PeriodInSeconds field's value.
func (s *AgentConfiguration) SetPeriodInSeconds(v int64) *AgentConfiguration {
	s.PeriodInSeconds = &v
	return s
}

// SetShouldProfile sets the ShouldProfile field's value.
func (s *AgentConfiguration) SetShouldProfile(v bool) *AgentConfiguration {
	s.ShouldProfile = &v
	return s
}

type AgentOrchestrationConfig struct {
	_ struct{} `type:"structure"`

	// ProfilingEnabled is a required field
	ProfilingEnabled *bool `locationName:"profilingEnabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s AgentOrchestrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentOrchestrationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentOrchestrationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AgentOrchestrationConfig"}
	if s.ProfilingEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfilingEnabled sets the ProfilingEnabled field's value.
func (s *AgentOrchestrationConfig) SetProfilingEnabled(v bool) *AgentOrchestrationConfig {
	s.ProfilingEnabled = &v
	return s
}

// Information about the time range of the latest available aggregated profile.
type AggregatedProfileTime struct {
	_ struct{} `type:"structure"`

	// The time period.
	Period *string `locationName:"period" type:"string" enum:"AggregationPeriod"`

	// The start time.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s AggregatedProfileTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregatedProfileTime) GoString() string {
	return s.String()
}

// SetPeriod sets the Period field's value.
func (s *AggregatedProfileTime) SetPeriod(v string) *AggregatedProfileTime {
	s.Period = &v
	return s
}

// SetStart sets the Start field's value.
func (s *AggregatedProfileTime) SetStart(v time.Time) *AggregatedProfileTime {
	s.Start = &v
	return s
}

// The structure representing the configureAgentRequest.
type ConfigureAgentInput struct {
	_ struct{} `type:"structure"`

	FleetInstanceId *string `locationName:"fleetInstanceId" min:"1" type:"string"`

	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfigureAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigureAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigureAgentInput"}
	if s.FleetInstanceId != nil && len(*s.FleetInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetInstanceId", 1))
	}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetInstanceId sets the FleetInstanceId field's value.
func (s *ConfigureAgentInput) SetFleetInstanceId(v string) *ConfigureAgentInput {
	s.FleetInstanceId = &v
	return s
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *ConfigureAgentInput) SetProfilingGroupName(v string) *ConfigureAgentInput {
	s.ProfilingGroupName = &v
	return s
}

// The structure representing the configureAgentResponse.
type ConfigureAgentOutput struct {
	_ struct{} `type:"structure" payload:"Configuration"`

	// Configuration is a required field
	Configuration *AgentConfiguration `locationName:"configuration" type:"structure" required:"true"`
}

// String returns the string representation
func (s ConfigureAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigureAgentOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ConfigureAgentOutput) SetConfiguration(v *AgentConfiguration) *ConfigureAgentOutput {
	s.Configuration = v
	return s
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request.
type ConflictException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConflictException) OrigErr() error {
	return nil
}

func (s ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConflictException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConflictException) RequestID() string {
	return s.respMetadata.RequestID
}

// The structure representing the createProfiliingGroupRequest.
type CreateProfilingGroupInput struct {
	_ struct{} `type:"structure"`

	// The agent orchestration configuration.
	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// This parameter specifies a unique identifier for the new profiling group
	// that helps ensure idempotency.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the profiling group.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProfilingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProfilingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfilingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfilingGroupInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.AgentOrchestrationConfig != nil {
		if err := s.AgentOrchestrationConfig.Validate(); err != nil {
			invalidParams.AddNested("AgentOrchestrationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentOrchestrationConfig sets the AgentOrchestrationConfig field's value.
func (s *CreateProfilingGroupInput) SetAgentOrchestrationConfig(v *AgentOrchestrationConfig) *CreateProfilingGroupInput {
	s.AgentOrchestrationConfig = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProfilingGroupInput) SetClientToken(v string) *CreateProfilingGroupInput {
	s.ClientToken = &v
	return s
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *CreateProfilingGroupInput) SetProfilingGroupName(v string) *CreateProfilingGroupInput {
	s.ProfilingGroupName = &v
	return s
}

// The structure representing the createProfilingGroupResponse.
type CreateProfilingGroupOutput struct {
	_ struct{} `type:"structure" payload:"ProfilingGroup"`

	// Information about the new profiling group
	//
	// ProfilingGroup is a required field
	ProfilingGroup *ProfilingGroupDescription `locationName:"profilingGroup" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateProfilingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProfilingGroupOutput) GoString() string {
	return s.String()
}

// SetProfilingGroup sets the ProfilingGroup field's value.
func (s *CreateProfilingGroupOutput) SetProfilingGroup(v *ProfilingGroupDescription) *CreateProfilingGroupOutput {
	s.ProfilingGroup = v
	return s
}

// The structure representing the deleteProfilingGroupRequest.
type DeleteProfilingGroupInput struct {
	_ struct{} `type:"structure"`

	// The profiling group name to delete.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProfilingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfilingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfilingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfilingGroupInput"}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *DeleteProfilingGroupInput) SetProfilingGroupName(v string) *DeleteProfilingGroupInput {
	s.ProfilingGroupName = &v
	return s
}

// The structure representing the deleteProfilingGroupResponse.
type DeleteProfilingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProfilingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfilingGroupOutput) GoString() string {
	return s.String()
}

// The structure representing the describeProfilingGroupRequest.
type DescribeProfilingGroupInput struct {
	_ struct{} `type:"structure"`

	// The profiling group name.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProfilingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProfilingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProfilingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProfilingGroupInput"}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *DescribeProfilingGroupInput) SetProfilingGroupName(v string) *DescribeProfilingGroupInput {
	s.ProfilingGroupName = &v
	return s
}

// The structure representing the describeProfilingGroupResponse.
type DescribeProfilingGroupOutput struct {
	_ struct{} `type:"structure" payload:"ProfilingGroup"`

	// Information about a profiling group.
	//
	// ProfilingGroup is a required field
	ProfilingGroup *ProfilingGroupDescription `locationName:"profilingGroup" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeProfilingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProfilingGroupOutput) GoString() string {
	return s.String()
}

// SetProfilingGroup sets the ProfilingGroup field's value.
func (s *DescribeProfilingGroupOutput) SetProfilingGroup(v *ProfilingGroupDescription) *DescribeProfilingGroupOutput {
	s.ProfilingGroup = v
	return s
}

// The structure representing the getProfileRequest.
type GetProfileInput struct {
	_ struct{} `type:"structure"`

	// The format of the profile to return. You can choose application/json or the
	// default application/x-amzn-ion.
	Accept *string `location:"header" locationName:"Accept" type:"string"`

	// You must specify exactly two of the following parameters: startTime, period,
	// and endTime.
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// The maximum depth of the graph.
	MaxDepth *int64 `location:"querystring" locationName:"maxDepth" min:"1" type:"integer"`

	// The period of the profile to get. The time range must be in the past and
	// not longer than one week.
	//
	// You must specify exactly two of the following parameters: startTime, period,
	// and endTime.
	Period *string `location:"querystring" locationName:"period" min:"1" type:"string"`

	// The name of the profiling group to get.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The start time of the profile to get.
	//
	// You must specify exactly two of the following parameters: startTime, period,
	// and endTime.
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileInput"}
	if s.MaxDepth != nil && *s.MaxDepth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxDepth", 1))
	}
	if s.Period != nil && len(*s.Period) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Period", 1))
	}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *GetProfileInput) SetAccept(v string) *GetProfileInput {
	s.Accept = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetProfileInput) SetEndTime(v time.Time) *GetProfileInput {
	s.EndTime = &v
	return s
}

// SetMaxDepth sets the MaxDepth field's value.
func (s *GetProfileInput) SetMaxDepth(v int64) *GetProfileInput {
	s.MaxDepth = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetProfileInput) SetPeriod(v string) *GetProfileInput {
	s.Period = &v
	return s
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *GetProfileInput) SetProfilingGroupName(v string) *GetProfileInput {
	s.ProfilingGroupName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetProfileInput) SetStartTime(v time.Time) *GetProfileInput {
	s.StartTime = &v
	return s
}

// The structure representing the getProfileResponse.
type GetProfileOutput struct {
	_ struct{} `type:"structure" payload:"Profile"`

	// The content encoding of the profile.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The content type of the profile in the payload. It is either application/json
	// or the default application/x-amzn-ion.
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" required:"true"`

	// Information about the profile.
	//
	// Profile is a required field
	Profile []byte `locationName:"profile" type:"blob" required:"true"`
}

// String returns the string representation
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *GetProfileOutput) SetContentEncoding(v string) *GetProfileOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetProfileOutput) SetContentType(v string) *GetProfileOutput {
	s.ContentType = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *GetProfileOutput) SetProfile(v []byte) *GetProfileOutput {
	s.Profile = v
	return s
}

// The server encountered an internal error and is unable to complete the request.
type InternalServerException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalServerException) OrigErr() error {
	return nil
}

func (s InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalServerException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalServerException) RequestID() string {
	return s.respMetadata.RequestID
}

// The structure representing the listProfileTimesRequest.
type ListProfileTimesInput struct {
	_ struct{} `type:"structure"`

	// The end time of the time range from which to list the profiles.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The maximum number of profile time results returned by ListProfileTimes in
	// paginated output. When this parameter is used, ListProfileTimes only returns
	// maxResults results in a single page with a nextToken response element. The
	// remaining results of the initial request can be seen by sending another ListProfileTimes
	// request with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListProfileTimes request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The order (ascending or descending by start time of the profile) to use when
	// listing profiles. Defaults to TIMESTAMP_DESCENDING.
	OrderBy *string `location:"querystring" locationName:"orderBy" type:"string" enum:"OrderBy"`

	// The aggregation period.
	//
	// Period is a required field
	Period *string `location:"querystring" locationName:"period" type:"string" required:"true" enum:"AggregationPeriod"`

	// The name of the profiling group.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The start time of the time range from which to list the profiles.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListProfileTimesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileTimesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileTimesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileTimesInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListProfileTimesInput) SetEndTime(v time.Time) *ListProfileTimesInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileTimesInput) SetMaxResults(v int64) *ListProfileTimesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileTimesInput) SetNextToken(v string) *ListProfileTimesInput {
	s.NextToken = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *ListProfileTimesInput) SetOrderBy(v string) *ListProfileTimesInput {
	s.OrderBy = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ListProfileTimesInput) SetPeriod(v string) *ListProfileTimesInput {
	s.Period = &v
	return s
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *ListProfileTimesInput) SetProfilingGroupName(v string) *ListProfileTimesInput {
	s.ProfilingGroupName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListProfileTimesInput) SetStartTime(v time.Time) *ListProfileTimesInput {
	s.StartTime = &v
	return s
}

// The structure representing the listProfileTimesResponse.
type ListProfileTimesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListProfileTimes request. When
	// the results of a ListProfileTimes request exceed maxResults, this value can
	// be used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of start times of the available profiles for the aggregation period
	// in the specified time range.
	//
	// ProfileTimes is a required field
	ProfileTimes []*ProfileTime `locationName:"profileTimes" type:"list" required:"true"`
}

// String returns the string representation
func (s ListProfileTimesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileTimesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileTimesOutput) SetNextToken(v string) *ListProfileTimesOutput {
	s.NextToken = &v
	return s
}

// SetProfileTimes sets the ProfileTimes field's value.
func (s *ListProfileTimesOutput) SetProfileTimes(v []*ProfileTime) *ListProfileTimesOutput {
	s.ProfileTimes = v
	return s
}

// The structure representing the listProfilingGroupsRequest.
type ListProfilingGroupsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to include a description.
	IncludeDescription *bool `location:"querystring" locationName:"includeDescription" type:"boolean"`

	// The maximum number of profiling groups results returned by ListProfilingGroups
	// in paginated output. When this parameter is used, ListProfilingGroups only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListProfilingGroups request with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListProfilingGroups
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfilingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfilingGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfilingGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfilingGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDescription sets the IncludeDescription field's value.
func (s *ListProfilingGroupsInput) SetIncludeDescription(v bool) *ListProfilingGroupsInput {
	s.IncludeDescription = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfilingGroupsInput) SetMaxResults(v int64) *ListProfilingGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilingGroupsInput) SetNextToken(v string) *ListProfilingGroupsInput {
	s.NextToken = &v
	return s
}

// The structure representing the listProfilingGroupsResponse.
type ListProfilingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListProfilingGroups request. When
	// the results of a ListProfilingGroups request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Information about profiling group names.
	//
	// ProfilingGroupNames is a required field
	ProfilingGroupNames []*string `locationName:"profilingGroupNames" type:"list" required:"true"`

	// Information about profiling groups.
	ProfilingGroups []*ProfilingGroupDescription `locationName:"profilingGroups" type:"list"`
}

// String returns the string representation
func (s ListProfilingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfilingGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilingGroupsOutput) SetNextToken(v string) *ListProfilingGroupsOutput {
	s.NextToken = &v
	return s
}

// SetProfilingGroupNames sets the ProfilingGroupNames field's value.
func (s *ListProfilingGroupsOutput) SetProfilingGroupNames(v []*string) *ListProfilingGroupsOutput {
	s.ProfilingGroupNames = v
	return s
}

// SetProfilingGroups sets the ProfilingGroups field's value.
func (s *ListProfilingGroupsOutput) SetProfilingGroups(v []*ProfilingGroupDescription) *ListProfilingGroupsOutput {
	s.ProfilingGroups = v
	return s
}

// The structure representing the postAgentProfileRequest.
type PostAgentProfileInput struct {
	_ struct{} `type:"structure" payload:"AgentProfile"`

	// AgentProfile is a required field
	AgentProfile []byte `locationName:"agentProfile" type:"blob" required:"true"`

	// ContentType is a required field
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" required:"true"`

	ProfileToken *string `location:"querystring" locationName:"profileToken" min:"1" type:"string" idempotencyToken:"true"`

	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PostAgentProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostAgentProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostAgentProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostAgentProfileInput"}
	if s.AgentProfile == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentProfile"))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ProfileToken != nil && len(*s.ProfileToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileToken", 1))
	}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentProfile sets the AgentProfile field's value.
func (s *PostAgentProfileInput) SetAgentProfile(v []byte) *PostAgentProfileInput {
	s.AgentProfile = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PostAgentProfileInput) SetContentType(v string) *PostAgentProfileInput {
	s.ContentType = &v
	return s
}

// SetProfileToken sets the ProfileToken field's value.
func (s *PostAgentProfileInput) SetProfileToken(v string) *PostAgentProfileInput {
	s.ProfileToken = &v
	return s
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *PostAgentProfileInput) SetProfilingGroupName(v string) *PostAgentProfileInput {
	s.ProfilingGroupName = &v
	return s
}

// The structure representing the postAgentProfileResponse.
type PostAgentProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PostAgentProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostAgentProfileOutput) GoString() string {
	return s.String()
}

// Information about the profile time.
type ProfileTime struct {
	_ struct{} `type:"structure"`

	// The start time of the profile.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ProfileTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProfileTime) GoString() string {
	return s.String()
}

// SetStart sets the Start field's value.
func (s *ProfileTime) SetStart(v time.Time) *ProfileTime {
	s.Start = &v
	return s
}

// The description of a profiling group.
type ProfilingGroupDescription struct {
	_ struct{} `type:"structure"`

	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure"`

	// The Amazon Resource Name (ARN) identifying the profiling group.
	Arn *string `locationName:"arn" type:"string"`

	// The time, in milliseconds since the epoch, when the profiling group was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the profiling group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the profiling group.
	ProfilingStatus *ProfilingStatus `locationName:"profilingStatus" type:"structure"`

	// The time, in milliseconds since the epoch, when the profiling group was last
	// updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ProfilingGroupDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProfilingGroupDescription) GoString() string {
	return s.String()
}

// SetAgentOrchestrationConfig sets the AgentOrchestrationConfig field's value.
func (s *ProfilingGroupDescription) SetAgentOrchestrationConfig(v *AgentOrchestrationConfig) *ProfilingGroupDescription {
	s.AgentOrchestrationConfig = v
	return s
}

// SetArn sets the Arn field's value.
func (s *ProfilingGroupDescription) SetArn(v string) *ProfilingGroupDescription {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ProfilingGroupDescription) SetCreatedAt(v time.Time) *ProfilingGroupDescription {
	s.CreatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProfilingGroupDescription) SetName(v string) *ProfilingGroupDescription {
	s.Name = &v
	return s
}

// SetProfilingStatus sets the ProfilingStatus field's value.
func (s *ProfilingGroupDescription) SetProfilingStatus(v *ProfilingStatus) *ProfilingGroupDescription {
	s.ProfilingStatus = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ProfilingGroupDescription) SetUpdatedAt(v time.Time) *ProfilingGroupDescription {
	s.UpdatedAt = &v
	return s
}

// Information about the profiling status.
type ProfilingStatus struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the latest agent was orchestrated.
	LatestAgentOrchestratedAt *time.Time `locationName:"latestAgentOrchestratedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The time, in milliseconds since the epoch, when the latest agent was reported..
	LatestAgentProfileReportedAt *time.Time `locationName:"latestAgentProfileReportedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The latest aggregated profile
	LatestAggregatedProfile *AggregatedProfileTime `locationName:"latestAggregatedProfile" type:"structure"`
}

// String returns the string representation
func (s ProfilingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProfilingStatus) GoString() string {
	return s.String()
}

// SetLatestAgentOrchestratedAt sets the LatestAgentOrchestratedAt field's value.
func (s *ProfilingStatus) SetLatestAgentOrchestratedAt(v time.Time) *ProfilingStatus {
	s.LatestAgentOrchestratedAt = &v
	return s
}

// SetLatestAgentProfileReportedAt sets the LatestAgentProfileReportedAt field's value.
func (s *ProfilingStatus) SetLatestAgentProfileReportedAt(v time.Time) *ProfilingStatus {
	s.LatestAgentProfileReportedAt = &v
	return s
}

// SetLatestAggregatedProfile sets the LatestAggregatedProfile field's value.
func (s *ProfilingStatus) SetLatestAggregatedProfile(v *AggregatedProfileTime) *ProfilingStatus {
	s.LatestAggregatedProfile = v
	return s
}

// The resource specified in the request does not exist.
type ResourceNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// You have exceeded your service quota. To perform the requested action, remove
// some of the relevant resources, or use Service Quotas (https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html)
// to request a service quota increase.
type ServiceQuotaExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ServiceQuotaExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ServiceQuotaExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ThrottlingException) OrigErr() error {
	return nil
}

func (s ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ThrottlingException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ThrottlingException) RequestID() string {
	return s.respMetadata.RequestID
}

// The structure representing the updateProfilingGroupRequest.
type UpdateProfilingGroupInput struct {
	_ struct{} `type:"structure"`

	// AgentOrchestrationConfig is a required field
	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure" required:"true"`

	// The name of the profiling group to update.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProfilingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProfilingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfilingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfilingGroupInput"}
	if s.AgentOrchestrationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentOrchestrationConfig"))
	}
	if s.ProfilingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.AgentOrchestrationConfig != nil {
		if err := s.AgentOrchestrationConfig.Validate(); err != nil {
			invalidParams.AddNested("AgentOrchestrationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentOrchestrationConfig sets the AgentOrchestrationConfig field's value.
func (s *UpdateProfilingGroupInput) SetAgentOrchestrationConfig(v *AgentOrchestrationConfig) *UpdateProfilingGroupInput {
	s.AgentOrchestrationConfig = v
	return s
}

// SetProfilingGroupName sets the ProfilingGroupName field's value.
func (s *UpdateProfilingGroupInput) SetProfilingGroupName(v string) *UpdateProfilingGroupInput {
	s.ProfilingGroupName = &v
	return s
}

// The structure representing the updateProfilingGroupResponse.
type UpdateProfilingGroupOutput struct {
	_ struct{} `type:"structure" payload:"ProfilingGroup"`

	// Updated information about the profiling group.
	//
	// ProfilingGroup is a required field
	ProfilingGroup *ProfilingGroupDescription `locationName:"profilingGroup" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateProfilingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProfilingGroupOutput) GoString() string {
	return s.String()
}

// SetProfilingGroup sets the ProfilingGroup field's value.
func (s *UpdateProfilingGroupOutput) SetProfilingGroup(v *ProfilingGroupDescription) *UpdateProfilingGroupOutput {
	s.ProfilingGroup = v
	return s
}

// The parameter is not valid.
type ValidationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ValidationException) OrigErr() error {
	return nil
}

func (s ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ValidationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ValidationException) RequestID() string {
	return s.respMetadata.RequestID
}

const (
	// AggregationPeriodP1d is a AggregationPeriod enum value
	AggregationPeriodP1d = "P1D"

	// AggregationPeriodPt1h is a AggregationPeriod enum value
	AggregationPeriodPt1h = "PT1H"

	// AggregationPeriodPt5m is a AggregationPeriod enum value
	AggregationPeriodPt5m = "PT5M"
)

const (
	// OrderByTimestampAscending is a OrderBy enum value
	OrderByTimestampAscending = "TimestampAscending"

	// OrderByTimestampDescending is a OrderBy enum value
	OrderByTimestampDescending = "TimestampDescending"
)
