/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.mavendeptree;

import com.jfrog.mavendeptree.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="projects", threadSafe=true)
public class MavenProjectTree
extends AbstractMojo {
    @Parameter(property="project.parentArtifact")
    private Artifact parent;
    @Parameter(property="project.artifact")
    private Artifact artifact;
    @Parameter(property="project.file")
    private File file;
    @Parameter(property="depsTreeOutputFile", readonly=true)
    private File depsTreeOutputFile;

    public void execute() throws MojoExecutionException {
        String gav = Utils.getGavString(this.artifact);
        String parentGav = Utils.getGavString(this.parent);
        String pomPath = this.file.getAbsolutePath();
        String projectInfo = String.format("{\"gav\":\"%s\",\"parentGav\":\"%s\",\"pomPath\":\"%s\"}", gav, parentGav, pomPath);
        if (this.depsTreeOutputFile == null) {
            System.out.println(projectInfo);
            return;
        }
        try (FileWriter fileWriter = new FileWriter(this.depsTreeOutputFile, true);){
            fileWriter.append(projectInfo).append(System.lineSeparator());
        }
        catch (IOException e) {
            String errorMessage = "Error writing to depsTreeOutputFile: " + e.getMessage();
            throw new MojoExecutionException(errorMessage, (Exception)e);
        }
    }
}

