/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;

public class DefaultXProcMessageListener
implements XProcMessageListener {
    private static Logger defaultLogger = Logger.getLogger("com.xmlcalabash");
    private Logger log = defaultLogger;

    @Override
    public void error(XProcRunnable xProcRunnable, XdmNode xdmNode, String string, QName qName) {
        this.log = xProcRunnable != null ? Logger.getLogger(xProcRunnable.getClass().getName()) : defaultLogger;
        this.log.severe(this.message(xProcRunnable, xdmNode, string, qName));
    }

    @Override
    public void error(Throwable throwable) {
        this.log.severe(this.exceptionMessage(throwable) + throwable.getMessage());
    }

    private String exceptionMessage(Throwable throwable) {
        Exception exception;
        StructuredQName structuredQName = null;
        SourceLocator sourceLocator = null;
        String string = "";
        if (throwable instanceof XPathException) {
            structuredQName = ((XPathException)throwable).getErrorCodeQName();
        }
        if (throwable instanceof TransformerException) {
            exception = (TransformerException)throwable;
            if (structuredQName == null && ((TransformerException)exception).getException() instanceof XPathException) {
                structuredQName = ((XPathException)((TransformerException)exception).getException()).getErrorCodeQName();
            }
            if (((TransformerException)exception).getLocator() != null) {
                sourceLocator = ((TransformerException)exception).getLocator();
                boolean bl = false;
                while (!bl && sourceLocator == null) {
                    if (((TransformerException)exception).getException() instanceof TransformerException) {
                        exception = (TransformerException)((TransformerException)exception).getException();
                        sourceLocator = ((TransformerException)exception).getLocator();
                        continue;
                    }
                    if (throwable.getCause() instanceof TransformerException) {
                        exception = (TransformerException)throwable.getCause();
                        sourceLocator = ((TransformerException)exception).getLocator();
                        continue;
                    }
                    bl = true;
                }
            }
        }
        if (throwable instanceof XProcException) {
            exception = (XProcException)throwable;
            sourceLocator = ((XProcException)exception).getLocator();
            if (((XProcException)exception).getErrorCode() != null) {
                QName qName = ((XProcException)exception).getErrorCode();
                structuredQName = new StructuredQName(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalName());
            }
            if (((XProcException)exception).getStep() != null) {
                string = string + ((XProcException)exception).getStep() + ":";
            }
        }
        if (sourceLocator != null) {
            if (sourceLocator.getSystemId() != null && !"".equals(sourceLocator.getSystemId())) {
                string = string + sourceLocator.getSystemId() + ":";
            }
            if (sourceLocator.getLineNumber() != -1) {
                string = string + sourceLocator.getLineNumber() + ":";
            }
            if (sourceLocator.getColumnNumber() != -1) {
                string = string + sourceLocator.getColumnNumber() + ":";
            }
        }
        if (structuredQName != null) {
            string = string + structuredQName.getDisplayName() + ":";
        }
        return string;
    }

    @Override
    public void warning(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.log = xProcRunnable != null ? Logger.getLogger(xProcRunnable.getClass().getName()) : defaultLogger;
        this.log.warning(this.message(xProcRunnable, xdmNode, string));
    }

    @Override
    public void warning(Throwable throwable) {
        this.log.warning(this.exceptionMessage(throwable) + throwable.getMessage());
    }

    @Override
    public void info(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.log = xProcRunnable != null ? Logger.getLogger(xProcRunnable.getClass().getName()) : defaultLogger;
        this.log.info(this.message(xProcRunnable, xdmNode, string));
    }

    @Override
    public void fine(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.log = xProcRunnable != null ? Logger.getLogger(xProcRunnable.getClass().getName()) : defaultLogger;
        this.log.fine(this.message(xProcRunnable, xdmNode, string));
    }

    @Override
    public void finer(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.log = xProcRunnable != null ? Logger.getLogger(xProcRunnable.getClass().getName()) : defaultLogger;
        this.log.finer(this.message(xProcRunnable, xdmNode, string));
    }

    @Override
    public void finest(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.log = xProcRunnable != null ? Logger.getLogger(xProcRunnable.getClass().getName()) : defaultLogger;
        this.log.finest(this.message(xProcRunnable, xdmNode, string));
    }

    private String message(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        return this.message(xProcRunnable, xdmNode, string, null);
    }

    private String message(XProcRunnable xProcRunnable, XdmNode xdmNode, String string, QName qName) {
        String string2 = "";
        if (xdmNode != null) {
            URI uRI = URIUtils.cwdAsURI();
            String string3 = uRI.relativize(xdmNode.getBaseURI()).toASCIIString();
            int n = xdmNode.getLineNumber();
            int n2 = xdmNode.getColumnNumber();
            if (string3 != null && !"".equals(string3)) {
                string2 = string2 + string3 + ":";
            }
            if (n != -1) {
                string2 = string2 + n + ":";
            }
            if (n2 != -1) {
                string2 = string2 + n2 + ":";
            }
        }
        return string2 + string;
    }
}

