package addmask

import (
	"bytes"
	"encoding/base64"
	"strings"
	"testing"
)

type memoryStore struct {
	phrases []string
}

func (s *memoryStore) List() ([]string, error) {
	return s.phrases, nil
}

func (s *memoryStore) Add(phrase string) error {
	s.phrases = append(s.phrases, phrase)
	return nil
}

func TestMasking(t *testing.T) {
	store := &memoryStore{}
	buf := new(bytes.Buffer)

	writer1, err := New(store, buf)
	if err != nil {
		t.Fatal(err)
	}

	userpass := base64.StdEncoding.EncodeToString([]byte("user:password"))

	writer1.Get(0).Write([]byte("::add-mask::simple\n"))
	writer1.Get(0).Write([]byte("::add-mask::test\r\n"))
	writer1.Get(0).Write([]byte("::add-mask::password\r\n"))
	writer1.Close()

	writer2, err := New(store, buf)
	if err != nil {
		t.Fatal(err)
	}

	writer2.Get(0).Write([]byte("thi"))
	writer2.Get(0).Write([]byte("s is a sim"))
	writer2.Get(0).Write([]byte("ple test\n"))
	writer2.Get(0).Write([]byte(userpass))
	writer2.Close()

	contents := buf.String()
	if strings.Contains(contents, "simple") {
		t.Errorf("contents %q contained the work 'simple'", contents)
	}
	if strings.Contains(contents, "test") {
		t.Errorf("contents %q contained the work 'test'", contents)
	}
	if strings.Contains(contents, "password") {
		t.Errorf("contents %q contained the work 'password'", contents)
	}
	if strings.Contains(contents, userpass) {
		t.Errorf("contents %q contained the work %q", contents, userpass)
	}
}
