// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.27.0
// source: query.sql

package nix_v10

import (
	"context"
	"database/sql"
)

const addDerivationOutput = `-- name: AddDerivationOutput :exec
insert or replace into DerivationOutputs (drv, id, path) values (?, ?, ?)
`

type AddDerivationOutputParams struct {
	Drv  int64
	ID   string
	Path string
}

func (q *Queries) AddDerivationOutput(ctx context.Context, arg AddDerivationOutputParams) error {
	_, err := q.db.ExecContext(ctx, addDerivationOutput, arg.Drv, arg.ID, arg.Path)
	return err
}

const addReference = `-- name: AddReference :exec
insert or replace into Refs (referrer, reference) values (?, ?)
`

type AddReferenceParams struct {
	Referrer  int64
	Reference int64
}

func (q *Queries) AddReference(ctx context.Context, arg AddReferenceParams) error {
	_, err := q.db.ExecContext(ctx, addReference, arg.Referrer, arg.Reference)
	return err
}

const invalidatePath = `-- name: InvalidatePath :exec
delete from ValidPaths where path = ?
`

func (q *Queries) InvalidatePath(ctx context.Context, path string) error {
	_, err := q.db.ExecContext(ctx, invalidatePath, path)
	return err
}

const queryDerivationOutputs = `-- name: QueryDerivationOutputs :many
select id, path from DerivationOutputs where drv = ?
`

type QueryDerivationOutputsRow struct {
	ID   string
	Path string
}

func (q *Queries) QueryDerivationOutputs(ctx context.Context, drv int64) ([]QueryDerivationOutputsRow, error) {
	rows, err := q.db.QueryContext(ctx, queryDerivationOutputs, drv)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []QueryDerivationOutputsRow
	for rows.Next() {
		var i QueryDerivationOutputsRow
		if err := rows.Scan(&i.ID, &i.Path); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const queryPathFromHashPart = `-- name: QueryPathFromHashPart :one
select path from ValidPaths where path >= ? limit 1
`

func (q *Queries) QueryPathFromHashPart(ctx context.Context, path string) (string, error) {
	row := q.db.QueryRowContext(ctx, queryPathFromHashPart, path)
	err := row.Scan(&path)
	return path, err
}

const queryPathInfo = `-- name: QueryPathInfo :one
select id, hash, registrationTime, deriver, narSize, ultimate, sigs, ca from ValidPaths where path = ?
`

type QueryPathInfoRow struct {
	ID               int64
	Hash             string
	Registrationtime int64
	Deriver          sql.NullString
	Narsize          sql.NullInt64
	Ultimate         sql.NullInt64
	Sigs             sql.NullString
	Ca               sql.NullString
}

func (q *Queries) QueryPathInfo(ctx context.Context, path string) (QueryPathInfoRow, error) {
	row := q.db.QueryRowContext(ctx, queryPathInfo, path)
	var i QueryPathInfoRow
	err := row.Scan(
		&i.ID,
		&i.Hash,
		&i.Registrationtime,
		&i.Deriver,
		&i.Narsize,
		&i.Ultimate,
		&i.Sigs,
		&i.Ca,
	)
	return i, err
}

const queryReferences = `-- name: QueryReferences :many
select path from Refs join ValidPaths on reference = id where referrer = ?
`

func (q *Queries) QueryReferences(ctx context.Context, referrer int64) ([]string, error) {
	rows, err := q.db.QueryContext(ctx, queryReferences, referrer)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []string
	for rows.Next() {
		var path string
		if err := rows.Scan(&path); err != nil {
			return nil, err
		}
		items = append(items, path)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const queryReferrers = `-- name: QueryReferrers :many
select path from Refs join ValidPaths on referrer = id where reference = (select vp.id from ValidPaths as vp where vp.path = ?)
`

func (q *Queries) QueryReferrers(ctx context.Context, path string) ([]string, error) {
	rows, err := q.db.QueryContext(ctx, queryReferrers, path)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []string
	for rows.Next() {
		var path string
		if err := rows.Scan(&path); err != nil {
			return nil, err
		}
		items = append(items, path)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const queryValidDerivers = `-- name: QueryValidDerivers :many
select v.id, v.path from DerivationOutputs d join ValidPaths v on d.drv = v.id where d.path = ?
`

type QueryValidDeriversRow struct {
	ID   int64
	Path string
}

func (q *Queries) QueryValidDerivers(ctx context.Context, path string) ([]QueryValidDeriversRow, error) {
	rows, err := q.db.QueryContext(ctx, queryValidDerivers, path)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []QueryValidDeriversRow
	for rows.Next() {
		var i QueryValidDeriversRow
		if err := rows.Scan(&i.ID, &i.Path); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const registerValidPath = `-- name: RegisterValidPath :exec
insert into ValidPaths (path, hash, registrationTime, deriver, narSize, ultimate, sigs, ca)
values (?, ?, ?, ?, ?, ?, ?, ?)
`

type RegisterValidPathParams struct {
	Path             string
	Hash             string
	Registrationtime int64
	Deriver          sql.NullString
	Narsize          sql.NullInt64
	Ultimate         sql.NullInt64
	Sigs             sql.NullString
	Ca               sql.NullString
}

func (q *Queries) RegisterValidPath(ctx context.Context, arg RegisterValidPathParams) error {
	_, err := q.db.ExecContext(ctx, registerValidPath,
		arg.Path,
		arg.Hash,
		arg.Registrationtime,
		arg.Deriver,
		arg.Narsize,
		arg.Ultimate,
		arg.Sigs,
		arg.Ca,
	)
	return err
}

const updatePathInfo = `-- name: UpdatePathInfo :exec
update ValidPaths set narSize = ?, hash = ?, ultimate = ?, sigs = ?, ca = ? where path = ?
`

type UpdatePathInfoParams struct {
	Narsize  sql.NullInt64
	Hash     string
	Ultimate sql.NullInt64
	Sigs     sql.NullString
	Ca       sql.NullString
	Path     string
}

func (q *Queries) UpdatePathInfo(ctx context.Context, arg UpdatePathInfoParams) error {
	_, err := q.db.ExecContext(ctx, updatePathInfo,
		arg.Narsize,
		arg.Hash,
		arg.Ultimate,
		arg.Sigs,
		arg.Ca,
		arg.Path,
	)
	return err
}
