//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2_core_foundation::*;

use crate::*;

#[cfg(feature = "SCPreferences")]
impl SCPreferences {
    /// Creates a new path component within the dictionary
    /// hierarchy.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `prefix`: A string that represents the parent path.
    ///
    /// Returns: Returns a string representing the new (unique) child path; NULL
    /// if the specified path does not exist.
    #[doc(alias = "SCPreferencesPathCreateUniqueChild")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn path_create_unique_child(&self, prefix: &CFString) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCPreferencesPathCreateUniqueChild(
                prefs: &SCPreferences,
                prefix: &CFString,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCPreferencesPathCreateUniqueChild(self, prefix) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the dictionary associated with the specified
    /// path.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `path`: A string that represents the path to be returned.
    ///
    /// Returns: Returns the dictionary associated with the specified path; NULL
    /// if the path does not exist.
    #[doc(alias = "SCPreferencesPathGetValue")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn path_get_value(&self, path: &CFString) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCPreferencesPathGetValue(
                prefs: &SCPreferences,
                path: &CFString,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCPreferencesPathGetValue(self, path) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the link (if one exists) associated with the
    /// specified path.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `path`: A string that represents the path to be returned.
    ///
    /// Returns: Returns the dictionary associated with the specified path; NULL
    /// if the path is not a link or does not exist.
    #[doc(alias = "SCPreferencesPathGetLink")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn path_get_link(&self, path: &CFString) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCPreferencesPathGetLink(
                prefs: &SCPreferences,
                path: &CFString,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCPreferencesPathGetLink(self, path) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Associates a dictionary with the specified path.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `path`: A string that represents the path to be updated.
    ///
    /// Parameter `value`: A dictionary that represents the data to be
    /// stored at the specified path.
    ///
    /// Returns: Returns TRUE if successful; FALSE otherwise.
    ///
    /// # Safety
    ///
    /// `value` generics must be of the correct type.
    #[doc(alias = "SCPreferencesPathSetValue")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub unsafe fn path_set_value(&self, path: &CFString, value: &CFDictionary) -> bool {
        extern "C-unwind" {
            fn SCPreferencesPathSetValue(
                prefs: &SCPreferences,
                path: &CFString,
                value: &CFDictionary,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesPathSetValue(self, path, value) };
        ret != 0
    }

    /// Associates a link to a second dictionary at the
    /// specified path.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `path`: A string that represents the path to be updated.
    ///
    /// Parameter `link`: A string that represents the link to be stored
    /// at the specified path.
    ///
    /// Returns: Returns TRUE if successful; FALSE otherwise.
    #[doc(alias = "SCPreferencesPathSetLink")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn path_set_link(&self, path: &CFString, link: &CFString) -> bool {
        extern "C-unwind" {
            fn SCPreferencesPathSetLink(
                prefs: &SCPreferences,
                path: &CFString,
                link: &CFString,
            ) -> Boolean;
        }
        let ret = unsafe { SCPreferencesPathSetLink(self, path, link) };
        ret != 0
    }

    /// Removes the data associated with the specified path.
    ///
    /// Parameter `prefs`: The preferences session.
    ///
    /// Parameter `path`: A string that represents the path to be returned.
    ///
    /// Returns: Returns TRUE if successful; FALSE otherwise.
    #[doc(alias = "SCPreferencesPathRemoveValue")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn path_remove_value(&self, path: &CFString) -> bool {
        extern "C-unwind" {
            fn SCPreferencesPathRemoveValue(prefs: &SCPreferences, path: &CFString) -> Boolean;
        }
        let ret = unsafe { SCPreferencesPathRemoveValue(self, path) };
        ret != 0
    }
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCPreferences::path_create_unique_child`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesPathCreateUniqueChild(
    prefs: &SCPreferences,
    prefix: &CFString,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCPreferencesPathCreateUniqueChild(
            prefs: &SCPreferences,
            prefix: &CFString,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCPreferencesPathCreateUniqueChild(prefs, prefix) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCPreferences::path_get_value`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesPathGetValue(
    prefs: &SCPreferences,
    path: &CFString,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCPreferencesPathGetValue(
            prefs: &SCPreferences,
            path: &CFString,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCPreferencesPathGetValue(prefs, path) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCPreferences::path_get_link`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesPathGetLink(
    prefs: &SCPreferences,
    path: &CFString,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCPreferencesPathGetLink(
            prefs: &SCPreferences,
            path: &CFString,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCPreferencesPathGetLink(prefs, path) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCPreferences::path_set_value`"]
#[inline]
pub unsafe extern "C-unwind" fn SCPreferencesPathSetValue(
    prefs: &SCPreferences,
    path: &CFString,
    value: &CFDictionary,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesPathSetValue(
            prefs: &SCPreferences,
            path: &CFString,
            value: &CFDictionary,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesPathSetValue(prefs, path, value) };
    ret != 0
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCPreferences::path_set_link`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesPathSetLink(
    prefs: &SCPreferences,
    path: &CFString,
    link: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesPathSetLink(
            prefs: &SCPreferences,
            path: &CFString,
            link: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCPreferencesPathSetLink(prefs, path, link) };
    ret != 0
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCPreferences::path_remove_value`"]
#[inline]
pub extern "C-unwind" fn SCPreferencesPathRemoveValue(
    prefs: &SCPreferences,
    path: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCPreferencesPathRemoveValue(prefs: &SCPreferences, path: &CFString) -> Boolean;
    }
    let ret = unsafe { SCPreferencesPathRemoveValue(prefs, path) };
    ret != 0
}
