/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.FallbackJnaMppImpls;
import com.github.ajalt.mordant.internal.JnaMppImpls;
import com.github.ajalt.mordant.internal.JvmTerminalCursor;
import com.github.ajalt.mordant.internal.LinuxMppImpls;
import com.github.ajalt.mordant.internal.MacosMppImpls;
import com.github.ajalt.mordant.internal.Win32MppImpls;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.io.Console;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.ConsoleKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0013H\u0000\u001a\b\u0010\u0016\u001a\u00020\u0013H\u0000\u001a&\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u001a\b\u0010\u001f\u001a\u00020\u0013H\u0000\u001a\b\u0010 \u001a\u00020\u0013H\u0000\u001a\b\u0010!\u001a\u00020\u0013H\u0000\u001a\"\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&H\u0080\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"impls", "Lcom/github/ajalt/mordant/internal/JnaMppImpls;", "codepointSequence", "Lkotlin/sequences/Sequence;", "", "string", "", "getEnv", "key", "getTerminalSize", "Lkotlin/Pair;", "makePrintingTerminalCursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "printStderr", "", "message", "newline", "", "readLineOrNullMpp", "hideInput", "runningInIdeaJavaAgent", "sendInterceptedPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "stderrInteractive", "stdinInteractive", "stdoutInteractive", "synchronizeJvm", "lock", "", "block", "Lkotlin/Function0;", "mordant"})
@SourceDebugExtension(value={"SMAP\nMppImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppImpl.kt\ncom/github/ajalt/mordant/internal/MppImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1747#2,3:108\n1789#2,3:111\n*S KotlinDebug\n*F\n+ 1 MppImpl.kt\ncom/github/ajalt/mordant/internal/MppImplKt\n*L\n28#1:108,3\n89#1:111,3\n*E\n"})
public final class MppImplKt {
    @NotNull
    private static final JnaMppImpls impls;

    @Nullable
    public static final String getEnv(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getenv(key);
    }

    public static final boolean runningInIdeaJavaAgent() {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = bean.getInputArguments();
                Intrinsics.checkNotNullExpressionValue(jvmArgs, "jvmArgs");
                Iterable $this$any$iv = jvmArgs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue(it, "it");
                        if (!(StringsKt.startsWith$default(it, "-javaagent", false, 2, null) && StringsKt.contains$default((CharSequence)it, "idea_rt.jar", false, 2, null))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Sequence<Integer> codepointSequence(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt, "string.codePoints().iterator()");
        return SequencesKt.asSequence(ofInt);
    }

    public static final void printStderr(@NotNull String message, boolean newline) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (newline) {
            System.err.println(message);
        } else {
            System.err.print(message);
        }
    }

    @Nullable
    public static final String readLineOrNullMpp(boolean hideInput) {
        Console console;
        if (hideInput && (console = System.console()) != null) {
            char[] cArray = console.readPassword();
            Intrinsics.checkNotNullExpressionValue(cArray, "console.readPassword()");
            return StringsKt.concatToString(cArray);
        }
        return ConsoleKt.readlnOrNull();
    }

    @NotNull
    public static final TerminalCursor makePrintingTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        return new JvmTerminalCursor(terminal);
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendInterceptedPrintRequest(@NotNull PrintRequest request2, @NotNull TerminalInterface terminalInterface, @NotNull List<? extends TerminalInterceptor> interceptors) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(request2, "request");
        Intrinsics.checkNotNullParameter(terminalInterface, "terminalInterface");
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        Iterable iterable = interceptors;
        TerminalInterface terminalInterface2 = terminalInterface;
        boolean $i$f$fold = false;
        PrintRequest accumulator$iv = request2;
        for (Object element$iv : $this$fold$iv) {
            void it;
            TerminalInterceptor terminalInterceptor = (TerminalInterceptor)element$iv;
            PrintRequest acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = it.intercept(acc);
        }
        terminalInterface2.completePrintRequest(accumulator$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void synchronizeJvm(@NotNull Object lock, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(lock, "lock");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$synchronizeJvm = false;
        Object object = lock;
        synchronized (object) {
            try {
                Unit unit = block.invoke();
            }
            finally {
                InlineMarker.finallyStart(1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd(1);
            }
            return;
        }
    }

    public static final boolean stdoutInteractive() {
        return impls.stdoutInteractive();
    }

    public static final boolean stdinInteractive() {
        return impls.stdinInteractive();
    }

    public static final boolean stderrInteractive() {
        return impls.stderrInteractive();
    }

    @Nullable
    public static final Pair<Integer, Integer> getTerminalSize() {
        return impls.getTerminalSize();
    }

    static {
        String os = System.getProperty("os.name");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue(os, "os");
        impls = StringsKt.startsWith$default(os, "Windows", false, 2, null) ? (JnaMppImpls)new Win32MppImpls() : (Intrinsics.areEqual(os, "Linux") ? (JnaMppImpls)new LinuxMppImpls() : (Intrinsics.areEqual(os, "Mac OS X") ? (JnaMppImpls)new MacosMppImpls() : (JnaMppImpls)new FallbackJnaMppImpls()));
    }
}

