#!/bin/sh

pesettings=`finddir B_USER_SETTINGS_DIRECTORY`/pe/settings

fgmap=(
"alt comment:"
"alt error:"
"alt keyword:"
"alt number:"
"alt operator:"
"alt separator:"
"altprocessor:"
"attribute:"
"char constant:html-entity"
"comment:comment html-comment"
"error:"
"highlight:highlight"
"invisibles:"
"keyword:keyword preprocess"
"low:window-border"
"mark:status"
"number:number"
"operator:function"
"preprocessor:"
"selection:selection"
"separator:"
"string:string string-q html-string"
"system identifier:type"
"tag:tag"
"tagstring:html-tag"
"text:default mode-line minibuf"
"user identifier:variable"
)

bgmap=(
"low:default"
"selection:mode-line window-border region-hilite"
)

map_pe_fg () {
	for item in "${fgmap[@]}"; do
		if [ "$1" = "${item%:*}" ]; then
			echo "${item#*:}"
			return
		fi
	done
}

map_pe_bg () {
	for item in "${bgmap[@]}"; do
		if [ "$1" = "${item%:*}" ]; then
			echo "${item#*:}"
			return
		fi
	done
}

out_style () {
	echo "set_style(\"$1\", \"$2\", \"$3\")"
}

echo "// map Pe settings to QEmacs"
echo "// generated by $(basename "$0") on `date`"

while read line; do
	token="${line%=*}"
	value="${line#*=}"
	case "$token" in
		*color)
			name="${token% color}"
			qenames="$(map_pe_fg "$name")"
			for qename in ${qenames}; do
				#echo "color: $name -> $qename" >&2
				out_style "$qename" "color" "$value"
			done
			qenames="$(map_pe_bg "$name")"
			for qename in ${qenames}; do
				#echo "bgcolor: $name -> $qename" >&2
				out_style "$qename" "background-color" "$value"
			done
			;;
		*)
			;;
	esac
done < "$pesettings"
