/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.provider;

import java.security.AccessController;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.d;

public final class TransitionMode {
    public static final String JCE_MODE_SECURITY_PROPERTY = "oracle.security.crypto.jce.mode";
    public static final String JCE_MODE_DISABLED = "disabled";
    public static final String JCE_MODE_ENABLED = "enabled";
    public static final String JCE_MODE_EXCLUSIVE = "exclusive";
    public static final String JCE_MODE_FIPS140 = "fips140";
    private static boolean a = false;
    private static boolean b = false;
    private static boolean c = false;

    public static synchronized void enableJCEUse() {
        a = true;
    }

    public static synchronized boolean isJCEUseEnabled() {
        return a;
    }

    public static synchronized void disableOSDTCrypto() {
        TransitionMode.enableJCEUse();
        b = true;
    }

    public static synchronized boolean isOSDTCryptoDisabled() {
        return b;
    }

    private static synchronized void a() {
        c = true;
    }

    public static void enableFIPS140Mode() {
        TransitionMode.disableOSDTCrypto();
        if (!TransitionMode.isFIPS140ModeEnabled()) {
            TransitionMode.a();
            JCEUtil.a();
        }
    }

    public static synchronized boolean isFIPS140ModeEnabled() {
        return c;
    }

    public static synchronized void checkCryptoCoreUseAllowed() {
        if (b) {
            throw new IllegalStateException("OSDT internal cryptographic module has been disabled");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 0) {
            System.exit(1);
        }
        if (TransitionMode.isFIPS140ModeEnabled()) {
            System.out.println(JCE_MODE_FIPS140);
        } else if (TransitionMode.isOSDTCryptoDisabled()) {
            System.out.println(JCE_MODE_EXCLUSIVE);
        } else if (TransitionMode.isJCEUseEnabled()) {
            System.out.println(JCE_MODE_ENABLED);
        } else {
            System.out.println(JCE_MODE_DISABLED);
        }
    }

    static {
        String string = AccessController.doPrivileged(new d());
        if (string != null) {
            if (string.equalsIgnoreCase(JCE_MODE_ENABLED)) {
                TransitionMode.enableJCEUse();
            } else if (string.equalsIgnoreCase(JCE_MODE_EXCLUSIVE)) {
                TransitionMode.disableOSDTCrypto();
            } else if (string.equalsIgnoreCase(JCE_MODE_FIPS140)) {
                TransitionMode.enableFIPS140Mode();
            }
        }
    }
}

