/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.extensions.CompileModuleOptions;
import org.javamodularity.moduleplugin.internal.CompileModuleInfoHelper;
import org.javamodularity.moduleplugin.tasks.AbstractCompileTask;
import org.javamodularity.moduleplugin.tasks.CompileJavaTaskMutator;

public class CompileModuleInfoTask
extends AbstractCompileTask {
    public CompileModuleInfoTask(Project project) {
        super(project);
    }

    public void configureCompileModuleInfoJava() {
        this.helper().findTask("compileJava", JavaCompile.class).ifPresent(this::configureCompileModuleInfoJava);
    }

    private void configureCompileModuleInfoJava(JavaCompile compileJava) {
        CompileModuleOptions moduleOptions = (CompileModuleOptions)compileJava.getExtensions().getByType(CompileModuleOptions.class);
        this.project.afterEvaluate(p -> {
            if (moduleOptions.getCompileModuleInfoSeparately()) {
                this.configureModularityForCompileModuleInfoJava(compileJava, moduleOptions);
            }
        });
    }

    void configureModularityForCompileModuleInfoJava(JavaCompile compileJava, CompileModuleOptions moduleOptions) {
        final JavaCompile compileModuleInfoJava = this.preconfigureCompileModuleInfoJava(compileJava);
        CompileModuleInfoHelper.dependOnOtherCompileModuleInfoJavaTasks(compileModuleInfoJava);
        final CompileJavaTaskMutator mutator = this.createCompileJavaTaskMutator(compileJava, moduleOptions);
        compileModuleInfoJava.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                mutator.modularizeJavaCompileTask(compileModuleInfoJava);
            }
        });
        this.project.getTasks().withType(Jar.class).configureEach((Action)new Action<Jar>(){

            public void execute(Jar jar) {
                final File moduleInfoDir = CompileModuleInfoTask.this.helper().getModuleInfoDir();
                jar.from(new Object[]{moduleInfoDir});
                jar.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        File classesDir = GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) >= 0 ? ((Directory)CompileModuleInfoTask.this.helper().mainSourceSet().getJava().getClassesDirectory().get()).getAsFile() : CompileModuleInfoTask.this.helper().mainSourceSet().getJava().getOutputDir();
                        File mainModuleInfoFile = new File(classesDir, "module-info.class");
                        File customModuleInfoFile = new File(moduleInfoDir, "module-info.class");
                        if (mainModuleInfoFile.isFile() && customModuleInfoFile.isFile()) {
                            mainModuleInfoFile.delete();
                        }
                    }
                });
            }
        });
    }

    private JavaCompile preconfigureCompileModuleInfoJava(JavaCompile compileJava) {
        JavaCompile compileModuleInfoJava = this.helper().compileJavaTask("compileModuleInfoJava");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            compileModuleInfoJava.getModularity().getInferModulePath().set((Object)false);
        }
        compileModuleInfoJava.setClasspath((FileCollection)this.project.files(new Object[0]));
        compileModuleInfoJava.setSource((Object)this.pathToModuleInfoJava());
        compileModuleInfoJava.getOptions().setSourcepath((FileCollection)this.project.files(new Object[]{this.pathToModuleInfoJava().getParent()}));
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) >= 0) {
            compileModuleInfoJava.getDestinationDirectory().set(this.helper().getModuleInfoDir());
        } else {
            compileModuleInfoJava.setDestinationDir(this.helper().getModuleInfoDir());
        }
        compileModuleInfoJava.dependsOn(new Object[]{compileJava});
        this.helper().task("classes").dependsOn(new Object[]{compileModuleInfoJava});
        return compileModuleInfoJava;
    }

    private Path pathToModuleInfoJava() {
        return this.helper().mainSourceSet().getJava().getSrcDirs().stream().map(srcDir -> srcDir.toPath().resolve("module-info.java")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IllegalStateException("module-info.java not found"));
    }
}

