/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.JavaCompile;
import org.javamodularity.moduleplugin.JavaProjectHelper;
import org.javamodularity.moduleplugin.extensions.CompileModuleOptions;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.internal.MutatorHelper;
import org.javamodularity.moduleplugin.tasks.MergeClassesHelper;

class CompileJavaTaskMutator {
    private static final Logger LOGGER = Logging.getLogger(CompileJavaTaskMutator.class);
    private final Project project;
    private final FileCollection compileJavaClasspath;
    private final CompileModuleOptions moduleOptions;

    CompileJavaTaskMutator(Project project, FileCollection compileJavaClasspath, CompileModuleOptions moduleOptions) {
        this.project = project;
        this.compileJavaClasspath = compileJavaClasspath;
        this.moduleOptions = moduleOptions;
    }

    void modularizeJavaCompileTask(JavaCompile javaCompile) {
        List<String> compilerArgs = this.buildCompilerArgs(javaCompile);
        javaCompile.getOptions().setCompilerArgs(compilerArgs);
        LOGGER.info("compiler args for task {}: {}", (Object)javaCompile.getName(), (Object)javaCompile.getOptions().getAllCompilerArgs());
        javaCompile.setClasspath((FileCollection)this.project.files(new Object[0]));
        this.configureSourcepath(javaCompile);
    }

    private void configureSourcepath(JavaCompile javaCompile) {
        ConfigurableFileCollection sourcePaths = this.project.files(new Object[]{this.helper().mainSourceSet().getJava().getSrcDirs()});
        javaCompile.getOptions().setSourcepath((FileCollection)sourcePaths);
    }

    private List<String> buildCompilerArgs(JavaCompile javaCompile) {
        PatchModuleContainer patchModuleContainer = PatchModuleContainer.copyOf(this.helper().modularityExtension().optionContainer().getPatchModuleContainer());
        String moduleName = this.helper().moduleName();
        new MergeClassesHelper(this.project).otherCompileTaskStream().map(MergeClassesHelper.CompileTaskWrapper::getDestinationDir).forEach(dir -> patchModuleContainer.addDir(moduleName, dir.getAbsolutePath()));
        ConfigurableFileCollection filteredClasspath = this.project.files(this.compileJavaClasspath.getFiles().stream().filter(f -> f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".jmod")).collect(Collectors.toList()).toArray());
        ArrayList<String> compilerArgs = new ArrayList<String>(javaCompile.getOptions().getCompilerArgs());
        patchModuleContainer.buildModulePathOption((FileCollection)filteredClasspath).ifPresent(option -> option.mutateArgs(compilerArgs));
        patchModuleContainer.mutator((FileCollection)filteredClasspath).mutateArgs(compilerArgs);
        this.moduleOptions.mutateArgs(compilerArgs);
        MutatorHelper.configureModuleVersion(this.helper(), compilerArgs);
        return compilerArgs;
    }

    private JavaProjectHelper helper() {
        return new JavaProjectHelper(this.project);
    }
}

