"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Markdown = void 0;
var react_1 = __importDefault(require("react"));
var isomorphic_dompurify_1 = require("isomorphic-dompurify");
var helpers_1 = require("../helpers");
var Markdown = function (_a) {
    var children = _a.children;
    if (!children) {
        return null;
    }
    if (typeof children !== 'string') {
        return react_1.default.createElement(react_1.default.Fragment, null, children);
    }
    return (react_1.default.createElement("div", { className: "prose max-w-none text-sm", dangerouslySetInnerHTML: { __html: (0, isomorphic_dompurify_1.sanitize)((0, helpers_1.renderMarkdown)(children)) } }));
};
exports.Markdown = Markdown;
//# sourceMappingURL=Markdown.js.map