/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0001*\u00020\u00042\u00020\u0005B%\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/base/introspector/SchemaPortion;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "", "database", "schemas", "", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "<init>", "(Lcom/intellij/database/model/basic/BasicDatabase;Ljava/util/List;Lcom/intellij/database/introspection/IntrospectionMode;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/model/basic/BasicDatabase;", "getSchemas", "()Ljava/util/List;", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "size", "", "getSize", "()I", "brief", "", "getBrief", "()Ljava/lang/String;", "suffices", "", "toString", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseIntrospectionFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/SchemaPortion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,472:1\n1#2:473\n*E\n"})
public class SchemaPortion<D extends BasicDatabase, S extends BasicSchema> {
    @NotNull
    private final D database;
    @NotNull
    private final List<S> schemas;
    @NotNull
    private final IntrospectionMode mode;

    public SchemaPortion(@NotNull D database, @NotNull List<? extends S> schemas, @NotNull IntrospectionMode mode) {
        boolean bl;
        Intrinsics.checkNotNullParameter(database, (String)"database");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.database = database;
        this.schemas = schemas;
        this.mode = mode;
        boolean bl2 = bl = !((Collection)this.schemas).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The list of schemas must not be empty";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final D getDatabase() {
        return this.database;
    }

    @NotNull
    public final List<S> getSchemas() {
        return this.schemas;
    }

    @NotNull
    public final IntrospectionMode getMode() {
        return this.mode;
    }

    public final int getSize() {
        return this.schemas.size();
    }

    @NotNull
    public String getBrief() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_brief__u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_brief__u24lambda_u242.append("Portion of ").append(this.getSize()).append(' ').append(StringUtil.pluralize((String)"schema", (int)this.getSize()));
        StringBuilder stringBuilder2 = $this$_get_brief__u24lambda_u242.append(" (");
        String string = this.mode.code;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
        String string2 = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        stringBuilder2.append(string3).append(')');
        CharSequence charSequence = this.suffices();
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl2 = false;
            $this$_get_brief__u24lambda_u242.append(',').append(it);
        }
        $this$_get_brief__u24lambda_u242.append(')');
        return stringBuilder.toString();
    }

    @Nullable
    public CharSequence suffices() {
        return null;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u244.append(this.getBrief());
        $this$toString_u24lambda_u244.append(": ");
        CollectionsKt.joinTo$default((Iterable)this.schemas, (Appendable)$this$toString_u24lambda_u244, (CharSequence)",", null, null, (int)0, null, SchemaPortion::toString$lambda$4$lambda$3, (int)60, null);
        return stringBuilder.toString();
    }

    private static final CharSequence toString$lambda$4$lambda$3(BasicSchema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

