/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.config;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/settingsSync/core/config/RoundedBorderLayoutPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "hgap", "", "vgap", "backgroundColor", "Ljava/awt/Color;", "borderOffset", "borderColor", "borderThickness", "cornerRadius", "<init>", "(IILjava/awt/Color;ILjava/awt/Color;II)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.settingsSync.core"})
public final class RoundedBorderLayoutPanel
extends BorderLayoutPanel {
    @NotNull
    private final Color borderColor;
    private final int borderThickness;
    private final int cornerRadius;

    public RoundedBorderLayoutPanel(int hgap, int vgap, @NotNull Color backgroundColor, int borderOffset, @NotNull Color borderColor, int borderThickness, int cornerRadius) {
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        super(hgap, vgap);
        this.borderColor = borderColor;
        this.borderThickness = borderThickness;
        this.cornerRadius = cornerRadius;
        this.setOpaque(true);
        this.setBackground(backgroundColor);
        this.setBorder(JBUI.Borders.empty((int)borderOffset));
    }

    public /* synthetic */ RoundedBorderLayoutPanel(int n, int n2, Color color, int n3, Color color2, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 12;
        }
        this(n, n2, color, n3, color2, n4, n5);
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int scaledCornerRadius = JBUI.scale((int)this.cornerRadius);
        int scaledBorderThickness = JBUI.scale((int)this.borderThickness);
        g.setColor(this.getBackground());
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), scaledCornerRadius, scaledCornerRadius);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.borderColor);
        g2d.setStroke(new BasicStroke(scaledBorderThickness, 1, 1));
        g2d.drawRoundRect(0, 0, this.getWidth() - scaledBorderThickness, this.getHeight() - scaledBorderThickness, scaledCornerRadius, scaledCornerRadius);
        config.restore();
    }
}

