/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassExtensionFunctionDocumentationProvider
implements DocumentationProvider {
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof CssFunction && element.getContainingFile() instanceof SassScssStylesheetFile) {
            for (PsiReference reference : element.getReferences()) {
                Collection<SassExtensionFunctionInfo> functionInfos;
                SassExtensionFunctionInfo function;
                PsiElement realElement;
                Module module;
                PsiElement resultResult = reference.resolve();
                if (!(reference instanceof SassScssFunctionReference) || resultResult != element && resultResult != null && SassExtensionFunctionDocumentationProvider.isSassScssLanguage(resultResult.getLanguage()) || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(realElement = originalElement != null ? originalElement : element))) == null || (function = (SassExtensionFunctionInfo)ContainerUtil.getFirstItem(functionInfos = SassExtension.findExtensionFunctionInfos(((CssFunction)element).getName(), originalElement, module))) == null) continue;
                return function.getDocumentation();
            }
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (SassRubyIntegrationHelper.getInstance().isSassExtensionLookupObject(object) && element != null && element.getContainingFile() instanceof SassScssStylesheetFile) {
            String name = object instanceof SassExtensionFunctionInfo ? ((SassExtensionFunctionInfo)object).getName() : (object instanceof LookupElement ? ((LookupElement)object).getLookupString() : object.toString());
            CssTerm term = CssElementFactory.getInstance((Project)element.getProject()).createTerm(name + "()", CssPsiUtil.getStylesheetLanguage((PsiElement)element));
            PsiElement firstChild = term.getFirstChild();
            if (firstChild instanceof CssFunction) {
                firstChild.putUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)psiManager.getProject()).createSmartPsiElementPointer(element));
                return firstChild;
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            SassExtensionFunctionDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SassExtensionFunctionDocumentationProvider.$$$reportNull$$$0(1);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)contextElement, CssFunction.class, (boolean)false);
    }

    private static boolean isSassScssLanguage(Language language) {
        return language == SCSSLanguage.INSTANCE || language == SASSLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/sass/extensions/SassExtensionFunctionDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

