/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.liveTemplates;

import com.intellij.codeInsight.template.LiveTemplateContext;
import com.intellij.codeInsight.template.LiveTemplateContextProvider;
import com.intellij.database.Dbms;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.sql.liveTemplates.contextTypes.SqlDialectContextType;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class SqlDialectLiveTemplateContextProvider
implements LiveTemplateContextProvider {
    @NlsSafe
    private static final String SQL92_LANGUAGE_DESC = "Sql92";

    SqlDialectLiveTemplateContextProvider() {
    }

    @NotNull
    public Collection<LiveTemplateContext> createContexts() {
        ArrayList<LiveTemplateContext> list = new ArrayList<LiveTemplateContext>();
        for (Dbms dbms : Dbms.allValues()) {
            String displayName = dbms.eq(Dbms.UNKNOWN) ? SQL92_LANGUAGE_DESC : dbms.getDisplayName();
            list.add(SqlDialectContextType.createCodeContext(dbms, displayName));
            list.add(SqlDialectContextType.createStatementContext(dbms, displayName));
            list.add(SqlDialectContextType.createQueryContext(dbms, displayName));
        }
        ArrayList<LiveTemplateContext> arrayList = list;
        if (arrayList == null) {
            SqlDialectLiveTemplateContextProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/liveTemplates/SqlDialectLiveTemplateContextProvider", "createContexts"));
    }
}

