/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.liveTemplates.macros;

import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.database.Dbms;
import com.intellij.database.liveTemplates.macros.DbContextMacroBase;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlEditorOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/database/liveTemplates/macros/DbObjectNameMacro;", "Lcom/intellij/database/liveTemplates/macros/DbContextMacroBase;", "<init>", "()V", "getName", "", "calcResultFromDbContext", "Lcom/intellij/codeInsight/template/Result;", "target", "Lcom/intellij/database/psi/DbElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.database.impl"})
public final class DbObjectNameMacro
extends DbContextMacroBase {
    @NotNull
    public String getName() {
        return "dbObjectName";
    }

    @Override
    @NotNull
    protected Result calcResultFromDbContext(@NotNull DbElement target, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Dbms dbms = target.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        NamingService namingService = NamingServices.getNamingService$default((Dbms)dbms2, null, null, (int)6, null);
        String string = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object name2 = namingService.catToScript(string, target.getKind(), !target.isQuoted());
        DbElement dasParent = target.getDasParent();
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((DbElement)target);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        if (dasParent != null && dialect.canBeQualifier((DasObject)dasParent)) {
            SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"getInstance(...)");
            SqlEditorOptions options = sqlEditorOptions;
            SqlEditorOptions.QualificationType qualificationType = DbSqlUtilCore.getQualificationByParentKind((ObjectKind)dasParent.getKind()).and(options.getLiveTemplateQualification());
            Intrinsics.checkNotNullExpressionValue((Object)qualificationType, (String)"and(...)");
            SqlEditorOptions.QualificationType qualification = qualificationType;
            int candidateCount = target.getDataSource().getNameIndex().getObjectsByName(target.getName()).size();
            if (qualification.shouldQualify(candidateCount)) {
                name2 = dasParent.getName() + "." + (String)name2;
            }
        }
        return (Result)new TextResult((String)name2);
    }
}

