/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.style;

import com.intellij.CommonBundle;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.DataFrameCSVAdapter;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.AreaSeriesSettings;
import com.intellij.charts.settings.data.BarSeriesSettings;
import com.intellij.charts.settings.data.ColumnModifier;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.LineSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.AreaSeriesType;
import com.intellij.charts.settings.data.type.BarSeriesType;
import com.intellij.charts.settings.data.type.LineSeriesType;
import com.intellij.charts.settings.data.type.SeriesType;
import com.intellij.charts.style.ChartConfig;
import com.intellij.charts.style.ChartsConfigurationPanel;
import com.intellij.charts.style.ChartsJBColor;
import com.intellij.charts.style.PaletteDialog;
import com.intellij.charts.style.PalettePanel;
import com.intellij.charts.utils.ChartMessagesBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0006\u0010\u001e\u001a\u00020\u0003J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\u0006\u0010 \u001a\u00020\u000fJ\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/charts/style/ChartsConfigurationPanel;", "", "originalChartsConfig", "Lcom/intellij/charts/style/ChartConfig;", "<init>", "(Lcom/intellij/charts/style/ChartConfig;)V", "chartConfig", "plotColorsList", "Ljavax/swing/JPanel;", "buttonGroup", "Ljavax/swing/ButtonGroup;", "colorSchemes", "", "Lcom/intellij/charts/style/ChartsConfigurationPanel$ColorScheme;", "panel", "Ljavax/swing/JComponent;", "currentChartType", "Lcom/intellij/charts/settings/data/type/SeriesType;", "getCurrentChartType", "()Lcom/intellij/charts/settings/data/type/SeriesType;", "setCurrentChartType", "(Lcom/intellij/charts/settings/data/type/SeriesType;)V", "reset", "", "createAxesPanel", "addColorScheme", "title", "", "createColorSchemesPanel", "getNewColorSchemeName", "getChartConfig", "updateDemoChart", "getPanel", "isModified", "", "Companion", "ColorScheme", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nChartsConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartsConfigurationPanel.kt\ncom/intellij/charts/style/ChartsConfigurationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,426:1\n1869#2,2:427\n1869#2,2:429\n1#3:431\n216#4,2:432\n*S KotlinDebug\n*F\n+ 1 ChartsConfigurationPanel.kt\ncom/intellij/charts/style/ChartsConfigurationPanel\n*L\n121#1:427,2\n334#1:429,2\n361#1:432,2\n*E\n"})
public final class ChartsConfigurationPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChartConfig originalChartsConfig;
    @NotNull
    private ChartConfig chartConfig;
    @NotNull
    private JPanel plotColorsList;
    @NotNull
    private final ButtonGroup buttonGroup;
    @NotNull
    private final List<ColorScheme> colorSchemes;
    @NotNull
    private final JComponent panel;
    @NotNull
    private SeriesType currentChartType;
    @NotNull
    private static final Float[] defaultFontSizes;

    /*
     * WARNING - void declaration
     */
    public ChartsConfigurationPanel(@NotNull ChartConfig originalChartsConfig) {
        void $this$_init__u24lambda_u248;
        OnePixelSplitter onePixelSplitter;
        JPanel jPanel;
        void $this$plotColorsList_u24lambda_u240;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)originalChartsConfig, (String)"originalChartsConfig");
        this.originalChartsConfig = originalChartsConfig;
        this.chartConfig = ChartConfig.copy$default(this.originalChartsConfig, false, null, null, null, 0, 0, null, false, 0.0f, null, null, null, null, null, null, 0.0f, null, null, 0.0f, null, null, 0x1FFFFF, null);
        JPanel jPanel3 = jPanel2 = new JPanel();
        ChartsConfigurationPanel chartsConfigurationPanel = this;
        boolean bl = false;
        $this$plotColorsList_u24lambda_u240.setLayout(new BoxLayout((Container)$this$plotColorsList_u24lambda_u240, 1));
        chartsConfigurationPanel.plotColorsList = jPanel2;
        this.buttonGroup = new ButtonGroup();
        this.colorSchemes = new ArrayList();
        this.currentChartType = AreaSeriesType.Companion.getInstance();
        DialogPanel cardPanel = BuilderKt.panel(arg_0 -> ChartsConfigurationPanel._init_$lambda$5(this, arg_0));
        JBScrollPane scroll = new JBScrollPane((Component)cardPanel);
        scroll.setBorder(null);
        JPanel $this$_init__u24lambda_u246 = jPanel = new JPanel(new BorderLayout(10, 10));
        boolean $i$a$-apply-ChartsConfigurationPanel$content$22 = false;
        $this$_init__u24lambda_u246.add((Component)scroll, "Center");
        JPanel content = jPanel;
        this.updateDemoChart();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Object[] $i$a$-apply-ChartsConfigurationPanel$content$22 = new SeriesType[]{LineSeriesType.Companion.getInstance(), BarSeriesType.Companion.getInstance(), AreaSeriesType.Companion.getInstance()};
        List chartTypes = CollectionsKt.listOf((Object[])$i$a$-apply-ChartsConfigurationPanel$content$22);
        Iterable $this$forEach$iv = chartTypes;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            SeriesType it = (SeriesType)element$iv;
            boolean bl2 = false;
            String string = it.getName();
            Icon icon = it.getIcon();
            DumbAwareToggleAction action2 = new DumbAwareToggleAction(this, it, string, icon){
                final /* synthetic */ ChartsConfigurationPanel this$0;
                final /* synthetic */ SeriesType $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super($super_call_param$1, null, $super_call_param$2);
                }

                public boolean isSelected(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    return Intrinsics.areEqual((Object)this.this$0.getCurrentChartType(), (Object)this.$it);
                }

                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.BGT;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (state) {
                        this.this$0.setCurrentChartType(this.$it);
                        ChartsConfigurationPanel.access$updateDemoChart(this.this$0);
                    }
                }
            };
            actionGroup.add((AnAction)action2);
        }
        content.setPreferredSize(new Dimension(10, 10));
        OnePixelSplitter $i$f$forEach22 = onePixelSplitter = new OnePixelSplitter(true, 0.5f);
        chartsConfigurationPanel = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u248.setFirstComponent((JComponent)content);
        chartsConfigurationPanel.panel = (JComponent)onePixelSplitter;
    }

    @NotNull
    public final SeriesType getCurrentChartType() {
        return this.currentChartType;
    }

    public final void setCurrentChartType(@NotNull SeriesType seriesType) {
        Intrinsics.checkNotNullParameter((Object)seriesType, (String)"<set-?>");
        this.currentChartType = seriesType;
    }

    public final void reset() {
        this.chartConfig = ChartConfig.copy$default(this.originalChartsConfig, false, null, null, null, 0, 0, null, false, 0.0f, null, null, null, null, null, null, 0.0f, null, null, 0.0f, null, null, 0x1FFFFF, null);
    }

    private final JPanel createAxesPanel() {
        return (JPanel)BuilderKt.panel(arg_0 -> ChartsConfigurationPanel.createAxesPanel$lambda$11(this, arg_0));
    }

    private final void addColorScheme(String title) {
        JRadioButton radioButton = new JRadioButton(title);
        if (Intrinsics.areEqual((Object)this.chartConfig.getColorScheme(), (Object)title)) {
            radioButton.setSelected(true);
        }
        this.buttonGroup.add(radioButton);
        radioButton.addActionListener(arg_0 -> ChartsConfigurationPanel.addColorScheme$lambda$12(this, title, arg_0));
        PalettePanel palettePanel = new PalettePanel();
        Object $this$addColorScheme_u24lambda_u2413 = palettePanel;
        boolean $i$a$-apply-ChartsConfigurationPanel$addColorScheme$palettePanel$22 = false;
        ((PalettePanel)$this$addColorScheme_u24lambda_u2413).setPalette(this.chartConfig.getPalette(title));
        PalettePanel palettePanel2 = palettePanel;
        $this$addColorScheme_u24lambda_u2413 = ChartMessagesBundle.message("colorScheme.action.edit", new Object[0]);
        Icon $i$a$-apply-ChartsConfigurationPanel$addColorScheme$palettePanel$22 = AllIcons.Actions.Edit;
        DumbAwareAction editAction2 = new DumbAwareAction(radioButton, this, palettePanel2, (String)$this$addColorScheme_u24lambda_u2413, $i$a$-apply-ChartsConfigurationPanel$addColorScheme$palettePanel$22){
            final /* synthetic */ JRadioButton $radioButton;
            final /* synthetic */ ChartsConfigurationPanel this$0;
            final /* synthetic */ PalettePanel $palettePanel;
            {
                this.$radioButton = $radioButton;
                this.this$0 = $receiver;
                this.$palettePanel = $palettePanel;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String currentTitle = this.$radioButton.getText();
                Intrinsics.checkNotNull((Object)currentTitle);
                PaletteDialog dialog = new PaletteDialog(currentTitle, ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getPalette(currentTitle));
                if (dialog.showAndGet()) {
                    String newTitle = dialog.getPaletteName();
                    List<ChartsJBColor> newPalette = dialog.getPalette();
                    ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getColorSchemes().remove(currentTitle);
                    ((Map)ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getColorSchemes()).put(newTitle, newPalette);
                    this.$radioButton.setText(newTitle);
                    this.$palettePanel.setPalette(newPalette);
                    this.$palettePanel.repaint();
                }
            }
        };
        ColorScheme colorScheme = new ColorScheme(radioButton, palettePanel2, null);
        ((Collection)this.colorSchemes).add(colorScheme);
        String string = ChartMessagesBundle.message("colorScheme.action.delete", new Object[0]);
        Object object = AllIcons.General.Remove;
        DumbAwareAction removeAction2 = new DumbAwareAction(this, radioButton, title, colorScheme, string, (Icon)object){
            final /* synthetic */ ChartsConfigurationPanel this$0;
            final /* synthetic */ JRadioButton $radioButton;
            final /* synthetic */ String $title;
            final /* synthetic */ ColorScheme $colorScheme;
            {
                this.this$0 = $receiver;
                this.$radioButton = $radioButton;
                this.$title = $title;
                this.$colorScheme = $colorScheme;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getColorSchemes().size() <= 1) {
                    Messages.showInfoMessage((String)ChartMessagesBundle.message("colorScheme.delete.last", new Object[0]), (String)"");
                    return;
                }
                Component component2 = ChartsConfigurationPanel.access$getPanel$p(this.this$0);
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.$radioButton.getText(), (String)"getText(...)");
                int dialogResult = Messages.showOkCancelDialog((Component)component2, (String)ChartMessagesBundle.message("colorScheme.delete", objectArray), (String)"", (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)AllIcons.General.Information);
                if (dialogResult == 0) {
                    ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getColorSchemes().remove(this.$title);
                    ChartConfig chartConfig = ChartsConfigurationPanel.access$getChartConfig$p(this.this$0);
                    Set<String> set2 = ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getColorSchemes().keySet();
                    Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
                    chartConfig.setColorScheme((String)CollectionsKt.first((Iterable)set2));
                    ChartsConfigurationPanel.access$getPlotColorsList$p(this.this$0).remove(this.$colorScheme.getBlock());
                    ((Collection)ChartsConfigurationPanel.access$getColorSchemes$p(this.this$0)).remove(this.$colorScheme);
                }
            }
        };
        object = ChartMessagesBundle.message("colorScheme.action.clone", new Object[0]);
        Icon icon = AllIcons.Actions.Copy;
        DumbAwareAction cloneAction2 = new DumbAwareAction(this, title, (String)object, icon){
            final /* synthetic */ ChartsConfigurationPanel this$0;
            final /* synthetic */ String $title;
            {
                this.this$0 = $receiver;
                this.$title = $title;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String newSchemeName = ChartsConfigurationPanel.access$getNewColorSchemeName(this.this$0);
                ((Map)ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getColorSchemes()).put(newSchemeName, CollectionsKt.toMutableList((Collection)ChartsConfigurationPanel.access$getChartConfig$p(this.this$0).getPalette(this.$title)));
                ChartsConfigurationPanel.access$addColorScheme(this.this$0, newSchemeName);
                ChartsConfigurationPanel.access$getPlotColorsList$p(this.this$0).revalidate();
                ChartsConfigurationPanel.access$getPlotColorsList$p(this.this$0).repaint();
            }
        };
        DialogPanel block = BuilderKt.panel(arg_0 -> ChartsConfigurationPanel.addColorScheme$lambda$17(palettePanel2, editAction2, removeAction2, cloneAction2, radioButton, this, arg_0));
        this.plotColorsList.add((Component)block);
        colorScheme.setBlock((JPanel)block);
    }

    private final JComponent createColorSchemesPanel() {
        JButton jButton;
        JPanel jPanel = this.plotColorsList;
        JComponent $this$createColorSchemesPanel_u24lambda_u2419 = jPanel;
        boolean bl = false;
        Set<Map.Entry<String, List<ChartsJBColor>>> set2 = this.chartConfig.getColorSchemes().entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry scheme = (Map.Entry)element$iv;
            boolean bl2 = false;
            Object k = scheme.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            this.addColorScheme((String)k);
        }
        JComponent $this$createColorSchemesPanel_u24lambda_u2421 = $this$createColorSchemesPanel_u24lambda_u2419 = new JButton(ChartMessagesBundle.message("colorScheme.add", new Object[0]), AllIcons.General.Add);
        boolean bl3 = false;
        ((AbstractButton)$this$createColorSchemesPanel_u24lambda_u2421).addActionListener(arg_0 -> ChartsConfigurationPanel.createColorSchemesPanel$lambda$21$lambda$20(this, arg_0));
        JComponent addNewButton = $this$createColorSchemesPanel_u24lambda_u2419;
        JButton $this$createColorSchemesPanel_u24lambda_u2424 = jButton = new JButton(ChartMessagesBundle.message("colorScheme.restore", new Object[0]));
        boolean bl4 = false;
        $this$createColorSchemesPanel_u24lambda_u2424.addActionListener(arg_0 -> ChartsConfigurationPanel.createColorSchemesPanel$lambda$24$lambda$23(this, arg_0));
        JButton restoreDefault = jButton;
        return (JComponent)BuilderKt.panel(arg_0 -> ChartsConfigurationPanel.createColorSchemesPanel$lambda$27(this, (JButton)addNewButton, restoreDefault, arg_0));
    }

    private final String getNewColorSchemeName() {
        Object name = "Colors";
        int index = 1;
        while (this.chartConfig.getColorSchemes().containsKey(name)) {
            name = "Colors " + index;
            ++index;
        }
        return name;
    }

    @NotNull
    public final ChartConfig getChartConfig() {
        return this.chartConfig;
    }

    private final void updateDemoChart() {
        SeriesSettings seriesSettings;
        String string = new Scanner(this.getClass().getClassLoader().getResourceAsStream("data/data.csv"), "UTF-8").useDelimiter("\\A").next();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"next(...)");
        String testData = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\t", (String)"\t", (boolean)false, (int)4, null), (String)"\\n", (String)"\n", (boolean)false, (int)4, null);
        DataFrame dataFrame = DataFrameCSVAdapter.fromCsvString$default(DataFrameCSVAdapter.INSTANCE, testData, Character.valueOf('\t'), false, null, 12, null);
        SeriesType seriesType = this.currentChartType;
        if (Intrinsics.areEqual((Object)seriesType, (Object)BarSeriesType.Companion.getInstance())) {
            var5_4 = new ColumnSettings[]{new ColumnSettings(new ColumnId("education", 3), null, 2, null), new ColumnSettings(new ColumnId("marital", 2), null, 2, null)};
            seriesSettings = new BarSeriesSettings(false, false, CollectionsKt.listOf((Object)new ColumnSettings(new ColumnId("job", 0), ColumnModifier.GroupAndSort)), CollectionsKt.listOf((Object[])var5_4), CollectionsKt.listOf((Object)new ColumnSettings(new ColumnId("age", 0), ColumnModifier.Median)), false, 35, null);
        } else if (Intrinsics.areEqual((Object)seriesType, (Object)LineSeriesType.Companion.getInstance())) {
            var5_4 = new ColumnSettings[]{new ColumnSettings(new ColumnId("education", 3), null, 2, null), new ColumnSettings(new ColumnId("marital", 2), null, 2, null)};
            seriesSettings = new LineSeriesSettings(CollectionsKt.listOf((Object)new ColumnSettings(new ColumnId("age", 0), ColumnModifier.GroupAndSort)), CollectionsKt.listOf((Object[])var5_4), CollectionsKt.listOf((Object)new ColumnSettings(new ColumnId("balance", 4), ColumnModifier.Median)), false, false, false, 56, null);
        } else {
            var5_4 = new ColumnSettings[]{new ColumnSettings(new ColumnId("education", 3), null, 2, null), new ColumnSettings(new ColumnId("marital", 2), null, 2, null)};
            seriesSettings = new AreaSeriesSettings(CollectionsKt.listOf((Object)new ColumnSettings(new ColumnId("age", 0), ColumnModifier.GroupAndSort)), CollectionsKt.listOf((Object[])var5_4), CollectionsKt.listOf((Object)new ColumnSettings(new ColumnId("balance", 4), ColumnModifier.Median)), null, false, 24, null);
        }
        SeriesSettings settings = seriesSettings;
    }

    @NotNull
    public final JComponent getPanel() {
        return this.panel;
    }

    public final boolean isModified() {
        return !Intrinsics.areEqual((Object)this.chartConfig, (Object)this.originalChartsConfig);
    }

    private static final Unit lambda$5$lambda$2$lambda$1(ChartsConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.createColorSchemesPanel()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$2(ChartsConfigurationPanel this$0, Panel $this$groupRowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$groupRowsRange, (String)"$this$groupRowsRange");
        Panel.row$default((Panel)$this$groupRowsRange, null, arg_0 -> ChartsConfigurationPanel.lambda$5$lambda$2$lambda$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4$lambda$3(ChartsConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.createAxesPanel());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4(ChartsConfigurationPanel this$0, Panel $this$groupRowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$groupRowsRange, (String)"$this$groupRowsRange");
        Panel.row$default((Panel)$this$groupRowsRange, null, arg_0 -> ChartsConfigurationPanel.lambda$5$lambda$4$lambda$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(ChartsConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.groupRowsRange$default((Panel)$this$panel, (String)ChartMessagesBundle.message("configuration.block.colorSchemes", new Object[0]), (boolean)false, null, null, arg_0 -> ChartsConfigurationPanel.lambda$5$lambda$2(this$0, arg_0), (int)14, null);
        Panel.groupRowsRange$default((Panel)$this$panel, (String)ChartMessagesBundle.message("configuration.block.axes", new Object[0]), (boolean)false, null, null, arg_0 -> ChartsConfigurationPanel.lambda$5$lambda$4(this$0, arg_0), (int)14, null);
        return Unit.INSTANCE;
    }

    private static final Unit createAxesPanel$lambda$11$lambda$9(ChartsConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(ChartMessagesBundle.message("configuration.axis.label.autoscale", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.chartConfig){

            public Object get() {
                return ((ChartConfig)this.receiver).getAxesTextScale();
            }

            public void set(Object value) {
                ((ChartConfig)this.receiver).setAxesTextScale((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createAxesPanel$lambda$11$lambda$10(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(ChartMessagesBundle.message("configuration.axis.label.scaled.min.size", new Object[0]));
        Row.comboBox$default((Row)$this$row, (Collection)ArraysKt.toList((Object[])defaultFontSizes), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createAxesPanel$lambda$11(ChartsConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartsConfigurationPanel.createAxesPanel$lambda$11$lambda$9(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, ChartsConfigurationPanel::createAxesPanel$lambda$11$lambda$10, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void addColorScheme$lambda$12(ChartsConfigurationPanel this$0, String $title, ActionEvent it) {
        this$0.chartConfig.setColorScheme($title);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addColorScheme$lambda$17$lambda$16(PalettePanel $palettePanel, addColorScheme.editAction.1 $editAction, addColorScheme.removeAction.1 $removeAction, addColorScheme.cloneAction.1 $cloneAction, JRadioButton $radioButton, ChartsConfigurationPanel this$0, Row $this$row) {
        void $this$addColorScheme_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415;
        void $this$addColorScheme_u24lambda_u2417_u24lambda_u2416_u24lambda_u2414;
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ActionToolbar actionToolbar2 = actionToolbar = new JPanel();
        Row row = $this$row;
        boolean $i$a$-apply-ChartsConfigurationPanel$addColorScheme$block$1$1$32 = false;
        $this$addColorScheme_u24lambda_u2417_u24lambda_u2416_u24lambda_u2414.add($radioButton);
        row.cell((JComponent)actionToolbar).widthGroup("color_schema_name");
        $this$row.cell((JComponent)$palettePanel).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
        actionToolbar2 = new ActionToolbar[]{$editAction, $removeAction, $cloneAction};
        ActionToolbar $i$a$-apply-ChartsConfigurationPanel$addColorScheme$block$1$1$32 = actionToolbar2 = ActionManager.getInstance().createActionToolbar("ChartStyleConfig", (ActionGroup)new DefaultActionGroup((AnAction[])actionToolbar2), true);
        row = $this$row;
        boolean bl = false;
        $this$addColorScheme_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.setTargetComponent((JComponent)this$0.plotColorsList);
        JComponent jComponent = actionToolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        row.cell(jComponent);
        return Unit.INSTANCE;
    }

    private static final Unit addColorScheme$lambda$17(PalettePanel $palettePanel, addColorScheme.editAction.1 $editAction, addColorScheme.removeAction.1 $removeAction, addColorScheme.cloneAction.1 $cloneAction, JRadioButton $radioButton, ChartsConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartsConfigurationPanel.addColorScheme$lambda$17$lambda$16($palettePanel, $editAction, $removeAction, $cloneAction, $radioButton, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void createColorSchemesPanel$lambda$21$lambda$20(ChartsConfigurationPanel this$0, ActionEvent it) {
        this$0.addColorScheme(this$0.getNewColorSchemeName());
        this$0.plotColorsList.revalidate();
        this$0.plotColorsList.repaint();
    }

    private static final void createColorSchemesPanel$lambda$24$lambda$23(ChartsConfigurationPanel this$0, ActionEvent it) {
        int dialogResult = Messages.showOkCancelDialog((Component)this$0.panel, (String)ChartMessagesBundle.message("colorScheme.restore.text", new Object[0]), (String)"", (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)AllIcons.General.Information);
        if (dialogResult == 0) {
            this$0.plotColorsList.removeAll();
            this$0.chartConfig.setColorSchemes(ChartConfig.Companion.getDefaultColorSchemes());
            ChartConfig chartConfig = this$0.chartConfig;
            Set<String> set2 = this$0.chartConfig.getColorSchemes().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            chartConfig.setColorScheme((String)CollectionsKt.first((Iterable)set2));
            Map $this$forEach$iv = this$0.chartConfig.getColorSchemes();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry scheme = element$iv = iterator2.next();
                boolean bl = false;
                this$0.addColorScheme((String)scheme.getKey());
            }
            this$0.plotColorsList.revalidate();
            this$0.plotColorsList.repaint();
        }
    }

    private static final Unit createColorSchemesPanel$lambda$27$lambda$25(ChartsConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.plotColorsList).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createColorSchemesPanel$lambda$27$lambda$26(JButton $addNewButton, JButton $restoreDefault, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$addNewButton);
        $this$row.cell((JComponent)$restoreDefault);
        return Unit.INSTANCE;
    }

    private static final Unit createColorSchemesPanel$lambda$27(ChartsConfigurationPanel this$0, JButton $addNewButton, JButton $restoreDefault, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartsConfigurationPanel.createColorSchemesPanel$lambda$27$lambda$25(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartsConfigurationPanel.createColorSchemesPanel$lambda$27$lambda$26($addNewButton, $restoreDefault, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ChartConfig access$getChartConfig$p(ChartsConfigurationPanel $this) {
        return $this.chartConfig;
    }

    public static final /* synthetic */ JComponent access$getPanel$p(ChartsConfigurationPanel $this) {
        return $this.panel;
    }

    public static final /* synthetic */ JPanel access$getPlotColorsList$p(ChartsConfigurationPanel $this) {
        return $this.plotColorsList;
    }

    public static final /* synthetic */ List access$getColorSchemes$p(ChartsConfigurationPanel $this) {
        return $this.colorSchemes;
    }

    public static final /* synthetic */ String access$getNewColorSchemeName(ChartsConfigurationPanel $this) {
        return $this.getNewColorSchemeName();
    }

    public static final /* synthetic */ void access$addColorScheme(ChartsConfigurationPanel $this, String title) {
        $this.addColorScheme(title);
    }

    public static final /* synthetic */ void access$updateDemoChart(ChartsConfigurationPanel $this) {
        $this.updateDemoChart();
    }

    static {
        Float[] floatArray = new Float[]{Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(11.0f), Float.valueOf(12.0f), Float.valueOf(14.0f), Float.valueOf(16.0f), Float.valueOf(18.0f), Float.valueOf(20.0f), Float.valueOf(22.0f), Float.valueOf(24.0f), Float.valueOf(26.0f), Float.valueOf(28.0f), Float.valueOf(36.0f), Float.valueOf(48.0f), Float.valueOf(72.0f)};
        defaultFontSizes = floatArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/charts/style/ChartsConfigurationPanel$ColorScheme;", "", "radioButton", "Ljavax/swing/JRadioButton;", "palettePanel", "Lcom/intellij/charts/style/PalettePanel;", "block", "Ljavax/swing/JPanel;", "<init>", "(Ljavax/swing/JRadioButton;Lcom/intellij/charts/style/PalettePanel;Ljavax/swing/JPanel;)V", "getRadioButton", "()Ljavax/swing/JRadioButton;", "getPalettePanel", "()Lcom/intellij/charts/style/PalettePanel;", "getBlock", "()Ljavax/swing/JPanel;", "setBlock", "(Ljavax/swing/JPanel;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.charts"})
    public static final class ColorScheme {
        @NotNull
        private final JRadioButton radioButton;
        @NotNull
        private final PalettePanel palettePanel;
        @Nullable
        private JPanel block;

        public ColorScheme(@NotNull JRadioButton radioButton, @NotNull PalettePanel palettePanel, @Nullable JPanel block) {
            Intrinsics.checkNotNullParameter((Object)radioButton, (String)"radioButton");
            Intrinsics.checkNotNullParameter((Object)palettePanel, (String)"palettePanel");
            this.radioButton = radioButton;
            this.palettePanel = palettePanel;
            this.block = block;
        }

        @NotNull
        public final JRadioButton getRadioButton() {
            return this.radioButton;
        }

        @NotNull
        public final PalettePanel getPalettePanel() {
            return this.palettePanel;
        }

        @Nullable
        public final JPanel getBlock() {
            return this.block;
        }

        public final void setBlock(@Nullable JPanel jPanel) {
            this.block = jPanel;
        }

        @NotNull
        public final JRadioButton component1() {
            return this.radioButton;
        }

        @NotNull
        public final PalettePanel component2() {
            return this.palettePanel;
        }

        @Nullable
        public final JPanel component3() {
            return this.block;
        }

        @NotNull
        public final ColorScheme copy(@NotNull JRadioButton radioButton, @NotNull PalettePanel palettePanel, @Nullable JPanel block) {
            Intrinsics.checkNotNullParameter((Object)radioButton, (String)"radioButton");
            Intrinsics.checkNotNullParameter((Object)palettePanel, (String)"palettePanel");
            return new ColorScheme(radioButton, palettePanel, block);
        }

        public static /* synthetic */ ColorScheme copy$default(ColorScheme colorScheme, JRadioButton jRadioButton, PalettePanel palettePanel, JPanel jPanel, int n, Object object) {
            if ((n & 1) != 0) {
                jRadioButton = colorScheme.radioButton;
            }
            if ((n & 2) != 0) {
                palettePanel = colorScheme.palettePanel;
            }
            if ((n & 4) != 0) {
                jPanel = colorScheme.block;
            }
            return colorScheme.copy(jRadioButton, palettePanel, jPanel);
        }

        @NotNull
        public String toString() {
            return "ColorScheme(radioButton=" + this.radioButton + ", palettePanel=" + this.palettePanel + ", block=" + this.block + ")";
        }

        public int hashCode() {
            int result2 = this.radioButton.hashCode();
            result2 = result2 * 31 + this.palettePanel.hashCode();
            result2 = result2 * 31 + (this.block == null ? 0 : this.block.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorScheme)) {
                return false;
            }
            ColorScheme colorScheme = (ColorScheme)other;
            if (!Intrinsics.areEqual((Object)this.radioButton, (Object)colorScheme.radioButton)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.palettePanel, (Object)colorScheme.palettePanel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.block, (Object)colorScheme.block);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/charts/style/ChartsConfigurationPanel$Companion;", "", "<init>", "()V", "defaultFontSizes", "", "", "getDefaultFontSizes", "()[Ljava/lang/Float;", "[Ljava/lang/Float;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Float[] getDefaultFontSizes() {
            return defaultFontSizes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

