/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.host.GuestToHostCodeCache;
import com.oracle.truffle.host.HostProxy;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@GeneratedBy(value=HostProxy.class)
final class HostProxyGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private HostProxyGen() {
    }

    static {
        LibraryExport.register(HostProxy.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=HostProxy.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, HostProxy.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof HostProxy);
            Uncached uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof HostProxy);
            return new Cached();
        }

        @GeneratedBy(value=HostProxy.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof HostProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostProxy;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                if (arg1Value instanceof HostProxy) {
                    HostProxy arg1Value_ = (HostProxy)arg1Value;
                    return HostProxy.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return HostProxy.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isInstantiable(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.instantiate(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isExecutable(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.execute(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isPointer(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.asPointer(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.hasArrayElements(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                arg0Value.writeArrayElement(arg1Value, arg2Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                arg0Value.removeArrayElement(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.getArraySize(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isArrayElementInsertable(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.hasMembers(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.getMembers(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.readMember(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, this, INTEROP_LIBRARY_.getUncached(), arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, this, INTEROP_LIBRARY_.getUncached(), arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                arg0Value.removeMember(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isDate(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isTime(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isTimeZone(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.asTimeZone(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.asDate(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.asTime(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.asInstant(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDuration(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isDuration(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.asDuration(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy)receiver).hasLanguage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy)receiver).getLanguage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy)receiver).toDisplayString(allowSideEffects);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy)receiver).hasMetaObject();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy)receiver).getMetaObject();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.hasIterator(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.getIterator(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isIterator(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.hasIteratorNextElement(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.getIteratorNextElement(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasHashEntries(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.hasHashEntries(arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.getHashSize(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isHashValueExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isHashValueExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isHashValueExisting(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.readHashValue(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.isHashEntryInsertable(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                arg0Value.writeHashEntry(arg1Value, arg2Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                arg0Value.removeHashEntry(arg1Value, this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = (HostProxy)arg0Value_;
                return arg0Value.getHashEntriesIterator(this, arg0Value.context.getGuestToHostCache());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return HostProxy.identityHashCode((HostProxy)receiver);
            }
        }

        @GeneratedBy(value=HostProxy.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private int state_1_;
            @CompilerDirectives.CompilationFinal
            private GuestToHostCodeCache cache;
            @Node.Child
            private InteropLibrary executables;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof HostProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostProxy;
            }

            private boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, HostProxy arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof HostProxy);
            }

            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof HostProxy) {
                        HostProxy arg1Value_ = (HostProxy)arg1Value;
                        return HostProxy.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && this.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return HostProxy.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(HostProxy arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof HostProxy) {
                    HostProxy arg1Value_ = (HostProxy)arg1Value;
                    this.state_0_ = state_0 |= 1;
                    return HostProxy.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 2;
                return HostProxy.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isInstantiable(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isInstantiableNode_AndSpecialize(arg0Value);
            }

            private boolean isInstantiableNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isInstantiable(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 4;
                return arg0Value.isInstantiable(cache_);
            }

            @Override
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.instantiate(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateNode_AndSpecialize(HostProxy arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'instantiate(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 8;
                return arg0Value.instantiate(arg1Value, library__, cache_);
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isExecutable(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableNode_AndSpecialize(arg0Value);
            }

            private boolean isExecutableNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isExecutable(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x10;
                return arg0Value.isExecutable(cache_);
            }

            @Override
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.execute(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(HostProxy arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'execute(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x20;
                return arg0Value.execute(arg1Value, library__, cache_);
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isPointer(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isPointerNode_AndSpecialize(arg0Value);
            }

            private boolean isPointerNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isPointer(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x40;
                return arg0Value.isPointer(cache_);
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.asPointer(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'asPointer(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x80;
                return arg0Value.asPointer(library__, cache_);
            }

            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.hasArrayElements(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasArrayElementsNode_AndSpecialize(arg0Value);
            }

            private boolean hasArrayElementsNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'hasArrayElements(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x100;
                return arg0Value.hasArrayElements(cache_);
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.readArrayElement(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(HostProxy arg0Value, long arg1Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'readArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x200;
                return arg0Value.readArrayElement(arg1Value, library__, cache_);
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, library__, cache_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeArrayElementNode_AndSpecialize(HostProxy arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'writeArrayElement(HostProxy, long, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x400;
                arg0Value.writeArrayElement(arg1Value, arg2Value, library__, cache_);
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    arg0Value.removeArrayElement(arg1Value, library__, cache_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void removeArrayElementNode_AndSpecialize(HostProxy arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'removeArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x800;
                arg0Value.removeArrayElement(arg1Value, library__, cache_);
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.getArraySize(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            private long getArraySizeNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'getArraySize(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x1000;
                return arg0Value.getArraySize(library__, cache_);
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementExistingNode_AndSpecialize(HostProxy arg0Value, long arg1Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x2000;
                return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isArrayElementInsertable(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableNode_AndSpecialize(HostProxy arg0Value, long arg1Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isArrayElementInsertable(HostProxy, long, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x4000;
                return arg0Value.isArrayElementInsertable(arg1Value, library__, cache_);
            }

            @Override
            public boolean hasMembers(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.hasMembers(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMembersNode_AndSpecialize(arg0Value);
            }

            private boolean hasMembersNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'hasMembers(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x8000;
                return arg0Value.hasMembers(cache_);
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.getMembers(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersNode_AndSpecialize(HostProxy arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'getMembers(HostProxy, boolean, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x10000;
                return arg0Value.getMembers(arg1Value, library__, cache_);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.readMember(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'readMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x20000;
                return arg0Value.readMember(arg1Value, library__, cache_);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    arg0Value.writeMember(arg1Value, arg2Value, library__, cache_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'writeMember(HostProxy, String, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x40000;
                arg0Value.writeMember(arg1Value, arg2Value, library__, cache_);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                GuestToHostCodeCache cache_;
                InteropLibrary executables_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80000) != 0 && (executables_ = this.executables) != null && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.invokeMember(arg1Value, arg2Value, library__, executables_, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared;
                InteropLibrary executables_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                InteropLibrary executables__shared = this.executables;
                if (executables__shared != null) {
                    executables_ = executables__shared;
                } else {
                    executables_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                    if (executables_ == null) {
                        throw new IllegalStateException("Specialization 'invokeMember(HostProxy, String, Object[], InteropLibrary, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'executables' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.executables == null) {
                    VarHandle.storeStoreFence();
                    this.executables = executables_;
                }
                if ((cache__shared = this.cache) != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'invokeMember(HostProxy, String, Object[], InteropLibrary, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x80000;
                return arg0Value.invokeMember(arg1Value, arg2Value, library__, executables_, cache_);
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                GuestToHostCodeCache cache_;
                InteropLibrary executables_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100000) != 0 && (executables_ = this.executables) != null && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isMemberInvocable(arg1Value, library__, executables_, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(HostProxy arg0Value, String arg1Value) {
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared;
                InteropLibrary executables_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                InteropLibrary executables__shared = this.executables;
                if (executables__shared != null) {
                    executables_ = executables__shared;
                } else {
                    executables_ = this.insert(INTEROP_LIBRARY_.createDispatched(5));
                    if (executables_ == null) {
                        throw new IllegalStateException("Specialization 'isMemberInvocable(HostProxy, String, InteropLibrary, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'executables' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.executables == null) {
                    VarHandle.storeStoreFence();
                    this.executables = executables_;
                }
                if ((cache__shared = this.cache) != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isMemberInvocable(HostProxy, String, InteropLibrary, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x100000;
                return arg0Value.isMemberInvocable(arg1Value, library__, executables_, cache_);
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    arg0Value.removeMember(arg1Value, library__, cache_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void removeMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'removeMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x200000;
                arg0Value.removeMember(arg1Value, library__, cache_);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberExistingNode_AndSpecialize(HostProxy arg0Value, String arg1Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x400000;
                return arg0Value.isMemberExisting(arg1Value, library__, cache_);
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isMemberInsertable(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(HostProxy arg0Value, String arg1Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isMemberInsertable(HostProxy, String, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x800000;
                return arg0Value.isMemberInsertable(arg1Value, library__, cache_);
            }

            @Override
            public boolean isDate(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000000) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isDate(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isDateNode_AndSpecialize(arg0Value);
            }

            private boolean isDateNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isDate(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x1000000;
                return arg0Value.isDate(cache_);
            }

            @Override
            public boolean isTime(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000000) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isTime(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isTimeNode_AndSpecialize(arg0Value);
            }

            private boolean isTimeNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isTime(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x2000000;
                return arg0Value.isTime(cache_);
            }

            @Override
            public boolean isTimeZone(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000000) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isTimeZone(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isTimeZoneNode_AndSpecialize(arg0Value);
            }

            private boolean isTimeZoneNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isTimeZone(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x4000000;
                return arg0Value.isTimeZone(cache_);
            }

            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.asTimeZone(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeZoneNode_AndSpecialize(arg0Value);
            }

            private ZoneId asTimeZoneNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'asTimeZone(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x8000000;
                return arg0Value.asTimeZone(library__, cache_);
            }

            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.asDate(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDateNode_AndSpecialize(arg0Value);
            }

            private LocalDate asDateNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'asDate(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x10000000;
                return arg0Value.asDate(library__, cache_);
            }

            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.asTime(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeNode_AndSpecialize(arg0Value);
            }

            private LocalTime asTimeNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'asTime(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x20000000;
                return arg0Value.asTime(library__, cache_);
            }

            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.asInstant(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asInstantNode_AndSpecialize(arg0Value);
            }

            private Instant asInstantNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'asInstant(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= 0x40000000;
                return arg0Value.asInstant(library__, cache_);
            }

            @Override
            public boolean isDuration(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & Integer.MIN_VALUE) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isDuration(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isDurationNode_AndSpecialize(arg0Value);
            }

            private boolean isDurationNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isDuration(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_0_ = state_0 |= Integer.MIN_VALUE;
                return arg0Value.isDuration(cache_);
            }

            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 1) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.asDuration(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDurationNode_AndSpecialize(arg0Value);
            }

            private Duration asDurationNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'asDuration(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 1;
                return arg0Value.asDuration(library__, cache_);
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostProxy)receiver).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostProxy)receiver).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostProxy)receiver).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostProxy)receiver).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((HostProxy)receiver).getMetaObject();
            }

            @Override
            public boolean hasIterator(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 2) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.hasIterator(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'hasIterator(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 2;
                return arg0Value.hasIterator(cache_);
            }

            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 4) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.getIterator(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'getIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 4;
                return arg0Value.getIterator(library__, cache_);
            }

            @Override
            public boolean isIterator(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 8) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.isIterator(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIteratorNode_AndSpecialize(arg0Value);
            }

            private boolean isIteratorNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isIterator(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 8;
                return arg0Value.isIterator(cache_);
            }

            @Override
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x10) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.hasIteratorNextElement(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNextElementNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'hasIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x10;
                return arg0Value.hasIteratorNextElement(library__, cache_);
            }

            @Override
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x20) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.getIteratorNextElement(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNextElementNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'getIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x20;
                return arg0Value.getIteratorNextElement(library__, cache_);
            }

            @Override
            public boolean hasHashEntries(Object arg0Value_) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x40) != 0 && (cache_ = this.cache) != null) {
                    return arg0Value.hasHashEntries(cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasHashEntriesNode_AndSpecialize(arg0Value);
            }

            private boolean hasHashEntriesNode_AndSpecialize(HostProxy arg0Value) {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'hasHashEntries(HostProxy, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x40;
                return arg0Value.hasHashEntries(cache_);
            }

            @Override
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x80) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.getHashSize(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getHashSizeNode_AndSpecialize(arg0Value);
            }

            private long getHashSizeNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'getHashSize(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x80;
                return arg0Value.getHashSize(library__, cache_);
            }

            @Override
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x100) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashValueExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashValueExistingNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x100;
                return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
            }

            @Override
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x100) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashValueExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x100) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashValueExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x200) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.readHashValue(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readHashValueNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readHashValueNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'readHashValue(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x200;
                return arg0Value.readHashValue(arg1Value, library__, cache_);
            }

            @Override
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x400) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.isHashEntryInsertable(arg1Value, library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isHashEntryInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashEntryInsertableNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'isHashEntryInsertable(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x400;
                return arg0Value.isHashEntryInsertable(arg1Value, library__, cache_);
            }

            @Override
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x800) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    arg0Value.writeHashEntry(arg1Value, arg2Value, library__, cache_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeHashEntryNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeHashEntryNode_AndSpecialize(HostProxy arg0Value, Object arg1Value, Object arg2Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'writeHashEntry(HostProxy, Object, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x800;
                arg0Value.writeHashEntry(arg1Value, arg2Value, library__, cache_);
            }

            @Override
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x1000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    arg0Value.removeHashEntry(arg1Value, library__, cache_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeHashEntryNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void removeHashEntryNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'removeHashEntry(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x1000;
                arg0Value.removeHashEntry(arg1Value, library__, cache_);
            }

            @Override
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                HostProxy arg0Value = (HostProxy)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x2000) != 0 && (cache_ = this.cache) != null) {
                    Cached library__ = this;
                    return arg0Value.getHashEntriesIterator(library__, cache_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getHashEntriesIteratorNode_AndSpecialize(arg0Value);
            }

            private Object getHashEntriesIteratorNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                GuestToHostCodeCache cache_;
                int state_1 = this.state_1_;
                Cached library__ = null;
                library__ = this;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = arg0Value.context.getGuestToHostCache();
                    if (cache_ == null) {
                        throw new IllegalStateException("Specialization 'getHashEntriesIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)' contains a shared cache with name 'cache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                this.state_1_ = state_1 |= 0x2000;
                return arg0Value.getHashEntriesIterator(library__, cache_);
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return HostProxy.identityHashCode((HostProxy)receiver);
            }
        }
    }
}

