/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.editor;

import com.intellij.codeInsight.editorActions.HtmlSelectioner;
import com.intellij.jinja.Jinja2TemplateUtil;
import com.intellij.jinja.model.TagLibrary;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.util.DjangoTemplateUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DjangoTemplateTagSelectionHandler
extends HtmlSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(0);
        }
        return e.getContainingFile().getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE) != null;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DjangoTemplateTagSelectionHandler.$$$reportNull$$$0(3);
        }
        List result = super.select(e, editorText, cursorOffset, editor);
        DjangoTagElementImpl tag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)e, DjangoTagElementImpl.class);
        if (tag == null) {
            tag = DjangoTemplateTagSelectionHandler.findClosestOpenDjangoTagBeforeCursor(e, cursorOffset);
        } else {
            result.add(tag.getTextRange());
        }
        if (tag != null) {
            DjangoTagName name = Jinja2TemplateUtil.getTagNameElement((DjangoTagElementImpl)tag);
            List open = DjangoTemplateUtil.getOpenedTags((DjangoTagElementImpl)tag);
            if (!DjangoTemplateUtil.isEndTag((DjangoTagName)name)) {
                DjangoTagName tagName = Jinja2TemplateUtil.getTagNameElement((DjangoTagElementImpl)tag);
                if (tagName != null) {
                    open.add(0, tagName);
                }
                tag = (DjangoTagElementImpl)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, DjangoTagElementImpl.class);
            }
            List endTags = DjangoTemplateUtil.getEndTags((DjangoTagElementImpl)tag);
            int i = 0;
            for (DjangoTagName openTag : open) {
                for (int j = i; j < endTags.size(); ++j) {
                    DjangoTagElementImpl closeTag = (DjangoTagElementImpl)endTags.get(j);
                    if (!TagLibrary.isCloseTagFor((String)Jinja2TemplateUtil.getTagName((DjangoTagElementImpl)closeTag), (String)openTag.getTagName())) continue;
                    DjangoTemplateTagSelectionHandler.pair(result, (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)openTag, DjangoTagElementImpl.class), closeTag);
                    i = j + 1;
                }
            }
        }
        return result;
    }

    private static DjangoTagElementImpl findClosestOpenDjangoTagBeforeCursor(PsiElement e, int cursorOffset) {
        PsiElement[] tags = DjangoTemplateUtil.findElementsBeforeOfType((PsiElement)e.getContainingFile().getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE), (int)cursorOffset, DjangoTagElementImpl.class);
        int min = Integer.MAX_VALUE;
        DjangoTagElementImpl tag = null;
        for (PsiElement el : tags) {
            if (DjangoTemplateUtil.isEndTag((DjangoTagName)Jinja2TemplateUtil.getTagNameElement((DjangoTagElementImpl)((DjangoTagElementImpl)el))) || cursorOffset - el.getTextOffset() >= min) continue;
            tag = (DjangoTagElementImpl)el;
        }
        return tag;
    }

    private static void pair(List<TextRange> result, DjangoTagElementImpl openTag, DjangoTagElementImpl closeTag) {
        result.add(DjangoTemplateUtil.betweenTags((PsiElement)openTag, (PsiElement)closeTag));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/lang/template/editor/DjangoTemplateTagSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

