/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.psi.PuppetClassDefinition;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightElement;
import com.intellij.lang.puppet.psi.PuppetNodeDefinition;
import com.intellij.lang.puppet.psi.PuppetResourceInstanceDeclaration;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.util.PuppetQualifiedNamesUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetItemPresentation<T extends NavigatablePsiElement>
implements ItemPresentation {
    @NotNull
    protected final String myName;
    @NotNull
    protected final T myDelegate;
    private final NullableLazyValue<Icon> myIconProvider;
    private final NullableLazyValue<String> myLocationProvider;

    public static PuppetItemPresentation create(@NotNull String name, @NotNull NavigatablePsiElement delegate) {
        if (name == null) {
            PuppetItemPresentation.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            PuppetItemPresentation.$$$reportNull$$$0(1);
        }
        return PuppetItemPresentation.create(name, null, delegate);
    }

    public static PuppetItemPresentation create(@NotNull String name, @Nullable String location, @NotNull NavigatablePsiElement delegate) {
        if (name == null) {
            PuppetItemPresentation.$$$reportNull$$$0(2);
        }
        if (delegate == null) {
            PuppetItemPresentation.$$$reportNull$$$0(3);
        }
        if (delegate instanceof PuppetDelegatingLightElement) {
            delegate = ((PuppetDelegatingLightElement)delegate).getDelegate();
        }
        if (delegate instanceof PuppetVariable) {
            return new VariablePresentation(name, location, (PuppetVariable)delegate);
        }
        if (delegate instanceof PuppetResourceInstanceDeclaration) {
            return new ResourceInstancePresentation(name, location, (PuppetResourceInstanceDeclaration)delegate);
        }
        if (delegate instanceof PuppetNodeDefinition) {
            return new NodePresentation(name, location, (PuppetNodeDefinition)delegate);
        }
        if (delegate instanceof PuppetClassDefinition) {
            return new ClassPresentation(name, location, (PuppetClassDefinition)delegate);
        }
        return new DefaultPresentation(name, location, (NavigatablePsiElement)delegate);
    }

    @NotNull
    private T getDelegate() {
        T t = this.myDelegate;
        if (t == null) {
            PuppetItemPresentation.$$$reportNull$$$0(4);
        }
        return t;
    }

    private PuppetItemPresentation(@NotNull String name, @Nullable String location, @NotNull T delegate) {
        if (name == null) {
            PuppetItemPresentation.$$$reportNull$$$0(5);
        }
        if (delegate == null) {
            PuppetItemPresentation.$$$reportNull$$$0(6);
        }
        this.myIconProvider = NullableLazyValue.lazyNullable(() -> (Icon)ReadAction.compute(() -> this.getDelegate().getIcon(0)));
        this.myName = name;
        this.myDelegate = delegate;
        this.myLocationProvider = location != null ? NullableLazyValue.lazyNullable(() -> location) : NullableLazyValue.lazyNullable(() -> (String)ReadAction.compute(() -> this.computeLocationString()));
    }

    @Nullable
    public String getPresentableText() {
        return this.myName;
    }

    @Nullable
    public final Icon getIcon(boolean unused) {
        return (Icon)this.myIconProvider.getValue();
    }

    @Nullable
    public final String getLocationString() {
        return (String)this.myLocationProvider.getValue();
    }

    @Nullable
    protected String computeLocationString() {
        if (!this.myDelegate.isValid()) {
            return null;
        }
        VirtualFile vFile = this.myDelegate.getContainingFile().getVirtualFile();
        if (vFile != null) {
            String relativePath;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myDelegate.getProject()).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(vFile);
            if (contentRoot == null) {
                contentRoot = fileIndex.getClassRootForFile(vFile);
            }
            if (contentRoot != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)contentRoot)) != null) {
                return relativePath;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class VariablePresentation
    extends PuppetItemPresentation<PuppetVariable> {
        VariablePresentation(@NotNull String name, @Nullable String location, @NotNull PuppetVariable delegate) {
            if (name == null) {
                VariablePresentation.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                VariablePresentation.$$$reportNull$$$0(1);
            }
            super(name, location, delegate);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            return "$" + super.getPresentableText();
        }

        @Override
        @Nullable
        protected String computeLocationString() {
            if (((PuppetVariable)this.myDelegate).isMetaparameter()) {
                return PuppetBundle.message("puppet.metaparameter", new Object[0]);
            }
            if (((PuppetVariable)this.myDelegate).isCoreFact()) {
                return PuppetBundle.message("puppet.fact", new Object[0]);
            }
            return super.computeLocationString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation$VariablePresentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ResourceInstancePresentation
    extends PuppetItemPresentation<PuppetResourceInstanceDeclaration> {
        ResourceInstancePresentation(@NotNull String name, @Nullable String location, @NotNull PuppetResourceInstanceDeclaration delegate) {
            if (name == null) {
                ResourceInstancePresentation.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                ResourceInstancePresentation.$$$reportNull$$$0(1);
            }
            super(name, location, delegate);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            String name;
            int delimiteroffset = this.myName.lastIndexOf("@");
            String string = name = delimiteroffset == -1 ? this.myName : this.myName.substring(delimiteroffset + 1);
            if ("default - the real one".equals(name)) {
                return "[default]";
            }
            if ("resource with heavy name".equals(name)) {
                return "???";
            }
            return name;
        }

        @Override
        @Nullable
        protected String computeLocationString() {
            return "[" + PuppetQualifiedNamesUtil.capitalizePuppetName(StringUtil.notNullize((String)((PuppetResourceInstanceDeclaration)this.myDelegate).getEffectiveTypeName())) + "] in " + super.computeLocationString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation$ResourceInstancePresentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NodePresentation
    extends PuppetItemPresentation<PuppetNodeDefinition> {
        NodePresentation(@NotNull String name, @Nullable String location, @NotNull PuppetNodeDefinition delegate) {
            if (name == null) {
                NodePresentation.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                NodePresentation.$$$reportNull$$$0(1);
            }
            super(name, location, delegate);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            return "default - the real one".equals(this.myName) ? "[default]" : this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation$NodePresentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassPresentation
    extends PuppetItemPresentation<PuppetClassDefinition> {
        private final String myFullQualifiedName;

        ClassPresentation(@NotNull String name, @Nullable String location, @NotNull PuppetClassDefinition delegate) {
            if (name == null) {
                ClassPresentation.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                ClassPresentation.$$$reportNull$$$0(1);
            }
            super(name, location, delegate);
            this.myFullQualifiedName = (String)ReadAction.compute(delegate::getFullQualifiedName);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            return this.myFullQualifiedName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation$ClassPresentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultPresentation
    extends PuppetItemPresentation<NavigatablePsiElement> {
        DefaultPresentation(@NotNull String name, @Nullable String location, @NotNull NavigatablePsiElement delegate) {
            if (name == null) {
                DefaultPresentation.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                DefaultPresentation.$$$reportNull$$$0(1);
            }
            super(name, location, delegate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/PuppetItemPresentation$DefaultPresentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

