/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ChangeJSDocTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String myType;
    @PropertyKey(resourceBundle="messages.JavaScriptBundle")
    private final @PropertyKey(resourceBundle="messages.JavaScriptBundle") String myNameKey;

    public ChangeJSDocTypeFix(@NotNull JSNamedElement psiElement, @NotNull JSType newType) {
        if (psiElement == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)psiElement);
        this.myType = newType.getTypeText(JSType.TypeTextFormat.CODE);
        this.myNameKey = psiElement instanceof JSParameter ? "javascript.fix.change.parameter.type" : (psiElement instanceof JSFunction ? "javascript.fix.set.method.return.type" : "javascript.fix.change.type");
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String paramName;
        JSFunction function;
        PsiComment comment;
        if (project == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(5);
        }
        if ((comment = JSDocumentationUtils.findDocComment(startElement)) == null && startElement instanceof JSParameter && (function = ((JSParameter)startElement).getDeclaringFunction()) != null) {
            comment = JSDocumentationUtils.findFunctionComment(function);
        }
        if (!(comment instanceof JSDocComment)) {
            return;
        }
        JSDocTag[] tags = ((JSDocComment)comment).getTags();
        JSDocBlockTags requiredTag = startElement instanceof JSParameter ? JSDocBlockTags.PARAM : (startElement instanceof JSFunction ? JSDocBlockTags.RETURNS : JSDocBlockTags.TYPE);
        String string = paramName = startElement instanceof JSParameter ? ((JSParameter)startElement).getName() : null;
        if (requiredTag.equals(JSDocBlockTags.PARAM) && paramName == null) {
            return;
        }
        Optional<JSDocTagType> typeValue = Arrays.stream(tags).map(tag -> tag.is(requiredTag) && (!requiredTag.equals(JSDocBlockTags.PARAM) || Objects.equals(paramName, tag.getNamepathText())) ? tag.getType() : null).filter(value -> value != null).findFirst();
        if (typeValue.isEmpty()) {
            return;
        }
        JSDocTagType typeElement = typeValue.get();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(typeElement.getContainingFile());
        if (document != null) {
            boolean wrapInBrackets = typeElement.getText().startsWith("{");
            document.replaceString(typeElement.getTextRange().getStartOffset(), typeElement.getTextRange().getEndOffset(), (CharSequence)(wrapInBrackets ? "{" + this.myType + "}" : this.myType));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message(this.myNameKey, ((JSNamedElement)this.getStartElement()).getName(), this.myType);
        if (string == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.change.jsdoc.type.family.name", new Object[0]);
        if (string == null) {
            ChangeJSDocTypeFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

