// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by gapic-generator. DO NOT EDIT.

package recaptchaenterprise

import (
	"context"
	"flag"
	"fmt"
	"io"
	"log"
	"net"
	"os"
	"strings"
	"testing"

	"github.com/golang/protobuf/proto"
	"github.com/golang/protobuf/ptypes"
	emptypb "github.com/golang/protobuf/ptypes/empty"
	"google.golang.org/api/option"
	recaptchaenterprisepb "google.golang.org/genproto/googleapis/cloud/recaptchaenterprise/v1beta1"

	status "google.golang.org/genproto/googleapis/rpc/status"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"

	gstatus "google.golang.org/grpc/status"
)

var _ = io.EOF
var _ = ptypes.MarshalAny
var _ status.Status

type mockRecaptchaEnterpriseServiceV1Beta1Server struct {
	// Embed for forward compatibility.
	// Tests will keep working if more methods are added
	// in the future.
	recaptchaenterprisepb.RecaptchaEnterpriseServiceV1Beta1Server

	reqs []proto.Message

	// If set, all calls return this error.
	err error

	// responses to return if err == nil
	resps []proto.Message
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) CreateAssessment(ctx context.Context, req *recaptchaenterprisepb.CreateAssessmentRequest) (*recaptchaenterprisepb.Assessment, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*recaptchaenterprisepb.Assessment), nil
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) AnnotateAssessment(ctx context.Context, req *recaptchaenterprisepb.AnnotateAssessmentRequest) (*recaptchaenterprisepb.AnnotateAssessmentResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*recaptchaenterprisepb.AnnotateAssessmentResponse), nil
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) CreateKey(ctx context.Context, req *recaptchaenterprisepb.CreateKeyRequest) (*recaptchaenterprisepb.Key, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*recaptchaenterprisepb.Key), nil
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) ListKeys(ctx context.Context, req *recaptchaenterprisepb.ListKeysRequest) (*recaptchaenterprisepb.ListKeysResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*recaptchaenterprisepb.ListKeysResponse), nil
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) GetKey(ctx context.Context, req *recaptchaenterprisepb.GetKeyRequest) (*recaptchaenterprisepb.Key, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*recaptchaenterprisepb.Key), nil
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) UpdateKey(ctx context.Context, req *recaptchaenterprisepb.UpdateKeyRequest) (*recaptchaenterprisepb.Key, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*recaptchaenterprisepb.Key), nil
}

func (s *mockRecaptchaEnterpriseServiceV1Beta1Server) DeleteKey(ctx context.Context, req *recaptchaenterprisepb.DeleteKeyRequest) (*emptypb.Empty, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*emptypb.Empty), nil
}

// clientOpt is the option tests should use to connect to the test server.
// It is initialized by TestMain.
var clientOpt option.ClientOption

var (
	mockRecaptchaEnterpriseServiceV1Beta1 mockRecaptchaEnterpriseServiceV1Beta1Server
)

func TestMain(m *testing.M) {
	flag.Parse()

	serv := grpc.NewServer()
	recaptchaenterprisepb.RegisterRecaptchaEnterpriseServiceV1Beta1Server(serv, &mockRecaptchaEnterpriseServiceV1Beta1)

	lis, err := net.Listen("tcp", "localhost:0")
	if err != nil {
		log.Fatal(err)
	}
	go serv.Serve(lis)

	conn, err := grpc.Dial(lis.Addr().String(), grpc.WithInsecure())
	if err != nil {
		log.Fatal(err)
	}
	clientOpt = option.WithGRPCConn(conn)

	os.Exit(m.Run())
}

func TestRecaptchaEnterpriseServiceV1Beta1CreateAssessment(t *testing.T) {
	var name string = "name3373707"
	var score float32 = 1.0926453e7
	var expectedResponse = &recaptchaenterprisepb.Assessment{
		Name:  name,
		Score: score,
	}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var assessment *recaptchaenterprisepb.Assessment = &recaptchaenterprisepb.Assessment{}
	var request = &recaptchaenterprisepb.CreateAssessmentRequest{
		Parent:     formattedParent,
		Assessment: assessment,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateAssessment(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestRecaptchaEnterpriseServiceV1Beta1CreateAssessmentError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var assessment *recaptchaenterprisepb.Assessment = &recaptchaenterprisepb.Assessment{}
	var request = &recaptchaenterprisepb.CreateAssessmentRequest{
		Parent:     formattedParent,
		Assessment: assessment,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateAssessment(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestRecaptchaEnterpriseServiceV1Beta1AnnotateAssessment(t *testing.T) {
	var expectedResponse *recaptchaenterprisepb.AnnotateAssessmentResponse = &recaptchaenterprisepb.AnnotateAssessmentResponse{}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/assessments/%s", "[PROJECT]", "[ASSESSMENT]")
	var annotation recaptchaenterprisepb.AnnotateAssessmentRequest_Annotation = recaptchaenterprisepb.AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED
	var request = &recaptchaenterprisepb.AnnotateAssessmentRequest{
		Name:       formattedName,
		Annotation: annotation,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.AnnotateAssessment(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestRecaptchaEnterpriseServiceV1Beta1AnnotateAssessmentError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/assessments/%s", "[PROJECT]", "[ASSESSMENT]")
	var annotation recaptchaenterprisepb.AnnotateAssessmentRequest_Annotation = recaptchaenterprisepb.AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED
	var request = &recaptchaenterprisepb.AnnotateAssessmentRequest{
		Name:       formattedName,
		Annotation: annotation,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.AnnotateAssessment(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestRecaptchaEnterpriseServiceV1Beta1CreateKey(t *testing.T) {
	var name string = "name3373707"
	var displayName string = "displayName1615086568"
	var expectedResponse = &recaptchaenterprisepb.Key{
		Name:        name,
		DisplayName: displayName,
	}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var key *recaptchaenterprisepb.Key = &recaptchaenterprisepb.Key{}
	var request = &recaptchaenterprisepb.CreateKeyRequest{
		Parent: formattedParent,
		Key:    key,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateKey(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestRecaptchaEnterpriseServiceV1Beta1CreateKeyError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var key *recaptchaenterprisepb.Key = &recaptchaenterprisepb.Key{}
	var request = &recaptchaenterprisepb.CreateKeyRequest{
		Parent: formattedParent,
		Key:    key,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.CreateKey(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestRecaptchaEnterpriseServiceV1Beta1ListKeys(t *testing.T) {
	var nextPageToken string = ""
	var keysElement *recaptchaenterprisepb.Key = &recaptchaenterprisepb.Key{}
	var keys = []*recaptchaenterprisepb.Key{keysElement}
	var expectedResponse = &recaptchaenterprisepb.ListKeysResponse{
		NextPageToken: nextPageToken,
		Keys:          keys,
	}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var request = &recaptchaenterprisepb.ListKeysRequest{
		Parent: formattedParent,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListKeys(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.Keys[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestRecaptchaEnterpriseServiceV1Beta1ListKeysError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var request = &recaptchaenterprisepb.ListKeysRequest{
		Parent: formattedParent,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListKeys(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestRecaptchaEnterpriseServiceV1Beta1GetKey(t *testing.T) {
	var name2 string = "name2-1052831874"
	var displayName string = "displayName1615086568"
	var expectedResponse = &recaptchaenterprisepb.Key{
		Name:        name2,
		DisplayName: displayName,
	}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/keys/%s", "[PROJECT]", "[KEY]")
	var request = &recaptchaenterprisepb.GetKeyRequest{
		Name: formattedName,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetKey(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestRecaptchaEnterpriseServiceV1Beta1GetKeyError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/keys/%s", "[PROJECT]", "[KEY]")
	var request = &recaptchaenterprisepb.GetKeyRequest{
		Name: formattedName,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetKey(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestRecaptchaEnterpriseServiceV1Beta1UpdateKey(t *testing.T) {
	var name string = "name3373707"
	var displayName string = "displayName1615086568"
	var expectedResponse = &recaptchaenterprisepb.Key{
		Name:        name,
		DisplayName: displayName,
	}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var key *recaptchaenterprisepb.Key = &recaptchaenterprisepb.Key{}
	var request = &recaptchaenterprisepb.UpdateKeyRequest{
		Key: key,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateKey(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestRecaptchaEnterpriseServiceV1Beta1UpdateKeyError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var key *recaptchaenterprisepb.Key = &recaptchaenterprisepb.Key{}
	var request = &recaptchaenterprisepb.UpdateKeyRequest{
		Key: key,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateKey(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestRecaptchaEnterpriseServiceV1Beta1DeleteKey(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockRecaptchaEnterpriseServiceV1Beta1.err = nil
	mockRecaptchaEnterpriseServiceV1Beta1.reqs = nil

	mockRecaptchaEnterpriseServiceV1Beta1.resps = append(mockRecaptchaEnterpriseServiceV1Beta1.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/keys/%s", "[PROJECT]", "[KEY]")
	var request = &recaptchaenterprisepb.DeleteKeyRequest{
		Name: formattedName,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	err = c.DeleteKey(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockRecaptchaEnterpriseServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestRecaptchaEnterpriseServiceV1Beta1DeleteKeyError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockRecaptchaEnterpriseServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/keys/%s", "[PROJECT]", "[KEY]")
	var request = &recaptchaenterprisepb.DeleteKeyRequest{
		Name: formattedName,
	}

	c, err := NewRecaptchaEnterpriseServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	err = c.DeleteKey(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
