#include <stdio.h>
#include <string.h>
#include <ctype.h>

/* Unescape characters in place using a subset of printf(1) syntax. */
void unescape_in_place(char *str)
{
	char *s, *d;

	for (s = d = str; (*d = *s); d++, s++)
		if (*s == '\\' && *++s != '\0') {
			if (*s == 'a')		/* alert (BEL) */
				*d = '\a';
			else if (*s == 'b')	/* backspace */
				*d = '\b';
			else if (*s == 'c')	/* produce no further output */
				*d = '\0';
			else if (*s == 'f')	/* form feed */
				*d = '\f';
			else if (*s == 'n')	/* new line */
				*d = '\n';
			else if (*s == 'r')	/* carriage return */
				*d = '\r';
			else if (*s == 't')	/* horizontal tab */
				*d = '\t';
			else if (*s == 'v')	/* vertical tab */
				*d = '\v';
			else			/* default: unescape */
				*d = *s;
		}
}

/* Non-destructive variant. Caller must free() result. */
char *unescape(const char *const orig)
{
	char *copy = NULL;

	if (orig != NULL) {
		copy = strdup(orig);
		if (copy != NULL)
			unescape_in_place(copy);
	}
	return copy;
}
